/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_EfuseCopy.c
*
*   This file contains VRX518 AFE Efuse copy functions
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added initial VRX518 AFE Efuse copy functions
//
// **********************************************************************************************//

//===========================INCLUDE FILES ========================================
#include "typedef.h"
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL
#include "Cnfg_task.h"

uint16 gus_fuse_read_ok = 0; //Debug

extern uint32 __StartOfSramBAR18;

/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  vrx518_ReadEFuseArray
**
** DESCRIPTION:    Read EFuse contents
**
** PARAMETERS:     None.
**
** RETURN VALUE:
**
** NOTES:
**
** =============================================================================
*/
// XDSLRTFW-3286 (Start)
// The EFuse register description is as following:
   // gula_VRX518_EfuseTable[0] --> 0x18200 --> AFE_BBVT_EFUSE
   // gula_VRX518_EfuseTable[1] --> 0x18204 --> AFE_TXDAC_DSL_EFUSE
   // gula_VRX518_EfuseTable[2] --> 0x18208 --> AFE_LDO_EFUSE
   // gula_VRX518_EfuseTable[3] --> 0x1820C -->   Not Used
   // gula_VRX518_EfuseTable[4] --> 0x18210 --> AFE_ADCDSL_EFUSE
   // gula_VRX518_EfuseTable[5] --> 0x18214 --> AFE_RC_TIME_EFUSE
   // gula_VRX518_EfuseTable[6] --> 0x18218 --> AFE_XO_EFUSE
   // gula_VRX518_EfuseTable[7] --> 0x1821C --> AFE_VEGA_EFUSE
   // gula_VRX518_EfuseTable[8] --> 0x18220 --> AFE_DSM_EFUSE

void vrx518_ReadEFuseArray(void)
{
   uint32* ul_addr_pointer = NULL;
   int n;

   CheckBARConfiguration();

   // The contents of EFuse are stored in BAR18 memory space.
   // BAR18 is obtained as following:
   // BAR18 = 0x100000 + (16*64*1024) + (512*1024) + (1*64*1024) = 0x290000
   // We have configured the BAR register to point to the address 0x18000
   // And the EFuse registers are present from the address 0x18200 to 0x18220
   // Hence we need to have an offset of 0x200 from the start of the BAR18 address space.

   ul_addr_pointer = (uint32 *)((uint32)&__StartOfSramBAR18 + EFUSE_OFFSET);  // BAR18 + Offset

    for(n=0; n<EFUSE_TABLE_LEN; n++)
    {
       gula_VRX518_EfuseTable[n] = *ul_addr_pointer++;
   }

}
// XDSLRTFW-3286 (End)

/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  vrx5afe_softfuse
**
** DESCRIPTION:    This routine shall be part of the power up
**                 initialization sequence of the firmware.
**
** PARAMETERS:     None.
**
** RETURN VALUE:
**
**
** NOTES:
**
** =============================================================================
*/

//-----------
// Soft-fuse
//-----------
uint16_t vrx5afe_softfuse(uint32_t *fuse_table)  //VRX518AFE_OPEN
{
   // get fuse-table (complete one) => address = 200h
   // set fusedone_bit = 1 if fusing information are found

   // tbd
   uint32_t fuse_reg;
   uint16_t fuse_reg_prog;
//-------------------------------------------
    //check if AFE fusing is done

    fuse_reg = fuse_table[0x1C/4]; //AFE_VEGA_EFUSE => 21Ch
    if ((fuse_reg & 0x0001) == 0)
    {
        return 1; // it has been changed to "1"= not fused
    }


   fuse_reg = fuse_table[0x00/4]; //AFE_BBVT_EFUSE => 200h

   //LDOCLKD => fusing not used, maybe in future
/* fuse_reg_prog = (fuse_reg & VRX5AFE_CENTRAL_FCSI_LDOCLKD_PROGLDOCLKD__MSK) << VRX5AFE_CENTRAL_FCSI_LDOCLKD_PROGLDOCLKD__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_LDOCLKD), \
      VRX5AFE_CENTRAL_FCSI_LDOCLKD_PROGLDOCLKD__ISMSK, \
      fuse_reg_prog);
*/

   //BIAS
   fuse_reg_prog = ((fuse_reg >> 4) & VRX5AFE_CENTRAL_FCSI_BIASTRIM_RBIASCONF__MSK) << VRX5AFE_CENTRAL_FCSI_BIASTRIM_RBIASCONF__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_BIASTRIM), \
      VRX5AFE_CENTRAL_FCSI_BIASTRIM_RBIASCONF__ISMSK, \
      fuse_reg_prog);

   //BGP
   fuse_reg_prog = ((fuse_reg >> 8) & VRX5AFE_CENTRAL_FCSI_BIASBGP_VREFCONF__MSK) << VRX5AFE_CENTRAL_FCSI_BIASBGP_VREFCONF__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_BIASBGP), \
      VRX5AFE_CENTRAL_FCSI_BIASBGP_VREFCONF__ISMSK, \
      fuse_reg_prog);

//----------------------------------------------
   fuse_reg = fuse_table[0x08/4]; //AFE_LDO_EFUSE => 208h

   //RXLDO1V1
   fuse_reg_prog = (fuse_reg & VRX5AFE_DSL_FCSI_DSLLDO1V1RX_PROGLDO1V1RX__MSK) << VRX5AFE_DSL_FCSI_DSLLDO1V1RX_PROGLDO1V1RX__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO1V1RX), \
   VRX5AFE_DSL_FCSI_DSLLDO1V1RX_PROGLDO1V1RX__ISMSK, \
   fuse_reg_prog);


   //RXLDO2V6
   fuse_reg_prog = ((fuse_reg >> 4) & VRX5AFE_DSL_FCSI_DSLLDO2V6RX_PRGFBLDO2V6RX__MSK) << VRX5AFE_DSL_FCSI_DSLLDO2V6RX_PRGFBLDO2V6RX__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO2V6RX), \
   VRX5AFE_DSL_FCSI_DSLLDO2V6RX_PRGFBLDO2V6RX__ISMSK, \
   fuse_reg_prog);

   //-----

   fuse_reg = fuse_table[0x20/4]; // AFE_DSM_EFUSE => 220h

   //LDOPREFI1V1
   fuse_reg_prog = ((fuse_reg >> 16) & VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI_PROGLDO1V1PREFI__MSK) << VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI_PROGLDO1V1PREFI__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI), \
   VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI_PROGLDO1V1PREFI__ISMSK, \
   fuse_reg_prog);

//----------------------------------------------


   fuse_reg = fuse_table[0x08/4]; //AFE_LDO_EFUSE => 208h

   //TXLDO1V1
   fuse_reg_prog = ((fuse_reg >> 16) &  VRX5AFE_DSL_FCSI_DSLLDO1V1TX_PROGLDO1V1TX__MSK) << VRX5AFE_DSL_FCSI_DSLLDO1V1TX_PROGLDO1V1TX__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO1V1TX), \
   VRX5AFE_DSL_FCSI_DSLLDO1V1TX_PROGLDO1V1TX__ISMSK, \
   fuse_reg_prog);

   //TXLDO2V6
   fuse_reg_prog = ((fuse_reg >> 20) &  VRX5AFE_DSL_FCSI_DSLLDO2V6TX_PRGFBLDO2V6TX__MSK) << VRX5AFE_DSL_FCSI_DSLLDO2V6TX_PRGFBLDO2V6TX__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO2V6TX), \
   VRX5AFE_DSL_FCSI_DSLLDO2V6TX_PRGFBLDO2V6TX__ISMSK, \
   fuse_reg_prog);

//----------------------------------------------

   fuse_reg = fuse_table[0x04/4]; //AFE_TXDAC_DSL_EFUSE => 204h

   //TXDAC gain
   fuse_reg_prog = (fuse_reg & VRX5AFE_DSL_FCSI_CSDAC0_TRIM__MSK) << VRX5AFE_DSL_FCSI_CSDAC0_TRIM__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC0), \
   VRX5AFE_DSL_FCSI_CSDAC0_TRIM__ISMSK, \
   fuse_reg_prog);

//----------------------------------------------

   fuse_reg = fuse_table[0x010/4]; //AFE_ADCDSL_EFUSE => 210h

   //adc clk invert
   fuse_reg_prog = (fuse_reg & VRX5AFE_DSL_FCSI_SDADC4_PROGCLKINV__MSK) << VRX5AFE_DSL_FCSI_SDADC4_PROGCLKINV__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC4), \
   VRX5AFE_DSL_FCSI_SDADC4_PROGCLKINV__ISMSK, \
   fuse_reg_prog);

   //progLDO1v8
   fuse_reg_prog = ((fuse_reg >> 4) & VRX5AFE_DSL_FCSI_SDADC5_PROGLDOFB__MSK) << VRX5AFE_DSL_FCSI_SDADC5_PROGLDOFB__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC5), \
   VRX5AFE_DSL_FCSI_SDADC5_PROGLDOFB__ISMSK, \
   fuse_reg_prog);

//----------------------------------------------

   fuse_reg = fuse_table[0x14/4]; //AFE_RC_TIME_EFUSE => 214h

   //rc count
   fuse_reg_prog = (fuse_reg & VRX5AFE_CENTRAL_FCSI_RCMEAS1_RCCOUNT__MSK);
   vrx5afe_set_rc_count(fuse_reg_prog);

//----------------------------------------------
//no fusing of XO amplitude but it's possible to enable it fot future.

/* fuse_reg = fuse_table[0x18/4]; //AFE_XO_EFUSE => 218h

   //xo bias trim
   fuse_reg_prog = (fuse_reg & VRX5AFE_CENTRAL_FCSI_XOPOC4_CFGBIASREG__MSK) << VRX5AFE_CENTRAL_FCSI_XOPOC4_CFGBIASREG__POS;
   VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_XOPOC4), \
      VRX5AFE_CENTRAL_FCSI_XOPOC4_CFGBIASREG__ISMSK, \
      fuse_reg_prog);
*/

    return(0);
} //end of function
