/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_HybTrainUtilities.c
*
*   This file contains VRX518 Hybrid training related functions
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 Hybrid training functions
//
// **********************************************************************************************//


//** ================= INCLUDE FILES ================================
#include "common.h"
#include "typedef.h"
#include "str_memmap.h"
#include "LL_IOf.h"
#include "Const.h"
#include "gdata.h"
#include "hndshk_Data.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL


/*******************************************************************************
*
*   Prototype: void AFED_SetHybrid(void)
*
*      This function shall make use of the global variable: gs_HybTrIndex and
*   global pointer to Hybrid array gpus_HybridsForProfileSelected to program the AFE
*   registers corresponding to that Hybrid index for that mode of operation.
*   The initialization of the Hybrid pointer based on appropriate mode and profile
*   has been considered to be handled outside this function and in function
*   ConfigTaskLayerForPostGhs(void) above.
*   This function will only update the pointer to the corresponding updated
*   Hybrid index meant for that mode and profile so that the same can be used
*   for programming the AFE registers.
*   This function restores the PGA to its default and calls BgSetPGA()
*   after setting up the hybrid
*
*   Input Arguments:
*   Global Variables:
*  Pointer to hybrid 2D array: gpus_HybridsForProfileSelected[I]
*   Hybrid array index corresponding to the row: gs_HybTrIndex
*
*
*   Output Arguments:
*
*   Returns:
*
*******************************************************************************/
C_SCOPE void AFED_SetHybrid(void)
{

   uint16 *pHybRegSetting;
   if (gus_SkipAfeFlow & 0x800)
   {
     guc_PgaState = TRAINING_DONE;
   return;
   }
#if 0   //bhadra_check
   if (gs_HybTrFinishUp == 1)
   {
   gs_HybTrIndex = gs_HybTrMaxIndex; // if complete Hybrid array is completed
   }// Make the Hybrid index point to the best Hybrid selected and progarm the same
#endif
   pHybRegSetting = gusa_InitHybridSettings + (gs_LoadHybIndex * VRX_HYB_NUM_SETTINGS);

// check for special hybrid
//    if ((pHybRegSetting[VR9_RIN1_IDX] == 0x7f ) && (pHybRegSetting[VR9_RIN2_IDX] == 0x7f))
//    {
//    gs_ResidualGain = -(9*256);
//    }
//    else
//    {
//    gs_ResidualGain = 0;
//    }

   // XDSLRTFW-3974 Wrong Hlog reporting with DPBO in ADSL
   // Calculate delta gain between showtime hybrid and hybrid of HLOG measurement
   // 0xFA17 is hybrid gain of special HLOG hybrid -5.9113 dB
   gs_ResidualGain = (pHybRegSetting[VRX518_HYBGAIN_IDX] - 0xFA17);


// VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA0), 0x0000, gusa_SpecialHybSetting[HybIndex+0]);

   //Hybrid Coeff 0
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA0), 0x0000, *pHybRegSetting++);

   //Hybrid Coeff 1
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA1), 0x0000, *pHybRegSetting++);

   //Hybrid Coeff 2
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA2), 0x0000, *pHybRegSetting);

   //guc_PgaState = TRAINING_DONE;

}

/*******************************************************************************
*
*   Prototype: void UpdateHybridBuffer_VR9(void)
*
*  This function shall make use of the global variable: gs_HybIndex and
*  global pointer to Hybrid array gusa_InitHybridSettings to update the hybrid
*  buffer with the special Hybrid settings to provide -6dB gain as input to the AGC1.
*  The initialization of the Hybrid pointer based on appropriate mode and profile
*  has been considered to be handled outside this function and in function
*  ConfigTaskLayerForPostGhs(void) above.
*
*  Input Arguments:
*  Global Variables:
*  Pointer to hybrid 2D array: gusa_InitHybridSettings[I]
*  Hybrid array index corresponding to the row: gs_HybIndex
*
*
*   Output Arguments:
*
*   Returns:
*
*******************************************************************************/
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE void AFED_UpdateHybridBuffer(void) //UpdateHybridBuffer_VR9
{
   unsigned short *pHybRegSetting;
   uint32 i;
   pHybRegSetting = gusa_InitHybridSettings + (gs_HybIndex * VRX518_HYB_NUM_SETTINGS);
   for (i = 0; i < VRX518_HYB_NUM_SETTINGS; i++)
   {
      pHybRegSetting[i] = gusa_SpecialHybSetting[i];
   }
}



#if 0 //Not Needed
/*******************************************************************************
*
*   Prototype: void AFED_SearchGoodHybridCap(void)
*   This function modifies the gpus_HybridsForProfileSelected to search for best hybrid capacitor.
*     Hybrid Index 0 ==> Best Hybrid selected
*          Index 1 .. VR9_NUM_CAP_SEARCH ==> Capacitor value got modified as per gsa_cap_delta[]
*           , others unchanged, ie. choose the best hybrid by changing the cap value.
*
*  Input Arguments:
*   Global Variables:
*  Pointer to hybrid 2D array: gpus_HybridsForProfileSelected[I]
*  Hybrid array index corresponding to the row: gs_HybTrIndex
*
*
*   Output Arguments:
*
*   Returns:
*
*******************************************************************************/
void AFED_SearchGoodHybridCap(void)
{
   uint16 *pHybRegSrc;

   // For cap search set x hybrid settings to the settings of the best hybrid!
   // Note: x = number of cap search = VR9_NUM_CAP_SEARCH
   //----------------------------
   // Address of the Best Metric. Note: Idx to Best metric is stored in "gs_HybTrIndex".
   pHybRegSrc = gpus_HybridsForProfileSelected + (gs_HybTrIndex * VRX_HYB_NUM_SETTINGS);
   // Best metric capacitor

}
#endif
/*^^^
 *------------------------------------------------------------------------
 *
 *  Description: Background function to calculate metric for hybrid training
 *
 *  Prototype: void AFED_BgHybTrCalcMetric(void)
 *
 *  Input Arguments: none
 *
 *  Output Arguments: none
 *
 *  Return: none
 *
 *------------------------------------------------------------------------
 *^^^
 */
#if 0
void AFED_BgHybTrCalcMetric(void)
{
   unsigned int i, j;
   int32 l_HybTrMaxMetric;
   int16 us_SNRref, s_Snr;

   us_SNRref = 10*256;         // 10dB
   if (gs_NumOfRxBands == 1)
   {
      us_SNRref = 1*256;       //  1dB
   }

   l_HybTrMaxMetric = 0;
   for (j=0; j<gs_NumOfRxBands; j++)
   {
      for (i=gsa_RxBandLeftChannel[j]; i<=gsa_RxBandRightChannel[j]; i++)
      {
         s_Snr = gpsa_MeasuredSnrBuf[i];

         // For the metric add-up only tones with SNRs >= 10dB for short loops or
         //                                                1dB for long loops
         if (s_Snr >= us_SNRref)
         {
            // limit use of SNRs to 60dB [Q8.8]
            if (s_Snr >= 60*256)
            {
               l_HybTrMaxMetric += (int32)(60*256);
            }
            else
            {
//               l_HybTrMaxMetric += s_Snr;
               l_HybTrMaxMetric += (int32)(s_Snr);
               l_HybTrMaxMetric -= (int32)(us_SNRref);
            }
         }
      }
   }

   //SMS01357115 - VDSL_62 HybridTraining - Start
   //Save the Hybrid Train Metric for Each Hybrid settings
   gl_HybTrMetric[gs_HybTrIndex] = l_HybTrMaxMetric;
   //SMS01357115 - VDSL_62 HybridTraining - End
   if(l_HybTrMaxMetric > gl_HybTrMaxMetric)
   {
      // Save best Hybrid index and metric value.
      gs_HybTrMaxIndex = gs_HybTrIndex;
      gl_HybTrMaxMetric = l_HybTrMaxMetric;
   }
   gs_RxBkgdProcessFlag = TRAINING_DONE;
}
#endif
C_SCOPE void AFED_PgmHybrGain(void)
{
      int16 s_HybGainIndex = (gs_LoadHybIndex * VRX_HYB_AFE_REG_GAINS);

      gs_PGA_required = gsa_HybGain[s_HybGainIndex + PGA_REQ_OFFSET]; //gs_PGA_required offset 1
      gs_PGA_set = gsa_HybGain[s_HybGainIndex + PGA_SET_OFFSET];      //gs_PGA_set offset 2
      gs_AGC1_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET];
      gs_AGC2_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC2_GAIN_SET_OFFSET];
      //Disabled here to write the all AFE gain registers once using SetPGA() and
      //Reenable the flag after SetPGA.
      gft_EnableDoublePGATrain = FALSE;
      AFED_SetPga(); //SetPGA() is called directly since PgmHybrGain() was called in TC task.
      gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Gain_Set) << 8); //8.8 format
      gft_EnableDoublePGATrain = TRUE;
}

C_SCOPE void AFED_LoadHybridHPFAndPGA_VR9(void) //LoadHybridHPFAndPGA_VR9
{
   int16 s_HybGainIndex;

   AFED_SetHybrid(); // Will load the hybrid setting with index "gs_LoadHybIndex"
   if (gs_LoadAllPGAGains == 0)
   {
      // Do these initializations during PGA training.
      if (gs_PgaHandlerRun ==0)
      {
         AFED_InitAFE_RegsPGA(); //Init for PGA1 training
      }
      else if (gs_PgaHandlerRun ==1)
      {
         //Program AGC1 Gain for PGA2 Training
         s_HybGainIndex = (gs_LoadHybIndex * VRX_HYB_AFE_REG_GAINS);
         gs_AGC1_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET];
         gs_PgaHandlerRun = 0; //Changed to "0" to program AGC1 gain Regs
         AFED_SetPga(); //SetPGA() is called directly since PgmHybrGain() was called in TC task.
         gs_PgaHandlerRun = 1; //Restore back
         //Enable HPF
         AFED_RestoreAFE_RegsforAGC2();
      }
   }
      //Load AFE gains which was computed earlier
   if (gs_LoadAllPGAGains == 1)
   {
      AFED_PgmHybrGain();
   }

   //   guc_PgaState = TRAINING_DONE;


}



