/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_LdModeConfig.c
*
*   This file contains Line Driver configuration functions
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 Line Driver functions
//
// **********************************************************************************************//
#include "common.h"
#include "typedef.h"
#include "str_memmap.h"
#include "LL_IOf.h"
#include "cri_memmap.h"
#include "Const.h"
#include "Gdata.h"
#include "ppe_memmap.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"


//
uint16 gusa_LD_CTL_DOUT[SIZE_LD_CTL_DOUT]=
{
   0x200,  //LD_PDN -> GPIO_LD_CTL <15:0>
   0x1,    //   "   -> GPIO_LD_DOUT<15:0>
   0x700,  //LD_VL_ADSL  //CRI_LD_CTRL (0x30C518)
   0x7,                //CRI_LD_DOUT (0x30C514)
   0x700,  //LD_L_ADSL
   0x6,
   0x700,  //LD_M_ADSL
   0x5,
   0x700,  //LD_H_ADSL
   0x4,
   0x600,  //LD_VH_ADSL
   0x7,
   0x700,  //LD_VL_VDSL
   0x3,
   0x700,  //LD_L_VDSL
   0x2,
   0x700,  //LD_M_VDSL
   0x1,
   0x700,  //LD_H_VDSL
   0,
   0x600,  //LD_VH_VDSL
   0x3
};

uint16 gus_CurrLDMode = LD_PDN; //By default Line Driver is in Power down mode,


/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  AFED_GetLdMode
**
** DESCRIPTION:    Get the Line driver mode from the AFE Digital Reg and
**                 is being used now. it is common
**                 function for Low noise(ADSL) and VDSL LD modes.
**
** PARAMETERS:     None
**
** RETURN VALUE:   One of the 11 modes listed in the #define
**
**
** NOTES:
**
** =============================================================================
*/

uint16 AFED_GetLdMode() //OPEN_VRX518
{

   uint16  us_ld_ctl, us_ld_dout, i = 0;
   uint16   us_curr_LDmode = LD_MODE_INVALID; //Initialize with Invalid LD Mode
    uint32  ul_ld_ctl, ul_ld_out;

   ReadCoreReg(CRI_LD_CTRL_ADDR, &ul_ld_ctl);
   ReadCoreReg(CRI_LD_DOUT_ADDR, &ul_ld_out);

   us_ld_ctl  = (uint16) (ul_ld_ctl & 0xFFFF);  //LD_CTL
    us_ld_dout = (uint16) (ul_ld_out & 0xFFFF);    //LD_DOUT

   while(i < SIZE_LD_CTL_DOUT)
   {
      if ((us_ld_ctl == gusa_LD_CTL_DOUT[i]) && (us_ld_dout == gusa_LD_CTL_DOUT[i+1]))
      {
      break;
      }
      i = i + 2;
   }

   if (i < SIZE_LD_CTL_DOUT)
   {
      us_curr_LDmode = (i >> 1);
   }

   return us_curr_LDmode;

}

/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  AFED_SetLdMode
**
** DESCRIPTION:    Set the Line driver mode only if change in the
**                 mode being used and mode required, it is common
**                 function for Low noise(ADSL) and VDSL LD modes.
**                 Update the LD mode is being used in a variable for debug.
**
** PARAMETERS:     us_LDMode --> Pass One of the 11 modes listed in the #define
**
** RETURN VALUE:
**
**
** NOTES:
**
** =============================================================================
*/

void AFED_SetLdMode(uint16 RequiredLDMode)  //OPEN_VRX518
{
   gus_CurrLDMode = AFED_GetLdMode();
   if ((gus_CurrLDMode != RequiredLDMode) && (RequiredLDMode <= LD_VH_VDSL))
   {
      //if Change in the LD mode, then change it.
//    GPIO_LD_CTL_AFE_SET(gusa_LD_CTL_DOUT[us_RequiredLDMode << 1]);
      WriteCoreReg(CRI_LD_CTRL_ADDR, (uint32) (gusa_LD_CTL_DOUT[RequiredLDMode << 1]));
//    GPIO_LD_DOUT_AFE_SET(gusa_LD_CTL_DOUT[(us_RequiredLDMode << 1)+1]);
      WriteCoreReg(CRI_LD_DOUT_ADDR, (uint32) (gusa_LD_CTL_DOUT[(RequiredLDMode << 1)+1]));
      gus_CurrLDMode = RequiredLDMode; //Update the LD mode is being set.
   }

    gul_Afe_flowtest |=0x4000000;

} //
