/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_PgaHandlerUtilities.c
*
*   This file contains VRX518 AFE Filter tuning formula implementation routines
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 Filter tune routines
//
// **********************************************************************************************//

//===========================INCLUDE FILES ========================================
#include "typedef.h"
#include "typedef.h"
#include "gdata.h"
#include "cmv.h"
#include "hndshk_Data.h"


#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL

extern int16 gs_AGC1_margin;

extern  int16 gs_PgaTrainingDbg;
extern int8 gc_AGC1_Gain_Start;
extern int16 gs_AGC2_Gain_Start;
#define TEST_HP2_CONFIG_AGC1_START_xDB               (0x0008) // Set AGC1 gain to a configured value between -6 to 12dB instead of 0dB for AGC1 training


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   void AFED_BgPGA(void)
**
** DESCRIPTION:   This background function calculates the PGA setting
**
** PARAMETERS:       gs_PGA_required (I): required gain (dB in 8.8 format)
**                   guc_PgaTrainingState (O): status indicator
**                   gs_PGA_reg_setting (O): register value for PGA gain (RX_GAIN)
**                   gs_PGA_set (O): actual gain (dB in 8.8 format)
**
** RETURN VALUE:   NONE
**
** NOTES:Reference:
** Registers used :
**
** TODO Revisit this paremeters Section
** =============================================================================
*/

void AFED_BgPGA(void) //BgPGA
{
   int16  s_Gain;

   //set this flag to false so we can program all AGCs (AGC1, AGC2)
   gft_EnableDoublePGATrain = FALSE;

   // AGC1 gain (variable part)
   AFED_CalcAGC1(gs_PGA_required - gs_AGC1_margin);

   // AGC2 (Fixed + Var gain) + AGC3 gain = (Total PGA Required - AGC1 gain set)
   s_Gain = gs_PGA_required - (gs_AGC1_Gain_Set << 8);
   // gain_prefi_dB = rxgain_dB - gain_pga_dB;
   AFED_CalcAGC2(s_Gain);
   guc_PgaTrainingState = TRAINING_DONE;

}


void AFED_SetPga() //SetPGA
{
    uint16 mode_set;

   mode_set = gus_AFE_RxMode;

   if (gus_SkipAfeFlow & 0x400)
   {
     guc_PgaState = TRAINING_DONE;
   return;
   }
   // PGA gain + fc_lp
    //int32_t fc_pga_lp_kHz[] = { 0,   25000, 00000, 12500, 10000, 00000, 00000, 50000,    50000};
    //DSL Mode                            VDSL17      VDSL8  ADSL2                VDSL35b   BYP
   //Index                          0     1     2     3     4     5     6     7     8
   // int32_t fc_prefi_lp_kHz[]   = { 0,   25000, 00000, 12500, 10000, 00000, 00000, 50000,     50000};

   if(((gs_PgaHandlerRun == 0)&& (gft_EnableDoublePGATrain == TRUE)) || (gft_EnableDoublePGATrain == FALSE))
   {
        // program AGC1 settings
      // PGA gain + fc_lp
      if (gus_SkipAfeFlow & 0x200)
      {
      guc_PgaState = TRAINING_DONE;
      return;
      }
        vrx5afe_dsl_pga_gainfc_set(mode_set, gs_AGC1_Gain_Set, gla_fc_pga_lp_kHz[mode_set]);
    }

   if(((gs_PgaHandlerRun == 1) && (gft_EnableDoublePGATrain == TRUE)) || (gft_EnableDoublePGATrain == FALSE))
   {
      if (gus_SkipAfeFlow & 0x100)
      {
      guc_PgaState = TRAINING_DONE;
      return;
      }
      //XDSLRTFW-3674 New_LLAPI_changes (start)
      //AGC2gain2(Variable Gain)\
      // PREFI gain + fc_lp
      if(gft_IsBTorLLoop == TRUE)
      {  // R1 2400 Ohm configuration
         vrx5afe_dsl_prefi_gainfc_set(ADSL2_CPE_LL, gs_AGC2_Gain_Set, gla_fc_prefi_lp_kHz[mode_set]);
      }
      else
      {  // R1 4900 Ohm configuration
         vrx5afe_dsl_prefi_gainfc_set(mode_set, gs_AGC2_Gain_Set, gla_fc_prefi_lp_kHz[mode_set]);
      }
      //XDSLRTFW-3674 New_LLAPI_changes (end)
   }

   // Update the PGA state, This function called in TC Task
   guc_PgaState = TRAINING_DONE;
}

#if 0
void AFED_GetPgaGains(void)
{
   int16 s_AGC1Code;
   int16 s_AGC2Code;
   int16  s_AGC1Gain=0, s_AGC2Gain=0;
   uint16 ReadDataDummy, mode_set;

   mode_set = gus_AFE_RxMode;
   // PGA1:     -9dB and  -6dB to +15dB in 1dB steps (VDSL35B)
   // PGA1:     -9dB and  -6dB to +21dB in 1dB steps (VDSL and ADSL)
   // PGA2:              -16dB to   0dB in 1dB steps (VDSL)
   //                     -8dB to +12dB in 1dB steps (ADSL)
   //
   s_AGC1Code = VRX5AFE_FCSI_READ(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA3), &ReadDataDummy);
   s_AGC1Code = s_AGC1Code & VRX5AFE_DSL_FCSI_PGA3_PGA35GAIN__MSK;
      // gain
   //------
    if (s_AGC1Code == 0)
   {
      s_AGC1Gain = -9 ;
   }
   else
   {
      s_AGC1Gain = s_AGC1Code - 7;// From 00001b to 11100b
   }
   s_AGC1Gain = s_AGC1Gain << 8;
    gs_AGC1_Gain_Get = s_AGC1Gain;

   // AGC2 Gain2 (Variable Gain) in dB (Q8.8 format)
   s_AGC2Code = VRX5AFE_FCSI_READ(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA7), &ReadDataDummy);
   s_AGC2Code = s_AGC2Code & VRX5AFE_DSL_FCSI_PGA7_PREFI35FBRES__MSK;
   s_AGC2Gain = s_AGC2Code - 16;
   s_AGC2Gain = s_AGC2Gain << 8;
   gs_AGC2_Gain_Get = s_AGC2Gain;


   //Max AGCGain = 21dB +0dB for 35B mode
   //else
   //Max AGCGain = 15dB + 0dB
   gs_AGC_Gain_Get = s_AGC1Gain + s_AGC2Gain;

   // Update the PGA state, This function called in TC Task
   guc_PgaState = TRAINING_DONE;
}

#endif
/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   int16 AFED_CalcAGC1(int16 s_PGA_required)
**
** DESCRIPTION:   This function calculates the Gain setting on AGC1
**
** PARAMETERS:
**
** RETURN VALUE:   AGC1 reg setting
**
** NOTES:
** =============================================================================
*/
void AFED_CalcAGC1(int16 s_PGA_required)
{
   // Gain of total rx-path is set -> splitted in PGA1 and PGA2 (PREFI)
   //

   //Rx-gain:  -25dB and -22dB to +15dB in 1dB steps(VDSL35B)
   //Rx-gain:  -25dB and -22dB to +21dB in 1dB steps (VDSL)
   //          -17dB and -14dB to +33dB in 1dB steps (ADSL)
   //
   // PGA1:     -9dB and  -6dB to +15dB in 1dB steps (VDSL35B)
   // PGA1:     -9dB and  -6dB to +21dB in 1dB steps (VDSL and ADSL)
   //                {-9 to -6dB in 3dB step
   //                -6 to 21dB in 1dB steps}
   // PGA2:              -16dB to   0dB in 1dB steps (VDSL)
   //                     -8dB to +12dB in 1dB steps (ADSL)
   //
   // Rule: always program PGA1 max. and if needed PGA2 (PREFI)

    int16_t rxgain_dB =0;
   int16_t gain_pga_dB =0;
   int16_t pga_gain_min = AFED_AGC1_PGA_MINUS_6DB;  //(-9)  //in dB
   int16_t pga_gain_max;
   uint16  mode_set;

   mode_set = gus_AFE_RxMode;


   if (mode_set == VDSL35b_CPE)
    {
       pga_gain_max =  AFED_AGC1_MAX_PGA_8K; //(15)  //in dB
    }
   else
    {
       pga_gain_max =  AFED_AGC1_MAX_PGA; //(21)  //in dB
    }

    rxgain_dB = s_PGA_required >> 8; //Convert to dB Format
   //----------------
   // gain splitting
   //----------------
   if ( (rxgain_dB >= pga_gain_min) && (rxgain_dB <= pga_gain_max) ) // PGA1 only
   {
      gain_pga_dB = rxgain_dB;
   }
   else if ( rxgain_dB < pga_gain_min)
   {
      gain_pga_dB = AFED_AGC1_MIN_PGA; //-9dB
   }
   else if (rxgain_dB > pga_gain_max)
   {
      gain_pga_dB = pga_gain_max;
   }

    gs_AGC1_Gain_Set = gain_pga_dB;

   if (gft_EnableDoublePGATrain == TRUE)
   {
      gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Gain_Set) << 8); //8.8 format
   }

}


/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   int16 AFED_CalcAGC2(int16 PGA_required)
**
** DESCRIPTION:   This function calculates the Gain setting on AGC1
**
** PARAMETERS:
**
** RETURN VALUE:   AGC1 reg setting
**
** NOTES:
** =============================================================================
*/
void AFED_CalcAGC2(int16 s_PGA_required)
{
   // Gain of total rx-path is set -> splitted in PGA1 and PGA2 (PREFI)
   //
   // Rx-gain: -25dB and -22dB to +21dB in 1dB steps (VDSL)
   //          -17dB and -14dB to +33dB in 1dB steps (ADSL)
   //
   // PGA1:     -9dB and  -6dB to +21dB in 1dB steps (VDSL and ADSL)
   // PGA2:              -16dB to   0dB in 1dB steps (VDSL)
   //                     -8dB to +12dB in 1dB steps (ADSL)
   //
   // Rule: always program PGA1 max. and if needed PGA2 (PREFI)
   int16_t rxgain_dB;
   int16_t gain_prefi_dB =0;
   int16_t prefi_gain_min = AFED_AGC2_MIN_PGA;//   (-8 in dB)
   int16_t prefi_gain_max = AFED_AGC2_MAX_PGA;//    (12 in dB)
   if(gft_IsBTorLLoop == TRUE)
   {
      prefi_gain_max = AFED_AGC2_MAX_PGA_R1_2400;  //(18 in dB steps) //XDSLRTFW-3674 New_LLAPI_changes
   }
   rxgain_dB = s_PGA_required >> 8; //Convert to dB Format

   gs_AGC2_Gain_Set = 0; // AGC2 gain
    if ( (rxgain_dB >= prefi_gain_min) && (rxgain_dB <= prefi_gain_max) ) // PGA1 only
   {
      gain_prefi_dB = rxgain_dB;
   }
   else if ( rxgain_dB < prefi_gain_min)
   {
      gain_prefi_dB = prefi_gain_min;
   }
   else if (rxgain_dB > prefi_gain_max)
   {
      gain_prefi_dB = prefi_gain_max;
   }

   if (gus_AFE_RxMode == BYPASSED)
   {
      // In Prefi35 BYPASSED mode, Gain is fixed @-8dB
      gain_prefi_dB = -8;
   }
   gs_AGC2_Gain_Set = gain_prefi_dB;

   gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Gain_Set) << 8); //8.8 format
}



void AFED_InitAFE_RegsPGA(void) //InitAFE_RegsPGA_ADSL_VR9
{
   uint16 us_PgaTrainingDbg;
   uint16 mode_set;
   int32_t fc_prefi_lp_kHz_PGA1Train;

   mode_set = gus_AFE_RxMode;

   //if (gus_ModemOperationMode_Status & MODEM_OPERATION_MODE_VDSL2)
   {
      us_PgaTrainingDbg = gs_PgaTrainingDbg;
      if ( (gs_PgaTrainingDbg !=0) && (gl_HybTrSymcnt_start > 0) )
      {
         us_PgaTrainingDbg = gs_PgaTrainingDbg;
      }

      //LA: Hybridsetting
      //PGA1: gain = gain from HS??
      //LP1: on
      //ACE: bypass mode
      //PGA2: gain = -8dB
      //LP2: on
         //%%%%%%% SET PGA gains to start values for PGA-Training %%%%%%%%%%%%%%%%%%%%
         //PGA_gain_dB_start=-9;
         //vrx5afe_api('vrx5afe_set_hybrid_rsa',400);  % required due to error in API, remove later !!!!!!!!!!!!!!!
         //vrx5afe_api('vrx5afe_dsl_pga_gainfc_set',api_mode,PGA_gain_dB_start,fc_PGA_LP); %//Mode 17//Gain_Pga_dB//FC_Pga_LP_kHz
         //%% set PREFI to bypass mode, -8dB
         //PREFI_gain_dB = -8;    % PREFI gain = -8;
         //vrx5afe_api('vrx5afe_dsl_prefi_gainfc_set',2, PREFI_gain_dB,40000); % 40MHz due to limitation of register-options
         //VRX518_h(r.DSL_FCSI_PGA5, '0001', '0001');              % PREFI bypass

      //PGA1: gain = gain from HS??   LP1: on
      // program AGC1 settings: PGA gain + fc_lp
      gs_AGC1_Gain_Set = -9; //add #define
      if (us_PgaTrainingDbg & TEST_HP2_CONFIG_AGC1_START_xDB)
      {
         //
         gs_AGC1_Gain_Set = gc_AGC1_Gain_Start;
      }
      vrx5afe_dsl_pga_gainfc_set(mode_set, gs_AGC1_Gain_Set, gla_fc_pga_lp_kHz[mode_set]);

      //if ((gft_EnableDoublePGATrain == TRUE) || (gft_BypassRxAFE_HPF == TRUE))
      if (gft_EnableDoublePGATrain == TRUE)
      {
         //%% set PREFI to bypass mode, -8dB
         //PREFI_gain_dB = -8;    % PREFI gain = -8;
         //vrx5afe_api('vrx5afe_dsl_prefi_gainfc_set',2, PREFI_gain_dB,40000); % 40MHz due to limitation of register-options
         //VRX518_h(r.DSL_FCSI_PGA5, '0001', '0001');              % PREFI bypass

         //PGA2: gain = -8dB LP2: on
            //AGC2gain2(Variable Gain) // PREFI gain + fc_lp
         gs_AGC2_Gain_Set = -8;
         fc_prefi_lp_kHz_PGA1Train = 40000;
#if 0
            //vrx5afe_dsl_prefi_gainfc_set(BYPASSED, gs_AGC2_Gain_Set, gla_fc_prefi_lp_kHz[BYPASSED]);
            vrx5afe_dsl_prefi_gainfc_set(mode_set, gs_AGC2_Gain_Set, gla_fc_prefi_lp_kHz[BYPASSED]);


#else    //VDSL2 way of implemenatation
         //vrx5afe_dsl_prefi_gainfc_set(mode_set, gs_AGC2_Gain_Set, fc_prefi_lp_kHz_PGA1Train);
         //XDSLRTFW-3674 New_LLAPI_changes (start)
         if(gft_IsBTorLLoop == TRUE)
         {  // R1 2400 Ohm configuration
            vrx5afe_dsl_prefi_gainfc_set(ADSL2_CPE_LL, gs_AGC2_Gain_Set, gla_fc_prefi_lp_kHz[BYPASSED]);
         }
         else
         {  // R1 4900 Ohm configuration
            vrx5afe_dsl_prefi_gainfc_set(mode_set, gs_AGC2_Gain_Set, gla_fc_prefi_lp_kHz[BYPASSED]);
         }
         //XDSLRTFW-3674 New_LLAPI_changes (end)
         // set bypass
         VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA5), \
            VRX5AFE_DSL_FCSI_PGA5_PREFI35BYPASS__ISMSK, \
            VRX5AFE_DSL_FCSI_PGA5_PREFI35BYPASS_1__SVAL);
#endif

         // ACE always OFF in ADSL-mode (per default OFF)
         // C21(30pF) | C22(15pF) | C23(7.5pF)
         //     0           0           0
         // PREFI ACE
         vrx5afe_dsl_prefi_ace_set(ACE_OFF);

      }
      else
      {
         //Train both PGA1 & 2 together
         // PREFI ACE
         vrx5afe_dsl_prefi_ace_set(ACE_OFF);

         // PREFI gain + fc_lp
         gs_AGC2_Gain_Set = -8;  //CHECK_VRX518AFE  is it 0 or even low
         //XDSLRTFW-3674 New_LLAPI_changes (start)
         if(gft_IsBTorLLoop == TRUE)
         {  // R1 2400 Ohm configuration
            vrx5afe_dsl_prefi_gainfc_set(ADSL2_CPE_LL, gs_AGC2_Gain_Set, gla_fc_prefi_lp_kHz[mode_set]);
         }
         else
         {  // R1 4900 Ohm configuration
            vrx5afe_dsl_prefi_gainfc_set(mode_set, gs_AGC2_Gain_Set, gla_fc_prefi_lp_kHz[mode_set]);
         }
         //XDSLRTFW-3674 New_LLAPI_changes (end)
      }

      // gs_PGA_set = PGA1 + PGA2
      gs_PGA_set = (gs_AGC1_Gain_Set + gs_AGC2_Gain_Set) << 8;

      if (gft_HybridTrainEnable == 1)
      {

       int16 s_HybGainIndex = (gs_LoadHybIndex * VRX_HYB_AFE_REG_GAINS);
       gsa_HybGain[s_HybGainIndex + PGA_SET_OFFSET] = gs_PGA_set;
       gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET] = gs_AGC1_Gain_Set;
       gsa_HybGain[s_HybGainIndex + AGC2_GAIN_SET_OFFSET] = gs_AGC2_Gain_Set;
      }


       // Update the PGA state (If this function called in Bg Task)
       guc_PgaState = TRAINING_DONE;
 }
}



void AFED_RestoreAFE_RegsforAGC2(void) //RestoreAFE_RegsAGC2_ADSL_VR9
{
   uint16 mode_set;
   mode_set = gus_AFE_RxMode;

   {

      if (gs_PgaHandlerRun ==1)
      {
      #if 0
         uint16 us_Agc2Feedback;
         uint8 uc_Agc2_Cmiller;

         if ((gs_PgaTrainingDbg & TEST_HP2_CONFIG_AGC2_START_6DB) && (gl_HybTrSymcnt_start > 0))
         {
         //AGC2_LP2_CAP_0P1F & AGC2gain2 6dB
         gs_AGC2_Gain_Set = 6;     // 6 dB
         //AGC2 Miller Capacitor programming
         uc_Agc2_Cmiller = AGC2_PRG_CMILLER_AGC2_OP_CMILLER_6dB;    //AGC2 Variable gain +6dB
         }
         else
         {
         gs_AGC2_Gain_Set = 0;    // 0 dB
         //AGC2 Miller Capacitor programming
         }
      #endif
         // PREFI ACE
         vrx5afe_dsl_prefi_ace_set(ACE_OFF); //CHECK_VRX518AFE
         // release PREFI bypass
         VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA5), \
            VRX5AFE_DSL_FCSI_PGA5_PREFI35BYPASS__ISMSK, \
            VRX5AFE_DSL_FCSI_PGA5_PREFI35BYPASS_0__SVAL);

         // PREFI gain + fc_lp
         gs_AGC2_Gain_Set = -8; //-8 to 12dB in 1dB steps for ADSL
         //XDSLRTFW-3674 New_LLAPI_changes (start)
         if(gft_IsBTorLLoop == TRUE)
         {  // R1 2400 Ohm configuration
            vrx5afe_dsl_prefi_gainfc_set(ADSL2_CPE_LL, gs_AGC2_Gain_Set, gla_fc_prefi_lp_kHz[mode_set]);
         }
         else
         {  // R1 4900 Ohm configuration
            vrx5afe_dsl_prefi_gainfc_set(mode_set, gs_AGC2_Gain_Set, gla_fc_prefi_lp_kHz[mode_set]);
         }
         //XDSLRTFW-3674 New_LLAPI_changes (end)
      }
  }
   // Update the PGA state (If this function called in Bg Task)
   guc_PgaState = TRAINING_DONE;
}


//CheckADCOverflow_ADSL_VR9
void AFED_CheckADCOverflow_ADSL(void)
{
    //in vrx518 there is no ADC overflow status register, so return 0

    gft_ADCOverflowed = 0; // mask for Rx Overflow status
}


   /*******************************************************************************
   *
   *   Prototype: void AFED_HskQlnHlogSetHybrid(void)
   **  This function overwrites the hybrid parameters for Hlog/Qln/PCB computations
   *
   *   Input Arguments:
   *   Global Variables:
   *   Hybrid array index corresponding to the row: gs_HybTrIndex
   *
   *
   *   Output Arguments:
   *
   *   Returns:
   *
   *******************************************************************************/
void AFED_HskQlnHlogSetHybrid(void) //ProgHyb_QlnHlog
{
   uint16 *pHybRegSetting,ReadDataDummy;


   if (gus_SkipAfeFlow & 0x800)
   {
      guc_PgaState = TRAINING_DONE;
      return;
   }

   if (gs_Hyb_Hsk_QlnHlog == 1)
   {
      pHybRegSetting = &gusa_HybridSettingV2_Handshake_VRX518[0];
   }
   else if (gs_Hyb_Hsk_QlnHlog == 2)
   {
      pHybRegSetting = &gusa_HybridSettingV2_QlnHlog_VRX518[0];
      //   POFIPOCO_gain = VRX5AFE_FCSI_READ(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO1), &ReadDataDummy);
      gus_AFeReg_PGA0 = VRX5AFE_FCSI_READ(FCSI_DSL,DSL_FCSI(VRX5AFE_DSL_FCSI_PGA0), &ReadDataDummy);
      gus_AFeReg_PGA1 = VRX5AFE_FCSI_READ(FCSI_DSL,DSL_FCSI(VRX5AFE_DSL_FCSI_PGA1), &ReadDataDummy);
      gus_AFeReg_PGA2 = VRX5AFE_FCSI_READ(FCSI_DSL,DSL_FCSI(VRX5AFE_DSL_FCSI_PGA2), &ReadDataDummy);
   }
   else
   {
      //pHybRegSetting = gusa_SpecialHybSetting[0];
       pHybRegSetting = gusa_InitHybridSettings + (gs_LoadHybIndex * VRX518_HYB_NUM_SETTINGS);
   }

   //Hybrid Coeff 0
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA0), 0x0000, *pHybRegSetting++);

   //Hybrid Coeff 1
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA1), 0x0000, *pHybRegSetting++);

   //Hybrid Coeff 2
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA2), 0x0000, *pHybRegSetting);
   guc_BkgdTaskState = BKGDTASK_DONE;
   return;

}

/*******************************************************************************
**
** Prototype: void  RestoreHyb_QlnHlog(void)
**
**  This function restores the hybrid parameters after Hlog/Qln/PCB computations
**
**   Input Arguments:
**
**   Output Arguments:
**
**   Returns:
**
**   Global Variables:
**       None
**
*******************************************************************************/
void AFED_RestoreHyb_QlnHlog(void)  //RestoreHyb_QlnHlog
{
   // Restore back the hybrid values

   //void VRX5AFE_FCSI_WRITE(uint16 FcsiInterface, uint16 AfeRegAddress, uint16 AfeRegData)
   VRX5AFE_FCSI_WRITE(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA0), gus_AFeReg_PGA0);
   VRX5AFE_FCSI_WRITE(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA1), gus_AFeReg_PGA1);
   VRX5AFE_FCSI_WRITE(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA2), gus_AFeReg_PGA2);

   guc_BkgdTaskState = BKGDTASK_DONE;
   return;
}

int16 AFED_SetInitialPgaToMax() //SetInitialPgaToMax
{
   int16 s_max_PgaSetting;

   //gs_PGA_required = 23*256; /* use 23dB to avoid Cocomo testvector changes */

     gs_PGA_required = (AFED_AGC1_MAX_PGA + AFED_AGC2_MAX_PGA)<<8; //(21+12) => 33dB for R1 4900 Ohm
     gs_max_pga_setting = gs_PGA_required;
     s_max_PgaSetting = gs_max_pga_setting;
     return (s_max_PgaSetting);
}

int16 AFED_MinPGASetting(void)
{

   int16 s_min_PgaSetting;

     s_min_PgaSetting =(AFED_AGC1_MIN_PGA + AFED_AGC2_MIN_PGA) << 8; // (-9+(-8)) -17
     //s_min_PgaSetting =  -12 << 8;//VR9 like setting , this is used for tone detection, min -17dB, Todo Revisit
   return (s_min_PgaSetting);

}
/*******************************************************************************
**
** Prototype: void  AFED_BgSetNmsPGA(void)
**
**  This function used to add the delta PGA in AGC1
**
**   Input Arguments:
**
**   Output Arguments:
**
**   Returns:
**
**   Global Variables:
**       None
**
*******************************************************************************/

void AFED_BgSetNmsPGA(void)
{
   gft_EnableDoublePGATrain = FALSE;
   AFED_CalcAGC1(gs_PGA_required);
   //Disabled here to write the all AFE gain registers once using SetPGA() and
   //Reenable the flag after SetPGA.
   AFED_SetPga(); //SetPGA() is called directly since PgmHybrGain() was called in TC task.
   gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Gain_Set) << 8); //8.8 format
   gft_EnableDoublePGATrain = TRUE;

}


