/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_RcMeasure.c
*
*   This file contains VRX518 AFE init routines
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 Init routines
//
// **********************************************************************************************//


/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "common.h"
#include "typedef.h"
#include "str_memmap.h"
#include "LL_IOf.h"
#include "delay.h"
#include "Const.h"
#include "Gdata.h"


#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL

// ---------------------------------------------------
// Set and get of global variables for RC-measurement
// ---------------------------------------------------

void vrx5afe_set_rc_meas_done(uint16_t set_val)
{
   RC_meas_done = set_val;
}

uint16_t vrx5afe_get_rc_meas_done(void)
{
   return RC_meas_done;
}


void vrx5afe_set_rc_count(uint16_t rc_count_val)
{
   RC_counter = rc_count_val;
}

uint16_t vrx5afe_get_rc_count(void)
{
   return RC_counter;
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  AFED_RcMeasure()
**
** DESCRIPTION:    MeasuresRC internally calls "ReadRCCnt" which calculates the
**                 the RC time constant value as described in sec 2.5 of AFEspec
**
**                 This function does the RC  measurement first in Calibration
**                 mode and then in Measurement mode.
**
**      Computation of the RC time constant detailed procedure is as given below.
**
** PARAMETERS:     NONE
**
** RETURN VALUE:Flag Status TRUE for Success FAIL for failure
**
** NOTES:Reference:
**
**       Registers used :
**
** =============================================================================
*/

//-----------------------------
// RC-meas (adapted from Wave)
//-----------------------------
//int16_t vrx5afe_rc_meas(uint16_t *rccount) // use pointer to pass val1, val2 and <val>
//int16_t vrx5afe_rc_meas()

//-----------------------------
// RC-meas (adapted from Wave)
//-----------------------------
//int16_t vrx5afe_rc_meas(uint16_t *rccount) // use pointer to pass val1, val2 and <val>
//int16_t vrx5afe_rc_meas()
void vrx5afe_rc_meas()
{
    // DON'T FORGET TO ENABLE THE INPUT CLOCK FOR THE RCMEAS

   // returns rc_meas_done = 0 if itdoesn't work properly


    uint16_t _data[FCSI_PORTS];
    uint16_t measdone = 0;
    uint16_t rccount_1 = 0;
    uint16_t rccount_2 = 0;
    uint16_t rccount_avg = 0;
    uint16_t i = 0;


    //--------
    // MEAS 1
    //--------

    // settings and start meas1
    VRX5AFE_FCSI_WRITE(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS0),\
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_SWAP_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_PUPRCTUNING_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_RESETNCNT_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_START_0__SVAL);

    VRX5AFE_FCSI_WRITE(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS0),\
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_SWAP_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_PUPRCTUNING_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_RESETNCNT_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_START_0__SVAL);

    VRX5AFE_FCSI_WRITE(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS0),\
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_SWAP_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_PUPRCTUNING_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_RESETNCNT_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_START_0__SVAL);

    VRX5AFE_FCSI_WRITE(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS0),\
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_SWAP_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_PUPRCTUNING_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_RESETNCNT_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_START_1__SVAL);

    // read measdone and countvalue
    while ((measdone == 0) && (i < 15))
    {
        VRX5AFE_FCSI_READ(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS1), _data);
        measdone = (_data[0] & VRX5AFE_CENTRAL_FCSI_RCMEAS1_RCTUNINGMEASDONE__SMSK) >>12; //rctuningmeasdone bit
        i = i+1;
    }

    if (measdone == 1)
    {
      rccount_1 = _data[0] & VRX5AFE_CENTRAL_FCSI_RCMEAS1_RCCOUNT__SMSK;
    }
    else
    {
        // set global variable RC_meas_done->0
        vrx5afe_set_rc_meas_done(0);
        // set global variable RC_counter->RC_nom
        vrx5afe_set_rc_count(RC_nom);
        // set rcmeas back to default value
        VRX5AFE_FCSI_WRITE(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS0),\
                VRX5AFE_CENTRAL_FCSI_RCMEAS0_SWAP_0__SVAL | \
                VRX5AFE_CENTRAL_FCSI_RCMEAS0_PUPRCTUNING_0__SVAL | \
                VRX5AFE_CENTRAL_FCSI_RCMEAS0_RESETNCNT_0__SVAL | \
                VRX5AFE_CENTRAL_FCSI_RCMEAS0_START_0__SVAL);
      return;
    }


    //--------
    // MEAS 2
    //--------

    // reset rcmeas, change swap bit, and start 2nd measurement
    VRX5AFE_FCSI_WRITE(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS0),\
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_SWAP_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_PUPRCTUNING_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_RESETNCNT_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_START_0__SVAL);

    VRX5AFE_FCSI_WRITE(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS0),\
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_SWAP_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_PUPRCTUNING_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_RESETNCNT_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_START_0__SVAL);

    VRX5AFE_FCSI_WRITE(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS0),\
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_SWAP_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_PUPRCTUNING_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_RESETNCNT_1__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_START_1__SVAL);

    // read measdone and 2nd countvalue
    measdone = 0;
    i = 0;

    while ((measdone == 0) && (i < 15))
    {
      VRX5AFE_FCSI_READ(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS1), _data);
        measdone = (_data[0] & VRX5AFE_CENTRAL_FCSI_RCMEAS1_RCTUNINGMEASDONE__SMSK) >>12; //rctuningmeasdone bit
        i = i+1;
    }

    if (measdone == 1)
    {
      rccount_2 = _data[0] & VRX5AFE_CENTRAL_FCSI_RCMEAS1_RCCOUNT__SMSK;
    }
    else
    {
        // set global variable RC_meas_done->0
        vrx5afe_set_rc_meas_done(0);
        // set global variable RC_counter->RC_nom
        vrx5afe_set_rc_count(RC_nom);
        // set rcmeas back to default value
        VRX5AFE_FCSI_WRITE(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS0),\
                VRX5AFE_CENTRAL_FCSI_RCMEAS0_SWAP_0__SVAL | \
                VRX5AFE_CENTRAL_FCSI_RCMEAS0_PUPRCTUNING_0__SVAL | \
                VRX5AFE_CENTRAL_FCSI_RCMEAS0_RESETNCNT_0__SVAL | \
                VRX5AFE_CENTRAL_FCSI_RCMEAS0_START_0__SVAL);
        return;
    }


    // average rc-count value
    rccount_avg = (rccount_1 + rccount_2) / 2;


    // set rcmeas back to default value
    VRX5AFE_FCSI_WRITE(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_RCMEAS0),\
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_SWAP_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_PUPRCTUNING_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_RESETNCNT_0__SVAL | \
            VRX5AFE_CENTRAL_FCSI_RCMEAS0_START_0__SVAL);


    // set global variable RC_meas_done->1
    vrx5afe_set_rc_meas_done(1);

    // set global variable RC_counter->rccount_avg
    vrx5afe_set_rc_count(rccount_avg);

//    // return RC-counter
//    return (int16_t) rccount_avg; // cast 16bit unsigned to 16bit signed
}

//uint16 gus_ctune_poco_bin;
//void vrx5afe_rc_tune(int16_t RC_count)

void vrx5afe_c_tune(uint16_t ctune_poco_shift )
{
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO1), \
        VRX5AFE_DSL_FCSI_POCO1_CTUNE__ISMSK, \
        ctune_poco_shift);

}

void vrx5afe_POCO_PD(void)
{
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO0), \
        VRX5AFE_DSL_FCSI_POCO0_PUPPOCO__ISMSK, \
        VRX5AFE_DSL_FCSI_POCO0_PUPPOCO_OFF__SVAL);

}

void vrx5afe_POCO_PU(void)
{
   VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO0), \
        VRX5AFE_DSL_FCSI_POCO0_PUPPOCO__ISMSK, \
        VRX5AFE_DSL_FCSI_POCO0_PUPPOCO_ON__SVAL);
}

void vrx5afe_rc_tune()
{
   uint16_t ctune_poco_bin,  ctune_poco_shift;
   uint16_t ctune_sdadc_bin, ctune_sdadc_shift;
#if 1
    uint16_t ctune_sdadc_bin_store = 0;
#endif

   int32_t temp1, RC_nomxK, ConstValue;

   uint16_t RC_count = 0;

#ifdef TEST_FLOAT_VRX518
   uint16_t ctune_poco_bin_Float, ctune_sdadc_bin_Float;
   float temp2;
#endif
    uint16_t DSL_version = 0;
    DSL_version = vrx5afe_get_dsl_version_init(0); //copy information from static area


   // get RC-counter value from global variable
   RC_count = vrx5afe_get_rc_count();


   //------
   // POCO
   //------
#ifdef TEST_FLOAT_VRX518
   //ctune_poco_bin = (uint16_t) ( (17.8 * RC_nom / RC_count - 12.0) + 0.5 );    // round(x) = truncate(x+0.5)
   temp2 = (17.8 * RC_nom / RC_count - 12.0) ;
   if (temp2 < 0)
   {
      ctune_poco_bin_Float = 0;
   }
   else
   {
      ctune_poco_bin_Float = (uint16_t)(temp2 + 0.5);                           // round(x) = truncate(x+0.5)
   }
   if (ctune_poco_bin_Float > VRX5AFE_DSL_FCSI_POCO1_CTUNE__MSK)
      {
            ctune_poco_bin_Float = VRX5AFE_DSL_FCSI_POCO1_CTUNE__MSK;
      }
#endif

    // float to fixed point of ctune_poco_bin
   RC_nomxK   = 0xB171999;      // Q15  // = 17.8 * RC_nom = 17.8*319 in Q15 = 0xB171999
   ConstValue = 0x60000;        // Q15  // =             12     in Q15 = 0x60000 (=12 *(1<<15))

   temp1 = RC_nomxK / RC_count; // Result in Q15 format
   temp1 = temp1 - ConstValue;  // Result in Q15 format

   if ((temp1 >> 15) < 0)
   {
      //ctune_poco_bin = (uint16_t)((temp1 - (1 << 14)) >> 15);  // Convert to integer; round(x) = truncate(x+0.5)
      ctune_poco_bin = 0;
   }
   else
   {
      ctune_poco_bin = (uint16_t)((temp1 + (1 << 14)) >> 15);    // Convert to integer; round(x) = truncate(x+0.5)
   }

   if (ctune_poco_bin > VRX5AFE_DSL_FCSI_POCO1_CTUNE__MSK)        // saturate to max. value
   {
      ctune_poco_bin = VRX5AFE_DSL_FCSI_POCO1_CTUNE__MSK;
   }
   gus_ctune_poco_bin = ctune_poco_bin;
   ctune_poco_shift = ctune_poco_bin & VRX5AFE_DSL_FCSI_POCO1_CTUNE__MSK;      // guarante's data bit-range
   ctune_poco_shift = ctune_poco_shift << VRX5AFE_DSL_FCSI_POCO1_CTUNE__POS;   // shift to correct position for "write"


    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO1), \
         VRX5AFE_DSL_FCSI_POCO1_CTUNE__ISMSK, \
         ctune_poco_shift);


    //-----
   // ADC
    //-----
#ifdef TEST_FLOAT_VRX518
   //ctune_sdadc_bin = (uint16_t) ( (18.9 * RC_nom / RC_count - 12.9) + 0.5 );   // round(x) = truncate(x+0.5)
   temp2 = (18.9 * RC_nom / RC_count - 12.9);
   if (temp2 < 0)
   {
      ctune_sdadc_bin_Float = 0;
   }
   else
   {
      ctune_sdadc_bin_Float = (uint16_t)(temp2 + 0.5);                          // round(x) = truncate(x+0.5)
   }
   if (ctune_sdadc_bin_Float > VRX5AFE_DSL_FCSI_SDADC0_CTUNE__MSK)
      {
            ctune_sdadc_bin_Float = VRX5AFE_DSL_FCSI_SDADC0_CTUNE__MSK;
   }
#endif

    // float to fixed point of ctune_sdadc_bin
   RC_nomxK = 0xBC68CCC;        // Q15  // = 18.9*RC_nom = 18.9*319 in Q15 = 0xBC68CCC
   ConstValue = 0x67333;        // Q15  // =                12.9 in Q15 = 0x67333

   temp1 = RC_nomxK / RC_count; // Result in Q15 format
   temp1 = temp1 - ConstValue;  // Result in Q15 format
   if ((temp1 >> 15) < 0)
   {
      ctune_sdadc_bin = 0;
   }
   else
   {
      ctune_sdadc_bin = (uint16_t)((temp1 + (1<<14)) >> 15);     // Convert to integer; round(x) = truncate(x+0.5)
   }

   if (ctune_sdadc_bin > VRX5AFE_DSL_FCSI_SDADC0_CTUNE__MSK)         // saturate to max. value
   {
      ctune_sdadc_bin = VRX5AFE_DSL_FCSI_SDADC0_CTUNE__MSK;
   }

   ctune_sdadc_shift = ctune_sdadc_bin & VRX5AFE_DSL_FCSI_SDADC0_CTUNE__MSK;    // guarante's data bit-range
   ctune_sdadc_shift = ctune_sdadc_shift << VRX5AFE_DSL_FCSI_SDADC0_CTUNE__POS; // shift to correct position for "write"

    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC0), \
         VRX5AFE_DSL_FCSI_SDADC0_CTUNE__ISMSK, \
         ctune_sdadc_shift);

    //----------------------------------------------------------------------------------
    // Type 1 setting - performance improvement
#if 1 //A11 is not taken this code, QA team tested without this working fine in A11.
    if(DSL_version != 0)
    {
      // programming of EXTC1TUNE
      ctune_sdadc_bin_store = ctune_sdadc_bin;

      ctune_sdadc_bin = 8 + (ctune_sdadc_bin_store - 6);
      if (ctune_sdadc_bin > 15)
      {
               ctune_sdadc_bin = 15;
         }
    }
#endif
   ctune_sdadc_shift = ctune_sdadc_bin & VRX5AFE_DSL_FCSI_SDADC2_EXTC1TUNE__MSK;    // guarante's data bit-range
   ctune_sdadc_shift = ctune_sdadc_shift << VRX5AFE_DSL_FCSI_SDADC2_EXTC1TUNE__POS; // shift to correct position for "write"

    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC2), \
         VRX5AFE_DSL_FCSI_SDADC2_EXTC1TUNE__ISMSK, \
         ctune_sdadc_shift);

#if 1 //A11 is not taken this code, QA team tested without this working fine in A11.
   //// programming of EXTC2TUNE & EXTC3TUNE
    if(DSL_version != 0)
    {
      if (ctune_sdadc_bin_store > 6)
         {
               ctune_sdadc_bin = ctune_sdadc_bin_store - 6;
         }
      else
      {
               ctune_sdadc_bin = 0;
         }
    }
#endif
   ctune_sdadc_shift = ctune_sdadc_bin & VRX5AFE_DSL_FCSI_SDADC2_EXTC2TUNE__MSK;    // guarante's data bit-range
   ctune_sdadc_shift = ctune_sdadc_shift << VRX5AFE_DSL_FCSI_SDADC2_EXTC2TUNE__POS; // shift to correct position for "write"

    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC2), \
         VRX5AFE_DSL_FCSI_SDADC2_EXTC2TUNE__ISMSK, \
         ctune_sdadc_shift);

   ctune_sdadc_shift = ctune_sdadc_bin & VRX5AFE_DSL_FCSI_SDADC2_EXTC3TUNE__MSK;    // guarante's data bit-range
   ctune_sdadc_shift = ctune_sdadc_shift << VRX5AFE_DSL_FCSI_SDADC2_EXTC3TUNE__POS; // shift to correct position for "write"

    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC2), \
         VRX5AFE_DSL_FCSI_SDADC2_EXTC3TUNE__ISMSK, \
         ctune_sdadc_shift);
    //----------------------------------------------------------------------------------

#ifdef TEST_FLOAT_VRX518
   debug_printf("\nRC=%5d::poco_bin =%4d %4d Diff=%2d sdadc_bin=%4d %4d Diff=%2d", RC_count, ctune_poco_bin_Float, ctune_poco_bin, ctune_poco_bin_Float - ctune_poco_bin, ctune_sdadc_bin_Float, ctune_sdadc_bin, ctune_sdadc_bin_Float - ctune_sdadc_bin);
#endif


    //-------------
   // PREFI - ACE
    //-------------
   // moved to vrx5afe_dsl_prefi_ace_set()


    //----------------------
   // PGA: -> no RC-tuning
    //----------------------


   //------------------------------
   // PGA - Hybrid -> no RC-tuning
   //------------------------------
}


void ProgramOSCDriveLevel(uint16 us_data)
{
   uint16 us_data1;
   us_data1 = us_data;
   //XO_CTL_AFE_SET(us_data); //VRX518AFE_OPEN
}




