/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _AFED_CONSTANTS_H
#define _AFED_CONSTANTS_H
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_AfeConstants.h
*
*   This file contains VRX518 AFE Data
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 AFE data
//
// **********************************************************************************************//

#include "common.h"
#include "vrx5afe_mode_defines.h"
// ADSL PGA Handler Substates
#define PGA_INIT                       (200)
#define PGA_CLEAR_OVERFLOW             (201)
#define BOOST_PGA_GAIN                 (202)
#define PGA_SET_ADC_OVERFLOWS          (203)
#define PGA_WAIT_ADC_OVERFLOWS         (204)
#define PGA_CHECK_ADC_OVERFLOW         (205)
#define SET_PGA_WAIT                   (206)
#define PGA_RX_PWR_INITIALIZE          (207)
#define SET_PGA                        (208)
#define PGA_WAIT                       (209)
#define PGA_START_AGC2_COMPUTATION     (210)
#define PGA_DOUBLE_TRN_DONE            (211)




//VRX518_AFE
#define  FCSI_CENTRAL      (VRX5AFE_CENTRAL)
#define  FCSI_DSL       (VRX5AFE_DSL)

#define VERSIONAFE_CENTRAL_A11   (0x00)  //0000 0000b Version A11 CENTRAL
#define VERSIONAFE_CENTRAL_A21   (0x01)  //0000 0001b Version A21 CENTRAL
#define  VERSIONAFE_DSL_A11      (0x00)  // 0000 0000b Version A11 DSL
#define  VERSIONAFE_DSL_A21      (0x02)  // 0000 0010b Version A21 DSL

//V_FCSI_CMD_C_35B / V_FCSI_CMD_D_35B  "CMD" field
#define  FCSI_CMD_RST_BUSREGS          0x6000  //Reset FCSI-Bus registers. The Command is queued into the Transmit-FIFO.
#define  FCSI_CMD_RST_CONTROLLER_BUSREGS  0x4000  //Reset the FCSI Controller and the FCSI-Bus registers. The Command is executed immediately.
#define  FCSI_BUS_READ_ACCESS          0x2000 //FCSI-Bus read access. The Command is queued into the Transmit-FIFO. After Command execution the read data is stored in the Receive-FIFO.
                                    //The queued data can be fetched with a read access to the RBUF register. The Command execution is stalled when the Receive-FIFO is full.
#define  FCSI_BUS_WRITE_ACCESS            0x0000 //FCSI-Bus write access. A following data write to the XBUF register is required and queues the Command together with the FCSI write data into the Transmit-FIFO

#define  FCSI_RR_BIT_STATUS      (0x0004) //Bit#2 Mask
#define  FCSI_XE_BIT_STATUS      (0x0002) //Bit#1 Mask
#define  FCSI_XR_BIT_STATUS      (0x0001) //Bit#0 Mask


#define FCSI_AFE_RD_TIMEOUT      (5000)   //TBD
#define FCSI_AFE_WR_TIMEOUT      (5000)   //TBD

//PGA1
#define  AFED_AGC1_MIN_PGA       (-9)  //in dB
#define  AFED_AGC1_PGA_MINUS_6DB    (-6)  //in dB

#define  AFED_AGC1_MAX_PGA    (21)  //in dB
#define  AFED_AGC1_MAX_PGA_8K (15)  //in dB
//XDSLRTFW-3674 New_LLAPI_changes (start)
//PGA2
#define  AFED_AGC2_MIN_PGA          (-8)  //in dB
#define  AFED_AGC2_MAX_PGA          (12)  //in dB for R1 4900 Ohm (check PGA5 register field PREFI35ACESRES)
#define  AFED_AGC2_MAX_PGA_R1_2400  (18)  //in dB for R1 2400 Ohm (check PGA5 register field PREFI35ACESRES)



#define VRX518_NUM_CAP_SEARCH             (0)  // No of hybrid with cap modification = VR9_NUM_CAP_SEARCH - 1
#define VRX518_ANX_ABJ_NUM_HYBS_ANNEXA       ( 28+1) //+1 for HLOG hybrid setting XDSLRTFW_3753 (start)
#define VRX518_ANX_ABJ_NUM_HYBS_ANNEXB       ( 25+1) //+1 for HLOG hybrid setting XDSLRTFW_3753 (end)
//XDSLRTFW-3674 New_LLAPI_changes (end)
#define VRX_HYB_TYPE_ABJ               (0x1) //Adaptive hybrid for Annex BJ
//#define VR9_HYB_TYPE_A               (0x1) //Adaptive hybrid for Annex A //VRX518AFE_CHECK


#ifdef ISDN
#define VRX518_MAX_NUM_ADAP_HYB_SETTINGS     VRX518_ANX_ABJ_NUM_HYBS_ANNEXB
#else
#define VRX518_MAX_NUM_ADAP_HYB_SETTINGS     VRX518_ANX_ABJ_NUM_HYBS_ANNEXA
#endif

#define VRX518_HYB_NUM_GAIN_VALUES     (1)
#define VRX518_HYB_NUM_AFE_REGS        (3)
#define VRX518_HYB_NUM_SETTINGS        (VRX518_HYB_NUM_AFE_REGS+VRX518_HYB_NUM_GAIN_VALUES) //3+1//
#define VRX518_HYBGAIN_IDX             (3)  // Hybrid gain value index



//ACE
#define     ACE_52p5F         (0)
#define     ACE_30pF          (1)
#define     ACE_15pF          (2)
#define     ACE_7p5F          (3)
#define     ACE_OFF           (4)

#endif /* _AFED_CONSTANTS_H */

