/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _AFED_DATA_H
#define _AFED_DATA_H
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_AfeData.h
*
*   This file contains VRX518 AFE Data
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 AFE data
//
// **********************************************************************************************//

#include "common.h"
#include "typedef.h"
#include "str_memmap.h"
#include "Data_alloc.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL

// global variable for RC-measurement
extern uint16_t RC_meas_done;
extern uint16_t RC_counter;
extern uint32   gul_Afe_flowtest;
extern uint16  gus_SkipAfeFlow;
extern uint16  gus_AfeImproveFixes;
extern int16_t gs_ForceGainPofi_dB;
extern int16 gs_Hyb_Hsk_QlnHlog;
extern int32_t gla_fc_pga_lp_kHz[];
extern int32_t gla_fc_prefi_lp_kHz[];
extern int32_t gla_fc_pofi_lp_kHz[];
extern int16_t gsa_gain_pofi_dB[];
extern uint16 gusa_HybridSettingV2_Handshake_VRX518[];
extern uint16 gusa_HybridSettingV2_QlnHlog_VRX518[];
extern uint16 gusa_HybridSettingV2_Handshake_A21_old_VRX518[];
extern uint16 gusa_HybridSettingV2_QlnHlog_A21_old_VRX518[];

extern uint16 gus_AFeReg_PGA0,gus_AFeReg_PGA1, gus_AFeReg_PGA2;
extern uint16 gusa_SpecialHybSetting[];

#ifdef ISDN
extern uint16 gusa_HybridSetting_ADSL_B[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS];
extern uint16 gusa_A21_HybridSetting_ADSL_B[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS];
#else
extern uint16 gusa_HybridSetting_ADSL_A[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS];
extern uint16 gusa_A21_HybridSetting_ADSL_A[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS];
extern uint16 gusa_A21_HybridSetting_ADSL_A_17kft[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS];
extern uint16 gusa_A21_HybridSetting_ADSL_A_BTLOOPS[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS];
#endif
extern uint32 gula_VRX518_EfuseTable[];


#endif /* _AFED_DATA_H */

