/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _AFED_ReadWriteModify_H
#define _AFED_ReadWriteModify_H
/////******************************************************************************************
//
//
//    File Name:  AFED_ReadWriteRmw.h
//
//    History
//
// 17/04/2016 Palaksha: This file contains functions definitions for AFE Read/Write/ReadModify
//
/////******************************************************************************************
/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "common.h"
#include "typedef.h"

// Primitives proto types

//uint16_t VRX5AFE_FCSI_READ(uint16_t block, uint16_t address, uint16_t *rdata)
//void    VRX5AFE_FCSI_RMW(uint16_t block, uint16_t address, uint16_t mask, uint16_t value)
//void    VRX5AFE_FCSI_WRITE(uint16_t block, uint16_t address, uint16_t value)

// VRX518 AFE Register Primitives proto types
//uint16 AFED_ReadAfeRegister(uint16 FcsiInterface, uint16 AfeRegAddress, uint16 *rdata));
uint16 VRX5AFE_FCSI_READ(uint16 FcsiInterface, uint16 AfeRegAddress, uint16 *rdata);
//void   AFED_WriteAfeRegister (uint16  FcsiInterface,uint16 AfeRegAddress, uint16 AfeRegData);
void VRX5AFE_FCSI_WRITE(uint16 FcsiInterface, uint16 AfeRegAddress, uint16 AfeRegData);
//void   AFED_ReadModifyAfeRegister (uint16 FcsiInterface,uint16 AfeRegAddress,uint16 mask, uint16 AfeRegData);
void VRX5AFE_FCSI_RMW(uint16 FcsiInterface, uint16 AfeRegAddress, uint16 mask, uint16 AfeRegData);

//Register FCSI_IRNICR_C/D following bits meaning
//XR:Indicates that the Transmit-FIFO is not full, i.e. at least one new command can be queued.
//XE:Indicates that the Transmit-FIFO is empty.
//RR:Indicates that at least one data word is available in the Receive Buffer Register RBUF.
void AFED_FcsiIrnicrRrPoll(uint16 FcsiInterface);
extern void wait_ms(uint16 msec);

#endif /* _AFED_ReadWriteModify_H */

