/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef VRX5AFE_MODE_DEFINES_H
#define VRX5AFE_MODE_DEFINES_H


// Defines for Port Access
#define VRX5AFE_CENTRAL 1 //00001
#define VRX5AFE_DSL     2 //00010

// number of FCSI ports
#define FCSI_PORTS  2

// RC-tuning
#define RC_nom 319 //Whenever RC_nom  values changes, then variable RC_nomxK in function vrx5afe_rc_tune()

// Enable floating point code for testing
//#define TEST_FLOAT_VRX518

// Factors for Fixed-Point calculations
//*********(1e9/ (2.0 * 3.1415* fc_pofi_lp_KHz * 512) ) //Scale by value 512 (9 bits) to reduce the range of number *********//
// rearrange constants and do offline float compute
//1e9/ (2.0 * 3.1415 * 512 * fc_pofi_lp_KHz) )  = (1e9/ (2.0 * 3.1415 * 512)) / fc_pofi_lp_KHz
//Const1e9By2pix = ((1e9 / (2.0 * 3.1415 * 512 * 256)) * 2 ^ 20) = 0x4BE4AAA9  Q20
               //Here scale factor 256(8bits) are used later 512(9 bits) are used
//Const1e9By2PiX = ((int32_t)0x4BE4AAA9) / fc_pga_lp_KHz; //Q20/Q0 = Q0
#define NUM_Q20_1E9BY2PIX512X256    (0x4BE4AAA9) //((1e9 / (2.0 * 3.1415 * 512 * 256)) * 2 ^ 20) = 0x4BE4AAA9  Q20
#define SCALE_1E9BY2PIX512X256BY8   (8)
#define SCALE_1E9BY2PIX512X256BY9   (9)

#endif
