/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        acc40.h
*
* DESCRIPTION:     Header file for the 40-bit accumulator
*
**************************************************************************/

/***** CONSTANTS *****/
#define ACC40_NUM_GUARD_BITS  (8)

/***** FUNCTION PROTOTYPES *****/
void ConvertAcc40toAcc48(int32 l_Acc40H, int32 l_Acc40L, int32 *pl_Acc48H, int32 *pl_Acc48L);
int32 round_acc40(int32 l_AccH, int32 l_AccL, int16 s_bit_position);

/***** MACROS *****/
/*******************************************************************************
*
*   Prototype: mACCUM40(int32 l_Acc40H, int32 l_Acc40L, int32 l_Acc)
*
*   Description:
*       This macro adds the 32-bit number l_Acc to the  40-bit accumulator
*       represented by {l_Acc40H, l_Acc40L}.
*
*******************************************************************************/
#define mACCUM40(l_Acc40H, l_Acc40L, l_Acc) {   \
   (l_Acc40L) += (l_Acc) & 0xFFFF;  \
   (l_Acc40H) += (l_Acc) >> 16;  \
} // mACCUM40

/*******************************************************************************
*
*   Prototype: mAddAcc40ToAcc48(l_acc48H, l_acc48L, l_acc40H, l_acc40L)
*
*   Description:
*       This macro adds the 40-bit number {l_acc40H, l_acc40L} to
*       the 48-bit accumulator {l_Acc48H, l_Acc48L}.
*
*******************************************************************************/
#define mAddAcc40ToAcc48(l_acc48H, l_acc48L, l_acc40H, l_acc40L) {   \
   (l_acc48H) = ((l_acc48H) + (l_acc40H)) + ((l_acc48L) >> 16) + ((l_acc40L) >> 16);   \
   (l_acc48L) = ((l_acc48L) & 0xFFFF) + ((l_acc40L) & 0xFFFF); \
} // mAddAcc40ToAcc48

