/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2004 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "H_FileTemplate.h"
** CCASE_DATE = "Wed Dec 15 12:50:51 2004"
**
** =============================================================================
**
** Project:    VDSL2
** Block:      Analog Frone-End Interface Device Driver
**
** =============================================================================
**
** Contents:   Analog Frone-End Interface Device Driver
**
** =============================================================================
**
** References: VDSL2 Firmware Design Specification - Analog Frone-End Interface
**                                                   Device Driver
**
** =============================================================================
** History:
**
** Date         Author        Comment
** 2005-04-01   SchmidCh      Initial version.
** =============================================================================
Additional version control information
********************************************************************************
 CCASE_USER    = "schmidch"
 CCASE_VERSION = "\main\2"
***C*E*************************************************************************/


#ifndef __AFE_IF_DD_H
#define __AFE_IF_DD_H

#ifdef __CPLUSPLUS__
extern "C" {
#endif

/*
** =============================================================================
**                           DEFINITIONS
** =============================================================================
*/

#define IFX_VDSL_CPE
//#define HDLC_TEST_LOOP
//#define HDLC_AFE_EMUL
//#define HDLC_TEST


/*
** =============================================================================
**                           TYPES
** =============================================================================
*/

/* configuration settings */
typedef struct afe_if_dd_cfg_t {

   /* duplex mode */
   enum duplex_t {

      HDLC_HALF,  /* half-duplex mode */
      HDLC_FULL   /* full-duplex mode */

   } duplex_e;

   /* clock divider */
   enum clk_div_t {

      HDLC_CLK_DIV_4,   /* system clock /  4 (8.832 MHz) */
      HDLC_CLK_DIV_8,   /* system clock /  8 (4.416 MHz) */
      HDLC_CLK_DIV_16,  /* system clock / 16 (2.208 MHz) */
      HDLC_CLK_DIV_32,  /* system clock / 32 (1.104 MHz) */
      HDLC_CLK_DIV_64   /* system clock / 64 (0.552 MHz) */

   } clk_div_e;

} afe_if_dd_cfg_s;

/* declare configuration settings structure */
extern afe_if_dd_cfg_s afe_if_dd_cfg;

/*
** =============================================================================
**                           FUNCTION PROTOTYPES
** =============================================================================
*/

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  afe_if_dd_error
**
** DESCRIPTION:    This function returns the AFE I/F DD's error indication. The
**                 error indication will be cleared.
**
** PARAMETERS:     None.
**
** RETURN VALUE:   Line of code in 'afe_if_dd.c' in which the error occurred.
**                 Zero, if no error occurred.
**
** NOTES:          This functions does not exist in the Aware firmware.
** =============================================================================
*/
extern uint32 afe_if_dd_error (void);

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  afe_if_dd_test
**
** DESCRIPTION:    This function runs a regression test of the AFE I/F DD.
**
** PARAMETERS:     None.
**
** RETURN VALUE:   Number of test failed. Zero if no test failed.
**
** NOTES:          This functions does not exist in the Aware firmware.
**                 This function exists only if 'HDLC_TEST_LOOP' is defined.
** =============================================================================
*/
#ifdef HDLC_TEST
extern int32 afe_if_dd_test (void);
#endif

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  ReadVDSLAfeCfg
**
** DESCRIPTION:    This function reads a configuration register in the AFE.
**
** RETURN VALUE:   Value read from the specified register in the AFE.
**
** NOTES:          This functions replaces the same function in the Aware
**                 firmware.
** =============================================================================
*/
#ifdef HDLC_TEST
extern uint16 ReadVDSLAfeCfg (uint16 us_addr);
#endif

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  InitAFESerialInterface
**
** DESCRIPTION:    This function initializes the AFE interface device driver. It
**                 must be called before any other function of the AFE I/F DD
**                 can be called.
**
** PARAMETERS:     None.
**
** RETURN VALUE:   None.
**
** NOTES:          This functions replaces the same function in the Aware
**                 firmware.
** =============================================================================
*/
extern void InitAFESerialInterface (void);

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  ReadVDSLAfe
**
** DESCRIPTION:    This function reads a register in the AFE.
**
** PARAMETERS:     address [IN] Address of register to be read from in the AFE.
**
** RETURN VALUE:   Value read from the specified register in the AFE.
**
** NOTES:          This functions replaces the same function in the Aware
**                 firmware.
** =============================================================================
*/
extern uint16 ReadVDSLAfe (uint16 us_addr);

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  WriteVDSLAfe
**
** DESCRIPTION:    This function writes a register in the AFE.
**
** PARAMETERS:     address [IN] Address of register to be written to in the AFE.
**                 data    [IN] Data to be written to the register in the AFE.
**
** RETURN VALUE:   None.
**
** NOTES:          This functions replaces the same function in the Aware
**                 firmware.
** =============================================================================
*/
extern void WriteVDSLAfe (uint16 us_addr, uint16 us_data);

#ifdef __CPLUSPLUS__
}
#endif

#endif  /* __AFE_IF_DD_H */
