/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        aux_reg_danube.h
*
* DESCRIPTION:     macros for the abstraction of multiplications
*
**************************************************************************/
//#ifndef _AUX_REG_DANUBE_h
#define _AUX_REG_DANUBE_h

#include "typedef.h"

//#ifdef DANUBE
    #define ARC_ADMA_CTRL        (0x100)
    #define ARC_ADMA_STAT        (0x101)
    #define ARC_ADMA_SA_S        (0x102)
    #define ARC_ADMA_DA_S        (0x103)
    #define ARC_ADMA_SA_E        (0x104)
    #define ARC_ADMA_FILL        (0x105)
    //#define ARC_ME2ARC_INT       (0x106)   name from spec
    #define ARC_ME2ARC_STAT      (0x106)
        #define ME2ARC_STAT_MSGAV         (0x0001)
        #define ME2ARC_STAT_CSDONE        (0x0002)
        #define ME2ARC_STAT_GPINT0        (0x0004)
        #define ME2ARC_STAT_GPINT1        (0x0008)

    //#define ARC_ARC2ME_STAT      (0x107) name from spec
    #define ARC_ARC2ME_INT       (0x107)
    // not that writing to ARC2ME_STAT_MSGAV, ARC2ME_STAT_CSDONE, ARC2ME_STAT_GPINTx won't
    // clear the corresponding ME2ARC_STAT_MSGAV, ME2ARC_STAT_CSDONE, ME2ARC_STAT_GPINTx
        #define ARC2ME_INT_MSGAV         (0x0001)
        #define ARC2ME_INT_NO_ACCESS     (0x0008)
        #define ARC2ME_INT_ARC_MSGACK    (0x0010)
        #define ARC2ME_INT_DBG_DONE      (0x0020)
        #define ARC2ME_INT_CS_REQ        (0x0040)
        #define ARC2ME_INT_GPINT0        (0x0080)
        #define ARC2ME_INT_GPINT1        (0x0100)
        #define ARC2ME_INT_MASK          (0x01F9)

    #define ARC_ME_CONFIG        (0x108)
    #define ARC_ADSL_MEMTEST     (0x109)
    #define ARC_INT_MASK         (0x10A)
        #define INT_VALID_MASK           (0x01FA)

    #define ARC_INT_EVENT        (0x10B)
        #define ARC_INT_MEMEX            (0x0002)
        #define ARC_INT_ADSL             (0x0008)
        #define ARC_INT_ADMA_DONE        (0x0010)
        #define ARC_INT_MBOX             (0x0020)
        #define ARC_INT_MEI_GP0          (0x0040)
        #define ARC_INT_MEI_GP1          (0x0080)
        #define ARC_INT_CSWAP            (0x0100)
        #define ARC_INT_XDMA_DONE        (0x0200)
        #define ARC_INT_EVENT_MASK       (0x03FA)

    #define ARC_GPIO_CTRL        (0x10C)
    #define ARC_GPIO_DATA        (0x10D)
    #define ARC_GP_STAT          (0x10E)

    #define ARC_XDMA_CTRL          (0x10F)
        #define XDMA_CTRL_ENABLED       (0x0001)
        #define XDMA_CTRL_READ_DIR      (0x0000)
        #define XDMA_CTRL_WRITE_DIR     (0x0002)
        #define XDMA_CTRL_BASE_0_SEL    (0x0000)
        #define XDMA_CTRL_BASE_1_SEL    (0x0004)

    #define ARC_XDMA_STAT          (0x110)
        #define XDMA_STAT_IN_PROC       (0x0001)
        #define XDMA_STAT_INT_ERR       (0x0004)
        #define XDMA_STAT_AHB_ERR       (0x0008)

    #define ARC_XDMA_SA_S          (0x111)
    #define ARC_XDMA_DA_S          (0x112)
    #define ARC_XDMA_SA_E          (0x113)
    //#define ARC_XDMA_GAP           (0x114)
        #define XDMA_GAP_SLOW           (0x0200)
        #define XDMA_GAP_FAST           (0x0000)

    //#define ARC_XMEM_BASE0         (0x115)
    //#define ARC_XMEM_BASE1         (0x116)
    //#define ARC_XMEM_LTEST         (0x117)

//#endif

//#endif
