/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _DATA_ALLOC_H
#define _DATA_ALLOC_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:
 * DESCRIPTION:
 *
 **********************************************************************/
//****************************************************************************
//data_alloc.h
//
// History
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//*****************************************************************************************

#define DATA_MAP_PERSISTENT                  #pragma Data(DATA,"PERSISTENT_RAM")
#define DATA_MAP_PERSISTENT_VDSL             #pragma Data(DATA,"PERSISTENT_RAM_VDSL")
#define DATA_MAP_PERSISTENT_COMMON           #pragma Data(DATA,"PERSISTENT_RAM_COMMON")
#define DATA_MAP_BIS                         #pragma Data(DATA,"BIS_RAM")
#define DATA_MAP_DMT                         #pragma Data(DATA,"DMT_RAM")

#define DATA_X_BEGIN                         #pragma Data(DATA,"X_RAM")
#define DATA_Y_BEGIN                         #pragma Data(DATA,"Y_RAM")

#define DATA_BULKO1_BEGIN                    #pragma Data(DATA,"BULK_O1")

#define DATA_BULKO2_BEGIN                    #pragma Data(DATA,"BULK_O2")

#define DATA_BULK_DATA2_BEGIN                #pragma Data(DATA,"BULK_DATA2")

#define DATA_GHS_TO_SHOW_BEGIN               #pragma Data(DATA,"GHS_TO_SHOW")

#define DATA_MAP_STMBUF_BIS                  #pragma Data(DATA,"STMBUF_RAM")

#if defined(DANUBE_TEMP) || defined(ADSL_62)
   #define DATA_MAP_ILV1_GHS                 #pragma Data(DATA,"ILV1_GHS_RAM")
   #define DATA_MAP_ILV2                     #pragma Data(DATA,"ILV2_RAM")
   #define DATA_MAP_deILV_PTR_SPACE          #pragma Data(DATA,"deILV_PTR_SPACE_RAM")
#endif

#ifdef ADSL_62
   #define DATA_LD_ST_MKERNEL_BEGIN          #pragma Data(DATA,"LD_ST_MKERNEL")
   #define DATA_PORTMODECONTROL_BEGIN        #pragma Data(DATA,"PORTMODECONTROL_DATA")
   #define DATA_SHOW_N_TRAIN_DM_BEGIN        #pragma Data(DATA, ".SHOW_N_TRAIN_DM")
   #define DATA_EXTENDED_TRAIN_BULK_BEGIN    #pragma Data(DATA, "EXTENDED_TRAIN_BULK")
   #define DATA_EXTENDED_TRAIN_BSS_BEGIN     #pragma Data(DATA, "EXTENDED_TRAIN_BSS")
   #define DATA_EXTENDED_RES_BULK_BEGIN      #pragma Data(DATA, "EXTENDED_RES_BULK")
   #define DATA_EXTENDED_RES_BSS_BEGIN       #pragma Data(DATA, "EXTENDED_RES_BSS")
   #define DATA_SRC_COEFS_4KHZ_BEGIN         #pragma Data(DATA, ".SRC_COEFS_4KHZ")
   #define DATA_XILVB_B4_SHOW_INIT_BEGIN     DATA_SHOW_N_TRAIN_DM_BEGIN
   #define DATA_ZEP_TX_UCODE_BEGIN           #pragma Data(DATA, ".ZEP_TX_UCODE")
   #define DATA_ZEP_RX_UCODE_BEGIN           #pragma Data(DATA, ".ZEP_RX_UCODE")
   #define DATA_ZEP_RX_RETX_LP1_UCODE_BEGIN  #pragma Data(DATA, ".ZEP_RX_RETX_LP1_UCODE") //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START-END)
   #define DATA_MAP_SRAM_BAR15               #pragma Data(DATA, ".SRAM_BAR15")   // XDSLRTFW-1942(Start_End)
   #define DATA_MAP_SRAM_BAR16               #pragma Data(DATA, ".SRAM_BAR16")
   #define DATA_MAP_SRAM_BAR17               #pragma Data(DATA, ".SRAM_BAR17")
   #define DATA_MAP_SRAM_BAR18               #pragma Data(DATA, ".SRAM_BAR18") // XDSLRTFW-3708:Control of GPIO14 to indicate dying gasp for ADSL
   #define DATA_MAP_SRAM_BAR19               #pragma Data(DATA, ".SRAM_BAR19")
#endif
#ifdef HERC_API
   #define DATA_MAP_HERC_API_BEGIN           #pragma Data(DATA,"HERC_API_RAM")
#endif

#define DATA_MAP_deILV1_BIS                  #pragma Data(DATA,"deILV1_RAM")
#define DATA_MAP_deILV2_BIS                  #pragma Data(DATA,"deILV2_BISDBG_RAM")
#define DATA_MAP_deILV3_BIS                  #pragma Data(DATA,"deILV3_RAM")
#define DATA_MAP_LOCAL_LD_ST_BEGIN           #pragma Data(DATA,"LOCAL_LD_ST")
#define DATA_LOCAL_LD_ST_BEGIN               DATA_MAP_LOCAL_LD_ST_BEGIN
#define DATA_MAP_SIM                         #pragma Data(DATA,"SIM_RAM")
#define BSS_DEILV2_BIS                       #pragma BSS("BIS_deILV2_BSS")
#define BSS_DEILV2_DMT                       #pragma BSS("DMT_deILV2_BSS")
#define BSS_MAP_END                          #pragma BSS()
#define DATA_MAP_END                         #pragma Data()

#endif /* _DATA_ALLOC_H*/

