/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _DATASWAP_H
#define _DATASWAP_H
/*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: dataswap.h
*
*   Include file for data swapping between internal and external memories
*   using XDMA engine.
*
*******************************************************************************/

// ****************************************************************************************************
// dataswap.h
// History :
// 15/12/2017 Sriram shastry: DCT tool does not work in ADSL mode for VRX518 FW R5
// Added Support towards VRX518 Platform for  debug traces ( Updated address field )
// Search  Pattern XDSLRTFW-3638
// ****************************************************************************************************
#ifdef DEBUG_TRACES

/* Data swap buffer size */
#ifdef CALC_REVERB_SNR
    #define REVERB_SNR_BUF_SIZE         (RX_NUM_TONES * sizeof(int16))
#else
    #define REVERB_SNR_BUF_SIZE         0
#endif

#ifdef CALC_REVERB_ECHO_SNR
    #define REVERB_ECHO_SNR_BUF_SIZE    (RX_NUM_TONES * sizeof(int16))
#else
    #define REVERB_ECHO_SNR_BUF_SIZE    0
#endif

#define MEDLEY_SNR_BUF_SIZE             (RX_NUM_TONES * sizeof(int16))
#define RX_MARGIN_BUF_SIZE                (RX_NUM_TONES * sizeof(int16))
#define STATES_TRAIL_BUF_SIZE           (2*DEBUG_TRAIL_SIZE * sizeof(int16))
#define DEBUG_BUF_GHS_TRAINING_SIZE     (1000*sizeof(int16))
#define DEBUG_BUF_SHOWTIME_SIZE         (9000*sizeof(int16))

/* Swapped buffer address in XDATA section of XMEM */
#define ADSL_IMAGE_BASE_ADDR            0x80000       /* from harvardArch_biscs.cmd */
// XDSLRTFW-3638 (Start)
#define XDATA_BASE_ADDR                 0x1f0000
#define XSDRAM_CACHE_IRAM_VRX518_ADDR   0x100000
#define XSDRAM_CACHE_IRAM_VRX218_ADDR   0x80000
// XDSLRTFW-3638 (End)

#define XDATA_SIZE                  (20 * 1024)    /* 18 KBytes - from harvardArch_biscs.cmd */
#define XDATA_END_ADDR              (XDATA_BASE_ADDR + XDATA_SIZE - 1)

#define XMEM_REVERB_SNR_BUF_ADDR        XDATA_BASE_ADDR
#define XMEM_REVERB_ECHO_SNR_BUF_ADDR   (XMEM_REVERB_SNR_BUF_ADDR + ((REVERB_SNR_BUF_SIZE+3)/4)*4)
#define XMEM_MEDLEY_SNR_BUF_ADDR        (XMEM_REVERB_ECHO_SNR_BUF_ADDR + ((REVERB_ECHO_SNR_BUF_SIZE+3)/4)*4)
#define XMEM_RX_MARGIN_BUF_ADDR        (XMEM_MEDLEY_SNR_BUF_ADDR + ((RX_MARGIN_BUF_SIZE+3)/4)*4)
#define XMEM_STATES_TRAIL_BUF_ADDR      (XMEM_RX_MARGIN_BUF_ADDR + ((MEDLEY_SNR_BUF_SIZE+3)/4)*4)
#define XMEM_STATES_TRAIL_BUF_END       (XMEM_STATES_TRAIL_BUF_ADDR+STATES_TRAIL_BUF_SIZE-1)

//#define XMEM_DEBUG_BUF_GHS_TRAINING_ADDR (XMEM_STATES_TRAIL_BUF_ADDR+((STATES_TRAIL_BUF_SIZE+3)/4)*4)
#define XMEM_DEBUG_BUF_GHS_TRAINING_ADDR XDATA_BASE_ADDR
#define XMEM_DEBUG_BUF_GHS_TRAINING_END  (XMEM_DEBUG_BUF_GHS_TRAINING_ADDR+DEBUG_BUF_GHS_TRAINING_SIZE-1)
#define XMEM_DEBUG_BUF_SHOWTIME_ADDR     (((XMEM_DEBUG_BUF_GHS_TRAINING_END+3)/4)*4)
#define XMEM_DEBUG_BUF_SHOWTIME_END        (XMEM_DEBUG_BUF_SHOWTIME_ADDR+DEBUG_BUF_SHOWTIME_SIZE)

/* XDMA transfer direction */
#define XDMA_READ_XMEM                  XDMA_CTRL_READ_DIR
#define XDMA_WRITE_XMEM                 XDMA_CTRL_WRITE_DIR

/* Data swap control flag */
#define DATASWAP_READY                  0       /* XDMA ready for next transfer */
#define DATASWAP_REQUESTED              1       /* Request XDMA transfer */
#define DATASWAP_IN_PROGRESS            2       /* XDMA transfer in progress */

/* Indicate which buffer(s) has been swapped to XMEM */
#define REVERB_SNR_BUF_IN_XMEM          0x0001
#define REVERB_ECHO_SNR_BUF_IN_XMEM     0x0002
#define MEMLEY_SNR_BUF_IN_XMEM          0x0004
#define STATES_TRAIL_BUF_IN_XMEM        0x0008
#define RX_MARGIN_BUF_IN_XMEM          0x0010
#define DEBUG_BUF_IN_XMEM               0x000B

//==============================================================================
// Structure definitions
//==============================================================================

/* Xmem addresses for data swapping */
typedef struct
{
    int32   l_SrcAddr;     // longword aligned byte address
    int32   l_DstAddr;     // longword aligned byte address
    int16   s_BufSize;     // bufer size in bytes
    int8    c_XferDir;     // XDMA_READ_XMEM / XDMA_WRITE_XMEM
    int8    c_State;    // DATASWAP_READY / DATASWAP_REQUESTED / DATASWAP_IN_PROGRESS
} DataSwapControl_t;


//==============================================================================
// External declarations
//==============================================================================
extern DataSwapControl_t gt_DataSwap;
extern uint16  gus_DataBuf_InXmem;
extern int16 gs_CodeSwapStatus;
extern int16 gs_ShowtimeTrailBufferIndex;


//==============================================================================
// Function prototypes
//==============================================================================
void InitDataSwap (void);
int ReadXdmaStatus (void);
void CheckForDataSwap (void);
int32 CheckSwappedDataInXmem (int16);
int RequestSwappedDataFromXmem (int32, int32, uint16);
void RequestSwap_STStatesTrailBuf_ToXmem (void);
void Check_ShowtimeDataSwap (void);
C_SCOPE void RequestSwap_ReverbSnrBuf_ToXmem (void);
C_SCOPE void RequestSwap_MedleySnrBuf_ToXmem (void);
C_SCOPE void RequestSwap_StatesTrailBuf_ToXmem (void);
C_SCOPE void RequestSwap_CSStatesTrailBuf_ToXmem (void);
void Verify_XdmaAccess (void);
void Xdma_ReadXmem (void);
void Xdma_WriteXmem (int32, int32, int32);
void Xdma_ClearXmem (void);
void RequestSwap_DebugBuff_GHS_OR_TRAINING_Tomem();
void RequestSwap_DebugBuff_ShowTime_Tomem(int32 *pl_addr_source ,int16 s_size_bytes);

#endif // #ifdef DEBUG_TRACES
#endif  // _DATASWAP_H
