/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        dma_iof.h
*
* DESCRIPTION:     header file for the DMA interface functions
*
**************************************************************************/
#include "typedef.h"

/***** AUXILIARY REGISTER ADDRESSES *****/
// ARC DMA auxiliary registers
enum {
   ADMA_CTRL_AC_ADDR = 0x100,
   ADMA_STAT_AC_ADDR,
   ADMA_SAD_S_AC_ADDR,
   ADMA_DAD_S_AC_ADDR,
   ADMA_SAD_E_AC_ADDR
};
#define ADMA_AC_FIRST_ADDR (ADMA_CTRL_AC_ADDR)
#define ADMA_AC_LAST_ADDR  (ADMA_SAD_E_AC_ADDR)

// REGISTER MASKS
#define ADMA_CTRL_AC_START_MASK (0x1)
#define ADMA_CTRL_AC_STOP_MASK   (0x2)
#define ADMA_STAT_AC_ERR_MASK (0x2)
#define ADMA_STAT_AC_PROC_MASK   (0x1)

/***** FUNCTION PROTOTYPES *****/
void DMA_RegisterRead(uint32 ul_addr, uint32 *pul_word);
void DMA_RegisterWrite(uint32 ul_addr, uint32 ul_word);
