/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//
//----------------------------------------------------------------------------
//
//   Aware DMT Technology. Proprietary and Condfidential
//
//   40 Middlesex Turnpike, Bedford, MA 01730-1413
//   Phone (781) 276-4000
//   FAX   (781) 276-4001
//
//   dsp_regs_62.h      // for VR9 CPE
//
//----------------------------------------------------------------------------
//

#ifndef IN_DSP_REGS_62_H

#define IN_DSP_REGS_62_H

    #ifndef IN_ASM
        extern uint8 guc_ch_id;
    #endif
        // extended DSP registers

        #define DSP_REGISTERS_BASE        0x20000


      #define XDMA_AVAILABLE

        // ADMA registers
        #define DSP_VERSION               (DSP_REGISTERS_BASE + 0x00)

        #define DSP_PORT_SEL              (DSP_REGISTERS_BASE + 0x04)
            // set ifetch, xy_ptr, ldst to port0 specific;
                                                // ld_st,   xy,      adma0_s,   adma0_d,   adma1_s,    adma1_d,
            #define DSP_PORT_0_SEL_MASK             (0 | (0 << 4) | (0 << 8) | (0 << 9) | (0 << 12) | (0 << 13) | \
                                                     (0 << 16) | (1 << 20) | (0 << 24))
                                                //    xdma0,      xdma1,        ifetch

            #define DSP_PORT_1_SEL_MASK             (1 | (1 << 4) | (0 << 8) | (0 << 9) | (1 << 12) | (1 << 13) | \
                                                     (0 << 16) | (1 << 20) | (1 << 24))




        #define DSP_INT_STAT              (DSP_REGISTERS_BASE + 0x08)
            #define DSP_INT_STAT_ME_GPINT      (1 << 6)

            #define DSP_INT_STAT_MSGAV_MASK         (1 << (4 + guc_ch_id))

            #define DSP_INT_STAT_ADMA_DONE_MASK     (1 << (8 + guc_ch_id))
            #define DSP_INT_STAT_XDMA_DONE_MASK     (1 << (12 + guc_ch_id))
            #define ARC_XSTAT_XDMA_DONE_MASK        DSP_INT_STAT_XDMA_DONE_MASK

            // alias of ME_GP_INT, since this VR9 doesn't have the CS_DONE bit
            // temporarily bypass it
            #define ARC_INT_CS_DONE_MASK            0

        // alias of DSP_INT_STAT; for HERC msg
        #define ARC_INT_STAT_REG          DSP_INT_STAT
        #define ARC_INT_STAT_ADDR         DSP_INT_STAT
            // ME_2_ARC interrupt status
            #define ARC_INT_MSGAV_MASK    DSP_INT_STAT_MSGAV_MASK

        // these are for SOC msg
        #define MEI_INT_MC_ADDR           DSP_INT_STAT
            #define MEI_MSGAV_MASK    DSP_INT_STAT_MSGAV_MASK





        #define DSP_INT_MASK              (DSP_REGISTERS_BASE + 0x0C)
            #define DSP_INT_MASK_XDSL1_PORT0_MASK  (1 << 16)
            #define DSP_INT_MASK_XDSL1_PORT1_MASK  (1 << 20)

            #define DSP_INT_MASK_XDSL1_2PORT_MASK   (DSP_INT_MASK_XDSL1_PORT0_MASK | DSP_INT_MASK_XDSL1_PORT1_MASK)

//            #define DSP_INT_MASK_XDSL2_PORT0_MASK  (1 << 17)
//            #define DSP_INT_MASK_XDSL2_PORT1_MASK  (1 << 21)
//            #define DSP_INT_MASK_XDSL2_2PORT_MASK   (DSP_INT_MASK_XDSL2_PORT0_MASK | DSP_INT_MASK_XDSL2_PORT1_MASK)

            // alias
            #define ARC_INT_XDSL1_MASK    (DSP_INT_MASK_XDSL1_PORT0_MASK << (guc_ch_id << 2))
//            #define ARC_INT_XDSL2_MASK    (DSP_INT_MASK_XDSL2_PORT0_MASK << (guc_ch_id << 2))


            #define DSP_INT_MASK_MEMEX              (1)

        // alias
        #define ARC_INT_MASK_REG          DSP_INT_MASK





        #define DSP_MEMEX_SRC             (DSP_REGISTERS_BASE + 0x10)

        // ARC-to-ME registers
        // both ARC2ME_INT and ARC2ME_STAT have the same bit format, so bitfields will be
        // shared by both
        #define DSP_ARC2ME_INT            (DSP_REGISTERS_BASE + 0x14)
            #define DSP_ARC2ME_GPINT                    (1 << 2)
            #define DSP_ARC2ME_MSGAV_MASK               (1 << guc_ch_id)

        // alias of DSP_ARC2ME_INT
        #define ARC_ARC2ME_INT_REG        DSP_ARC2ME_INT





        #define DSP_ARC2ME_STAT           (DSP_REGISTERS_BASE + 0x18)

        // alias of DSP_ARC2ME_STAT; HERC msg
        #define ARC_ARC2ME_STAT_REG       DSP_ARC2ME_STAT
            #define ARC_ARC2ME_MSGAV_MASK      DSP_ARC2ME_MSGAV_MASK
            #define ARC_ARC2ME_VALID_MASK      0x00000007


        // alias of DSP_ARC2ME_STAT; SOC msg
        #define MEI_INT_AC_ADDR           DSP_ARC2ME_STAT
            #define MEI_INT_AC_ARC_MSGAV_MASK  DSP_ARC2ME_MSGAV_MASK
            #define ARC_MSGAV_MASK             DSP_ARC2ME_MSGAV_MASK

        #define DSP_GP_STAT               (DSP_REGISTERS_BASE + 0x1C)   // general purpose ARC2ME short message status
        #define DSP_ME_CONFIG             (DSP_REGISTERS_BASE + 0x20)   // RO - status of same register on ME interface
        #define DSP_MEMEX_SEL             (DSP_REGISTERS_BASE + 0x24)   // RO - which SRAM banks for external use only






        #define DSP_ADMA0_CTRL            (DSP_REGISTERS_BASE + 0x28)
        #define DSP_ADMA1_CTRL            (DSP_REGISTERS_BASE + 0x40)
#ifndef IN_ASM
extern uint8 guc_adma_reg_offset;              // will be set to 0 or (DSP_ADMA1_CTRL - DSP_ADMA0_CTRL) for port0 and port1 respectively

        #define DSP_ADMA_CTRL             (DSP_REGISTERS_BASE + 0x28 + guc_adma_reg_offset)
        #define DSP_ADMA_STAT             (DSP_REGISTERS_BASE + 0x2C + guc_adma_reg_offset)
        #define DSP_ADMA_SA_S             (DSP_REGISTERS_BASE + 0x30 + guc_adma_reg_offset)
        #define DSP_ADMA_SA_E             (DSP_REGISTERS_BASE + 0x34 + guc_adma_reg_offset)
        #define DSP_ADMA_DA_S             (DSP_REGISTERS_BASE + 0x38 + guc_adma_reg_offset)
        #define DSP_ADMA_FILL_VAL         (DSP_REGISTERS_BASE + 0x3C + guc_adma_reg_offset)
#endif

                                          // from 0x40 t0 0x54 is referenced thru the use guc_adma_reg_offset

        // these are aliases of the above ADMA registers
      // By default we only use the high prio DMA transfers since these happen in TC tasks only.
      // No attempt is yet done to utilize the low prio DMA queues.
        #define ARC_ADMA_CTRL_REG               (DSP_ADMA_CTRL)
            #define ARC_ADMA_CTRL_FILL_MASK  (0x1 << 1)
            #define ARC_ADMA_CTRL_START_MASK    (0x1)

        #define ARC_ADMA_STAT_REG               DSP_ADMA_STAT
            #define ARC_ADMA_STAT_ERR_MASK      (MASK_BIT1 | MASK_BIT2)
            #define ARC_ADMA_STAT_PROC_MASK     (MASK_BIT0)

        #define ARC_ADMA_SAD_S_REG              (DSP_ADMA_SA_S)
        #define ARC_ADMA_DAD_S_REG              (DSP_ADMA_DA_S)
        #define ARC_ADMA_SAD_E_REG              (DSP_ADMA_SA_E)




        #define DSP_XDMA0_CTRL            (DSP_REGISTERS_BASE + 0x58)
        #define DSP_XDMA1_CTRL            (DSP_REGISTERS_BASE + 0x6C)

#ifndef IN_ASM
        // equivalent to (DSP_XDMA1_CTRL - DSP_XDMA0_CTRL)
extern uint8 guc_xdma_reg_offset;              // will be set to 0 or (DSP_XDMA1_CTRL - DSP_XDMA0_CTRL) for port0 and port1 respectively

        #define DSP_XDMA_CTRL             (DSP_REGISTERS_BASE + 0x58 + guc_xdma_reg_offset)
            #define DSP_XDMA_CTRL_EN_MASK             (MASK_BIT0)
            #define DSP_XDMA_CTRL_WR_MASK             (MASK_BIT1)
            #define DSP_XDMA_CTRL_RD_MASK             0

        #define ARC_XMEM_XCTRL_REG                       DSP_XDMA_CTRL
            #define ARC_XMEM_XCTRL_EN_MASK                    DSP_XDMA_CTRL_EN_MASK

        #define DSP_XDMA_STAT             (DSP_REGISTERS_BASE + 0x5C + guc_xdma_reg_offset)
            #define DSP_XDMA_STAT_ERR_MASK            (MASK_BIT2 | MASK_BIT3)
            #define DSP_XDMA_STAT_PROC_MASK           (MASK_BIT0)
        #define DSP_XDMA_SA_S             (DSP_REGISTERS_BASE + 0x60 + guc_xdma_reg_offset)
        #define DSP_XDMA_SA_E             (DSP_REGISTERS_BASE + 0x64 + guc_xdma_reg_offset)
        #define DSP_XDMA_DA_S             (DSP_REGISTERS_BASE + 0x68 + guc_xdma_reg_offset)

        // will need to defined BARn register to do XDMA data transfer
#endif

                                          // from 0x6C t0 0x7C is referenced thru the use (guc_xdma_reg_offset)

        #define DSP_XDMA_GAP              (DSP_REGISTERS_BASE + 0x80)
            #define DSP_XDMA_GAP_MASK         0x0000FFFF
        // alias
        #define ARC_XDMA_GAP              DSP_XDMA_GAP
            // Danube value; when applied will be multiplied by 2 because of VR9 instruction cycle is twice as short.
            #define XDMA_GAP_SLOW           (0x0200)
            #define XDMA_GAP_FAST           (0x0000)


      //XDSLRTFW-3365 (Start)
      //GPIO registers
      #define DSP_GPIO_CTRL            (DSP_REGISTERS_BASE + 0xD0)  //General Purpose I/O Control Register
      #define DSP_GPIO_DATA            (DSP_REGISTERS_BASE + 0xD8)  //Gneral Purpose I/O Data Register
      //XDSLRTFW-3365 (End)

      //XDSLRTFW-3255 (Start)
      //BAR Registers
      #define DSP_XMEM_BAR13            (DSP_REGISTERS_BASE + 0xC0)  //BAR13 Read access address
      #define DSP_XMEM_BAR14            (DSP_REGISTERS_BASE + 0xC4)  //BAR14 Read access address
      #define DSP_XMEM_BAR15            (DSP_REGISTERS_BASE + 0xC8)  //BAR15 Read access address
      #define DSP_XMEM_BAR16            (DSP_REGISTERS_BASE + 0xCC)  //BAR16 Read access address
      #define DSP_XMEM_BAR17           (DSP_REGISTERS_BASE + 0xF4)  //BAR17 Raed access address
      #define DSP_XMEM_BAR18           (DSP_REGISTERS_BASE + 0xF8)  //BAR18 Raed access address
      #define DSP_XMEM_BAR19           (DSP_REGISTERS_BASE + 0xFC)  //BAR19 Raed access address
      #define DSP_XMEM_BAR20           (DSP_REGISTERS_BASE + 0x100)  //BAR20 Raed access address
      #define DSP_XMEM_BAR21           (DSP_REGISTERS_BASE + 0x104)  //BAR21 Raed access address
      #define DSP_XMEM_BAR22           (DSP_REGISTERS_BASE + 0x108)  //BAR22 Raed access address
      #define DSP_XMEM_BAR23           (DSP_REGISTERS_BASE + 0x10C)  //BAR23 Raed access address
      #define DSP_XMEM_BAR24           (DSP_REGISTERS_BASE + 0x110)  //BAR24 Raed access address
      //XDSLRTFW-3255 (End)


      // BAR registers (14,17,18 and 19) are configured by adding OFFSET to the PCI address.
      // PCIE ADDRESS + OFFSET --> Value configured in the BAR register
      #define BAR_REGISTER_OFFSET      (0x7FFFF)

      // XDSLRTFW-3708:Control of GPIO14 to indicate dying gasp for ADSL (Start)
      #define VRX518_CHIPID_EFUSE_BASE_ADDRESS              (0x18000)
      #define VRX518_GPIO_FUNC_BASE_ADDRESS                 (0x20000)
      #define VRX518_GPIO_PAD_BASE_ADDRESS                  (0x24000)

      #define VRX518_GPIO_FUNC_OUT_0_ADDRESS               (VRX518_GPIO_FUNC_BASE_ADDRESS + 0x0)
      #define VRX518_GPIO_FUNC_DIR_0_ADDRESS               (VRX518_GPIO_FUNC_BASE_ADDRESS + 0x8)
      #define VRX518_GPIO_FUNC_OUTSET_0_ADDRESS            (VRX518_GPIO_FUNC_BASE_ADDRESS + 0x40)
      #define VRX518_GPIO_FUNC_OUTCLR_0_ADDRESS            (VRX518_GPIO_FUNC_BASE_ADDRESS + 0x44)
      #define VRX518_GPIO_FUNC_DIRSET_0_ADDRESS            (VRX518_GPIO_FUNC_BASE_ADDRESS + 0x48)


      #define VRX518_GPIO_PAD_PORTMUXC14_ADDRESS           (VRX518_GPIO_PAD_BASE_ADDRESS + 0x38)
      #define VRX518_GPIO_PAD_PUEN_0_ADDRESS               (VRX518_GPIO_PAD_BASE_ADDRESS + 0x80)
      #define VRX518_GPIO_PAD_DCC_0_ADDRESS                (VRX518_GPIO_PAD_BASE_ADDRESS + 0x8C)
      // XDSLRTFW-3708:Control of GPIO14 to indicate dying gasp for ADSL (End)
#endif
