/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        gpio.h
*
* DESCRIPTION:     header file for the GPIO interface functions
*
**************************************************************************/
#ifndef _GPIO_H
#define _GPIO_H

#include "typedef.h"

#ifndef ADSL_62
#define GPIO_CTRL 0x10C
#define GPIO_DATA 0x10D
#else
#define GPIO_CTRL 0x200D0
#define GPIO_DATA 0x200D8
#endif

#define GPIO9     0x0200
#define GPIO10    0x0400
#define GPIO11    0x0800
#define GPIO12    0x1000

/* Structure used for GPIO pin control */
typedef struct {
   int16  s_GPIO_Ctrl;        /* value to be written to GPIO_CTRL register (GPIO_CTRL) every 250usec. 0=input, 1=output */
    uint16 us_GPIO_Data_Read; /* Value read from GPIO Data register (GPIO_DATA) every 250usec   */
   uint16 us_GPIO_Data_Mask;  /* mask used for writing to GPIO data register. */
   uint16 us_GPIO_Data_Write; /* Data written to GPIO Data register (GPIO_DATA) every 250usec   */
   int16  s_GPIO_For_TR68_Adsl_LED;
   int16  s_GPIO_16Hz_Flash_LED;
   int16  s_GPIO_DyingGasp_Pin; /* GPIO pin used to trigger dying gasp */
   int16  s_GPIO_LOL;         /* GPIO used to indicate LOL (loss of link) - decimal number for pin, e.g 4 for GPIO4*/
} Gpio_t;

extern void SetGPIODirectionBits(int16 s_data);
extern void SetGPIOBits(int16 s_data);
extern void ClearGPIOBits(int16 s_data);
extern void WriteGPIOBits(uint16 us_data_write);
extern uint16 GetGPIOStatus (void);
extern int16 GetGPIOBit (int16 Pin_Num);
extern void FlashGPIO(void);

#ifdef HERCULES_ADSL_CPE
//**********************
// TR68 LED Additions
/** GPIO Pin LED Functions */
extern void UpdateTr68Leds();
extern void InitLedsHw();
extern void switchOffConnectLED(void);
extern void switchOnConnectLED(void);
extern void switchOffDetectLED(void);
extern void switchOnDetectLED(void);
extern void switchOffLosLED(void);
extern void switchOnLosLED(void);

/** GPIO Pin Masks and Typedefs */
#define GPIO2_MASK (0x4) // Connect LED is GPIO2_D of the Vinax Chip
#define GPIO1_MASK (0x2) // Detect LED is GPIO2_D of the Vinax Chip
#define GPIO0_MASK (0x1) // LOS LED is GPIO2_D of the Vinax Chip
typedef unsigned long uint_32;

/** Base address for module GPIO Register Description */
#define GPIO_BASE (0x000EA000)

/** AFSEL. This register is read/writable by the ARC4 DSP. */
#define GPIO_AFSEL ( (GPIO_BASE + 0x00) )
#define GPIO_AFSEL_DEF (0x000003D8 )
#define GPIO_AFSEL_SET(val)   (*((uint_32*) GPIO_AFSEL) = val)
#define GPIO_AFSEL_GET        (*((uint_32*) GPIO_AFSEL))

/* Enable Alternate Function for GPIO9. AFSPI4 is set to 0, GPIO pin is used as GPIOAFSPI4 is set to 1, GPIO pin is configured as SPICS pin for SPI */
#define GPIO_AFSEL_AFSPI4 (1 << 9)
#define GPIO_AFSEL_AFSPI4_GET(reg) ((reg & GPIO_AFSEL_AFSPI4) >> 9)
#define GPIO_AFSEL_AFSPI4_SET(reg, val) reg = ((reg & ~GPIO_AFSEL_AFSPI4) | ((val & 0x0001) << 9))
#define GPIO_AFSEL_AFSPI4_ACC ( RW )

/* Enable Alternate Function for GPIO8. AFSPI3 is set to 0, GPIO pin is used as GPIOAFSPI3 is set to 1, GPIO pin is configured as MRST pin for SPI */
#define GPIO_AFSEL_AFSPI3 (1 << 8)
#define GPIO_AFSEL_AFSPI3_GET(reg) ((reg & GPIO_AFSEL_AFSPI3) >> 8)
#define GPIO_AFSEL_AFSPI3_SET(reg, val) reg = ((reg & ~GPIO_AFSEL_AFSPI3) | ((val & 0x0001) << 8))
#define GPIO_AFSEL_AFSPI3_ACC ( RW )

/* Enable Alternate Function for GPIO7. AFSPI2 is set to 0, GPIO pin is used as GPIOAFSPI2 is set to 1, GPIO pin is configured as MTSR pin for SPI */
#define GPIO_AFSEL_AFSPI2 (1 << 7)
#define GPIO_AFSEL_AFSPI2_GET(reg) ((reg & GPIO_AFSEL_AFSPI2) >> 7)
#define GPIO_AFSEL_AFSPI2_SET(reg, val) reg = ((reg & ~GPIO_AFSEL_AFSPI2) | ((val & 0x0001) << 7))
#define GPIO_AFSEL_AFSPI2_ACC ( RW )

/* Enable Alternate Function for GPIO6. AFSPI1 is set to 0, GPIO pin is used as GPIOAFSPI1 is set to 1, GPIO pin is configured as MSCLK pin for SPI */
#define GPIO_AFSEL_AFSPI1 (1 << 6)
#define GPIO_AFSEL_AFSPI1_GET(reg) ((reg & GPIO_AFSEL_AFSPI1) >> 6)
#define GPIO_AFSEL_AFSPI1_SET(reg, val) reg = ((reg & ~GPIO_AFSEL_AFSPI1) | ((val & 0x0001) << 6))
#define GPIO_AFSEL_AFSPI1_ACC ( RW )

/* Enable Alternate Function for GPIO5. AFSEN is set to 0, GPIO pin is used as GPIOAFSEN is set to 1, GPIO pin is configured as CS output for SSC */
#define GPIO_AFSEL_AFSEN (1 << 5)
#define GPIO_AFSEL_AFSEN_GET(reg) ((reg & GPIO_AFSEL_AFSEN) >> 5)
#define GPIO_AFSEL_AFSEN_SET(reg, val) reg = ((reg & ~GPIO_AFSEL_AFSEN) | ((val & 0x0001) << 5))
#define GPIO_AFSEL_AFSEN_ACC ( RW )

/* Enable Alternate Function for GPIO4. AFCLKO2 is set to 0, GPIO pin is used as GPIOAFCLKO2 is set to 1, GPIO pin is configured as CLKO2 output */
#define GPIO_AFSEL_AFCLKO2 (1 << 4)
#define GPIO_AFSEL_AFCLKO2_GET(reg) ((reg & GPIO_AFSEL_AFCLKO2) >> 4)
#define GPIO_AFSEL_AFCLKO2_SET(reg, val) reg = ((reg & ~GPIO_AFSEL_AFCLKO2) | ((val & 0x0001) << 4))
#define GPIO_AFSEL_AFCLKO2_ACC ( RW )

/* Enable Alternate Function for GPIO3. AFCLKO1 is set to 0, GPIO pin is used as GPIOAFCLKO1 is set to 1, GPIO pin is configured as CLKO1 output */
#define GPIO_AFSEL_AFCLKO1 (1 << 3)
#define GPIO_AFSEL_AFCLKO1_GET(reg) ((reg & GPIO_AFSEL_AFCLKO1) >> 3)
#define GPIO_AFSEL_AFCLKO1_SET(reg, val) reg = ((reg & ~GPIO_AFSEL_AFCLKO1) | ((val & 0x0001) << 3))
#define GPIO_AFSEL_AFCLKO1_ACC ( RW )

/** AFSEL. This register is read/writable by the ARC4 DSP. */
typedef union {
     uint_32 Reg;
     struct {
      /* Reserved. return 0 */
      uint_32        : 3;
      /* Enable Alternate Function for GPIO3. AFCLKO1 is set to 0, GPIO pin is used as GPIOAFCLKO1 is set to 1, GPIO pin is configured as CLKO1 output */
      uint_32   AFCLKO1 : 1;
      /* Enable Alternate Function for GPIO4. AFCLKO2 is set to 0, GPIO pin is used as GPIOAFCLKO2 is set to 1, GPIO pin is configured as CLKO2 output */
      uint_32   AFCLKO2 : 1;
      /* Enable Alternate Function for GPIO5. AFSEN is set to 0, GPIO pin is used as GPIOAFSEN is set to 1, GPIO pin is configured as CS output for SSC */
      uint_32   AFSEN : 1;
      /* Enable Alternate Function for GPIO6. AFSPI1 is set to 0, GPIO pin is used as GPIOAFSPI1 is set to 1, GPIO pin is configured as MSCLK pin for SPI */
      uint_32   AFSPI1 : 1;
      /* Enable Alternate Function for GPIO7. AFSPI2 is set to 0, GPIO pin is used as GPIOAFSPI2 is set to 1, GPIO pin is configured as MTSR pin for SPI */
      uint_32   AFSPI2 : 1;
      /* Enable Alternate Function for GPIO8. AFSPI3 is set to 0, GPIO pin is used as GPIOAFSPI3 is set to 1, GPIO pin is configured as MRST pin for SPI */
      uint_32   AFSPI3 : 1;
      /* Enable Alternate Function for GPIO9. AFSPI4 is set to 0, GPIO pin is used as GPIOAFSPI4 is set to 1, GPIO pin is configured as SPICS pin for SPI */
      uint_32   AFSPI4 : 1;
      /* Reserved. return 0 */
      uint_32        : 22;
      }Fld;
} gpio_afsel_t;

/** GPIODOH. This register is read/writable by the ARC4 DSP. */
#define GPIO_GPIODOH ( (GPIO_BASE + 0x04) )
#define GPIO_GPIODOH_DEF (0x00000000 )
#define GPIO_GPIODOH_SET(val)   (*((uint_32*) GPIO_GPIODOH) = val)
#define GPIO_GPIODOH_GET        (*((uint_32*) GPIO_GPIODOH))

/* Data Output High for GPIOn. n=9..0DOH[n] is set to 0, pin GPIOn remains unaffected.DOH[n] is set to 1, pin GPIOn is set to high, when configured as output.A Change in register GPIODOH takes effect only when register GPIODOL is written the next time. Thus, two different GPIOs can be set, one to low and the other to high at exactly the same time. */
#define GPIO_GPIODOH_DOH_MASK (((1 << 10) - 1) << 0)
#define GPIO_GPIODOH_DOH_GET(reg) (((reg) >> 0) & ((1 << 10) - 1))
#define GPIO_GPIODOH_DOH_SET(val) ((((1 << 10) - 1) & (val)) << 0)
#define GPIO_GPIODOH_DOH_MODIFY(reg, val) reg = ( (reg & ~GPIO_GPIODOH_DOH_MASK) | ((((1 << 10) - 1) & (val)) << 0) )
#define GPIO_GPIODOH_DOH_ACC ( RW )

/** GPIODOH. This register is read/writable by the ARC4 DSP. */
typedef union {
     uint_32 Reg;
     struct {
      /* Data Output High for GPIOn. n=9..0DOH[n] is set to 0, pin GPIOn remains unaffected.DOH[n] is set to 1, pin GPIOn is set to high, when configured as output.A Change in register GPIODOH takes effect only when register GPIODOL is written the next time. Thus, two different GPIOs can be set, one to low and the other to high at exactly the same time. */
      uint_32   DOH : 10;
      /* Reserved. return 0 */
      uint_32        : 22;
      }Fld;
} gpio_gpiodoh_t;

/** GPIODOL. This register is read/writable by the ARC4 DSP. */
#define GPIO_GPIODOL ( (GPIO_BASE + 0x08) )
#define GPIO_GPIODOL_DEF (0x00000000 )
#define GPIO_GPIODOL_SET(val)   (*((uint_32*) GPIO_GPIODOL) = val)
#define GPIO_GPIODOL_GET        (*((uint_32*) GPIO_GPIODOL))

/* Data Output Low for GPIOn. n=9..0.DOL[n] is set to 0, pin GPIOn remains unaffected.DOL[n] is set to 1, pin GPIOn is set to low, when configured as output.A Change in register GPIODOH takes effect only when register GPIODOL is written the next time. Thus, two different GPIOs can be set, one to low and the other to high at exactly the same time. */
#define GPIO_GPIODOL_DOL_MASK (((1 << 10) - 1) << 0)
#define GPIO_GPIODOL_DOL_GET(reg) (((reg) >> 0) & ((1 << 10) - 1))
#define GPIO_GPIODOL_DOL_SET(val) ((((1 << 10) - 1) & (val)) << 0)
#define GPIO_GPIODOL_DOL_MODIFY(reg, val) reg = ( (reg & ~GPIO_GPIODOL_DOL_MASK) | ((((1 << 10) - 1) & (val)) << 0) )
#define GPIO_GPIODOL_DOL_ACC ( RW )

/** GPIODOL. This register is read/writable by the ARC4 DSP. */
typedef union {
     uint_32 Reg;
     struct {
      /* Data Output Low for GPIOn. n=9..0.DOL[n] is set to 0, pin GPIOn remains unaffected.DOL[n] is set to 1, pin GPIOn is set to low, when configured as output.A Change in register GPIODOH takes effect only when register GPIODOL is written the next time. Thus, two different GPIOs can be set, one to low and the other to high at exactly the same time. */
      uint_32   DOL : 10;
      /* Reserved. return 0 */
      uint_32        : 22;
      }Fld;
} gpio_gpiodol_t;

/** GPIOCFG. This register is read/writable by the ARC4 DSP. */
#define GPIO_GPIOCFG ( (GPIO_BASE + 0x0C) )
#define GPIO_GPIOCFG_DEF (0x00000000 )
#define GPIO_GPIOCFG_SET(val)   (*((uint_32*) GPIO_GPIOCFG) = val)
#define GPIO_GPIOCFG_GET        (*((uint_32*) GPIO_GPIOCFG))

/* I/O Line Configuration for GPIOn. n=5..0IOLC[n] is set to 0, pull-up component activated if configured as input for GPIOn, push-pull mode if configured as output for GPIOn.IOLC[n] is set to 1, no pull-up component activated if configured as input for GPIOn, open-drain mode when configured as output for GPIOnn=9..6IOLC[n] is set to 0, pull-up component activated if configured as input for GPIOn, push-pull mode if configured as output for GPIOn.IOLC[n] is set to 1, no pull-up component activated if configured as input for GPIOn, tristate when configured as output for GPIOn */
#define GPIO_GPIOCFG_IOLC_MASK (((1 << 10) - 1) << 0)
#define GPIO_GPIOCFG_IOLC_GET(reg) (((reg) >> 0) & ((1 << 10) - 1))
#define GPIO_GPIOCFG_IOLC_SET(val) ((((1 << 10) - 1) & (val)) << 0)
#define GPIO_GPIOCFG_IOLC_MODIFY(reg, val) reg = ( (reg & ~GPIO_GPIOCFG_IOLC_MASK) | ((((1 << 10) - 1) & (val)) << 0) )
#define GPIO_GPIOCFG_IOLC_ACC ( RW )

/** GPIOCFG. This register is read/writable by the ARC4 DSP. */
typedef union {
     uint_32 Reg;
     struct {
      /* I/O Line Configuration for GPIOn. n=5..0IOLC[n] is set to 0, pull-up component activated if configured as input for GPIOn, push-pull mode if configured as output for GPIOn.IOLC[n] is set to 1, no pull-up component activated if configured as input for GPIOn, open-drain mode when configured as output for GPIOnn=9..6IOLC[n] is set to 0, pull-up component activated if configured as input for GPIOn, push-pull mode if configured as output for GPIOn.IOLC[n] is set to 1, no pull-up component activated if configured as input for GPIOn, tristate when configured as output for GPIOn */
      uint_32   IOLC : 10;
      /* Reserved. return 0 */
      uint_32        : 22;
      }Fld;
} gpio_gpiocfg_t;

/** GPIODIR. This register is read/writable by the ARC4 DSP. */
#define GPIO_GPIODIR ( (GPIO_BASE + 0x10) )
#define GPIO_GPIODIR_DEF (0x00000000 )
#define GPIO_GPIODIR_SET(val)   (*((uint_32*) GPIO_GPIODIR) = val)
#define GPIO_GPIODIR_GET        (*((uint_32*) GPIO_GPIODIR))

/* I/O Line Direction for GPIOn. n=9..0IOD[n] is set to 0, pin GPIOn is inputIOD[n] is set to 1, pin GPIOn is output */
#define GPIO_GPIODIR_IOD_MASK (((1 << 10) - 1) << 0)
#define GPIO_GPIODIR_IOD_GET(reg) (((reg) >> 0) & ((1 << 10) - 1))
#define GPIO_GPIODIR_IOD_SET(val) ((((1 << 10) - 1) & (val)) << 0)
#define GPIO_GPIODIR_IOD_MODIFY(reg, val) reg = ( (reg & ~GPIO_GPIODIR_IOD_MASK) | ((((1 << 10) - 1) & (val)) << 0) )
#define GPIO_GPIODIR_IOD_ACC ( RW )

/** GPIODIR. This register is read/writable by the ARC4 DSP. */
typedef union {
     uint_32 Reg;
     struct {
      /* I/O Line Direction for GPIOn. n=9..0IOD[n] is set to 0, pin GPIOn is inputIOD[n] is set to 1, pin GPIOn is output */
      uint_32   IOD : 10;
      /* Reserved. return 0 */
      uint_32        : 22;
      }Fld;
} gpio_gpiodir_t;

/** GPIODI. This register is read/writable by the ARC4 DSP. */
#define GPIO_GPIODI ( (GPIO_BASE + 0x14) )
#define GPIO_GPIODI_DEF (0x00000000 )
#define GPIO_GPIODI_SET(val)   (*((uint_32*) GPIO_GPIODI) = val)
#define GPIO_GPIODI_GET        (*((uint_32*) GPIO_GPIODI))

/* TTR Status. The status of TTR input is mapped into this bit. The input generates an interrupt to ARC4.TTRSTA is 0 if pin GPIOn has low levelTTRSTA is 1 if pin GPIOn has high level */
#define GPIO_GPIODI_TTRSTA (1 << 10)
#define GPIO_GPIODI_TTRSTA_GET(reg) ((reg & GPIO_GPIODI_TTRSTA) >> 10)
#define GPIO_GPIODI_TTRSTA_SET(reg, val) reg = ((reg & ~GPIO_GPIODI_TTRSTA) | ((val & 0x0001) << 10))
#define GPIO_GPIODI_TTRSTA_ACC ( R )

/* Data Input for GPIOn. n=9..0DI[n] is 0 if pin GPIOn has low-levelDI[n] is 1 if pin GPIOn has high level */
#define GPIO_GPIODI_DI_MASK (((1 << 10) - 1) << 0)
#define GPIO_GPIODI_DI_GET(reg) (((reg) >> 0) & ((1 << 10) - 1))
#define GPIO_GPIODI_DI_SET(val) ((((1 << 10) - 1) & (val)) << 0)
#define GPIO_GPIODI_DI_MODIFY(reg, val) reg = ( (reg & ~GPIO_GPIODI_DI_MASK) | ((((1 << 10) - 1) & (val)) << 0) )
#define GPIO_GPIODI_DI_ACC ( R )

/** GPIODI. This register is read/writable by the ARC4 DSP. */
typedef union {
     uint_32 Reg;
     struct {
      /* Data Input for GPIOn. n=9..0DI[n] is 0 if pin GPIOn has low-levelDI[n] is 1 if pin GPIOn has high level */
      uint_32   DI : 10;
      /* TTR Status. The status of TTR input is mapped into this bit. The input generates an interrupt to ARC4.TTRSTA is 0 if pin GPIOn has low levelTTRSTA is 1 if pin GPIOn has high level */
      uint_32   TTRSTA : 1;
      /* Reserved. return 0 */
      uint_32        : 21;
      }Fld;
} gpio_gpiodi_t;
// TR68 LED Additions - End
//*********************
#endif  // #ifdef HERCULES_ADSL_CPE
#endif // _GPIO_H
