/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef IN_AUX_REGS_H

#define IN_AUX_REGS_H

#define AUX_STATUS_REG_ADDR                 0x0000
#define AUX_STATUS_PC_MASK                  0x00FFFFFF

// this is the offset when looking at aux reg space in arc simulator
// for the below registers which we maintain manualy thru simext.dll
#define AUX_REGS_ASIM_OFFSET                0x0100

#define ARC_ADMA_CTRL_REG                   0x0100    // ARC4 DMA Control
   #define ARC_ADMA_CTRL_FILL_MASK  (0x4)
   #define ARC_ADMA_CTRL_STOP_MASK  (0x2)
   #define ARC_ADMA_CTRL_START_MASK    (0x1)
#define ARC_ADMA_STAT_REG                   0x0101    // ARC4 DMA Status
   #define ARC_ADMA_STAT_DONE_MASK     (0x4)
   #define ARC_ADMA_STAT_ERR_MASK      (0x2)
   #define ARC_ADMA_STAT_PROC_MASK     (0x1)
#define ARC_ADMA_SAD_S_REG                  0x0102    // ARC4 DMA Source Start Address
#define ARC_ADMA_DAD_S_REG                  0x0103    // ARC4 DMA Destination Start Address
#define ARC_ADMA_SAD_E_REG                  0x0104    // ARC4 DMA Source End Address
#define ARC_ADMA_FILL_REG                   0x0105    // ARC4 DMA Programmable Fill Value

#define ARC_ARC2ME_INT_REG                  0x0106    // MEI Control Interrupt from the ARC4 to the MEI
#define ARC_ARC2ME_STAT_REG                 0x0107    // MEI Control Status from the ARC4 to the MEI
    #define ARC_ARC2ME_MSGAV_MASK       0x00000001    // bit-0
    #define ARC_ARC2ME_GPINT0_MASK      0x00000002    // bit-1
    #define ARC_ARC2ME_GPINT1_MASK      0x00000004    // bit-2
    #define ARC_ARC2ME_VALID_MASK       0x00000007    //

#define ARC_INT_MASK_REG                    0x0108    // ARC4 General Interrupt Mask Register
#define ARC_INT_STAT_REG                    0x0109    // ARC4 General Interrupt Status Register
    #define ARC_INT_MSGAV_MASK          0x00000004    // bit-2
    #define ARC_INT_GP_INT_MASK         0x00000008    // bit-3
    #define ARC_INT_CS_DONE_MASK        0x00000010    // bit-4
    #define ARC_INT_XDSL1_MASK          0x00000020    // bit-5
    #define ARC_INT_XDSL2_MASK          0x00000040    // bit-6
    #define ARC_INT_XDSLx_MASK          0x00000060    // bit-5 and bit-6
    #define ARC_INT_VALID_MASK          0x000007FF

#define ARC_XMEM_INT_MASK_REG               0x010a    // ARC4 External Memory Interrupt Mask Register
#define ARC_XMEM_INT_STAT_REG               0x010b    // ARC4 External Memory Interrupt Status Register
#define ARC_GPIO_CTRL_REG                   0x010c    // General Purpose I/O Control Register
#define ARC_GPIO_DATA_REG                   0x010d    // General Purpose I/O Data Register
#define ARC_GP_STAT_REG                     0x010e    // ARC4 General Purpose Status to MEI
#define ARC_CONFIG_REG                      0x010f    // Read-only configuration register from MEI
#define ARC_XMEM_ARB_REG                    0x0110    // Memory Arbitration Parameter Control Register
#define ARC_XMEM_AP_MAX_REG                 0x0111    // Memory Access Period Maximum Count Register
#define ARC_XMEM_AP_CUR_REG                 0x0112    // Memory Access Period Current Count Register
#define ARC_XMEM_CTL_REG                    0x0113    // Memory Configuration Control Register
    #define ARC_XMEM_CTL_WS1_22                  0x1600
    #define ARC_XMEM_CTL_WS2_22                  0x0016
    #define ARC_XMEM_CTL_DW_16                   0x0020
    #define ARC_XMEM_CTL_AW_21                   0x00C0

#define ARC_XMEM_WDOG_REG                   0x0114    // Memory Watchdog Timer Control Register
#define ARC_XMEM_WTMR_REG                   0x0115    // Memory Watchdog Timer Value Register
#define ARC_XMEM_BUS_RST_REG                0x0116    // Memory Arbitrated Bus Reset Register
#define ARC_XMEM_XCTRL_REG                  0x0117    // XDMA Control Register
    #define ARC_XMEM_XCTRL_EN_MASK               0x0001    // Memory Configuration Control Register
    #define ARC_XMEM_XCTRL_DIR_MASK              0x0002
    #define ARC_XMEM_XCTRL_LOCK_MASK             0x0FF0
    #define ARC_XMEM_XCTRL_LOCK_SHIFT            4

#define ARC_XMEM_XSTAT_REG                  0x0118    // XDMA Status Register
   #define ARC_XSTAT_XDMA_DONE_MASK            0x0001    //
   #define ARC_XSTAT_XDMA_ACTIVE_MASK          0x0002    //
   #define ARC_XSTAT_XDMA_XERR_MASK            0x0004    //
   #define ARC_XSTAT_XDMA_LKERR_MASK           0x0008    //
   #define ARC_XSTAT_XDMA_APHOLD_MASK          0x0010    //
   #define ARC_XSTAT_XDMA_BUS_RST_MASK         0x0020    //
#define ARC_XMEM_SSADR_REG                  0x0119    // XDMA Source Start Address Register
#define ARC_XMEM_SEADR_REG                  0x011a    // XDMA Source End Address Register
    #define ARC_XMEM_SEADR_LOCK_MASK            0x00FF    // XDMA Source End Address Register
#define ARC_XMEM_DSADR_REG                  0x011b    // XDMA Destination Start Address Register
#define ARC_PER_ENA_REG                     0x011c    // Peripheral Bus Enable
#define ARC_XMEM_MODE_REG                   0x011d    // External Memory Mode
#define ARC_XDSL_MTM_REG                    0x011e    // XDSL Memory Test Mode

#endif  //IN_AUX_REGS_H
