/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: ifx_vdsl2_afe_memmap.h
;
;  Header file for the IFX_VDSL2 AFE HW memory map.
;
*****************************************************************************/
#ifndef _IFX_VDSL2_AFE_MEMMAP_H
#define _IFX_VDSL2_AFE_MEMMAP_H

/****************************************************/
/* Register definitions */
/****************************************************/

// Analog Registers
#define IFX_VDSL2_AFE_LINE_ADAPTATION1_ADDR     (0x1000)
#define IFX_VDSL2_AFE_LINE_ADAPTATION2_ADDR     (0x1001)
#define IFX_VDSL2_AFE_AGC_PREFILTER_ADDR     (0x1002)
#define IFX_VDSL2_AFE_AGC_POSTFILTER_ADDR       (0x1003)
#define IFX_VDSL2_AFE_ADC1_ADDR                 (0x1004)
#define IFX_VDSL2_AFE_ADC2_ADDR                 (0x1005)
#define IFX_VDSL2_AFE_RESERVED1_ADDR         (0x1006)
#define IFX_VDSL2_AFE_ADC3_ADDR                 (0x1006)
#define IFX_VDSL2_AFE_DAC_ADDR                  (0x1007)
#define IFX_VDSL2_AFE_POCO_TESTLOOP_ADDR     (0x1008)
#define IFX_VDSL2_AFE_CLKDIST_ADDR              (0x1009)

#define IFX_VDSL2_AFE_BIAS1_ADDR             (0x100A)
#define IFX_VDSL2_AFE_BIAS2_ADDR             (0x100B)
#define IFX_VDSL2_AFE_BIAS3_ADDR             (0x100C)
#define IFX_VDSL2_AFE_BIAS4_ADDR             (0x100D)
#define IFX_VDSL2_AFE_BIAS5_ADDR             (0x100E)
#define IFX_VDSL2_AFE_RESERVED2_ADDR         (0x100F)
#define IFX_VDSL2_AFE_REVISION_ADDR             (0x100F)


// Digital Registers
#define IFX_VDSL2_AFE_DIGITAL_REG_0_ADDR     (0x0000)
#define IFX_VDSL2_AFE_DIGITAL_REG_1_ADDR     (0x0001)
#define IFX_VDSL2_AFE_DIGITAL_REG_2_ADDR     (0x0002)
#define IFX_VDSL2_AFE_DIGITAL_REG_3_ADDR     (0x0003)
#define IFX_VDSL2_AFE_DIGITAL_REG_4_ADDR     (0x0004)
#define IFX_VDSL2_AFE_DIGITAL_REG_5_ADDR     (0x0005)
#define IFX_VDSL2_AFE_DIGITAL_REG_6_ADDR     (0x0006)
#define IFX_VDSL2_AFE_DIGITAL_REG_7_ADDR     (0x0007)
#define IFX_VDSL2_AFE_DIGITAL_REG_8_ADDR     (0x0008)
#define IFX_VDSL2_AFE_DIGITAL_REG_9_ADDR     (0x0009)

#define IFX_VDSL2_AFE_DIGITAL_REG_10_ADDR       (0x000A)
#define IFX_VDSL2_AFE_DIGITAL_REG_11_ADDR       (0x000B)
#define IFX_VDSL2_AFE_DIGITAL_REG_12_ADDR       (0x000C)
#define IFX_VDSL2_AFE_DIGITAL_REG_13_ADDR       (0x000D)
#define IFX_VDSL2_AFE_DIGITAL_REG_14_ADDR       (0x000E)
#define IFX_VDSL2_AFE_DIGITAL_REG_15_ADDR       (0x000F)
#define IFX_VDSL2_AFE_DIGITAL_REG_16_ADDR       (0x0010)
#define IFX_VDSL2_AFE_DIGITAL_REG_17_ADDR       (0x0011)
#define IFX_VDSL2_AFE_DIGITAL_REG_18_ADDR       (0x0012)
#define IFX_VDSL2_AFE_DIGITAL_REG_19_ADDR       (0x0013)

#define IFX_VDSL2_AFE_DIGITAL_REG_20_ADDR       (0x0014)
#define IFX_VDSL2_AFE_DIGITAL_REG_21_ADDR       (0x0015)
#define IFX_VDSL2_AFE_DIGITAL_REG_22_ADDR       (0x0016)
#define IFX_VDSL2_AFE_DIGITAL_REG_23_ADDR       (0x0017)
#define IFX_VDSL2_AFE_DIGITAL_REG_24_ADDR       (0x0018)
#define IFX_VDSL2_AFE_DIGITAL_REG_25_ADDR       (0x0019)
#define IFX_VDSL2_AFE_DIGITAL_REG_26_ADDR       (0x001A)
#define IFX_VDSL2_AFE_DIGITAL_REG_27_ADDR       (0x001B)
#define IFX_VDSL2_AFE_DIGITAL_REG_28_ADDR       (0x001C)
#define IFX_VDSL2_AFE_DIGITAL_REG_29_ADDR       (0x001D)

#define IFX_VDSL2_AFE_DIGITAL_REG_30_ADDR       (0x001E)
#define IFX_VDSL2_AFE_DIGITAL_REG_31_ADDR       (0x001F)
#define IFX_VDSL2_AFE_DIGITAL_REG_32_ADDR       (0x0020)
#define IFX_VDSL2_AFE_DIGITAL_REG_33_ADDR       (0x0021)
#define IFX_VDSL2_AFE_DIGITAL_REG_34_ADDR       (0x0022)
#define IFX_VDSL2_AFE_DIGITAL_REG_35_ADDR       (0x0023)
#define IFX_VDSL2_AFE_DIGITAL_REG_36_ADDR       (0x0024)
#define IFX_VDSL2_AFE_DIGITAL_REG_37_ADDR       (0x0025)
#define IFX_VDSL2_AFE_DIGITAL_REG_38_ADDR       (0x0026)
#define IFX_VDSL2_AFE_DIGITAL_REG_39_ADDR       (0x0027)

#define IFX_VDSL2_AFE_DIGITAL_REG_40_ADDR       (0x0028)
#define IFX_VDSL2_AFE_DIGITAL_REG_41_ADDR       (0x0029)
#define IFX_VDSL2_AFE_DIGITAL_REG_42_ADDR       (0x002A)
#define IFX_VDSL2_AFE_DIGITAL_REG_43_ADDR       (0x002B)
#define IFX_VDSL2_AFE_DIGITAL_REG_44_ADDR       (0x002C)
#define IFX_VDSL2_AFE_DIGITAL_REG_45_ADDR       (0x002D)
#define IFX_VDSL2_AFE_DIGITAL_REG_46_ADDR       (0x002E)
#define IFX_VDSL2_AFE_DIGITAL_REG_47_ADDR       (0x002F)
#define IFX_VDSL2_AFE_DIGITAL_REG_48_ADDR       (0x0030)
#define IFX_VDSL2_AFE_DIGITAL_REG_49_ADDR       (0x0031)

#define IFX_VDSL2_AFE_DIGITAL_REG_50_ADDR       (0x0032)
#define IFX_VDSL2_AFE_DIGITAL_REG_51_ADDR       (0x0033)
#define IFX_VDSL2_AFE_DIGITAL_REG_52_ADDR       (0x0034)
#define IFX_VDSL2_AFE_DIGITAL_REG_53_ADDR       (0x0035)
#define IFX_VDSL2_AFE_DIGITAL_REG_54_ADDR       (0x0036)
#define IFX_VDSL2_AFE_DIGITAL_REG_55_ADDR       (0x0037)
#define IFX_VDSL2_AFE_DIGITAL_REG_56_ADDR       (0x0038)
#define IFX_VDSL2_AFE_DIGITAL_REG_57_ADDR       (0x0039)
#define IFX_VDSL2_AFE_DIGITAL_REG_58_ADDR       (0x003A)
#define IFX_VDSL2_AFE_DIGITAL_REG_59_ADDR       (0x003B)

#define IFX_VDSL2_AFE_DIGITAL_REG_60_ADDR       (0x003C)
#define IFX_VDSL2_AFE_DIGITAL_REG_61_ADDR       (0x003D)
#define IFX_VDSL2_AFE_DIGITAL_REG_62_ADDR       (0x003E)

/****************************************************/
/* Other constants */
/****************************************************/
#define AFE_REG_NO_OP  (0x0)   // AFE register no operation.
#define AFE_REG_RD_OP  (0x1)   // AFE register read operation.
#define AFE_REG_WR_OP  (0x2)   // AFE register write operation.

//============================================================================================
// AFE PGA Parameters
//============================================================================================
#define VINAX_MIN_PGA         (-18 << 8)  // minimum gain of PGA (-18 dB in Q8.8)
#define VINAX_MAX_PGA         (0x1B << 8) // maximum gain of PGA can apply (27 dB in Q8.8)
#define AGC_3DB_STEP       (0x3 << 8)
#define LA_6DB_STEP           (0x6 << 8)

#ifdef TARGET     // not defined currently in CPE
//============================================================================================
// AFE Transmitter Level Parameters
//============================================================================================
// note: AFE POCO register has a nonzero gain offset in bits containing attenuation value
// i.e. if POCO register attenuation bits content = 6, then actual atten = 6 - 6 = 0 (dB)
#define AFE_TX_ATTEN_REG_MASK   (0x1F)  // Bitmask used by AFE POCO reg to set atten (dB)
#define AFE_TX_ATTEN_REG_OFFSET (6)     // Offset of AFE Tx attenuation in (dB)
#define MAX_AFE_TX_ATTEN   (18)    // max attenuation that AFE transmitter can supply (dB)
#define MIN_AFE_TX_ATTEN   (0)    // min attenuation that AFE transmitter can supply (dB)
#define MAX_AFE_TX_CUTBACK    (MAX_AFE_TX_ATTEN - MIN_AFE_TX_ATTEN)
#define AFE_TX_ATTEN_STEP     (1)               // Granularity of AFE Tx attenuation in (dB)

#endif // TARGET

#endif //_IFX_VDSL2_AFE_MEMMAP_H
