/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        interrupt.h
*
* DESCRIPTION:     header file for Socrates interrupts
*
**************************************************************************/
#include <stdlib.h>
#include "typedef.h"
#include "const.h"

/* ============================================================================================ */
/* Exception Codes */
/* ============================================================================================ */
//(0~49)  are reserved for common+DMT only error code, see below
//(50~79) are reserved for BIS only Error code, see detail in const_bis.h
//(80~89) are reserved for Kernel Excepton Error code, see detail in soc_src\modem\include\interrupt.h
//(90~93) have been used, see const.h
#ifdef HERC_API
#define E_CODE_DMA_INTERRUPT         (((E_CHIPSET | (Esub_HW_Error<<8))<<16)| (80))
#define E_CODE_RESERVED_INT          (((E_CHIPSET | (Esub_HW_Error<<8))<<16)| (81))
#define E_CODE_CODESWAP              (((E_CHIPSET | (Esub_HW_Error<<8))<<16)| (82))
#define E_CODE_EXPANSION             (((E_CHIPSET | (Esub_HW_Error<<8))<<16)| (83))
#define E_CODE_MAILBOX_INTERRUPT     (((E_CHIPSET | (Esub_HW_Error<<8))<<16)| (84))
#define E_CODE_CRI_STATUS2_INTERRUPT (((E_CHIPSET | (Esub_HW_Error<<8))<<16)| (85))
#define E_CODE_STACK_OVERFLOW_IN_TC  (((E_CHIPSET | (Esub_HW_Error<<8))<<16)| (86))
#define E_CODE_STACK_OVERFLOW_IN_NTC (((E_CHIPSET | (Esub_HW_Error<<8))<<16)| (87))
#define E_CODE_STACK_OVERFLOW_IN_BG  (((E_CHIPSET | (Esub_HW_Error<<8))<<16)| (88))

#else //non HERC_API
#define E_CODE_DMA_INTERRUPT      (80)
#define E_CODE_RESERVED_INT       (81)
#define E_CODE_CODESWAP           (82)
#define E_CODE_EXPANSION          (83)
#define E_CODE_MAILBOX_INTERRUPT  (84)
#define E_CODE_CRI_STATUS2_INTERRUPT (85)
#define E_CODE_STACK_OVERFLOW_IN_TC (86)
#define E_CODE_STACK_OVERFLOW_IN_NTC (87)
#define E_CODE_STACK_OVERFLOW_IN_BG (88)
#endif

/***** FUNCTION PROTOTYPES *****/
extern _Interrupt1 void adsl_interrupt_handler(void);

/***** VECTOR TABLE *****/
#define ADSL_INTERRUPT  (0x03)

