/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        intr_asm.h
;
; DESCRIPTION:     constants useful for intr_asm.s
;
;*************************************************************************

; volatile scratch regs need to be saved
.equ   r0_offset, BTSIZE_IN_BYTES
.equ   r1_offset, r0_offset + BYTES_PER_LONGWORD
.equ   r2_offset, r1_offset + BYTES_PER_LONGWORD
.equ   r3_offset, r2_offset + BYTES_PER_LONGWORD
.equ   r4_offset, r3_offset + BYTES_PER_LONGWORD
.equ   r5_offset, r4_offset + BYTES_PER_LONGWORD
.equ   r6_offset, r5_offset + BYTES_PER_LONGWORD
.equ   r7_offset, r6_offset + BYTES_PER_LONGWORD
.equ   r8_offset, r7_offset + BYTES_PER_LONGWORD
.equ   r9_offset, r8_offset + BYTES_PER_LONGWORD
.equ   r10_offset, r9_offset + BYTES_PER_LONGWORD
.equ   r11_offset, r10_offset + BYTES_PER_LONGWORD
.equ   r12_offset, r11_offset + BYTES_PER_LONGWORD
.equ   r13_offset, r12_offset + BYTES_PER_LONGWORD
.equ   r14_offset, r13_offset + BYTES_PER_LONGWORD
.equ   r15_offset, r14_offset + BYTES_PER_LONGWORD
.equ   r16_offset, r15_offset + BYTES_PER_LONGWORD
.equ   r17_offset, r16_offset + BYTES_PER_LONGWORD
.equ   r18_offset, r17_offset + BYTES_PER_LONGWORD
.equ   r19_offset, r18_offset + BYTES_PER_LONGWORD
.equ   r20_offset, r19_offset + BYTES_PER_LONGWORD
.equ   r21_offset, r20_offset + BYTES_PER_LONGWORD
.equ   r22_offset, r21_offset + BYTES_PER_LONGWORD
.equ   r23_offset, r22_offset + BYTES_PER_LONGWORD
.equ   r24_offset, r23_offset + BYTES_PER_LONGWORD
.equ   r25_offset, r24_offset + BYTES_PER_LONGWORD

.equ   gp_offset, r25_offset + BYTES_PER_LONGWORD
.equ   fp_offset, gp_offset + BYTES_PER_LONGWORD
.equ   blink_offset, fp_offset + BYTES_PER_LONGWORD
.equ   ilink1_offset, blink_offset + BYTES_PER_LONGWORD
.equ   ilink2_offset, ilink1_offset + BYTES_PER_LONGWORD
.equ   status32_l1_offset, ilink2_offset + BYTES_PER_LONGWORD       ; this one only used by ARC5+
.equ   bta_l1_offset, status32_l1_offset + BYTES_PER_LONGWORD       ; this one only used by ARC5+


; hardware loop regs
.equ   lp_count_offset, bta_l1_offset + BYTES_PER_LONGWORD
.equ   lp_start_offset, lp_count_offset + BYTES_PER_LONGWORD
.equ   lp_end_offset, lp_start_offset + BYTES_PER_LONGWORD


; ARC DMA engine regs
.equ   ADMA_CTRL_AC_offset, lp_end_offset + BYTES_PER_LONGWORD
.equ   ADMA_SAD_S_AC_offset, ADMA_CTRL_AC_offset + BYTES_PER_LONGWORD
.equ   ADMA_DAD_S_AC_offset, ADMA_SAD_S_AC_offset + BYTES_PER_LONGWORD
.equ   ADMA_SAD_E_AC_offset, ADMA_DAD_S_AC_offset + BYTES_PER_LONGWORD

.equ   acc1_offset, ADMA_SAD_E_AC_offset + BYTES_PER_LONGWORD
.equ   acc2_offset, acc1_offset + BYTES_PER_LONGWORD
.equ   mx00_offset, acc2_offset + BYTES_PER_LONGWORD
.equ   mx01_offset, mx00_offset + BYTES_PER_LONGWORD
.equ   mx10_offset, mx01_offset + BYTES_PER_LONGWORD
.equ   mx11_offset, mx10_offset + BYTES_PER_LONGWORD
.equ   my00_offset, mx11_offset + BYTES_PER_LONGWORD
.equ   my01_offset, my00_offset + BYTES_PER_LONGWORD
.equ   my10_offset, my01_offset + BYTES_PER_LONGWORD
.equ   my11_offset, my10_offset + BYTES_PER_LONGWORD
.equ   my20_offset, my11_offset + BYTES_PER_LONGWORD
.equ   my21_offset, my20_offset + BYTES_PER_LONGWORD
.equ   ax0_offset, my21_offset + BYTES_PER_LONGWORD

.equ   ax1_offset, ax0_offset + BYTES_PER_LONGWORD
.equ   ay0_offset, ax1_offset + BYTES_PER_LONGWORD
.equ   ay1_offset, ay0_offset + BYTES_PER_LONGWORD
.equ   ay2_offset, ay1_offset + BYTES_PER_LONGWORD
.equ   aux_xmac0_offset, ay2_offset + BYTES_PER_LONGWORD
.equ   aux_xmac1_offset, aux_xmac0_offset + BYTES_PER_LONGWORD
.equ   aux_xmac2_offset, aux_xmac1_offset + BYTES_PER_LONGWORD
.equ   aux_macmode_offset, aux_xmac2_offset + BYTES_PER_LONGWORD
.equ   aux_xmaclw_h_offset, aux_macmode_offset + BYTES_PER_LONGWORD
.equ   aux_xmaclw_l_offset, aux_xmaclw_h_offset + BYTES_PER_LONGWORD

.equ   xyconfig_offset, aux_xmaclw_h_offset + BYTES_PER_LONGWORD

.equ   ISR_FPSIZE, xyconfig_offset + BYTES_PER_LONGWORD

