/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        mei_iof.h
*
* DESCRIPTION:     header file for the MEI interface functions
*
**************************************************************************/
#ifndef _MEI_IOF_H
#define _MEI_IOF_H

#include "typedef.h"
#include "socrates_memrymap.h"

/***** AUXILIARY REGISTER ADDRESSES *****/
// mailbox general purpose registers -- ARC to MEI
enum {
   OMB_GP_0_ADDR = SOC_TO_MEI_FIRST_ADDR,
   OMB_GP_1_ADDR = SOC_TO_MEI_FIRST_ADDR+4,
   OMB_GP_2_ADDR = SOC_TO_MEI_FIRST_ADDR+8,
   OMB_GP_3_ADDR = SOC_TO_MEI_FIRST_ADDR+12,
   OMB_GP_4_ADDR = SOC_TO_MEI_FIRST_ADDR+16,
   OMB_GP_5_ADDR = SOC_TO_MEI_FIRST_ADDR+20,
   OMB_GP_6_ADDR = SOC_TO_MEI_FIRST_ADDR+24,
   OMB_GP_7_ADDR = SOC_TO_MEI_FIRST_ADDR+28,
   OMB_GP_8_ADDR = SOC_TO_MEI_FIRST_ADDR+32,
   OMB_GP_9_ADDR = SOC_TO_MEI_FIRST_ADDR+36,
   OMB_GP_10_ADDR = SOC_TO_MEI_FIRST_ADDR+40,
   OMB_GP_11_ADDR = SOC_TO_MEI_FIRST_ADDR+44
};
#define OMB_GP_FIRST_ADDR        (OMB_GP_0_ADDR)
#define OMB_GP_LAST_ADDR         (OMB_GP_11_ADDR)

#define NUM_OMB_GP_REGISTERS     (12)

#define OMB_WINHOST_FIRST_ADDR      (OMB_GP_FIRST_ADDR)
#define OMB_WINHOST_LAST_ADDR    (OMB_WINHOST_FIRST_ADDR+8) // we need 17 words (=9 longword registers) of data for WinHost
#define OMB_CODESWAP_MESSAGE_ADDR   (OMB_GP_11_ADDR)        // indicates if a codeswap request is available
                                                // and which codeswap segment is requested
// mailbox general purpose registers -- MEI to ARC
enum {
   IMB_GP_0_ADDR = MEI_TO_SOC_FIRST_ADDR,
   IMB_GP_1_ADDR = MEI_TO_SOC_FIRST_ADDR+4,
   IMB_GP_2_ADDR = MEI_TO_SOC_FIRST_ADDR+8,
   IMB_GP_3_ADDR = MEI_TO_SOC_FIRST_ADDR+12,
   IMB_GP_4_ADDR  = MEI_TO_SOC_FIRST_ADDR+16,
   IMB_GP_5_ADDR = MEI_TO_SOC_FIRST_ADDR+20,
   IMB_GP_6_ADDR = MEI_TO_SOC_FIRST_ADDR+24,
   IMB_GP_7_ADDR = MEI_TO_SOC_FIRST_ADDR+28,
   IMB_GP_8_ADDR = MEI_TO_SOC_FIRST_ADDR+32,
   IMB_GP_9_ADDR = MEI_TO_SOC_FIRST_ADDR+36,
   IMB_GP_10_ADDR = MEI_TO_SOC_FIRST_ADDR+40,
   IMB_GP_11_ADDR  = MEI_TO_SOC_FIRST_ADDR+44
};
#define IMB_GP_FIRST_ADDR        (IMB_GP_0_ADDR)
#define IMB_GP_LAST_ADDR         (IMB_GP_11_ADDR)

#define NUM_IMB_GP_REGISTERS     (12)

#define IMB_WINHOST_FIRST_ADDR      (IMB_GP_FIRST_ADDR)
#define IMB_WINHOST_LAST_ADDR    (IMB_WINHOST_FIRST_ADDR+8) // we need 17 words (=9 longword registers) of data for WinHost
#define IMB_CODESWAP_STATUS_ADDR (IMB_GP_11_ADDR)        // indicates the status of a completed codeswap request
                                                // used in conjunction with MEI_INT_MC
#ifndef ADSL_62
   // MEI auxiliary registers
   #define MFIFO_CTRL_AC_ADDR (0x105)
   #define MEI_INT_MC_ADDR    (0x106)
   #define MEI_INT_AC_ADDR    (0x107)

   /***** REGISTER MASKS *****/
   // common between Danube and Stratiphy
   #define MEI_INT_MC_MASK          (0x00000003)
   #define MEI_INT_MC_CS_DONE_MASK     (0x00000002)
   #define MEI_INT_MC_MEI_MSGAV_MASK   (0x00000001)
   #define MEI_MSGAV_MASK           (MEI_INT_MC_MEI_MSGAV_MASK)

   #ifdef DANUBE
      #define MEI_INT_AC_MASK          (0x00000003)
      #define MEI_INT_AC_NO_ACCESS_MASK   (0x00000002)
      #define MEI_INT_AC_ARC_MSGAV_MASK   (0x00000001)
   #else
      #define MEI_INT_AC_MASK          (0x0000000F)
      #define MEI_INT_AC_NO_ACCESS_MASK   (0x00000008)
      #define MEI_INT_AC_CHECK_AAITX_MASK (0x00000004)
      #define MEI_INT_AC_CHECK_AAIRX_MASK (0x00000002)
      #define MEI_INT_AC_ARC_MSGAV_MASK   (0x00000001)
   #endif

   #define ARC_MSGAV_MASK           (MEI_INT_AC_ARC_MSGAV_MASK)
#endif // ADSL_62

#define OMB_CODESWAP_MESSAGE_MSG_TYPE_MASK   (0x80000000)
#define OMB_FASTREAD_MESSAGE_MSG_TYPE_MASK   (0x40000000)
#define OMB_CODESWAP_MESSAGE_CS_SECTION_MASK    (0x0000FFFF)
#define OMB_INTERRUPT_REQUEST_MASK               (0x3FFF0000)

#define OMB_CLEAREOC_INTERRUPT_CODE              (0x0002)

#define IMB_CODESWAP_STATUS_MASK    (0x000000FF)
#define IMB_CODESWAP_STATUS_FAIL_MASK  (0x000000FF)
#define IMB_CODESWAP_STATUS_PASS_MASK  (0x00000001)

#ifndef ADSL_62
   /***** FUNCTION PROTOTYPES *****/
   void MEI_RegisterRead(uint32 ul_addr, uint32 *pul_data);
   void MEI_RegisterWrite(uint32 ul_addr, uint32 ul_data);
#endif // ADSL_62
#endif //_MEI_IOF_H
