/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        mul.h
*
* DESCRIPTION:     macros for the abstraction of multiplications
*
**************************************************************************/
#ifndef _MUL_H
#define _MUL_H

#include "typedef.h"

#define AUX_XMAC0   (0x44)
#define AUX_XMAC1   (0x45)
#define AUX_XMAC2 (0x46)


extern int32  mul_op(int32, int32);
extern uint32 mulu_op(uint32, uint32);


#ifdef USE_ARC_6
    pragma intrinsic(mul_op,  opcode => 0x05, sub_opcode => 0x0c, assume_volatile => 1);
    pragma intrinsic(mulu_op, opcode => 0x05, sub_opcode => 0x0d, assume_volatile => 1);
#else
    pragma intrinsic(mul_op, opcode => 0x1c, assume_volatile => 1);
    pragma intrinsic(mulu_op, opcode => 0x1d, assume_volatile => 1);
#endif

/* 16-bit * 16-bit multiply */
#define MULS16(prod, x, y) {  \
    mul_op((int32) (x), (int32) (y));  \
    (prod) = (int32) _lr(AUX_XMAC2);   \
}

#define MULU16(prod, x, y) {  \
    mulu_op((uint32) (x), (uint32) (y));  \
    (prod) = (uint32) _lr(AUX_XMAC2);  \
}

/* 32-bit x 16-bit multiply */
#define MULS32x16(prod, x32, y16) { \
    mul_op((x32) >> 16, (y16));  \
    (prod) = (int32) (_lr(AUX_XMAC2) << 16); \
    if((y16) < 0) {  \
        mulu_op((x32) & 0x0000FFFF, -(y16)); \
        (prod) -= (int32) _lr(AUX_XMAC2); \
    } \
    else {  \
        mulu_op((x32) & 0x0000FFFF, (y16));  \
        (prod) += (int32) _lr(AUX_XMAC2); \
    } \
}

#endif
