/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _PLATFORM_H
#define _PLATFORM_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             platform.h
 * DESCRIPTION:      Platform-dependent constant definitions
 *
 **********************************************************************/
// ******************************************************************
// platform.h
//
// History
// 23/08/2011 Kannan: DS Performance improvement in DEC training.
//    Increased the DEC length from 400 to 480 to reduce the
//      uncancelled echo.
//      Grep for XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining
//
// 26/03/2013 Anantha Ramu: The DEC order restored back to 400 for Annex B
//            Grep for XDSLRTFW-761:PERF_ALL_ALL_AnxB_DEC_order_reduction
// ******************************************************************
// Define the max and min exponents allowed for TDQ filter.
// Subtract 15 from value to get true power-of-two exponent.
#define LOWERBOUND_TDQEXP                       (12)
#define UPPERBOUND_TDQEXP                       (19)

// Values obtained by Rx power calibration. See details in calibrat.c.
// Typical values might be:
// 0.43 milliwatts / (68000) = 6.323 * 10^-6 = 27159 * 2^-32.

#define  RXPOWERCAL_CONVERT_MANTISSA      (27159)
#define  RXPOWERCAL_CONVERT_EXPONENT      (-32)
#define  RXPOWERCAL_AFEGAIN            (1587)      // 6.2 dB
#define  RXPOWERCAL_FFT_SCALEBACKS     (5)

/* =========================================================================================== */
/* Parameters associated with digital echo canceller */
/* WARNING! The following constants are used for test purpose, and they should not be */
/* relied on for each individual system. Parameters for a different system should be calibrated  */
/* based on that particular system. */
/* =========================================================================================== */
//XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining (START - END)
//XDSLRTFW-761:PERF_ALL_ALL_AnxB_DEC_order_reduction (Start)
#ifndef ISDN
   #define DEC_ORDER_MAX               (480) /* digital echo canceller filter order */
#else
   #define DEC_ORDER_MAX               (400)  /* digital echo canceller filter order */
#endif
//XDSLRTFW-761:PERF_ALL_ALL_AnxB_DEC_order_reduction (End)

   #define LOG2DEC_ORDER            (9)      /* ceil(log2(DEC_ORDER)) */

#ifdef ADSL_62
   #define  MAX_DEC_DELAY           (48)  /* Maximum allowable DEC delay */
#else
   #define  MAX_DEC_DELAY           (31)  /* Maximum allowable DEC delay */
#endif

#endif /* _PLATFORM_H */

