/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _SOC_CODESWAP_H
#define _SOC_CODESWAP_H

/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   soc_codeswap.h
 *
 *   Header file for Socrates specific codeswap
 *
 *----------------------------------------------------------------------------
 */

#ifdef NEW_SOC_BUILD
    #include "ModemHWE_swap_index.h"

    #define CSPAGE_BULK_O2          CSPAGE_BIS_BULK_O2
    #define CSPAGE_BULK_O1          CSPAGE_BIS_BULK_O1
#else

    #define NO_OF_SWAPPAGES         (39)

    // BIS codeswap page defination
    #define CSPAGE_BIS_RES       (1)
    #define CSPAGE_BIS_INIT         (2)
    #define CSPAGE_BIS_HNSHK1    (3)
    #define CSPAGE_BIS_HNSHK2    (4)
    #define CSPAGE_BIS_XCVR0     (5)
    #define CSPAGE_BIS_DISC1     (6)
    #define CSPAGE_BIS_DISC2     (7)
    #define CSPAGE_BIS_XCVR1     (8)
    #define CSPAGE_BIS_XCVR2     (9)
    #define CSPAGE_BIS_ANAL         (10)
    #define CSPAGE_BIS_ANL1DMT      (11)
    #define CSPAGE_BIS_MTDQ         (12)
    #define CSPAGE_BIS_TDQTEST      (13)
    #define CSPAGE_BIS_BTLD         (14)
    #define CSPAGE_BIS_BTLDDMT      (15)
    #define CSPAGE_BIS_RXINIT    (16)
    #define CSPAGE_BIS_EXCH1     (17)
    #define CSPAGE_BIS_EXCH2     (18)
    #define CSPAGE_BIS_EXCH3     (19)
    #define CSPAGE_BIS_EXCHDMT      (20)
    #define CSPAGE_BIS_SHOW1     (21)
    #define CSPAGE_BIS_SHOW2        (22)
    #define CSPAGE_BIS_TXINIT    (23)
    #define CSPAGE_BIS_SHOWBG1      (24)
    #define CSPAGE_BIS_SHOWBG2      (25)
    #define CSPAGE_BIS_SHT1DMT      (26)
    #define CSPAGE_BIS_SHT2DMT      (27)
    #define CSPAGE_BIS_R_NOSHOW     (28)
    #define CSPAGE_BIS_R_NOGHS      (29)
    #define CSPAGE_BIS_BIS_RAM      (30)
    #define CSPAGE_BIS_DMT_RAM      (31)
    #define CSPAGE_BIS_SLEEP     (32)
    #define CSPAGE_BIS_XCVRDMT      (33)
    #define CSPAGE_BULK_O1       (34)
    //Note: page BULK_O1 is the "normal" page, BULK_O2 is the overlay page for handshake,
    //after handshake, we will request code-swap to re-init the normal page. So only
    //the index of CSPAGE_BULK_O1 is used, CSPAGE_BULK_O2 is never used.
    //And the order here must match the one in ModemHWE_biscs.sec.
    #define CSPAGE_BULK_O2          (35)
    #define CSPAGE_BIS_SHWBG3A      (36)
    #define CSPAGE_BIS_SHWBG3B      (37)
    #define CSPAGE_BIS_DISC3     (38)
#endif

// showtime (loopback) only test page
#define CSPAGE_BIS_LOOPINIT     (2)
#define CSPAGE_BIS_SHOW11     (3)
#define CSPAGE_BIS_SHOW22       (4)

 typedef struct {
     int32 l_PmOffset;
     int32 l_PmDestination;
     int32 l_PmSize;
     int32 l_DmOffset;
     int32 l_DmDestination;
     int32 l_DmSize;
 } CS_HeaderEntry_t;
 extern CS_HeaderEntry_t gt_CS_HeaderEntry;
 extern uint8 guc_XdmaCodeSwapSpeed;

 #define CODESWAP_REQUEST_SENT          0
 #define SEND_CODESWAP_REQUEST          1
 #define SEND_CODESWAP_REQUEST_2        2
 #define SEND_CODESWAP_REQUEST_3        3

 #define XDMA_SLOW_CODESWAP             0
 #define XDMA_FAST_CODESWAP             1
// codeswap API functions
void HandleCodeSwap(void);
void SendCodeSwapRequest(void);
void SendFastReadRequest(void);
FlagT CheckForCodeSwapDone(void);
void CheckForCodeSwapTrain(void);

/* Fast Read variables */
extern int16 gs_FastReadlength;
extern int16 gs_FastReadDestOffset;
extern int32 gl_FastReadAddress;

/* the following variables are used to coordinate the Socrates-ME interrupts. */
/* the flags guc_MPMsgReq, CodeSwapMsgReq, and FastReadMsgReq are set to request */
/* an MP transmission, Code Swap, and Fast Read, respectively.  The ProcessTxMailbox */
/* function monitors these flags and coordinates the interrupt signals. */

extern uint8   guc_MPMsgReq;
extern uint8   guc_CodeSwapMsgReq;
extern uint8   guc_FastReadMsgReq;
extern uint8*  gpuc_FastReadMsgReq;

/* the time out cnt is incremented each time the Fast Read times out. */
/* (should remain 0). */

/* FAST_READ_TIME_OUT defines the max number of frames to wait for a Fast Read */
#define FAST_READ_TIME_OUT 100

extern int16 gs_FastReadTimeOutCnt;

/* A flag is associated with each FastReadRequest.  The FastReadAddressList      */
/* identifies and enables Fast Reads by the address of this flag. if       */
/* the address of the flag is contained within the FastReadAddressList, then  */
/* the Fast Read is enabled.                                      */

#define FAST_READ_LIST_LENGTH 12

extern uint8*  gpuca_FastReadAddressList[FAST_READ_LIST_LENGTH];
extern uint8   guca_FastReadIDList[FAST_READ_LIST_LENGTH];

#endif //_SOC_CODESWAP_H
