/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: socrates_memrymap.h
;
;  Header file for simext cocomo interface.
;
*****************************************************************************/

#ifndef _SOCRATES_MEMRYMAP_H
#define _SOCRATES_MEMRYMAP_H

#if defined(TARGET_HW) && defined(ADSL_62)
    #include "vr9_memorymap.h"

   //XDSLRTFW-241: FIX_ALL_ALL_ALL_Clear_Persistent_Memory (Start - End)
   //Peristent memory size is taken from ADSL_62.mem. Please change here if it is changed in mem file
   #define PERSISTENT_MEM_SIZE      (0x200)
#else
   #ifdef DANUBE  // For Danube Cocomo build

      #define INSTR_BEGIN             (0x0)

   #ifdef AMAZON_SE
      #define INSTR_END               (0x5FFF)
      #define BULK_BEGIN              (0x06000)
      #define BULK_END                (0x0AF9F)
      #define SOC_TO_MEI_FIRST_ADDR   (0x0AFA0)
      #define MEI_TO_SOC_FIRST_ADDR   (0x0AFD0)
   #else
      #define INSTR_END               (0x8FFF)
      #define BULK_BEGIN              (0x09000)
      #define BULK_END                (0x0DF9F)
      #define SOC_TO_MEI_FIRST_ADDR   (0x0DFA0)
      #define MEI_TO_SOC_FIRST_ADDR   (0x0DFD0)
   #endif

      #define XY_BEGIN                (0x18000)
      #define X_BEGIN                 (0x18000)
      #define    Y_BEGIN              (0x1A000)
      #define XY_END                  (0x1BFFF)

      #define ADSL_BASE_OFFSET        (0x20000) // If Core_Addr = 0, Soc_Addr = 0x2C000
      #define    ADSL_BEGIN           (0x2C000)
      #define ADSL_END                (0x47FFF)

      #define STACK_TOP               (0x1C200)

      #define SIMEXT_BEGIN            (0x2BF00)       // from 0x20000 to 0x2BFFF are free "inside" ADSL cores space

         #define SIMEXT_INIT_CORES             (SIMEXT_BEGIN + 0*4)
         #define SIMEXT_CLOCK_CORES            (SIMEXT_BEGIN + 1*4)
         #define SIMEXT_CLOCK_CORE_MODE        (SIMEXT_BEGIN + 2*4)
               #define CLOCK_CORES_PER_INSTRUCTION   1
               #define CLOCK_CORES_UNTIL_INTR        2
               #define CLOCK_CORES_DISABLED          3
         #define SIMEXT_INIT_CORES_END         (SIMEXT_BEGIN + 3*4)



         #define SIMEXT_MODEM_VARS_LOOKUP                (SIMEXT_INIT_CORES_END)
               #define SIMEXT_PTR_gul_ModeControl              (SIMEXT_MODEM_VARS_LOOKUP + 0*4)
               #define SIMEXT_PTR_gs_bypass_strymon            (SIMEXT_MODEM_VARS_LOOKUP + 1*4)
               #define SIMEXT_PTR_TESTArray_TEST_Control       (SIMEXT_MODEM_VARS_LOOKUP + 2*4)
               #define SIMEXT_PTR_TESTArray_TEST_Control2      (SIMEXT_MODEM_VARS_LOOKUP + 3*4)
               #define SIMEXT_PTR_TESTArray_TEST_InitState     (SIMEXT_MODEM_VARS_LOOKUP + 4*4)
               #define SIMEXT_PTR_OPTNArray_OPTN_ModeControl   (SIMEXT_MODEM_VARS_LOOKUP + 5*4)
               #define SIMEXT_PTR_gs_RxFftLength               (SIMEXT_MODEM_VARS_LOOKUP + 6*4)
               #define SIMEXT_PTR_gs_TxFftLength               (SIMEXT_MODEM_VARS_LOOKUP + 7*4)
               #define SIMEXT_PTR_gft_ResetDmaPtr              (SIMEXT_MODEM_VARS_LOOKUP + 8*4)
               #define SIMEXT_PTR_gft_TxDataPump_On            (SIMEXT_MODEM_VARS_LOOKUP + 9*4)
               #define SIMEXT_PTR_gft_TcmFlag_bis_US           (SIMEXT_MODEM_VARS_LOOKUP + 10*4)
               #define SIMEXT_PTR_gft_ModemType                (SIMEXT_MODEM_VARS_LOOKUP + 11*4)
               #define SIMEXT_EXEC_ConfigForLinkStartAndTest   (SIMEXT_MODEM_VARS_LOOKUP + 12*4)
               #define SIMEXT_PTR_gl_LogTxFrame                (SIMEXT_MODEM_VARS_LOOKUP + 13*4)
               #define SIMEXT_PTR_gs_txFrameInt                (SIMEXT_MODEM_VARS_LOOKUP + 14*4)
               #define SIMEXT_PTR_gs_rxFrameInt                (SIMEXT_MODEM_VARS_LOOKUP + 15*4)
               #define SIMEXT_PTR_gs_AFE_PGAGain               (SIMEXT_MODEM_VARS_LOOKUP + 16*4)

         #define SIMEXT_MODEM_VARS_LOOKUP_END            (SIMEXT_MODEM_VARS_LOOKUP + 20*4)


         #define SIMEXT_FILE_IO                          (SIMEXT_MODEM_VARS_LOOKUP_END)
               #define SIMEXT_FILE_PERMISSION_LENGTH           (SIMEXT_FILE_IO + 4*4)
               #define SIMEXT_FILE_PERMISSION_STRING           (SIMEXT_FILE_IO + 5*4)
               #define SIMEXT_FILE_NAME_LENGTH                 (SIMEXT_FILE_IO + 6*4)
               #define SIMEXT_FILE_NAME_STRING                 (SIMEXT_FILE_IO + 7*4)
               #define SIMEXT_FILE_PTR                         (SIMEXT_FILE_IO + 8*4)
               #define SIMEXT_FILE_IO_WRITE                    (SIMEXT_FILE_IO + 9*4)
               #define SIMEXT_FILE_IO_READ                     (SIMEXT_FILE_IO + 10*4)
               #define SIMEXT_FOPEN_REQUEST                    (SIMEXT_FILE_IO + 11*4)
               #define SIMEXT_FCLOSE_REQUEST                   (SIMEXT_FILE_IO + 12*4)
               #define SIMEXT_FFLUSH_REQUEST                   (SIMEXT_FILE_IO + 13*4)
               #define SIMEXT_FILE_STDOUT                      (SIMEXT_FILE_IO + 14*4)
               #define SIMEXT_SCANF_TYPE                       (SIMEXT_FILE_IO + 15*4)
               #define SIMEXT_SCANF_VAR_PTR                    (SIMEXT_FILE_IO + 16*4)
                  #define PERCENT_s                 1
                  #define PERCENT_d                 2
                  #define PERCENT_x                 3
                  #define PERCENT_rest_of_line      4
               #define SIMEXT_SCANF_RETURN                     (SIMEXT_FILE_IO + 17*4)
                  #define SCANF_EOF                 -1
         #define SIMEXT_FILE_IO_END                      (SIMEXT_FILE_IO + 18*4)

      #define SIMEXT_END          (0x2BFFF)

   #else   // for Socrates Cocomo build

   #define BULK_BEGIN            (0x10000)   //(0x10000)
   #define BULK_END           (0x15f8c)
   #define SOC_TO_MEI_FIRST_ADDR (0x15f90)
   #define MEI_TO_SOC_FIRST_ADDR (0x15fc0)

   #define INSTR_BEGIN           (0x0)    //(0x00000)
   #define INSTR_END          (0xABFFF)   //(0x0FFFF)
   #define XY_BEGIN           (0x18000)
   #define XY_END             (0x1BFFF)
   #define X_BEGIN               (0x18000)
   #define  Y_BEGIN              (0x1A000)
   #define  MEI_RAM_BEGIN        (0x1C000)
   #define  MEI_RAM_END          (0x1C3FF)
   #define  ADSL_BEGIN           (0x20000)
   #define ADSL_END           (0x47FFF)
   #define ADSL_BASE_OFFSET      (0x20000)   // If Core_Addr = 0, Soc_Addr = 0x20000
   #define UNUSED_BEGIN       (0x1C400)
   #define UNUSED_END            (0x1FFFF)

   //STACK_TOP should be consistant with the STACK_RAM allocation defined in harvardArch_biscs.cmd
   #define STACK_TOP               (0xFE200)

   #endif   // #ifdef DANUBE
#endif // ADSL_62

#endif /* _SOCRATES_MEMRYMAP_H */
