/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        xy_iof.h
*
* DESCRIPTION:     Header file for functions that interface the XY memory
*
**************************************************************************/
#include "common.h"

/***** GENERAL CONSTANTS *****/
#ifndef FAIL
#define FAIL   (0)
#endif // #ifndef FAIL

#ifndef PASS
#define PASS   (1)
#endif // #ifndef PASS

#define ADDR_MODE_16 (0)
#define ADDR_MODE_32 (1)
#define ADDR_NOT_IN_XY  (-1)

#define BYTES_PER_WORD        (2)
#define BYTES_PER_LONGWORD    (4)
#define LOG2_BYTES_PER_WORD      (1)
#define LOG2_BYTES_PER_LONGWORD  (2)

/***** BUFFER IDs *****/
#define NUM_BUFFER_ID      (6)

#define XY_MEM          (0)
#define X_MEM           (1)
#define Y_MEM           (2)

#ifdef ADSL_62
   #define XY_BUF_8X0         (X_MEM)
   #define XY_BUF_8X1         (Y_MEM)
// #define XY_BUF_Y_TMP_DEC      (3)

   #define X_BLOCK_SIZE_IN_BYTES (0x1000)
   #define Y_BLOCK_SIZE_IN_BYTES (0x1000)

   #define X_BASE_ADDR_IN_BYTES  (0x30000)
   #define Y_BASE_ADDR_IN_BYTES  (0x34000)

   /* X MEMORY -- addr relative to X memory */
   #define XY_BUF_8X0_SIZE       (X_BLOCK_SIZE_IN_BYTES/2)
   #define XY_BUF_8X0_START      (0)
   #define XY_BUF_8X0_END        (XY_BUF_8X0_START + XY_BUF_8X0_SIZE-1)

   /* Y MEMORY -- addr relative to Y memory */
   #define XY_BUF_8X1_SIZE       (Y_BLOCK_SIZE_IN_BYTES/2)
   #define XY_BUF_8X1_START      (0)
   #define XY_BUF_8X1_END        (XY_BUF_8X1_START + XY_BUF_8X1_SIZE-1)

    // this one needs to be verified when we want to run Dec adapt in show
   #define XY_BUF_Y_DEC_TMP_BUF_SIZE   (2048)
   #define XY_BUF_Y_DEC_TMP_START      (XY_BUF_8X1_END-XY_BUF_Y_DEC_TMP_BUF_SIZE+1)
   #define XY_BUF_Y_DEC_TMP_END     (XY_BUF_Y_DEC_TMP_START + XY_BUF_Y_DEC_TMP_BUF_SIZE-1)
#else

   #define XY_BUF_8X0         (3)
   #define XY_BUF_8X1         (4)
   #define XY_BUF_Y_TMP_DEC      (5)

   /***** BUFFER ADDRESSES *****/
   #define X_BLOCK_SIZE_IN_BYTES (0x2000)
   #define Y_BLOCK_SIZE_IN_BYTES (0x2000)

   #ifdef HERCULES_ADSL_CPE
   #define XY_BASE_ADDR_IN_BYTES (0x2A000)
   #else
   #define XY_BASE_ADDR_IN_BYTES (0x18000)
   #endif
   #define X_BASE_ADDR_IN_BYTES  (XY_BASE_ADDR_IN_BYTES)
   #define Y_BASE_ADDR_IN_BYTES  (XY_BASE_ADDR_IN_BYTES + X_BLOCK_SIZE_IN_BYTES)

   // all the addresses are listed in 16-bit addressing mode
   // to convert to 32-bit addressing mode, right shift by 2

   /* XY MEMORY -- addr relative to XY Base Addr */
   #define XY_BUF_SIZE           (8192)
   #define XY_BUF_START       (0)
   #define XY_BUF_END            (XY_BUF_START + XY_BUF_SIZE-1)

   #define X_BUF_SIZE            (4096)
   #define X_BUF_START           (0)
   #define X_BUF_END          (X_BUF_START + X_BUF_SIZE-1)

   #define Y_BUF_SIZE            (4096)
   #define Y_BUF_START           (X_BUF_END+1)
   #define Y_BUF_END          (Y_BUF_START + Y_BUF_SIZE-1)

   /* X MEMORY -- addr relative to X memory */
   #define XY_BUF_8X0_SIZE       (4096)
   #define XY_BUF_8X0_START      (0)
   #define XY_BUF_8X0_END        (XY_BUF_8X0_START + XY_BUF_8X0_SIZE-1)

   /* Y MEMORY -- addr relative to Y memory */
   #define XY_BUF_8X1_SIZE       (4096)
   #define XY_BUF_8X1_START      (0)
   #define XY_BUF_8X1_END        (XY_BUF_8X1_START + XY_BUF_8X1_SIZE-1)

   #define XY_BUF_Y_DEC_TMP_BUF_SIZE   (1024)
   #define XY_BUF_Y_DEC_TMP_START      (XY_BUF_8X1_END-XY_BUF_Y_DEC_TMP_BUF_SIZE+1)
   #define XY_BUF_Y_DEC_TMP_END     (XY_BUF_Y_DEC_TMP_START + XY_BUF_Y_DEC_TMP_BUF_SIZE-1)
#endif


/* FUNCTION PROTOTYPES */
int32 XYAddrDecode(int32 *pla_input, FlagT ft_AddrMode);
FlagT CheckXYAddrRange(int32 *pla_buf, int16 s_bufId);
FlagT CheckValidModuloAddr(int32 pla_bufXY, int16 s_bufLen);
void  AlignOddAddressWordsX(int32 psa_xyBuf, int16 s_bufLen);
void  AlignOddAddressWordsY(int32 psa_xyBuf, int16 s_bufLen);
void XYDecodeBypass_AddrDecode();

