/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http:// www.aware.com
 *
 * FILE:             alp_dsp_interface.h
 * DESCRIPTION:      Specifies DSP to Alphaeus interface.  This interface
 *             consists of the register offsets (from register
 *             base), the register masks, memory lengths, and other
 *             #define's that specify the hardware.
 *
 **********************************************************************/
#ifndef _ALP_DSP_INTERFACE_H
#define _ALP_DSP_INTERFACE_H

/**********************************************************************
 * Register offsets within register block.
 **********************************************************************/
/* Address offsets of global registers */
#define ALP_CVER_OFFSET          (0x00)   // Core version register
#define ALP_UTP_CFG_OFFSET          (0x01)   // UTOPIA configuration register
#define ALP_UTP_STAT_OFFSET         (0x02)   // UTOPIA transmit port status register
#define ALP_INT_STAT_OFFSET         (0x03)   // Interrupt Status Register
#define ALP_INT_MASK_OFFSET         (0x04)   // Interrupt Mask Register
#define ALP_DEBUG1_OFFSET        (0x05)   // Debug Register 1
#define ALP_DEBUG2_OFFSET        (0x06)   // Debug Register 2
#define ALP_DCP_CONFIG_OFFSET    (0x07)   // DCP (Device Control Protocol) config register
#define ALP_DCP_STAT_OFFSET         (0x08)   // DCP buffer status register

/* Address offsets of Tx registers */
//#define ALP_T_CONTROL_OFFSET      (0x10)   // Obsolete
#define ALP_T_CONFIG_OFFSET         (0x11)   // Transmit path configuration register
#define ALP_T_CB_STAT_OFFSET     (0x12)   // Transmit cell buffer status register
#define ALP_T_CB_CFG_BC0_OFFSET     (0x13)   // Transmit cell buffer configuration reg for BC0
#define ALP_T_CB_CFG_BC1_OFFSET     (0x14)   // Transmit cell buffer configuration reg for BC1

#define ALP_T_PCNTL_BC0_OFFSET      (0x20)   // Transmit bearer channel control reg for BC0
#define ALP_T_IDLE_BC0_OFFSET    (0x21)  // Transmit idle cell payload pattern for BC0
#define ALP_T_CELL_CNT_BC0_OFFSET   (0x22)  // Transmit processed cell counter for BC0
#define ALP_T_IDLE_CNT_BC0_OFFSET   (0x23)  // Transmit idle cell counter for BC0

#define ALP_T_PCNTL_BC1_OFFSET      (0x30)   // Transmit bearer channel control reg for BC1
#define ALP_T_IDLE_BC1_OFFSET    (0x31)  // Transmit idle cell payload pattern for BC1
#define ALP_T_CELL_CNT_BC1_OFFSET   (0x32)  // Transmit processed cell counter for BC1
#define ALP_T_IDLE_CNT_BC1_OFFSET   (0x33)  // Transmit idle cell counter for BC1


/* Address offsets of Rx registers */
//#define ALP_R_CONTROL_OFFSET      (0x40)   // Obsolete
#define ALP_R_CONFIG_OFFSET         (0x41)   // Receive path configuration register
#define ALP_R_CB_STAT_OFFSET     (0x42)   // Receive cell buffer status register
#define ALP_R_CB_CFG_BC0_OFFSET     (0x43)   // Receive cell buffer configuration reg for BC0
#define ALP_R_CB_CFG_BC1_OFFSET     (0x44)   // Receive cell buffer configuration reg for BC1
#define ALP_R_IMAHEC_OFFSET         (0x45)   // Byte Patterns Register for HEC Byte Overwrite in IMA Mode

#define ALP_R_PCNTL_BC0_OFFSET      (0x80)   // Receive bearer channel control reg for BC0
#define ALP_R_ATM_STAT_BC0_OFFSET   (0x81)  // Receive ATM status register for receive BC0
#define ALP_R_CELL_CNT_BC0_OFFSET   (0x82)  // Receive processed cell counter for BC0
#define ALP_R_IDLE_CNT_BC0_OFFSET   (0x83)  // Receive idle cell counter for BC0
#define ALP_R_AIDLE_CNT_BC0_OFFSET  (0x84)  // Receive idle cells in cell buffer for BC0
#define ALP_R_BE_CNT_BC0_OFFSET     (0x85)  // Receive bit error counter for BC0
#define ALP_R_HEC_CNT_BC0_OFFSET    (0x86)  // Receive HEC counter for BC0
#define ALP_R_CD_CNT_BC0_OFFSET     (0x87)  // Receive cell drop counter for BC0
#define ALP_R_IDLE_BC0_OFFSET    (0x88)  // Receive expected idle cell payload pattern for BC0
#define ALP_R_DELIN_BC0_OFFSET      (0x89)  // Receive delineation (alpha/delta constant) reg for BC0

#define ALP_R_PCNTL_BC1_OFFSET      (0xA0)   // Receive bearer channel control reg for BC1
#define ALP_R_ATM_STAT_BC1_OFFSET   (0xA1)  // Receive ATM status register for receive BC1
#define ALP_R_CELL_CNT_BC1_OFFSET   (0xA2)  // Receive processed cell counter for BC1
#define ALP_R_IDLE_CNT_BC1_OFFSET   (0xA3)  // Receive idle cell counter for BC1
#define ALP_R_AIDLE_CNT_BC1_OFFSET  (0xA4)  // Receive idle cells in cell buffer for BC1
#define ALP_R_BE_CNT_BC1_OFFSET     (0xA5)  // Receive bit error counter for BC1
#define ALP_R_HEC_CNT_BC1_OFFSET    (0xA6)  // Receive HEC counter for BC1
#define ALP_R_CD_CNT_BC1_OFFSET     (0xA7)  // Receive cell drop counter for BC1
#define ALP_R_IDLE_BC1_OFFSET    (0xA8)  // Receive expected idle cell payload pattern for BC1
#define ALP_R_DELIN_BC1_OFFSET      (0xA9)  // Receive delineation (alpha/delta constant) reg for BC1

/* Address offsets of Tx XTC registers */
#define ALP_T_XTC_CONFIG_OFFSET     (0xC0)   // Transmit XTC configuration
#define ALP_T_XTC_CB_CFG_OFFSET        (0xC1) // Transmit XTC cell buffer configuration
#define ALP_T_XTC_STAT_OFFSET        (0xC2) // Transmit XTC status
#define ALP_T_XTC_DMT_DLY_OFFSET     (0xC3) // Transmit delay for first request for XTC core.
#define ALP_T_XTC_DMT_DLY_A_OFFSET   (0xC4) // Active transmit delay for first request for XTC core.
#define ALP_T_XTC_SIZE0_OFFSET       (0xC5) // Transmit num of XTC requests per symbol for BC0
#define ALP_T_XTC_SIZE0_A_OFFSET     (0xC6) // Active transmit num of XTC requests per symbol for BC0
#define ALP_T_XTC_SIZE1_OFFSET       (0xC7) // Transmit num of XTC requests per symbol for BC1
#define ALP_T_XTC_SIZE1_A_OFFSET     (0xC8) // Active transmit num of XTC requests per symbol for BC1
#define ALP_T_XTC_BYTE_DLY0_OFFSET   (0xC9) // Transmit delay between byte requests for XTC core for BC0
#define ALP_T_XTC_BYTE_DLY0_A_OFFSET (0xCA) // Active transmit delay between byte requests for XTC core for BC0
#define ALP_T_XTC_BYTE_DLY1_OFFSET   (0xCB) // Transmit delay between byte requests for XTC core for BC1
#define ALP_T_XTC_BYTE_DLY1_A_OFFSET (0xCC) // Active transmit delay between byte requests for XTC core for BC1
#define ALP_T_XTC_TCR_OFFSET         (0xCD)

/* Address offsets of Rx XTC registers */
#define ALP_R_XTC_CONFIG_OFFSET     (0xD0)   // Receive XTC configuration
#define ALP_R_XTC_CB_CFG_OFFSET        (0xD1) // Receive XTC cell buffer configuration
#define ALP_R_XTC_STAT_OFFSET        (0xD2) // Receive XTC status
#define ALP_R_XTC_DMT_DLY_OFFSET     (0xD3) // Receive delay for first data transfer for XTC core.
#define ALP_R_XTC_DMT_DLY_A_OFFSET   (0xD4) // Active receive delay for first data transfer for XTC core.
#define ALP_R_XTC_SIZE0_OFFSET       (0xD5) // Receive num of XTC data transfer per symbol for BC0
#define ALP_R_XTC_SIZE0_A_OFFSET     (0xD6) // Active receive num of XTC data transfer per symbol for BC0
#define ALP_R_XTC_SIZE1_OFFSET       (0xD7) // Receive num of XTC data transfer per symbol for BC1
#define ALP_R_XTC_SIZE1_A_OFFSET     (0xD8) // Active receive num of XTC data transfer per symbol for BC1
#define ALP_R_XTC_BYTE_DLY0_OFFSET   (0xD9) // Receive delay between byte transfers for XTC core for BC0
#define ALP_R_XTC_BYTE_DLY0_A_OFFSET (0xDA) // Active receive delay between byte transfers for XTC core for BC0
#define ALP_R_XTC_BYTE_DLY1_OFFSET   (0xDB) // Receive delay between byte transfers for XTC core for BC1
#define ALP_R_XTC_BYTE_DLY1_A_OFFSET (0xDC) // Active receive delay between byte transfers for XTC core for BC1
#define ALP_R_XTC_TCR_OFFSET         (0xDD)

#define ALP_MAX_REG_OFFSET       (0xDD)

#define ALP_GLOBALREG_OFFSET     (ALP_CVER_OFFSET)    // Offset of common (global) regs
#define ALP_TXREG_OFFSET         (ALP_T_CONFIG_OFFSET) // Offset of Tx registers
#define ALP_RXREG_OFFSET         (ALP_R_CONFIG_OFFSET) // Offset of Rx registers

/* Size of GLOBAL and TX/RX register */
#define ALP_GLOBALREG_SIZE       (ALP_DCP_STAT_OFFSET-ALP_GLOBALREG_OFFSET+1)    // size of common regs
#define ALP_TXREG_SIZE           (ALP_T_IDLE_CNT_BC1_OFFSET-ALP_TXREG_OFFSET+1) // size of Tx regs
#define ALP_RXREG_SIZE           (ALP_R_DELIN_BC1_OFFSET-ALP_RXREG_OFFSET+1)     // size of Rx regs.

/**********************************************************************
 * Register masks
 **********************************************************************/
/* Mask of global registers */
#define ALP_CVER_MASK            (0x000000FF)  // Core version register
#define ALP_UTP_CFG_MASK         (0x0000FFFF)  // UTOPIA configuration register
#define ALP_UTP_STAT_MASK        (0x0000FFFF)  // UTOPIA transmit port status register
#define ALP_INT_STAT_MASK        (0x03030303)  // Interrupt Status Register
#define ALP_INT_MASK_MASK        (0x13031303)  // Interrupt Mask Register
#define ALP_DEBUG1_MASK          (0xFE7FFE7F)  // Debug Register 1
#define ALP_DEBUG2_MASK          (0xFE7FFE7F)  // Debug Register 2
#define ALP_DCP_CONFIG_MASK         (0xFFFFFF7F)  // DCP (Device Control Protocol) config register
#define ALP_DCP_STAT_MASK        (0x00000003)  // DCP buffer status register

/* Masks of Tx registers */
#define ALP_T_CONTROL_MASK       (0x00000003)  // Transmit path control register
#define ALP_T_CONFIG_MASK        (0x0000001F)  // Transmit path configuration register
#define ALP_T_CB_STAT_MASK       (0x0001FEFF)  // Transmit cell buffer status register
#define ALP_T_CB_CFG_BC0_MASK    (0x007F0FFF)  // Transmit cell buffer configuration reg for BC0
#define ALP_T_CB_CFG_BC1_MASK    (0x007F0FFF)  // Transmit cell buffer configuration reg for BC1

#define ALP_T_PCNTL_BC0_MASK     (0x0000000F)  // Transmit bearer channel control reg for BC0
#define ALP_T_IDLE_BC0_MASK         (0x000000FF)  // Transmit idle cell payload pattern for BC0
#define ALP_T_CELL_CNT_BC0_MASK     (0x0000FFFF)  // Transmit processed cell counter for BC0
#define ALP_T_IDLE_CNT_BC0_MASK     (0x0000FFFF)  // Transmit idle cell counter for BC0

#define ALP_T_PCNTL_BC1_MASK     (0x0000000F)  // Transmit bearer channel control reg for BC1
#define ALP_T_IDLE_BC1_MASK         (0x000000FF)  // Transmit idle cell payload pattern for BC1
#define ALP_T_CELL_CNT_BC1_MASK     (0x0000FFFF)  // Transmit processed cell counter for BC1
#define ALP_T_IDLE_CNT_BC1_MASK     (0x0000FFFF)  // Transmit idle cell counter for BC1


/* Masks of Rx registers */
#define ALP_R_CONTROL_MASK       (0x00000003)  // Receive path control register
#define ALP_R_CONFIG_MASK        (0x0000003F)  // Receive path configuration register
#define ALP_R_CB_STAT_MASK       (0x0001FEFF)  // Receive cell buffer status register
#define ALP_R_CB_CFG_BC0_MASK    (0x007F0FFF)  // Receive cell buffer configuration reg for BC0
#define ALP_R_CB_CFG_BC1_MASK    (0x007F0FFF)  // Receive cell buffer configuration reg for BC1
#define ALP_R_IMAHEC_MASK        (0x0001FFFF)  // Byte Patterns Register for HEC Byte Overwrite in IMA Mode

#define ALP_R_PCNTL_BC0_MASK     (0x0000000F)  // Receive bearer channel control reg for BC0
#define ALP_R_ATM_STAT_BC0_MASK     (0x00000007)  // Receive ATM status register for receive BC0
#define ALP_R_CELL_CNT_BC0_MASK     (0x0000FFFF)  // Receive processed cell counter for BC0
#define ALP_R_IDLE_CNT_BC0_MASK     (0x0000FFFF)  // Receive idle cell counter for BC0
#define ALP_R_AIDLE_CNT_BC0_MASK    (0x0000FFFF)  // Receive idle cells in cell buffer for BC0
#define ALP_R_BE_CNT_BC0_MASK       (0xFFFFFFFF)  // Receive bit error counter for BC0
#define ALP_R_HEC_CNT_BC0_MASK      (0x0000FFFF)  // Receive HEC counter for BC0
#define ALP_R_CD_CNT_BC0_MASK       (0x0000FFFF)  // Receive cell drop counter for BC0
#define ALP_R_IDLE_BC0_MASK         (0x000000FF)  // Receive expected idle cell payload pattern for BC0
#define ALP_R_DELIN_BC0_MASK     (0x000000FF)  // Receive delineation (alpha/delta constant) reg for BC0

#define ALP_R_PCNTL_BC1_MASK     (0x0000000F)  // Receive bearer channel control reg for BC1
#define ALP_R_ATM_STAT_BC1_MASK     (0x00000007)  // Receive ATM status register for receive BC1
#define ALP_R_CELL_CNT_BC1_MASK     (0x0000FFFF)  // Receive processed cell counter for BC1
#define ALP_R_IDLE_CNT_BC1_MASK     (0x0000FFFF)  // Receive idle cell counter for BC1
#define ALP_R_AIDLE_CNT_BC1_MASK    (0x0000FFFF)  // Receive idle cells in cell buffer for BC1
#define ALP_R_BE_CNT_BC1_MASK       (0xFFFFFFFF)  // Receive bit error counter for BC1
#define ALP_R_HEC_CNT_BC1_MASK      (0x0000FFFF)  // Receive HEC counter for BC1
#define ALP_R_CD_CNT_BC1_MASK       (0x0000FFFF)  // Receive cell drop counter for BC1
#define ALP_R_IDLE_BC1_MASK         (0x000000FF)  // Receive expected idle cell payload pattern for BC1
#define ALP_R_DELIN_BC1_MASK     (0x000000FF)  // Receive delineation (alpha/delta constant) reg for BC1


/* Masks of Tx XTC registers */
#define ALP_T_XTC_CONFIG_MASK       (0x00000001)  // Transmit XTC configuration
#define ALP_T_XTC_CB_CFG_MASK       (0x1FFF1FFF)  // Transmit XTC cell buffer configuration
#define ALP_T_XTC_STAT_MASK         (0x00000000)  // Transmit XTC status: RO and W1C bits only
#define ALP_T_XTC_DMT_DLY_MASK      (0x0000003F)  // Transmit delay for first request for XTC core.
#define ALP_T_XTC_DMT_DLY_A_MASK    (0x0000003F)  // Active transmit delay for first request for XTC core.
#define ALP_T_XTC_SIZE0_MASK        (0x00001FFF)  // Transmit num of XTC requests per symbol for BC0
#define ALP_T_XTC_SIZE0_A_MASK      (0x00001FFF)  // Active transmit num of XTC requests per symbol for BC0
#define ALP_T_XTC_SIZE1_MASK        (0x00001FFF)  // Transmit num of XTC requests per symbol for BC1
#define ALP_T_XTC_SIZE1_A_MASK      (0x00001FFF)  // Active transmit num of XTC requests per symbol for BC1
#define ALP_T_XTC_BYTE_DLY0_MASK    (0x0000001F)  // Transmit delay between byte requests for XTC core for BC0
#define ALP_T_XTC_BYTE_DLY0_A_MASK  (0x0000001F)  // Active transmit delay between byte requests for XTC core for BC0
#define ALP_T_XTC_BYTE_DLY1_MASK    (0x0000001F)  // Transmit delay between byte requests for XTC core for BC1
#define ALP_T_XTC_BYTE_DLY1_A_MASK  (0x0000001F)  // Active transmit delay between byte requests for XTC core for BC1

/* Masks of Rx XTC registers */
#define ALP_R_XTC_CONFIG_MASK       (0x00000001)  // Receive XTC configuration
#define ALP_R_XTC_CB_CFG_MASK       (0x1FFF1FFF)  // Receive XTC cell buffer configuration
#define ALP_R_XTC_STAT_MASK         (0x00000000)  // Receive XTC status: RO and W1C bits only
#define ALP_R_XTC_DMT_DLY_MASK      (0x0000003F)  // Receive delay for first data transfer for XTC core.
#define ALP_R_XTC_DMT_DLY_A_MASK    (0x0000003F)  // Active receive delay for first data transfer for XTC core.
#define ALP_R_XTC_SIZE0_MASK        (0x00001FFF)  // Receive num of XTC data transfer per symbol for BC0
#define ALP_R_XTC_SIZE0_A_MASK      (0x00001FFF)  // Active receive num of XTC data transfer per symbol for BC0
#define ALP_R_XTC_SIZE1_MASK        (0x00001FFF)  // Receive num of XTC data transfer per symbol for BC1
#define ALP_R_XTC_SIZE1_A_MASK      (0x00001FFF)  // Active receive num of XTC data transfer per symbol for BC1
#define ALP_R_XTC_BYTE_DLY0_MASK    (0x0000001F)  // Receive delay between byte transfers for XTC core for BC0
#define ALP_R_XTC_BYTE_DLY0_A_MASK  (0x0000001F)  // Active receive delay between byte transfers for XTC core for BC0
#define ALP_R_XTC_BYTE_DLY1_MASK    (0x0000001F)  // Receive delay between byte transfers for XTC core for BC1
#define ALP_R_XTC_BYTE_DLY1_A_MASK  (0x0000001F)  // Active receive delay between byte transfers for XTC core for BC1

#endif /* #endifndef _ALP_DSP_INTERFACE_H */
