/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ft_memmap.h
*
*   This file contains Iridia-FT BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FT_MEMMAP_H
#define _FT_MEMMAP_H

//==============================================================================
// Iridia-FT Memory Map
//==============================================================================
#define IRI_FT_RAM_BASE_ADDR              (0x310000)

//Unused picked arb large.

#define  IRI_FT_RAM_TX_PAR_PVEC_ADDR         (IRI_FT_RAM_BASE_ADDR)

//==============================================================================
// Iridia-FT Register Map
//==============================================================================
   #define IRI_FT_REG_BASE_ADDR                (0x30C800)

// Tx Registers
#define  IRI_FT_REG_RX_CTRL_ADDR          (IRI_FT_REG_BASE_ADDR+0x00)
#define  IRI_FT_REG_RX_CTRL_A_35B_ADDR       (IRI_FT_REG_BASE_ADDR+0x04)
#define  IRI_FT_REG_TX_CTRL_35B_ADDR            (IRI_FT_REG_BASE_ADDR+0x08)
#define  IRI_FT_REG_TX_CTRL_A_35B_ADDR       (IRI_FT_REG_BASE_ADDR+0x0C)
#define  IRI_FT_REG_RX_SCALE_35B_ADDR        (IRI_FT_REG_BASE_ADDR+0x14)
#define  IRI_FT_REG_TX_SCALE_35B_ADDR        (IRI_FT_REG_BASE_ADDR+0x18)

#define  IRI_FT_REG_STATUS_ADDR           (IRI_FT_REG_BASE_ADDR+0x10)
#define  IRI_FT_REG_TX_PARR_PARAM_ADDR    (IRI_FT_REG_BASE_ADDR+0x1C)
#define  IRI_FT_REG_TX_PARR_MAX0_ADDR     (IRI_FT_REG_BASE_ADDR+0x20)
#define  IRI_FT_REG_TX_PARR_MAX1_ADDR     (IRI_FT_REG_BASE_ADDR+0x24)
#define  IRI_FT_REG_TX_PARR_MAX2_ADDR     (IRI_FT_REG_BASE_ADDR+0x28)


//==============================================================================
// Iridia-FT Sizes and Masks
//==============================================================================

// Sizes for Iridia-FT RAM block
#define  IRI_FT_RAM_TX_PAR_PVEC_SIZE            (8192*4)
// Offsets for Iridia-FT RAM block

#define  IRI_FT_RAM_TX_PAR_PVEC_OFFSET       (0)

// Iridia-FT RAM Masks

#define  IRI_FT_RAM_TX_PAR_PVEC_MASK            (0xFFFFFFFF)

// Iridia-FT Register Masks
#define  IRI_FT_REG_CTRL_MASK             (0x0000771F) // Not sure????
#define  IRI_FT_REG_STATUS_MASK              (0x0000003F) // Should be 0x0000000F

#define  IRI_FT_REG_RX_SCALE_MASK            (0x0000FFFF)
#define  IRI_FT_REG_TX_SCALE_MASK            (0x0000FFFF)

#define  IRI_FT_REG_TX_PARR_PARAM_MASK       (0xFFFF8733)
#define  IRI_FT_REG_TX_PARR_MAX0_MASK        (0xFFFFFFFF)
#define  IRI_FT_REG_TX_PARR_MAX1_MASK        (0xFFFFFFFF)
#define  IRI_FT_REG_TX_PARR_MAX2_MASK        (0x0000FFFF)


//==============================================================================
// Iridia-FT DSP interface register bit field masks
//==============================================================================

// Iridia-FT Tx register bit field masks
#define  IRI_FT_REG_TX_IFFT_SIZE_MASK           (0x0000E000)  // Should be 0x00000038
#define  IRI_FT_REG_TX_IFFT_PRE_PROC_MASK       (0x00000004)  // Should be 0x00000002
#define  IRI_FT_REG_TX_STR_BUF_STAT_MASK           (0x00000030)  // ??
#define  IRI_FT_REG_TX_IFFT_IN_BUF_STAT_MASK       (0x0000000C)  // ??
#define  IRI_FT_REG_TX_IFFT_OUT_BUF_STAT_MASK      (0x00000003)  // ??

// Iridia-FT Rx register bit field masks
#define  IRI_FT_REG_RX_FFT_SIZE_MASK               (0x00000070)  // Should be 0x0000001C
#define  IRI_FT_REG_RX_FFT_POST_PROC_MASK       (0x00000004)  // Should be 0x00000002
#define  IRI_FT_REG_RX_STR_BUF_STAT_MASK           (0x00000030)  // ??
#define  IRI_FT_REG_RX_FFT_IN_BUF_STAT_MASK        (0x0000000C)  // ??
#define  IRI_FT_REG_RX_FFT_OUT_BUF_STAT_MASK       (0x00000003)  // ??


#define  IRI_FT_REG_RX_CTRL_A_ADDR        (IRI_FT_REG_RX_CTRL_A_35B_ADDR)
#define  IRI_FT_REG_TX_CTRL_ADDR          (IRI_FT_REG_TX_CTRL_35B_ADDR)
#define  IRI_FT_REG_TX_CTRL_A_ADDR        (IRI_FT_REG_TX_CTRL_A_35B_ADDR)
#define  IRI_FT_REG_RX_SCALE_ADDR         (IRI_FT_REG_RX_SCALE_35B_ADDR)
#define  IRI_FT_REG_TX_SCALE_ADDR         (IRI_FT_REG_TX_SCALE_35B_ADDR)

#endif // _FT_MEMMAP_H
