/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2007 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ftb_memmap.h
*
*   This file contains Iridia-FTB BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FTB_MEMMAP_H
#define _FTB_MEMMAP_H

//==============================================================================
// Iridia-FTB Memory Map
//==============================================================================

#define IRI_FTB_RAM_BASE_ADDR             (0x310000)

#define IRI_FTB_IFFT_RAM_A_ADDR           (IRI_FTB_RAM_BASE_ADDR+0x0000)
#define IRI_FTB_IFFT_RAM_B_ADDR           (IRI_FTB_RAM_BASE_ADDR+0x8000)
#define IRI_FTB_IFFT_RAM_C_ADDR           (IRI_FTB_RAM_BASE_ADDR+0x10000)
#define IRI_FTB_FFT_RAM_A_ADDR            (IRI_FTB_RAM_BASE_ADDR+0x18000)
#define IRI_FTB_FFT_RAM_B_ADDR            (IRI_FTB_RAM_BASE_ADDR+0x20000)
#define IRI_FTB_FFT_RAM_C_ADDR            (IRI_FTB_RAM_BASE_ADDR+0x28000)

//==============================================================================
// Iridia-FTB Register Map
//==============================================================================
#define  IRI_FTB_REG_BASE_ADDR               (0x30D200)

// Global Registers
#define  IRI_FTB_CTRL_35B_ADDR               (IRI_FTB_REG_BASE_ADDR+0x00)
#define  IRI_FTB_IFFT_TSIZE_35B_ADDR            (IRI_FTB_REG_BASE_ADDR+0x04)

#define IRI_FTB_RX_STATUS_ADDR            (IRI_FTB_REG_BASE_ADDR+0x08)
#define IRI_FTB_TX_STATUS_ADDR            (IRI_FTB_REG_BASE_ADDR+0x0C)
#define IRI_FTB_FFT_START_ADDR            (IRI_FTB_REG_BASE_ADDR+0x10)  // Not in spec


//==============================================================================
// Iridia-FTB Sizes and Masks
//==============================================================================

// Sizes for Iridia-FTB RAM block IN bytes
#define  IRI_FTB_IFFT_RAM_A_SIZE                   (8192*4)
#define  IRI_FTB_IFFT_RAM_B_SIZE                   (8192*4)
#define  IRI_FTB_IFFT_RAM_C_SIZE                      (8192*4)

#define  IRI_FTB_FFT_RAM_A_SIZE                    (8192*4)
#define  IRI_FTB_FFT_RAM_B_SIZE                    (8192*4)
#define  IRI_FTB_FFT_RAM_C_SIZE                    (8192*4)

// Offsets for Iridia-FTB RAM block

#define  IRI_FTB_IFFT_RAM_A_OFFSET           (0)
#define  IRI_FTB_IFFT_RAM_B_OFFSET           (0)
#define  IRI_FTB_IFFT_RAM_C_OFFSET           (0)
#define  IRI_FTB_FFT_RAM_A_OFFSET               (0)
#define  IRI_FTB_FFT_RAM_B_OFFSET               (0)
#define  IRI_FTB_FFT_RAM_C_OFFSET            (0)

// Iridia-FTB RAM Masks

#define  IRI_FTB_IFFT_RAM_A_MASK          (0xFFFFFFFF)
#define  IRI_FTB_IFFT_RAM_B_MASK          (0xFFFFFFFF)
#define  IRI_FTB_IFFT_RAM_C_MASK          (0xFFFFFFFF)
#define  IRI_FTB_FFT_RAM_A_MASK           (0xFFFFFFFF)
#define  IRI_FTB_FFT_RAM_B_MASK           (0xFFFFFFFF)
#define  IRI_FTB_FFT_RAM_C_MASK           (0xFFFFFFFF)

// Iridia-FTB Register Masks

#define  IRI_FTB_CTRL_35B_MASK               (0x00009FFF)  // Should be (0x00038FFF)
#define  IRI_FTB_IFFT_TSIZE_35B_MASK            (0x00007777)

#define IRI_FTB_RX_STATUS_MASK            (0x000001FF)
#define IRI_FTB_TX_STATUS_MASK            (0x000001FF)
#define IRI_FTB_FFT_START_MASK            (0x00001FFF)    // Not in Spec


#define  IRI_FTB_REG_TX_STR_BUF_STAT_MASK          (0x000000C0)
#define  IRI_FTB_REG_TX_IFFT_BUF_STAT_MASK         (0x00000018)
#define  IRI_FTB_REG_TX_QT_BUF_STAT_MASK     (0x00000003)

#define  IRI_FTB_REG_RX_STR_BUF_STAT_MASK          (0x000000C0)
#define  IRI_FTB_REG_RX_FFT_BUF_STAT_MASK       (0x00000018)
#define  IRI_FTB_REG_RX_QT_BUF_STAT_MASK        (0x00000003)

//For VRX518, the registers FTB_CTRL and FTB_IFFT_TSIZE, new fields added. Earlier bit fields till remains same.
#define  IRI_FTB_CTRL_ADDR             (IRI_FTB_CTRL_35B_ADDR)
#define  IRI_FTB_IFFT_TSIZE_ADDR          (IRI_FTB_IFFT_TSIZE_35B_ADDR)


#define REG_COUNT 5                    // Should be 4
#define MAX_NUM_CHANNELS 4

#endif // _QT_MEMMAP_H
