/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_memmap.h
*
*   This file contains Iridia-QT BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QT_MEMMAP_H
#define _QT_MEMMAP_H

//==============================================================================
// Iridia-QT Memory Map
//==============================================================================
#define IRI_QT_RAM_BASE_ADDR              (0x350000)

#define IRI_QT_RAM_ACTIVE_BGTN_ADDR                (IRI_QT_RAM_BASE_ADDR+0x0000)
#define IRI_QT_RAM_TX_ACTIVE_EGT_ADDR              (IRI_QT_RAM_BASE_ADDR+0x10000)
#define IRI_QT_RAM_FDQ_MANT_ADDR                (IRI_QT_RAM_BASE_ADDR+0x18000)
#define IRI_QT_RAM_FDQ_EXP_ADDR                    (IRI_QT_RAM_BASE_ADDR+0x20000)
#define IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ADDR       (IRI_QT_RAM_BASE_ADDR+0x30000)
#define IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ADDR       (IRI_QT_RAM_BASE_ADDR+0x30100)
#define IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ADDR           (IRI_QT_RAM_BASE_ADDR+0x30200)
#define IRI_QT_RAM_RX_XY_DECISION_ADDR             (IRI_QT_RAM_BASE_ADDR+0x30800)
#define IRI_QT_RAM_RX_SURVIVOR_PATH_ADDR           (IRI_QT_RAM_BASE_ADDR+0x31000)
#define IRI_QT_RAM_RX_NOISY_POINT_SPAD_ADDR           (IRI_QT_RAM_BASE_ADDR+0x31200)
#define IRI_QT_RAM_RX_VITERBI_DECISION_ADDR           (IRI_QT_RAM_BASE_ADDR+0x31400)
#define IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ADDR            (IRI_QT_RAM_BASE_ADDR+0x32000)
#define IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ADDR            (IRI_QT_RAM_BASE_ADDR+0x34000)
#define IRI_QT_RAM_TX_PRAM_ADDR                    (IRI_QT_RAM_BASE_ADDR+0x36000)
#define IRI_QT_RAM_RX_PRAM_ADDR                    (IRI_QT_RAM_BASE_ADDR+0x36400)
#define IRI_QT_RAM_RX_FEEDBACK_TONE_ADDR           (IRI_QT_RAM_BASE_ADDR+0x36500)
#define IRI_QT_RAM_RX_FINAL_DECISION_ADDR          (IRI_QT_RAM_BASE_ADDR+0x36600)
#define IRI_QT_RAM_RX_FDQASPL_ADDR                 (IRI_QT_RAM_BASE_ADDR+0x31800)
#define IRI_QT_RAM_RX_FDQASPH_ADDR                 (IRI_QT_RAM_BASE_ADDR+0x31500)



//==============================================================================
// Iridia-QT Register Map
//==============================================================================
#define  IRI_QT_REG_BASE_ADDR             (0x30CA00)
// Global Registers  -29


#define IRI_QT_REG_TX_ENABLE_ADDR         (IRI_QT_REG_BASE_ADDR+0x00)


#define IRI_QT_REG_RX_ENABLE_ADDR         (IRI_QT_REG_BASE_ADDR+0x04)
#define IRI_QT_REG_RX_NSC_35B_ADDR           (IRI_QT_REG_BASE_ADDR+0x08)

#define  IRI_QT_REG_RX_LUT_CTRL_ADDR         (-1)
#define  IRI_QT_REG_RX_DMULT0_ADDR        (-1)
#define  IRI_QT_REG_RX_DMULT1_ADDR        (-1)
#define  IRI_QT_REG_RX_DMULT2_ADDR        (-1)
#define  IRI_QT_REG_RX_DMULT3_ADDR        (-1)
#define  IRI_QT_REG_RX_PLUT6_0_ADDR       (-1)
#define  IRI_QT_REG_RX_PLUT6_1_ADDR       (-1)
#define  IRI_QT_REG_RX_PLUT5_0_ADDR       (-1)
#define  IRI_QT_REG_RX_PLUT5_1_ADDR       (-1)
#define  IRI_QT_REG_RX_LUT_ERR_ADDR       (-1)

#define  IRI_QT_REG_RX_PRBS_CTRL_ADDR     (IRI_QT_REG_BASE_ADDR+0x0C)
#define  IRI_QT_REG_RX_PRBS0_ADDR         (IRI_QT_REG_BASE_ADDR+0x10)
#define  IRI_QT_REG_RX_PRBS1_ADDR         (IRI_QT_REG_BASE_ADDR+0x14)

#define  IRI_QT_REG_ABGT_OFFSET_35B_ADDR        (IRI_QT_REG_BASE_ADDR+0x18)

//Qtxpram Registers    -49

#define  IRI_QT_TXPRAM_ADDR               (IRI_QT_RAM_TX_PRAM_ADDR)

#define IRI_QT_REG_TX_CNFG_35B_ADDR       (IRI_QT_TXPRAM_ADDR+0x00)
#define  IRI_QT_REG_TX_TCM_CTRL_35B_ADDR     (IRI_QT_TXPRAM_ADDR+0x04)
#define  IRI_QT_REG_TX_ACTIVE_35B_ADDR    (IRI_QT_TXPRAM_ADDR+0x0C)
#define  IRI_QT_REG_TX_LP0_BITS_35B_ADDR     (IRI_QT_TXPRAM_ADDR+0x10)
#define  IRI_QT_REG_TX_LP1_BITS_35B_ADDR     (IRI_QT_TXPRAM_ADDR+0x14)
#define  IRI_QT_REG_TX_LP2_BITS_35B_ADDR     (IRI_QT_TXPRAM_ADDR+0x18)
#define  IRI_QT_REG_TX_PTINDEX_35B_ADDR      (IRI_QT_TXPRAM_ADDR+0x30)

#define  IRI_QT_REG_TX_MISC_ADDR       (IRI_QT_TXPRAM_ADDR+0x08)
#define  IRI_QT_REG_TX_DUMMY_ADDR      (IRI_QT_TXPRAM_ADDR+0x1C)
#define  IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR     (IRI_QT_TXPRAM_ADDR+0x20)
#define  IRI_QT_REG_TX_LP1_BIT_FIFO_ADDR     (IRI_QT_TXPRAM_ADDR+0x24)
#define  IRI_QT_REG_TX_LP2_BIT_FIFO_ADDR     (IRI_QT_TXPRAM_ADDR+0x28)

#define  IRI_QT_REG_TX_PILOT_ADDR      (IRI_QT_TXPRAM_ADDR+0x2C)
#define  IRI_QT_REG_TX_PRBS_ADDR       (IRI_QT_TXPRAM_ADDR+0x34)
#define  IRI_QT_REG_TX_PRBS_MISC_ADDR     (IRI_QT_TXPRAM_ADDR+0x38)
#define  IRI_QT_REG_TX_PRBS_POLY_ADDR     (IRI_QT_TXPRAM_ADDR+0x3C)

#define  IRI_QT_REG_TX_PRBS_DATA0_ADDR    (IRI_QT_TXPRAM_ADDR+0x40)
#define  IRI_QT_REG_TX_PRBS_DATA1_ADDR    (IRI_QT_TXPRAM_ADDR+0x44)
#define  IRI_QT_REG_TX_PRBS_DATA2_ADDR    (IRI_QT_TXPRAM_ADDR+0x48)
#define  IRI_QT_REG_TX_PRBS_DATA3_ADDR    (IRI_QT_TXPRAM_ADDR+0x4C)
#define  IRI_QT_REG_TX_PRBS_DATA4_ADDR    (IRI_QT_TXPRAM_ADDR+0x50)
#define  IRI_QT_REG_TX_PRBS_DATA5_ADDR    (IRI_QT_TXPRAM_ADDR+0x54)
#define  IRI_QT_REG_TX_PRBS_DATA6_ADDR    (IRI_QT_TXPRAM_ADDR+0x58)
#define  IRI_QT_REG_TX_PRBS_DATA7_ADDR    (IRI_QT_TXPRAM_ADDR+0x5C)
#define  IRI_QT_REG_TX_REF_GAIN_ADDR      (IRI_QT_TXPRAM_ADDR+0x60)
#define  IRI_QT_REG_TX_NYQ_TONE_DATA_ADDR (IRI_QT_TXPRAM_ADDR+0x64)

#define IRI_QT_REG_TX_CG0_ADDR         (IRI_QT_TXPRAM_ADDR+0x68)
#define IRI_QT_REG_TX_CG1_ADDR         (IRI_QT_TXPRAM_ADDR+0x6C)
#define IRI_QT_REG_TX_CG2_ADDR         (IRI_QT_TXPRAM_ADDR+0x70)
#define IRI_QT_REG_TX_CG3_ADDR         (IRI_QT_TXPRAM_ADDR+0x74)
#define IRI_QT_REG_TX_CG4_ADDR         (IRI_QT_TXPRAM_ADDR+0x78)
#define IRI_QT_REG_TX_CG5_ADDR         (IRI_QT_TXPRAM_ADDR+0x7C)
#define IRI_QT_REG_TX_CG6_ADDR         (IRI_QT_TXPRAM_ADDR+0x80)
#define IRI_QT_REG_TX_CG7_ADDR         (IRI_QT_TXPRAM_ADDR+0x84)
#define IRI_QT_REG_TX_CG8_ADDR         (IRI_QT_TXPRAM_ADDR+0x88)
#define IRI_QT_REG_TX_CG9_ADDR         (IRI_QT_TXPRAM_ADDR+0x8C)
#define IRI_QT_REG_TX_CG10_ADDR        (IRI_QT_TXPRAM_ADDR+0x90)
#define IRI_QT_REG_TX_CG11_ADDR        (IRI_QT_TXPRAM_ADDR+0x94)
#define IRI_QT_REG_TX_CG12_ADDR        (IRI_QT_TXPRAM_ADDR+0x98)
#define IRI_QT_REG_TX_CG13_ADDR        (IRI_QT_TXPRAM_ADDR+0x9C)
#define IRI_QT_REG_TX_CG14_ADDR        (IRI_QT_TXPRAM_ADDR+0xA0)
#define IRI_QT_REG_TX_CG15_ADDR        (IRI_QT_TXPRAM_ADDR+0xA4)

#define IRI_QT_REG_TX_IFFTZ_RNG0_35B_ADDR    (IRI_QT_TXPRAM_ADDR+0xA8)
#define IRI_QT_REG_TX_IFFTZ_RNG1_35B_ADDR    (IRI_QT_TXPRAM_ADDR+0xAC)
#define IRI_QT_REG_TX_IFFTZ_RNG2_35B_ADDR    (IRI_QT_TXPRAM_ADDR+0xB0)
#define IRI_QT_REG_TX_IFFTZ_RNG3_35B_ADDR    (IRI_QT_TXPRAM_ADDR+0xB4)
#define IRI_QT_REG_TX_IFFTZ_RNG4_35B_ADDR    (IRI_QT_TXPRAM_ADDR+0xB8)
#define IRI_QT_REG_TX_IFFTZ_RNG5_35B_ADDR    (IRI_QT_TXPRAM_ADDR+0xBC)
#define IRI_QT_REG_TX_DCI_CTRL_35B_ADDR      (IRI_QT_TXPRAM_ADDR+0xC4)

#define IRI_QT_REG_TX_TONEZERO_ADDR       (IRI_QT_TXPRAM_ADDR+0xC0)

//Qrxpram Registers    -49
#define  IRI_QT_RXPRAM_ADDR               (IRI_QT_RAM_RX_PRAM_ADDR)
#define  IRI_QT_REG_RX_CNFG_35B_ADDR      (IRI_QT_RXPRAM_ADDR+0x00)
#define  IRI_QT_REG_RX_TCM_CTRL_35B_ADDR  (IRI_QT_RXPRAM_ADDR+0x04)
#define  IRI_QT_REG_RX_ACTIVE_35B_ADDR    (IRI_QT_RXPRAM_ADDR+0x0C)
#define  IRI_QT_REG_RX_LP0_BITS_35B_ADDR  (IRI_QT_RXPRAM_ADDR+0x10)
#define  IRI_QT_REG_RX_LP1_BITS_35B_ADDR  (IRI_QT_RXPRAM_ADDR+0x14)
#define  IRI_QT_REG_RX_LP2_BITS_35B_ADDR  (IRI_QT_RXPRAM_ADDR+0x18)

#define  IRI_QT_REG_RX_MISC_ADDR          (IRI_QT_RXPRAM_ADDR+0x08)
#define  IRI_QT_REG_RX_DUMMY_ADDR         (IRI_QT_RXPRAM_ADDR+0x1C)

#define  IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR  (IRI_QT_RXPRAM_ADDR+0x20)
#define  IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR  (IRI_QT_RXPRAM_ADDR+0x24)
#define  IRI_QT_REG_RX_LP2_BIT_FIFO_ADDR  (IRI_QT_RXPRAM_ADDR+0x28)

#define  IRI_QT_REG_RX_DPRBS_MISC_ADDR    (IRI_QT_RXPRAM_ADDR+0x2C)
#define  IRI_QT_REG_RX_DPRBS_POLY_ADDR    (IRI_QT_RXPRAM_ADDR+0x30)
#define  IRI_QT_REG_RX_FD_RNG0_35B_ADDR         (IRI_QT_RXPRAM_ADDR+0x34)
#define  IRI_QT_REG_RX_FD_RNG1_35B_ADDR         (IRI_QT_RXPRAM_ADDR+0x38)
#define  IRI_QT_REG_RX_FD_RNG1_BASE_35B_ADDR    (IRI_QT_RXPRAM_ADDR+0x3C)
#define  IRI_QT_REG_RX_NPR_IIBRAM_35B_ADDR      (IRI_QT_RXPRAM_ADDR+0x40)
#define  IRI_QT_REG_RX_QUAD0_ADDR         (IRI_QT_RXPRAM_ADDR+0x44)
#define  IRI_QT_REG_RX_QUAD1_ADDR         (IRI_QT_RXPRAM_ADDR+0x48)

#define  IRI_QT_REG_RX_SLOWDOWN_ADDR      (IRI_QT_RXPRAM_ADDR+0x4C)
#define  IRI_QT_REG_RX_PTINDEX_ADDR       (IRI_QT_RXPRAM_ADDR+0x50)
#define  IRI_QT_REG_RX_PILOT_ADDR         (IRI_QT_RXPRAM_ADDR+0x54)

#define  IRI_QT_REG_RX_FDQADAPT_ADDR      (IRI_QT_RXPRAM_ADDR+0x58)

#define  IRI_QT_REG_RX_VECPOW_L_ADDR      (IRI_QT_RXPRAM_ADDR+0x5C)
#define  IRI_QT_REG_RX_VECPOW_H_ADDR      (IRI_QT_RXPRAM_ADDR+0x60)

#define  IRI_QT_REG_RX_RMETRIC_CTL_ADDR   (IRI_QT_RXPRAM_ADDR+0x64)
#define  IRI_QT_REG_RX_RMETRIC_VAL_ADDR   (IRI_QT_RXPRAM_ADDR+0x68)

#define  IRI_QT_REG_RX_CG0_ADDR           (IRI_QT_RXPRAM_ADDR+0x6C)
#define  IRI_QT_REG_RX_CG1_ADDR           (IRI_QT_RXPRAM_ADDR+0x70)
#define  IRI_QT_REG_RX_CG2_ADDR           (IRI_QT_RXPRAM_ADDR+0x74)
#define  IRI_QT_REG_RX_CG3_ADDR           (IRI_QT_RXPRAM_ADDR+0x78)
#define  IRI_QT_REG_RX_CG4_ADDR           (IRI_QT_RXPRAM_ADDR+0x7C)
#define  IRI_QT_REG_RX_CG5_ADDR           (IRI_QT_RXPRAM_ADDR+0x80)
#define  IRI_QT_REG_RX_CG6_ADDR           (IRI_QT_RXPRAM_ADDR+0x84)
#define  IRI_QT_REG_RX_CG7_ADDR           (IRI_QT_RXPRAM_ADDR+0x88)
#define  IRI_QT_REG_RX_CG8_ADDR           (IRI_QT_RXPRAM_ADDR+0x8C)
#define  IRI_QT_REG_RX_CG9_ADDR           (IRI_QT_RXPRAM_ADDR+0x90)
#define  IRI_QT_REG_RX_CG10_ADDR          (IRI_QT_RXPRAM_ADDR+0x94)
#define  IRI_QT_REG_RX_CG11_ADDR          (IRI_QT_RXPRAM_ADDR+0x98)
#define  IRI_QT_REG_RX_CG12_ADDR          (IRI_QT_RXPRAM_ADDR+0x9C)
#define  IRI_QT_REG_RX_CG13_ADDR          (IRI_QT_RXPRAM_ADDR+0xA0)
#define  IRI_QT_REG_RX_CG14_ADDR          (IRI_QT_RXPRAM_ADDR+0xA4)
#define  IRI_QT_REG_RX_CG15_ADDR          (IRI_QT_RXPRAM_ADDR+0xA8)
#define  IRI_QT_REG_RX_PTINDEX1_ADDR      (IRI_QT_RXPRAM_ADDR+0xAC)
#define  IRI_QT_REG_RX_PILOT1_ADDR        (IRI_QT_RXPRAM_ADDR+0xB0)
#define  IRI_QT_REG_RX_PTINDEX2_ADDR      (IRI_QT_RXPRAM_ADDR+0xB4)
#define  IRI_QT_REG_RX_PILOT2_ADDR        (IRI_QT_RXPRAM_ADDR+0xB8)

#define  IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR (IRI_QT_RXPRAM_ADDR+0xBC)
#define  IRI_QT_REG_RX_FD_RNG1_CNT_35B_ADDR (IRI_QT_RXPRAM_ADDR+0xC0)
//==============================================================================
// Iridia-QT Sizes and Masks
//==============================================================================


// Sizes for Iridia-QT RAM block IN bytes
#define  IRI_QT_RAM_ACTIVE_BGTN_SIZE            ((8192+512)*4)
#define  IRI_QT_RAM_TX_ACTIVE_EGT_SIZE          ((8192+512)*2)
//Hak Keong confirmed that HW support to use bigger size ((8192 + 512)*4) for Active table in VRX518,
//So removed the restriction of using smaller size(8192) * 4) for active tables
#define  IRI_QT_RAM_FDQ_MANT_SIZE               (8192*4)
#define  IRI_QT_RAM_FDQ_EXP_SIZE                (8192*4)

#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_SIZE      (64*4)
#define  IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_SIZE      (64*4)
#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_SIZE       (64*4)
#define  IRI_QT_RAM_RX_XY_DECISION_SIZE            (320*4)

// modified after discussion with Li, registers not replicated for each port
#define  IRI_QT_RAM_RX_SURVIVOR_PATH_SIZE       (384)
#define  IRI_QT_RAM_RX_NOISY_POINT_SPAD_SIZE       (384)
#define  IRI_QT_RAM_RX_VITERBI_DECISION_SIZE       (192)
// end of modification

#define IRI_QT_RAM_RX_NOISE_ACCMR_LSW_SIZE            (2048*4)
#define IRI_QT_RAM_RX_NOISE_ACCMR_MSW_SIZE            (2048*4)
#define IRI_QT_RAM_RX_FEEDBACK_TONE_SIZE        (64*4)
#define  IRI_QT_RAM_RX_FINAL_DECISION_SIZE         (128*4)
#define  IRI_QT_RAM_RX_FDQASPL_SIZE       (768*4)   // Should be 192*4
#define  IRI_QT_RAM_RX_FDQASPH_SIZE       (96*4)    // Should be 24*4



// Offsets for Iridia-QT RAM block


#define  IRI_QT_RAM_ACTIVE_BGTN_OFFSET          (0)
#define  IRI_QT_RAM_TX_ACTIVE_EGT_OFFSET           (0)

#define  IRI_QT_RAM_FDQ_MANT_OFFSET             (0)
#define  IRI_QT_RAM_FDQ_EXP_OFFSET              (0)

#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_OFFSET       (0)
#define  IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_OFFSET       (0)
#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_OFFSET        (0)
#define  IRI_QT_RAM_RX_XY_DECISION_OFFSET          (0)
#define  IRI_QT_RAM_RX_SURVIVOR_PATH_OFFSET           (0)
#define  IRI_QT_RAM_RX_NOISY_POINT_SPAD_OFFSET        (0)
#define  IRI_QT_RAM_RX_VITERBI_DECISION_OFFSET        (0)

#define IRI_QT_RAM_RX_NOISE_ACCMR_LSW_OFFSET          (0)
#define IRI_QT_RAM_RX_NOISE_ACCMR_MSW_OFFSET          (0)

#define  IRI_QT_RAM_RX_FEEDBACK_TONE_OFFSET           (0)


#define  IRI_QT_RAM_RX_FINAL_DECISION_OFFSET          (0)
#define  IRI_QT_RAM_RX_FDQASPL_OFFSET           (0)
#define  IRI_QT_RAM_RX_FDQASPH_OFFSET           (0)



// Iridia-QT RAM Masks


#define  IRI_QT_RAM_ACTIVE_BGTN_MASK               (0xFFFFFFFF)
#define  IRI_QT_RAM_TX_ACTIVE_EGT_MASK          (0xFFFFFFFF)

#define  IRI_QT_RAM_FDQ_MANT_MASK                  (0xFFFFFFFF)
#define  IRI_QT_RAM_FDQ_EXP_MASK                (0xFFFFFFFF)

#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_MASK      (0xFFFFFFFF)
#define  IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_MASK      (0xFFFFFFFF)
#define  IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_MASK       (0x0000000F)
#define  IRI_QT_RAM_RX_XY_DECISION_MASK            (0xFFFFFFFF)
#define  IRI_QT_RAM_RX_SURVIVOR_PATH_MASK       (0x0000FFFF)
#define  IRI_QT_RAM_RX_NOISY_POINT_SPAD_MASK       (0xFFFFFFFF)
#define  IRI_QT_RAM_RX_VITERBI_DECISION_MASK       (0xFFFFFFFF)
#define IRI_QT_RAM_RX_NOISE_ACCMR_LSW_MASK            (0xFFFFFFFF)
#define IRI_QT_RAM_RX_NOISE_ACCMR_MSW_MASK            (0x0000FFFF)
#define IRI_QT_RAM_RX_FDQASPL_MASK           (0xFFFFFFFF)
#define IRI_QT_RAM_RX_FDQASPH_MASK           (0x0000007F)


#define  IRI_QT_RAM_RX_FEEDBACK_TONE_MASK       (0xFFFFFFFF) //(0x0FFF0FFF)
#define  IRI_QT_RAM_RX_FINAL_DECISION_MASK         (0xFFFFFFFF)//(0xFF00FF00)




// Iridia-QT Register Masks Starting From (0x20CA00)



#define IRI_QT_REG_TX_ENABLE_MASK            (0x00000001)

#define IRI_QT_REG_RX_ENABLE_MASK            (0x00000001)
#define IRI_QT_REG_RX_NSC_35B_MASK              (0x0000000F)
#define  IRI_QT_REG_ABGT_OFFSET_35B_MASK        (0xFFFFFFFF)   // Should be (0x1FFF1FFF)
#define  IRI_QT_REG_RX_LUT_CTRL_MASK            (0x00000003)
#define  IRI_QT_REG_RX_DMULT0_MASK           (0x0F0F0F0F)
#define  IRI_QT_REG_RX_DMULT1_MASK           (0x0F0F0F0F)
#define  IRI_QT_REG_RX_DMULT2_MASK           (0x0F0F0F0F)
#define  IRI_QT_REG_RX_DMULT3_MASK           (0x0F0F0F0F)
#define  IRI_QT_REG_RX_PLUT6_0_MASK          (0x3F3F3F3F)
#define  IRI_QT_REG_RX_PLUT6_1_MASK          (0x3F3F3F3F)
#define  IRI_QT_REG_RX_PLUT5_0_MASK          (0x1F1F1F1F)
#define  IRI_QT_REG_RX_PLUT5_1_MASK          (0x1F1F1F1F)
#define  IRI_QT_REG_RX_LUT_ERR_MASK          (0x3FFFFFFF)


#define  IRI_QT_REG_RX_PRBS_CTRL_MASK     (0x00000003)
#define  IRI_QT_REG_RX_PRBS0_MASK      (0xFFFFFFFF)
#define  IRI_QT_REG_RX_PRBS1_MASK         (0xFFFFFFFF)


//Qtxpram Registers    -41    Starting From (0x2C2000)

#define  IRI_QT_REG_TX_CNFG_35B_MASK               (0x000000FF)
#define  IRI_QT_REG_TX_TCM_CTRL_35B_MASK           (0x03FFFFFF)
#define  IRI_QT_REG_TX_ACTIVE_ADDR_35B_MASK           (0x1FFF1FFF)
#define  IRI_QT_REG_TX_LP0_BITS_35B_MASK           (0x0001FFFF)
#define  IRI_QT_REG_TX_LP1_BITS_35B_MASK           (0x0001FFFF)
#define  IRI_QT_REG_TX_LP2_BITS_35B_MASK           (0x0001FFFF)
#define  IRI_QT_REG_TX_PTINDEX_35B_MASK            (0x0000FFFF)


#define  IRI_QT_REG_TX_MISC_MASK             (0x00FFFFF0)
#define  IRI_QT_REG_TX_DUMMY_MASK            (0x0000FFFF)
#define  IRI_QT_REG_TX_LP0_BIT_FIFO_MASK              (0x000007FF)
#define  IRI_QT_REG_TX_LP1_BIT_FIFO_MASK              (0x000007FF)
#define  IRI_QT_REG_TX_LP2_BIT_FIFO_MASK              (0x000007FF)

#define  IRI_QT_REG_TX_PILOT_MASK            (0xFFFFFFFF)

#define  IRI_QT_REG_TX_PRBS_MASK             (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_MISC_MASK        (0xFFFFFFF8)
#define  IRI_QT_REG_TX_PRBS_POLY_MASK        (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_DATA0_MASK       (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_DATA1_MASK       (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_DATA2_MASK       (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_DATA3_MASK       (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_DATA4_MASK       (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_DATA5_MASK       (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_DATA6_MASK       (0xFFFFFFFF)
#define  IRI_QT_REG_TX_PRBS_DATA7_MASK       (0xFFFFFFFF)

#define  IRI_QT_REG_TX_REF_GAIN_MASK            (0x00007FFF)
#define  IRI_QT_REG_TX_NYQ_TONE_DATA_MASK (0xFFFFFFFF)


#define IRI_QT_REG_TX_CG0_MASK            (0x0007FFFF)
#define IRI_QT_REG_TX_CG1_MASK            (0x0007FFFF)
#define IRI_QT_REG_TX_CG2_MASK            (0x0007FFFF)
#define IRI_QT_REG_TX_CG3_MASK            (0x0007FFFF)
#define IRI_QT_REG_TX_CG4_MASK            (0x0007FFFF)
#define IRI_QT_REG_TX_CG5_MASK            (0x0007FFFF)
#define IRI_QT_REG_TX_CG6_MASK            (0x0007FFFF)
#define IRI_QT_REG_TX_CG7_MASK            (0x0007FFFF)
#define IRI_QT_REG_TX_CG8_MASK            (0x0007FFFF)
#define IRI_QT_REG_TX_CG9_MASK            (0x0007FFFF)
#define IRI_QT_REG_TX_CG10_MASK           (0x0007FFFF)
#define IRI_QT_REG_TX_CG11_MASK           (0x0007FFFF)
#define IRI_QT_REG_TX_CG12_MASK           (0x0007FFFF)
#define IRI_QT_REG_TX_CG13_MASK           (0x0007FFFF)
#define IRI_QT_REG_TX_CG14_MASK           (0x0007FFFF)
#define IRI_QT_REG_TX_CG15_MASK           (0x0007FFFF)
#define  IRI_QT_REG_TX_IFFTZ_RNG0_35B_MASK         (0x07FFFFFF)
#define  IRI_QT_REG_TX_IFFTZ_RNG1_35B_MASK         (0x07FFFFFF)
#define  IRI_QT_REG_TX_IFFTZ_RNG2_35B_MASK         (0x07FFFFFF)
#define  IRI_QT_REG_TX_IFFTZ_RNG3_35B_MASK         (0x07FFFFFF)
#define  IRI_QT_REG_TX_IFFTZ_RNG4_35B_MASK         (0x07FFFFFF)
#define  IRI_QT_REG_TX_IFFTZ_RNG5_35B_MASK         (0x07FFFFFF)
#define IRI_QT_REG_TX_DCI_CTRL_35B_MASK            (0x07FFFFFF)
#define IRI_QT_REG_TX_TONEZERO_MASK          (0xFFFFFFFF)

//Qrxpram Registers    -43 Starting From (0x252400)
#define  IRI_QT_REG_RX_CNFG_35B_MASK                  (0x00001FFF)
#define  IRI_QT_REG_RX_TCM_CTRL_35B_MASK              (0x03FFFFFF)
#define  IRI_QT_REG_RX_ACTIVE_ADDR_35B_MASK              (0x1FFF1FFF)
#define  IRI_QT_REG_RX_LP0_BITS_35B_MASK              (0x0001FFFF)
#define  IRI_QT_REG_RX_LP1_BITS_35B_MASK              (0x0001FFFF)
#define  IRI_QT_REG_RX_LP2_BITS_35B_MASK              (0x0001FFFF)

#define  IRI_QT_REG_RX_MISC_MASK                (0x7FEFFFE0)

#define  IRI_QT_REG_RX_DUMMY_MASK               (0x0000FFFF)
#define  IRI_QT_REG_RX_LP0_BIT_FIFO_MASK           (0x000007FF)
#define  IRI_QT_REG_RX_LP1_BIT_FIFO_MASK           (0x000007FF)
#define  IRI_QT_REG_RX_LP2_BIT_FIFO_MASK           (0x000007FF)

#define  IRI_QT_REG_RX_DPRBS_MISC_MASK          (0x00007FFF)
#define  IRI_QT_REG_RX_DPRBS_POLY_MASK          (0xFFFFFFFF)
#define  IRI_QT_REG_RX_FD_RNG0_35B_MASK                  (0xBF001FFF)
#define  IRI_QT_REG_RX_FD_RNG1_35B_MASK                  (0xBF001FFF)
#define  IRI_QT_REG_RX_FD_RNG1_BASE_35B_MASK                (0x00001FFF)
#define  IRI_QT_REG_RX_NPR_IIBRAM_35B_MASK                  (0x8001FFFF)
#define  IRI_QT_REG_RX_PTINDEX_35B_MASK               (0x00003FFF)

#define  IRI_QT_REG_RX_QUAD0_MASK                  (0xFFFFFFFF )
#define  IRI_QT_REG_RX_QUAD1_MASK                  (0xFFFFFFFF )

#define  IRI_QT_REG_RX_SLOWDOWN_MASK               (0x000000FF)
#define  IRI_QT_REG_RX_PILOT_MASK               (0xFFFFFFFF)

#define  IRI_QT_REG_RX_FDQADAPT_MASK               (0x000073FF)
#define  IRI_QT_REG_RX_VECPOW_L_MASK               (0xFFFFFFFF)
#define  IRI_QT_REG_RX_VECPOW_H_MASK               (0x000003FF)
#define  IRI_QT_REG_RX_RMETRIC_CTL_MASK            (0x0000001F)
#define  IRI_QT_REG_RX_RMETRIC_VAL_MASK            (0x000000FF)

#define  IRI_QT_REG_RX_FD_RNG0_CNT_35B_MASK                 (0x00001FFF)
#define  IRI_QT_REG_RX_FD_RNG1_CNT_35B_MASK                 (0x00001FFF)

#define IRI_QT_REG_RX_CG0_MASK            (0x0007FFFF)
#define IRI_QT_REG_RX_CG1_MASK            (0x0007FFFF)
#define IRI_QT_REG_RX_CG2_MASK            (0x0007FFFF)
#define IRI_QT_REG_RX_CG3_MASK            (0x0007FFFF)
#define IRI_QT_REG_RX_CG4_MASK            (0x0007FFFF)
#define IRI_QT_REG_RX_CG5_MASK            (0x0007FFFF)
#define IRI_QT_REG_RX_CG6_MASK            (0x0007FFFF)
#define IRI_QT_REG_RX_CG7_MASK            (0x0007FFFF)
#define IRI_QT_REG_RX_CG8_MASK            (0x0007FFFF)
#define IRI_QT_REG_RX_CG9_MASK            (0x0007FFFF)
#define IRI_QT_REG_RX_CG10_MASK           (0x0007FFFF)
#define IRI_QT_REG_RX_CG11_MASK           (0x0007FFFF)
#define IRI_QT_REG_RX_CG12_MASK           (0x0007FFFF)
#define IRI_QT_REG_RX_CG13_MASK           (0x0007FFFF)
#define IRI_QT_REG_RX_CG14_MASK           (0x0007FFFF)
#define IRI_QT_REG_RX_CG15_MASK           (0x0007FFFF)



//redefine in order to avoid changes on upper layers (address defines)
#define IRI_QT_REG_RX_NSC_ADDR              IRI_QT_REG_RX_NSC_35B_ADDR
#define IRI_QT_REG_ABGT_OFFSET_ADDR         IRI_QT_REG_ABGT_OFFSET_35B_ADDR
#define IRI_QT_REG_TX_CNFG_ADDR             IRI_QT_REG_TX_CNFG_35B_ADDR
#define IRI_QT_REG_TX_TCM_CTRL_ADDR         IRI_QT_REG_TX_TCM_CTRL_35B_ADDR
#define IRI_QT_REG_TX_ACTIVE_ADDR           IRI_QT_REG_TX_ACTIVE_35B_ADDR
#define IRI_QT_REG_TX_LP0_BITS_ADDR         IRI_QT_REG_TX_LP0_BITS_35B_ADDR
#define IRI_QT_REG_TX_LP1_BITS_ADDR         IRI_QT_REG_TX_LP1_BITS_35B_ADDR
#define IRI_QT_REG_TX_LP2_BITS_ADDR         IRI_QT_REG_TX_LP2_BITS_35B_ADDR
#define IRI_QT_REG_TX_PTINDEX_ADDR          IRI_QT_REG_TX_PTINDEX_35B_ADDR
#define IRI_QT_REG_TX_IFFTZ_RNG0_ADDR       IRI_QT_REG_TX_IFFTZ_RNG0_35B_ADDR
#define IRI_QT_REG_TX_IFFTZ_RNG1_ADDR       IRI_QT_REG_TX_IFFTZ_RNG1_35B_ADDR
#define IRI_QT_REG_TX_IFFTZ_RNG2_ADDR       IRI_QT_REG_TX_IFFTZ_RNG2_35B_ADDR
#define IRI_QT_REG_TX_IFFTZ_RNG3_ADDR       IRI_QT_REG_TX_IFFTZ_RNG3_35B_ADDR
#define IRI_QT_REG_TX_IFFTZ_RNG4_ADDR       IRI_QT_REG_TX_IFFTZ_RNG4_35B_ADDR
#define IRI_QT_REG_TX_IFFTZ_RNG5_ADDR       IRI_QT_REG_TX_IFFTZ_RNG5_35B_ADDR
#define IRI_QT_REG_TX_DCI_CTRL_ADDR         IRI_QT_REG_TX_DCI_CTRL_35B_ADDR
#define IRI_QT_REG_RX_CNFG_ADDR             IRI_QT_REG_RX_CNFG_35B_ADDR
#define IRI_QT_REG_RX_TCM_CTRL_ADDR         IRI_QT_REG_RX_TCM_CTRL_35B_ADDR
#define IRI_QT_REG_RX_ACTIVE_ADDR           IRI_QT_REG_RX_ACTIVE_35B_ADDR
#define IRI_QT_REG_RX_LP0_BITS_ADDR         IRI_QT_REG_RX_LP0_BITS_35B_ADDR
#define IRI_QT_REG_RX_LP1_BITS_ADDR         IRI_QT_REG_RX_LP1_BITS_35B_ADDR
#define IRI_QT_REG_RX_LP2_BITS_ADDR         IRI_QT_REG_RX_LP2_BITS_35B_ADDR
#define IRI_QT_REG_RX_FD_RNG0_ADDR          IRI_QT_REG_RX_FD_RNG0_35B_ADDR
#define IRI_QT_REG_RX_FD_RNG1_ADDR          IRI_QT_REG_RX_FD_RNG1_35B_ADDR
#define IRI_QT_REG_RX_FD_RNG1_BASE_ADDR     IRI_QT_REG_RX_FD_RNG1_BASE_35B_ADDR
#define IRI_QT_REG_RX_NPR_IIBRAM_ADDR       IRI_QT_REG_RX_NPR_IIBRAM_35B_ADDR

//redefine in order to avoid changes on upper layers (mask defines)
#define IRI_QT_REG_RX_NSC_MASK              IRI_QT_REG_RX_NSC_35B_MASK
#define IRI_QT_REG_ABGT_OFFSET_MASK         IRI_QT_REG_ABGT_OFFSET_35B_MASK
#define IRI_QT_REG_TX_CNFG_MASK             IRI_QT_REG_TX_CNFG_35B_MASK
#define IRI_QT_REG_TX_TCM_CTRL_MASK         IRI_QT_REG_TX_TCM_CTRL_35B_MASK
#define IRI_QT_REG_TX_ACTIVE_MASK           IRI_QT_REG_TX_ACTIVE_35B_MASK
#define IRI_QT_REG_TX_LP0_BITS_MASK         IRI_QT_REG_TX_LP0_BITS_35B_MASK
#define IRI_QT_REG_TX_LP1_BITS_MASK         IRI_QT_REG_TX_LP1_BITS_35B_MASK
#define IRI_QT_REG_TX_LP2_BITS_MASK         IRI_QT_REG_TX_LP2_BITS_35B_MASK
#define IRI_QT_REG_TX_PTINDEX_MASK          IRI_QT_REG_TX_PTINDEX_35B_MASK
#define IRI_QT_REG_TX_IFFTZ_RNG0_MASK       IRI_QT_REG_TX_IFFTZ_RNG0_35B_MASK
#define IRI_QT_REG_TX_IFFTZ_RNG1_MASK       IRI_QT_REG_TX_IFFTZ_RNG1_35B_MASK
#define IRI_QT_REG_TX_IFFTZ_RNG2_MASK       IRI_QT_REG_TX_IFFTZ_RNG2_35B_MASK
#define IRI_QT_REG_TX_IFFTZ_RNG3_MASK       IRI_QT_REG_TX_IFFTZ_RNG3_35B_MASK
#define IRI_QT_REG_TX_IFFTZ_RNG4_MASK       IRI_QT_REG_TX_IFFTZ_RNG4_35B_MASK
#define IRI_QT_REG_TX_IFFTZ_RNG5_MASK       IRI_QT_REG_TX_IFFTZ_RNG5_35B_MASK
#define IRI_QT_REG_TX_DCI_CTRL_MASK         IRI_QT_REG_TX_DCI_CTRL_35B_MASK
#define IRI_QT_REG_RX_CNFG_MASK             IRI_QT_REG_RX_CNFG_35B_MASK
#define IRI_QT_REG_RX_TCM_CTRL_MASK         IRI_QT_REG_RX_TCM_CTRL_35B_MASK
#define IRI_QT_REG_RX_ACTIVE_MASK           IRI_QT_REG_RX_ACTIVE_35B_MASK
#define IRI_QT_REG_RX_LP0_BITS_MASK         IRI_QT_REG_RX_LP0_BITS_35B_MASK
#define IRI_QT_REG_RX_LP1_BITS_MASK         IRI_QT_REG_RX_LP1_BITS_35B_MASK
#define IRI_QT_REG_RX_LP2_BITS_MASK         IRI_QT_REG_RX_LP2_BITS_35B_MASK
#define IRI_QT_REG_RX_FD_RNG0_MASK          IRI_QT_REG_RX_FD_RNG0_35B_MASK
#define IRI_QT_REG_RX_FD_RNG1_MASK          IRI_QT_REG_RX_FD_RNG1_35B_MASK
#define IRI_QT_REG_RX_FD_RNG1_BASE_MASK     IRI_QT_REG_RX_FD_RNG1_BASE_35B_MASK
#define IRI_QT_REG_RX_NPR_IIBRAM_MASK       IRI_QT_REG_RX_NPR_IIBRAM_35B_MASK
#define IRI_QT_REG_RX_PTINDEX_MASK          IRI_QT_REG_RX_PTINDEX_35B_MASK


#define MAX_NUM_CHANNELS 4

#endif // _QT_MEMMAP_H
