/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qtp_memmap.h
*
*   This file contains Iridia-QTP BM memory map.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QTP_MEMMAP_H
#define _QTP_MEMMAP_H

//==============================================================================
// Iridia-QTP Register Map
//==============================================================================
#define IRI_QTP_RAM_BASE_ADDR             (0x380000)

#define IRI_QT_RAM_INACTIVE_BAT_ADDR               (IRI_QTP_RAM_BASE_ADDR+0x10000)
#define IRI_QT_RAM_INACTIVE_GAIN_SCALE_ADDR           (IRI_QTP_RAM_BASE_ADDR+0x12000)
#define IRI_QT_RAM_INACTIVE_EGT_ADDR               (IRI_QTP_RAM_BASE_ADDR+0x18000)
#define IRI_QT_RAM_INACTIVE_TOT_ADDR               (IRI_QTP_RAM_BASE_ADDR+0x1A000)
#define IRI_QT_RAM_INACTIVE_FBT_ADDR               (IRI_QTP_RAM_BASE_ADDR+0x1F000)

#define  IRI_QTP_REG_BASE_ADDR               (0x30CB00)

// Global Registers  -10
#define IRI_QTP_REG_CONFIG_35B_ADDR       (IRI_QTP_REG_BASE_ADDR+0x00)

#define IRI_QTP_REG_STATUS_ADDR        (IRI_QTP_REG_BASE_ADDR+0x04)
#define IRI_QTP_REG_TX_PRBS_DATA0_ADDR    (IRI_QTP_REG_BASE_ADDR+0x08)
#define IRI_QTP_REG_TX_PRBS_DATA1_ADDR    (IRI_QTP_REG_BASE_ADDR+0x0C)
#define IRI_QTP_REG_TX_PRBS_DATA2_ADDR    (IRI_QTP_REG_BASE_ADDR+0x10)
#define IRI_QTP_REG_TX_PRBS_DATA3_ADDR    (IRI_QTP_REG_BASE_ADDR+0x14)
#define IRI_QTP_REG_TX_PRBS_DATA4_ADDR    (IRI_QTP_REG_BASE_ADDR+0x18)
#define IRI_QTP_REG_TX_PRBS_DATA5_ADDR    (IRI_QTP_REG_BASE_ADDR+0x1C)
#define IRI_QTP_REG_TX_PRBS_DATA6_ADDR    (IRI_QTP_REG_BASE_ADDR+0x20)
#define IRI_QTP_REG_TX_PRBS_DATA7_ADDR    (IRI_QTP_REG_BASE_ADDR+0x24)

//TxPRAM REGISTERS  -8

#define  IRI_QTP_TXPRAM_ADDR              (0x386800)
#define IRI_QTP_REG_TX_CTRL_35B_ADDR         (IRI_QTP_TXPRAM_ADDR+0x00)
#define IRI_QTP_REG_TXTC_CTRL_35B_ADDR       (IRI_QTP_TXPRAM_ADDR+0x04)
#define IRI_QTP_REG_TXTC_TOT_35B_ADDR        (IRI_QTP_TXPRAM_ADDR+0x08)
#define IRI_QTP_REG_TXTC_ACTIVE_35B_ADDR     (IRI_QTP_TXPRAM_ADDR+0x0C)

#define IRI_QTP_REG_TX_PRBS_ADDR       (IRI_QTP_TXPRAM_ADDR+0x10)
#define IRI_QTP_REG_TX_PRBS_MISC_ADDR     (IRI_QTP_TXPRAM_ADDR+0x14)
#define IRI_QTP_REG_TX_PRBS_POLY_ADDR     (IRI_QTP_TXPRAM_ADDR+0x18)


//RxPRAM REGISTERS  -8

#define  IRI_QTP_RXPRAM_ADDR              (0x386840)
#define IRI_QTP_REG_RX_CTRL_35B_ADDR         (IRI_QTP_RXPRAM_ADDR+0x00)
#define IRI_QTP_REG_RXTC_CTRL_35B_ADDR       (IRI_QTP_RXPRAM_ADDR+0x04)
#define IRI_QTP_REG_RXTC_TOT_35B_ADDR        (IRI_QTP_RXPRAM_ADDR+0x08)
#define IRI_QTP_REG_RXTC_ACTIVE_35B_ADDR     (IRI_QTP_RXPRAM_ADDR+0x0C)
#define IRI_QTP_REG_RX_PRBS_OFFSET_35B_ADDR     (IRI_QTP_RXPRAM_ADDR+0x1C)
#define IRI_QTP_REG_RX_PRBS_ADDR       (IRI_QTP_RXPRAM_ADDR+0x10)
#define IRI_QTP_REG_RX_PRBS_MISC_ADDR     (IRI_QTP_RXPRAM_ADDR+0x14)
#define IRI_QTP_REG_RX_PRBS_POLY_ADDR     (IRI_QTP_RXPRAM_ADDR+0x18)




//==============================================================================
// Iridia-QTP Sizes and Masks
//==============================================================================

// Iridia-QTP Register Masks Starting From (0x20CB00)

#define IRI_QTP_REG_CONFIG_35B_MASK       (0x0000000F)

#define IRI_QTP_REG_STATUS_MASK        (0x00000003)
#define IRI_QTP_REG_TX_PRBS_DATA0_MASK    (0xFFFFFFFF)
#define IRI_QTP_REG_TX_PRBS_DATA1_MASK    (0xFFFFFFFF)
#define IRI_QTP_REG_TX_PRBS_DATA2_MASK    (0xFFFFFFFF)
#define IRI_QTP_REG_TX_PRBS_DATA3_MASK    (0xFFFFFFFF)
#define IRI_QTP_REG_TX_PRBS_DATA4_MASK    (0xFFFFFFFF)
#define IRI_QTP_REG_TX_PRBS_DATA5_MASK    (0xFFFFFFFF)
#define IRI_QTP_REG_TX_PRBS_DATA6_MASK    (0xFFFFFFFF)
#define IRI_QTP_REG_TX_PRBS_DATA7_MASK    (0xFFFFFFFF)

#define IRI_QTP_REG_TX_CTRL_35B_MASK         (0x00007FFF)
#define IRI_QTP_REG_TXTC_CTRL_35B_MASK       (0xFFFFFFFF)
#define IRI_QTP_REG_TXTC_TOT_35B_MASK        (0x03FFFFFF)
#define IRI_QTP_REG_TXTC_ACTIVE_35B_MASK     (0x03FFFFFF)

#define IRI_QTP_REG_TX_PRBS_MASK       (0xFFFFFFFF)
#define IRI_QTP_REG_TX_PRBS_MISC_MASK     (0xFFFFFDF0)
#define IRI_QTP_REG_TX_PRBS_POLY_MASK     (0xFFFFFFFF)

#define IRI_QTP_REG_RX_CTRL_35B_MASK         (0x00007FFF)
#define IRI_QTP_REG_RXTC_CTRL_35B_MASK       (0xFFFFFFFF)
#define IRI_QTP_REG_RXTC_TOT_35B_MASK        (0x03FFFFFF)
#define IRI_QTP_REG_RXTC_ACTIVE_35B_MASK     (0x03FFFFFF)
#define IRI_QTP_REG_RX_PRBS_OFFSET_35B_MASK     (0x1FFF1FFF)

#define IRI_QTP_REG_RX_PRBS_MASK       (0xFFFFFFFF)
#define IRI_QTP_REG_RX_PRBS_MISC_MASK     (0x00007DF0)
#define IRI_QTP_REG_RX_PRBS_POLY_MASK     (0xFFFFFFFF)


#define IRI_QT_RAM_INACTIVE_BAT_SIZE            (2048*4)
#define  IRI_QT_RAM_INACTIVE_GAIN_SCALE_SIZE       (4096*4)
#define IRI_QT_RAM_INACTIVE_EGT_SIZE            (2048*4)
#define  IRI_QT_RAM_INACTIVE_TOT_SIZE           (4096*4)

#define  IRI_QT_RAM_INACTIVE_FBT_SIZE           (32*4)


#define IRI_QT_RAM_INACTIVE_BAT_OFFSET          (0)
#define  IRI_QT_RAM_INACTIVE_GAIN_SCALE_OFFSET     (0)
#define IRI_QT_RAM_INACTIVE_EGT_OFFSET          (0)
#define  IRI_QT_RAM_INACTIVE_TOT_OFFSET            (0)
#define  IRI_QT_RAM_INACTIVE_FBT_OFFSET            (0)


#define IRI_QT_RAM_INACTIVE_BAT_MASK               (0x0F0F0F0F)
#define  IRI_QT_RAM_INACTIVE_GAIN_SCALE_MASK       (0xFFFFFFFF)
#define IRI_QT_RAM_INACTIVE_EGT_MASK               (0x1F1F1F1F)

#define  IRI_QT_RAM_INACTIVE_TOT_MASK        (0x1FFF1FFF)

#define  IRI_QT_RAM_INACTIVE_FBT_MASK        (0x0FFF0FFF)



//redefine in order to avoid changes on upper layers (address defines)
#define IRI_QTP_REG_CONFIG_ADDR              IRI_QTP_REG_CONFIG_35B_ADDR
#define IRI_QTP_REG_TX_CTRL_ADDR             IRI_QTP_REG_TX_CTRL_35B_ADDR
#define IRI_QTP_REG_TXTC_CTRL_ADDR           IRI_QTP_REG_TXTC_CTRL_35B_ADDR
#define IRI_QTP_REG_TXTC_TOT_ADDR            IRI_QTP_REG_TXTC_TOT_35B_ADDR
#define IRI_QTP_REG_TXTC_ACTIVE_ADDR         IRI_QTP_REG_TXTC_ACTIVE_35B_ADDR
#define IRI_QTP_REG_RX_CTRL_ADDR             IRI_QTP_REG_RX_CTRL_35B_ADDR
#define IRI_QTP_REG_RXTC_CTRL_ADDR           IRI_QTP_REG_RXTC_CTRL_35B_ADDR
#define IRI_QTP_REG_RXTC_TOT_ADDR            IRI_QTP_REG_RXTC_TOT_35B_ADDR
#define IRI_QTP_REG_RXTC_ACTIVE_ADDR         IRI_QTP_REG_RXTC_ACTIVE_35B_ADDR
#define IRI_QTP_REG_RX_PRBS_OFFSET_ADDR      IRI_QTP_REG_RX_PRBS_OFFSET_35B_ADDR

//redefine in order to avoid changes on upper layers (mesk defines)
#define IRI_QTP_REG_CONFIG_MASK              IRI_QTP_REG_CONFIG_35B_MASK
#define IRI_QTP_REG_TX_CTRL_MASK             IRI_QTP_REG_TX_CTRL_35B_MASK
#define IRI_QTP_REG_TXTC_CTRL_MASK           IRI_QTP_REG_TXTC_CTRL_35B_MASK
#define IRI_QTP_REG_TXTC_TOT_MASK            IRI_QTP_REG_TXTC_TOT_35B_MASK
#define IRI_QTP_REG_TXTC_ACTIVE_MASK         IRI_QTP_REG_TXTC_ACTIVE_35B_MASK
#define IRI_QTP_REG_RX_CTRL_MASK             IRI_QTP_REG_RX_CTRL_35B_MASK
#define IRI_QTP_REG_RXTC_CTRL_MASK           IRI_QTP_REG_RXTC_CTRL_35B_MASK
#define IRI_QTP_REG_RXTC_TOT_MASK            IRI_QTP_REG_RXTC_TOT_35B_MASK
#define IRI_QTP_REG_RXTC_ACTIVE_MASK         IRI_QTP_REG_RXTC_ACTIVE_35B_MASK
#define IRI_QTP_REG_RX_PRBS_OFFSET_MASK      IRI_QTP_REG_RX_PRBS_OFFSET_35B_MASK

#define MAX_NUM_CHANNELS 4

#endif // _QTP_MEMMAP_H
