/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_typedef.h
*
*   This file contains type definitions used by different files.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QTP_TYPEDEF_H
#define _QTP_TYPEDEF_H


//#define Rev_2

#ifndef _BASIC_TYPES
#define _BASIC_TYPES
// variable type definitions
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef signed char      int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
typedef unsigned short   bool;        //prefix b
#endif // _BASIC_TYPES

// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc_qt long long
#else
#ifdef MSVC_ONLY
#define acc_qt __int64
#else
#define acc_qt long
#endif
#endif

// Structure used for Iridia-QTP registers
typedef struct{


// IRI_QTP_REG_CONFIG

   int32 l_Segmentsize ;


// IRI_QTP_REG_STATUS

   int32 l_RxProcessError ;
   int32 l_TxProcessError ;


} IridiaQTP_Global_Register_t;

typedef struct {

// IRI_QTP_REG_TX_CTRL

   int32 l_TxTCEnable    ;
  int32 l_TxPRBSEnable    ;
  int32 l_TxMaxTones  ;

// IRI_QTP_REG_TXTC_CTRL

  int32 l_TxTCDirection    ;
  int32 l_TxTCOneBitReorder ;
  int32 l_TxTCCopySegment    ;
  int32 l_TxTC_TOTDisable  ;
  int32 l_TxTC_NumGT1  ;
  int32 l_TxTC_Num0Bit   ;

  // IRI_QTP_REG_TXTC_TOT

   int32 l_TxTCMaxTOTAddr;
   int32 l_TxTCMinTOTAddr;

// IRI_QTP_REG_TXTC_ACTIVE
   int32 l_TxTCMaxActiveAddr;
   int32 l_TxTCMinActiveAddr;


// IRI_QTP_REG_TX_PRBS
   int32 l_TxPRBSState ;

// IRI_QTP_REG_TX_PRBS_MISC
   int32 l_TxPRBSScrambling11 ;
   int32 l_TxPRBSScrambling10 ;
   int32 l_TxPRBSScrambling01 ;
   int32 l_TxPRBSScrambling00 ;
   int32 l_TxPRBSModulo ;
   int32 l_TxPRBSOutput ;
   int32 l_TxPRBSSkip ;
   int32 l_TxPRBSReset ;
   int32 l_TxPRBSInvert ;
   int32 l_TxPRBSLength ;

// IRI_QTP_REG_TX_PRBS_POLY

   int32 l_TxPRBSPolynomial ;

// IRI_QTP_REG_TX_PRBS_DATA

   int32 l_TxPRBS2BitInput[128] ;

} IridiaQTP_TxPram_Register_t;

typedef struct {

// IRI_QTP_REG_RX_CTRL

   int32 l_RxTCEnable    ;
  int32 l_RxPRBSEnable    ;
  int32 l_RxMaxTones  ;
// IRI_QTP_REG_RXTC_CTRL

  int32 l_RxTCDirection    ;
  int32 l_RxTCOneBitReorder;
  int32 l_RxTCCopySegment    ;
  int32 l_RxTC_TOTDisable  ;
  int32 l_RxTC_NumGT1  ;
  int32 l_RxTC_Num0Bit   ;


 // IRI_QTP_REG_RXTC_TOT

   int32 l_RxTCMaxTOTAddr;
   int32 l_RxTCMinTOTAddr;

// IRI_QTP_REG_RXTC_ACTIVE
   int32 l_RxTCMaxActiveAddr;
   int32 l_RxTCMinActiveAddr;


// IRI_QTP_REG_RX_PRBS
   int32 l_RxPRBSState ;

// IRI_QTP_REG_RX_PRBS_MISC

   int32 l_RxPRBSSkip ;
   int32 l_RxPRBSReset ;
   int32 l_RxPRBSLength ;

// IRI_QTP_REG_RX_PRBS_POLY
   int32 l_RxPRBSPolynomial ;

// IRI_QTP_REG_RX_PRBS_OFFSET

   int32 l_RxRTVBuffer0Offset ;
   int32 l_RxRTVBuffer1Offset ;

} IridiaQTP_RxPram_Register_t;


typedef struct {

   // IRI_QT_TX
   uint16 us_ENC;

   // IRI_QT_RX
   uint16 us_DEC;

} IridiaQTP_Latencies_t;


// These are needed inside corexec.

// Structure used for Iridia-QT input signals
typedef struct {

   // IRI_QT_TX
   uint8 uc_TX_GO[4];

   // IRI_QT_RX
   uint8 uc_RX_GO[4];

} IridiaQTP_Input_t;


// Structure used for Iridia-QT output signals
typedef struct {

   // IRI_QT_TX
   uint8 uc_TX_DONE[4];


   // IRI_QT_RX
   uint8 uc_RX_DONE[4];


} IridiaQTP_Output_t;


#endif //QTP_TYPEDEF_H
