/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright Infineon Technologies Asia Pacific Pte Ltd
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//------------------------------------------------------------
// Filename : mem.h
// Location : utils/include
// Author   : GohChee
// Date     : Mon Apr 24 14:19:54 MPST 2006
//------------------------------------------------------------
// All rights reserved. No part of this file shall be modified without notifying the owner.
//------------------------------------------------------------
// Modification History
// Date  Owner Changes
// Mon Apr 24 14:19:54 MPST 2006 GohChee  Created
//------------------------------------------------------------

#ifndef __MEM__
#define __MEM__

#include <common.h>

typedef struct {
  char *name;
  uint32 start;
  uint32 end;
  uint32 mask;
  uint32 *mem;
  uint8  nmem;
} memdef_t;

extern uint8 mem_read(memdef_t *memlist, uint16 nmem, uint32 addr, uint32 *dout, uint32 rmask, uint8 ch_id);
extern uint8 mem_write(memdef_t *memlist, uint16 nmem, uint32 addr, uint32 din, uint32 rmask, uint8 ch_id);
extern uint8 mem_readBlock(memdef_t *memlist, uint16 nmem, uint32 addr_start, uint32 addr_end, uint32 *dout, uint32 rmask, uint8 ch_id);
extern uint8 mem_writeBlock(memdef_t *memlist, uint16 nmem, uint32 addr_start, uint32 addr_end, uint32 *din, uint32 wmask, uint8 ch_id);
#endif
