/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_MEMMAP_H
#define _ZEP_MEMMAP_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_memmap.h
 * DESCRIPTION:      Memory map definition
 *
 **********************************************************************/


// Definitions for overhead FIFOS
#define  NUM_FIFOS   3

#define BYTES_IN_TX_FIFO0  32
#define BYTES_IN_TX_FIFO1  32
#define BYTES_IN_TX_FIFO2  6

#define BYTES_IN_RX_FIFO0  32
#define BYTES_IN_RX_FIFO1  32
#define BYTES_IN_RX_FIFO2  6
/**********************************************************************
* Sample Memory map for Zephyr RAM  blocks
**********************************************************************/

// CW buffers are not currently mapped to the DSP memory, the following
// values are just for illustration

#define ZEP_RAM_RX_CW_SIZE              (512)

#define ZEP_RAM_RX_CW_ADDR          (uint32)(0x7C000)

#define ZEP_RAM_RX_PARAM_ADDR       (uint32)(0x1A34C0)
#define ZEP_RAM_TX_PARAM_ADDR       (uint32)(0x1A30C0)

#define ZEP_REG_BASE_GLOBAL            (uint32)(0x7CC00)

/**********************************************************************
 * Memory map for Global Zephyr-FC registers
 **********************************************************************/




#define Z_VERSION_ADDR              (uint32)(ZEP_REG_BASE_GLOBAL + 0x00)
#define Z_WB_DBG_ADDR                 (uint32)(ZEP_REG_BASE_GLOBAL + 0x04)
#define Z_WB_RCHK0_ADDR               (uint32)(ZEP_REG_BASE_GLOBAL + 0x08)
#define Z_WB_RCHK1_ADDR               (uint32)(ZEP_REG_BASE_GLOBAL + 0x0C)
#define Z_WB_RCHK2_ADDR               (uint32)(ZEP_REG_BASE_GLOBAL + 0x10)
#define Z_WB_RCHK3_ADDR               (uint32)(ZEP_REG_BASE_GLOBAL + 0x14)
#define Z_WB_RSYND0_ADDR              (uint32)(ZEP_REG_BASE_GLOBAL + 0x18)
#define Z_WB_RSYND1_ADDR              (uint32)(ZEP_REG_BASE_GLOBAL + 0x1C)
#define Z_WB_RSYND2_ADDR              (uint32)(ZEP_REG_BASE_GLOBAL + 0x20)
#define Z_WB_RSYND3_ADDR              (uint32)(ZEP_REG_BASE_GLOBAL + 0x24)
#define ZEP_REG_ZT_FIFO0_CTRL_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x28)
#define ZEP_REG_ZT_FIFO0_BYTE_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x2C)
#define ZEP_REG_ZT_FIFO1_CTRL_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x30)
#define ZEP_REG_ZT_FIFO1_BYTE_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x34)
#define ZEP_REG_ZT_FIFO2_CTRL_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x38)
#define ZEP_REG_ZT_FIFO2_BYTE_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x3C)
#define ZEP_REG_ZR_FIFO0_CTRL_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x40)
#define ZEP_REG_ZR_FIFO0_BYTE_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x44)
#define ZEP_REG_ZR_FIFO1_CTRL_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x48)
#define ZEP_REG_ZR_FIFO1_BYTE_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x4C)
#define ZEP_REG_ZR_FIFO2_CTRL_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x50)
#define ZEP_REG_ZR_FIFO2_BYTE_ADDR    (uint32)(ZEP_REG_BASE_GLOBAL + 0x54)
#define ZEP_REG_ZT_PI_ADDR            (uint32)(ZEP_REG_BASE_GLOBAL + 0x58)
#define ZEP_REG_WB_AJ0_ADDR           (uint32)(ZEP_REG_BASE_GLOBAL + 0x5C)
#define ZEP_REG_WB_AJ1_ADDR           (uint32)(ZEP_REG_BASE_GLOBAL + 0x60)
#define ZEP_REG_WB_AJ2_ADDR           (uint32)(ZEP_REG_BASE_GLOBAL + 0x64)
#define ZEP_REG_WB_AJ3_ADDR           (uint32)(ZEP_REG_BASE_GLOBAL + 0x68)
#define ZEP_REG_ZT_NTR_IBITS_ADDR     (uint32)(ZEP_REG_BASE_GLOBAL + 0x6C)
#define ZEP_REG_ZT_NTR_CLK_ADDR       (uint32)(ZEP_REG_BASE_GLOBAL + 0x70)
#define  ZEP_NUM_GREGS           (uint32)((ZEP_REG_ZT_NTR_CLK_ADDR - Z_VERSION_ADDR + 4)/4)
/**********************************************************************
 * Memory map TX PRAM Zephyr-FC registers
 **********************************************************************/


#define ZEP_TX_START_ADDRESS                  ZEP_RAM_TX_PARAM_ADDR

#define ZEP_REG_ZT_LINE_ADDR                  (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x00)
#define ZEP_REG_ZT_LP0_CFG_ADDR               (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x04)
#define ZEP_REG_ZT_LP1_CFG_ADDR               (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x08)
#define ZEP_REG_ZT_VBC0_SIZE_ADDR             (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x0C)
#define ZEP_REG_ZT_VBC1_SIZE_ADDR             (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x10)
#define ZEP_REG_ZT_FRAME_IDX0_ADDR            (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x14)
#define ZEP_REG_ZT_FRAME_IDX1_ADDR            (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x18)
#define ZEP_REG_ZT_CODEWORD_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x1C)
#define ZEP_REG_ZT_MP_ADDR                    (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x20)
#define ZEP_REG_ZT_TP0_ADDR                   (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x24)
#define ZEP_REG_ZT_TP1_ADDR                   (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x28)
#define ZEP_REG_ZT_DZ_MAX_ADDR                (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x2C)
#define ZEP_REG_ZT_DZ_VAL_ADDR                (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x30)
#define ZEP_REG_ZT_DRS_VAL_ADDR               (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x34)
#define ZEP_REG_ZT_OHRATE0_ADDR               (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x38)
#define ZEP_REG_ZT_OHRATE1_ADDR               (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x3C)
#define ZEP_REG_ZT_EOC_ADDR                   (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x40)
#define ZEP_REG_ZT_VOC_ADDR                   (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x44)
#define ZEP_REG_ZT_AOC_ADDR                   (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x48)
#define ZEP_REG_ZT_FIFO0_BYTE0_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x4C)
#define ZEP_REG_ZT_FIFO0_BYTE1_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x50)
#define ZEP_REG_ZT_FIFO0_BYTE2_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x54)
#define ZEP_REG_ZT_FIFO0_BYTE3_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x58)
#define ZEP_REG_ZT_FIFO0_BYTE4_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x5C)
#define ZEP_REG_ZT_FIFO0_BYTE5_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x60)
#define ZEP_REG_ZT_FIFO0_BYTE6_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x64)
#define ZEP_REG_ZT_FIFO0_BYTE7_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x68)
#define ZEP_REG_ZT_FIFO1_BYTE0_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x6C)
#define ZEP_REG_ZT_FIFO1_BYTE1_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x70)
#define ZEP_REG_ZT_FIFO1_BYTE2_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x74)
#define ZEP_REG_ZT_FIFO1_BYTE3_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x78)
#define ZEP_REG_ZT_FIFO1_BYTE4_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x7C)
#define ZEP_REG_ZT_FIFO1_BYTE5_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x80)
#define ZEP_REG_ZT_FIFO1_BYTE6_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x84)
#define ZEP_REG_ZT_FIFO1_BYTE7_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x88)
#define ZEP_REG_ZT_FIFO2_BYTE0_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x8C)
#define ZEP_REG_ZT_FIFO2_BYTE1_ADDR           (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x90)
#define ZEP_REG_ZT_SCR_CRC0_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x94)
#define ZEP_REG_ZT_SCR_CRC1_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x98)
#define ZEP_REG_ZT_CHECKBYTE_ADDR             (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0x9C)
#define ZEP_REG_ZT_CBYTE0_0_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0xA0)
#define ZEP_REG_ZT_CBYTE0_1_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0xA4)
#define ZEP_REG_ZT_CBYTE0_2_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0xA8)
#define ZEP_REG_ZT_CBYTE0_3_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0xAC)
#define ZEP_REG_ZT_CBYTE1_0_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0xB0)
#define ZEP_REG_ZT_CBYTE1_1_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0xB4)
#define ZEP_REG_ZT_CBYTE1_2_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0xB8)
#define ZEP_REG_ZT_CBYTE1_3_ADDR              (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0xBC)
#define ZEP_REG_ZT_OHRATE_SRA_ADDR            (uint32)(ZEP_RAM_TX_PARAM_ADDR + 0xC0)
#define ZEP_REG_NUM_TX_WORDS     (uint32)((ZEP_REG_ZT_OHRATE_SRA_ADDR - ZEP_REG_ZT_LINE_ADDR + 4)/4)

/**********************************************************************
 * Memory map RX PRAM Zephyr-FC registers
 **********************************************************************/
#define ZEP_RX_START_ADDRESS                  ZEP_RAM_RX_PARAM_ADDR


#define ZEP_REG_ZR_LINE_ADDR                  (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x00)
#define ZEP_REG_ZR_LP0_CFG_ADDR               (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x04)
#define ZEP_REG_ZR_LP1_CFG_ADDR               (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x08)
#define ZEP_REG_ZR_VBC0_SIZE_ADDR             (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x0C)
#define ZEP_REG_ZR_VBC1_SIZE_ADDR             (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x10)
#define ZEP_REG_ZR_FRAME_IDX0_ADDR            (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x14)
#define ZEP_REG_ZR_FRAME_IDX1_ADDR            (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x18)
#define ZEP_REG_ZR_MP_ADDR                    (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x1C)
#define ZEP_REG_ZR_TP0_ADDR                   (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x20)
#define ZEP_REG_ZR_TP1_ADDR                   (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x24)
#define ZEP_REG_ZR_DZ_MAX_ADDR                (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x28)
#define ZEP_REG_ZR_DZ_VAL_ADDR                (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x2C)
#define ZEP_REG_ZR_DRS_VAL_ADDR               (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x30)
#define ZEP_REG_ZR_OHRATE0_ADDR               (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x34)
#define ZEP_REG_ZR_OHRATE1_ADDR               (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x38)
#define ZEP_REG_ZR_EOC_ADDR                   (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x3C)
#define ZEP_REG_ZR_VOC_ADDR                   (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x40)
#define ZEP_REG_ZR_AOC_ADDR                   (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x44)
#define ZEP_REG_ZR_FIFO0_BYTE0_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x48)
#define ZEP_REG_ZR_FIFO0_BYTE1_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x4C)
#define ZEP_REG_ZR_FIFO0_BYTE2_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x50)
#define ZEP_REG_ZR_FIFO0_BYTE3_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x54)
#define ZEP_REG_ZR_FIFO0_BYTE4_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x58)
#define ZEP_REG_ZR_FIFO0_BYTE5_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x5C)
#define ZEP_REG_ZR_FIFO0_BYTE6_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x60)
#define ZEP_REG_ZR_FIFO0_BYTE7_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x64)
#define ZEP_REG_ZR_FIFO1_BYTE0_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x68)
#define ZEP_REG_ZR_FIFO1_BYTE1_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x6C)
#define ZEP_REG_ZR_FIFO1_BYTE2_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x70)
#define ZEP_REG_ZR_FIFO1_BYTE3_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x74)
#define ZEP_REG_ZR_FIFO1_BYTE4_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x78)
#define ZEP_REG_ZR_FIFO1_BYTE5_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x7C)
#define ZEP_REG_ZR_FIFO1_BYTE6_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x80)
#define ZEP_REG_ZR_FIFO1_BYTE7_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x84)
#define ZEP_REG_ZR_FIFO2_BYTE0_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x88)
#define ZEP_REG_ZR_FIFO2_BYTE1_ADDR           (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x8C)
#define ZEP_REG_ZR_DSCR_CRC0_ADDR             (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x90)
#define ZEP_REG_ZR_DSCR_CRC1_ADDR             (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x94)
#define ZEP_REG_ZR_CRC_CNT_ADDR               (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x98)
#define ZEP_REG_ZR_CW_COUNT_ADDR              (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0x9C)
#define ZEP_REG_ZR_FEC1_CNT_ADDR              (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0xA0)
#define ZEP_REG_ZR_FEC0_CNT_ADDR              (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0xA4)
#define ZEP_REG_ZR_RXIB_ADDR                  (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0xA8)
#define ZEP_REG_ZR_WB_SCORE_CTL_ADDR          (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0xAC)
#define ZEP_REG_ZR_WB_SCORE2_ADDR             (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0xB0)
#define ZEP_REG_ZR_OHRATE_SRA_ADDR            (uint32)(ZEP_RAM_RX_PARAM_ADDR + 0xB4)
#define ZEP_REG_NUM_RX_WORDS           (uint16)((ZEP_REG_ZR_OHRATE_SRA_ADDR - ZEP_REG_ZR_LINE_ADDR + 4)/4)

/**********************************************************************
 * Register Masks for test purposes
 **********************************************************************/

// TX PRAM masks
#define ZEP_REG_ZT_LINE_MASK              (0x000018FF)
#define ZEP_REG_ZT_LP0_CFG_MASK              (0x00FF171F)
#define ZEP_REG_ZT_LP1_CFG_MASK              (0x0000171F)
#define ZEP_REG_ZT_VBC0_SIZE_MASK            (0x1FFF1FFF)
#define ZEP_REG_ZT_VBC1_SIZE_MASK            (0x1FFF1FFF)
#define ZEP_REG_ZT_FRAME_IDX0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_FRAME_IDX1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZT_CODEWORD_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_MP_MASK                (0x1F1F1F1F)
#define ZEP_REG_ZT_TP0_MASK                  (0xFFFF1FFF)
#define ZEP_REG_ZT_TP1_MASK                  (0xFFFF1FFF)
#define ZEP_REG_ZT_DZ_MAX_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZT_DZ_VAL_MASK               (0x0000FFFF)
#define ZEP_REG_ZT_DRS_VAL_MASK              (0xFFFFFFFF)
#define ZEP_REG_ZT_EMPTY_MASK                   (0x00000000)   // Blank location in Memmap
#define ZEP_REG_ZT_OHRATE0_MASK              (0xFFFF1F1F)
#define ZEP_REG_ZT_OHRATE1_MASK              (0xFFFF1F1F)
#define ZEP_REG_ZT_EOC_MASK                  (0x0001FFFF)
#define ZEP_REG_ZT_VOC_MASK                  (0x0000FFFF)
#define ZEP_REG_ZT_AOC_MASK                  (0x01FF01FF)
#define ZEP_REG_ZT_FIFO0_BYTE0_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO0_BYTE1_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO0_BYTE2_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO0_BYTE3_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO0_BYTE4_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO0_BYTE5_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO0_BYTE6_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO0_BYTE7_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO1_BYTE0_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO1_BYTE1_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO1_BYTE2_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO1_BYTE3_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO1_BYTE4_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO1_BYTE5_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO1_BYTE6_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO1_BYTE7_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO2_BYTE0_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZT_FIFO2_BYTE1_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_EMPTY_MASK                   (0x00000000)   // Blank location in Memmap
#define ZEP_REG_ZT_SCR_CRC0_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZT_SCR_CRC1_MASK             (0xFFFFFFFF)
#define ZEP_REG_ZT_CHECKBYTE_MASK            (0x1F1F1F1F)
#define ZEP_REG_ZT_CBYTE0_0_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE0_1_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE0_2_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE0_3_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE0_4_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE0_5_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE0_6_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE0_7_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE1_0_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE1_1_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE1_2_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE1_3_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE1_4_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE1_5_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE1_6_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_CBYTE1_7_MASK          (0x0000FFFF)
#define ZEP_REG_ZT_OHRATE_SRA_MASK              (0x9F1F9F1F)

// RX PRAM masks
#define ZEP_REG_ZR_LINE_MASK              (0xFFFF21FF)
#define ZEP_REG_ZR_LP0_CFG_MASK              (0x1FFF1311)
#define ZEP_REG_ZR_LP1_CFG_MASK              (0x1FFF1311)
#define ZEP_REG_ZR_VBC0_SIZE_MASK            (0x1FFF1FFF)
#define ZEP_REG_ZR_VBC1_SIZE_MASK            (0x1FFF1FFF)
#define ZEP_REG_ZR_FRAME_IDX0_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_FRAME_IDX1_MASK           (0xFFFFFFFF)
#define ZEP_REG_ZR_MP_MASK                   (0x1F1F1F1F)
#define ZEP_REG_ZR_TP0_MASK                  (0xFFFFFFFF)
#define ZEP_REG_ZR_TP1_MASK                  (0xFFFFFFFF)
#define ZEP_REG_ZR_DZ_MAX_MASK               (0xFFFFFFFF)
#define ZEP_REG_ZR_DZ_VAL_MASK               (0x0000FFFF)
#define ZEP_REG_ZR_DRS_VAL_MASK                 (0xFFFFFFFF)
#define ZEP_REG_ZR_OHRATE0_MASK              (0xFFFF1F1F)
#define ZEP_REG_ZR_OHRATE1_MASK              (0xFFFF1F1F)
#define ZEP_REG_ZR_EOC_MASK                  (0x0001FFFF)
#define ZEP_REG_ZR_VOC_MASK                  (0x0000FFFF)
#define ZEP_REG_ZR_AOC_MASK                  (0x000001FF)
#define ZEP_REG_ZR_FIFO0_BYTE0_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO0_BYTE1_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO0_BYTE2_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO0_BYTE3_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO0_BYTE4_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO0_BYTE5_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO0_BYTE6_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO0_BYTE7_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO1_BYTE0_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO1_BYTE1_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO1_BYTE2_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO1_BYTE3_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO1_BYTE4_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO1_BYTE5_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO1_BYTE6_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO1_BYTE7_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO2_BYTE0_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FIFO2_BYTE1_MASK          (0x0000FFFF)
#define ZEP_REG_ZR_DSCR_CRC0_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZR_DSCR_CRC1_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZR_CRC_CNT_MASK              (0x0000FFFF)
#define ZEP_REG_ZR_CW_COUNT_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FEC1_CNT_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_FEC0_CNT_MASK          (0xFFFFFFFF)
#define ZEP_REG_ZR_RXIB_MASK              (0x00111111)
#define ZEP_REG_ZR_WB_SCORE_CTL_MASK         (0xF777FFFF)
#define ZEP_REG_ZR_WB_SCORE2_MASK            (0xFFFFFFFF)
#define ZEP_REG_ZR_OHRATE_SRA_MASK              (0x9F1F9F1F)

// Global Register Masks
#define ZEP_REG_Z_VERSION_MASK               (0x00000000)  //RO
#define ZEP_REG_ZR_WB_DBG_MASK               (0x00000000)  //RO
#define ZEP_REG_ZR_WB_RCHK0_MASK          (0x00000000)  //RO
#define ZEP_REG_ZR_WB_RCHK1_MASK          (0x00000000)  //RO
#define ZEP_REG_ZR_WB_RCHK2_MASK          (0x00000000)  //RO
#define ZEP_REG_ZR_WB_RCHK3_MASK          (0x00000000)  //RO
#define ZEP_REG_ZR_WB_RSYND0_MASK            (0x00000000)  //RO
#define ZEP_REG_ZR_WB_RSYND1_MASK            (0x00000000)  //RO
#define ZEP_REG_ZR_WB_RSYND2_MASK            (0x00000000)  //RO
#define ZEP_REG_ZR_WB_RSYND3_MASK            (0x00000000)  //RO
#define ZEP_REG_ZT_FIFO0_CTRL_MASK           (0xFF013F3F)
#define ZEP_REG_ZT_FIFO0_BYTE_MASK           (0x00000000)  //RO//WO
#define ZEP_REG_ZT_FIFO1_CTRL_MASK           (0xFF013F3F)
#define ZEP_REG_ZT_FIFO1_BYTE_MASK           (0x00000000)  //RO//WO
#define ZEP_REG_ZT_FIFO2_CTRL_MASK           (0xFF010707)
#define ZEP_REG_ZT_FIFO2_BYTE_MASK           (0x00000000)  //RO//WO
#define ZEP_REG_ZR_FIFO0_CTRL_MASK           (0x00033F3F)
#define ZEP_REG_ZR_FIFO0_BYTE_MASK           (0x00000000)  //RO
#define ZEP_REG_ZR_FIFO1_CTRL_MASK           (0x00033F3F)
#define ZEP_REG_ZR_FIFO1_BYTE_MASK           (0x00000000)  //RO
#define ZEP_REG_ZR_FIFO2_CTRL_MASK           (0x00030707)
#define ZEP_REG_ZR_FIFO2_BYTE_MASK           (0x00000000)  //RO
#define ZEP_REG_ZT_PI_MASK                      (0x3FFF3FFF)
#define ZEP_REG_WB_AJ0_MASK                     (0x00000000)  //RO
#define ZEP_REG_WB_AJ1_MASK                     (0x00000000)  //RO
#define ZEP_REG_WB_AJ2_MASK                     (0x00000000)  //RO
#define ZEP_REG_WB_AJ3_MASK                     (0x00000000)  //RO
#define ZEP_REG_ZT_NTR_IBITS_MASK            (0x07000000)  //RO
#define ZEP_REG_ZT_NTR_CLK_MASK                 (0x3FFF01FF)

#endif //_ZEP_MEMMAP_H  Do not add anything below this line.


