/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File galois.h
;
;  This file contains declarations for variables and functions required
;   for computation in GF(256)
;
;***************************************************************************/


#ifndef _GALOIS_H
#define _GALOIS_H

#define NN 255  // field size
#define MM 8    // log2(field size)
#define MAXCOEFF 256 // The maximum degree of a polynomial


typedef int galois; // galois field can hold polynomial as well as index form (polynomial by default)
typedef struct{ galois coeffs[MAXCOEFF];} polynomial; // polynomial with coefficients in galois field


extern galois ALPHA;


void generate_gf(void);
int modnn(int);
int my_index(galois);
galois poly(int);
galois galois_exponent(galois , int );
galois galois_multiply(galois , galois );
galois galois_add(galois , galois );
galois galois_divide(galois, galois);
galois galois_inv(galois);
void clear_polynomial(polynomial *, char);

int degree(polynomial);
int roots(polynomial ,galois *);
galois eval(polynomial , int );

#endif

