/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_IO_TYPEDEF_H
#define _ZEP_IO_TYPEDEF_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_io_typedef.h
 * DESCRIPTION:      Header file for zephyr io signals.c
 *
 **********************************************************************/

#ifndef _BASIC_TYPES
#define _BASIC_TYPES

#include <stdio.h>

#ifdef UNIX_PLATFORM
#include "svdpi.h"
#endif

typedef void  (*PtrToFunc)(void);
/* Variable type definitions */
typedef double float64;          /* prefix d in hungarian notation */
typedef long  int32;             /* prefix l */
typedef char  int8;              /* prefix c */
typedef short int16;          /* prefix s */
typedef unsigned char uint8;     /* prefix uc */
typedef unsigned long uint32;    /* prefix ul */
typedef unsigned short uint16;      /* prefix us */
typedef unsigned long Float32;      /* prefix f */
typedef unsigned char FlagT;     /* prefix ft */

#endif // _BASIC_TYPES


//Input/output parameter structures
typedef struct {
    uint8   uc_CRI_FC_TX_GO[2];
    uint8   uc_CRI_FC_RX_GO[2];
   uint8 uc_QT_TX_DONE[2];
   uint16   us_QT_TX_PMD_BYTES0[2];
   uint16   us_QT_TX_PMD_BYTES1[2];

}  Zephyr_Input_t;

typedef struct {

   uint8 uc_FCI_TX_DONE[2];
   uint8   uc_FCI_TX_INT_GO[2];
   uint8 uc_FCI_RX_DONE[2];
   uint8   uc_FCI_RX_INT_GO[2];

   uint8 uc_FCI_RX_ON;
   uint8 uc_FCI_TX_ON;

   uint8 uc_FC_RX_PROC_DONE;

}  Zephyr_Output_t;

// Zephyr IO signals
extern Zephyr_Input_t  gt_ZEP_Input;
extern Zephyr_Output_t gt_ZEP_Output;

//Temporarily added for ASIC testing
extern uint8 Tx_port;
extern uint8 Rx_port;

#endif //_ZEP_TYPEDEF_H    Do not add anything below this line.


