/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_TYPEDEF_H
#define _ZEP_TYPEDEF_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             register.h
 * DESCRIPTION:      Header file for register.c
 *
 **********************************************************************/

#include "zep_const.h"
#include "zep_memmap.h"

#ifndef _BASIC_TYPES
#define _BASIC_TYPES

typedef void  (*PtrToFunc)(void);
/* Variable type definitions */
typedef double float64;          /* prefix d in hungarian notation */
typedef long  int32;             /* prefix l */
typedef char  int8;              /* prefix c */
typedef short int16;          /* prefix s */
typedef unsigned char uint8;     /* prefix uc */
typedef unsigned long uint32;    /* prefix ul */
typedef unsigned short uint16;      /* prefix us */
typedef unsigned long Float32;      /* prefix f */
typedef unsigned char FlagT;     /* prefix ft */

#endif // _BASIC_TYPES


typedef struct {
   //Framing Processor Registers
   uint16 base;   //UPROC_BASE

   //BM Internal Variables

   //Instruction Processing
   uint8  inst_type;
   uint32 ul_cur_inst;
   uint16  pc; //STATE0[7:0] * 4 //Program counter, offset from base

   //SET_IO
   uint8  input_master;  //STATE1[28]
   uint8  output_master; //STATE1[29]
   uint8  null_src;  //STATE1[30]
   uint8  null_dest; //STATE1[31]
   uint8  input_const_block_id;    //STATE2[23:16]
   uint8  input_flag_block_id;    //STATE0[8:12]
   //uint8  input_block_id; //STATE2[23:16]
   uint32 output_mask;  //STATE3[31:0]

   //MOV
   uint8  keep_byte_cnt;
   uint8  mov_bit_flip;
   uint8  mov_invert;
   uint16 mov_num_bytes;
   uint8  mov_flag_mode;
   uint8  mov_flag_mask;
   uint8  mov_apply_mode;
   uint8  breakOnFlagEn;
   uint8  breakOnFlagSet;
   uint8  breakOnFlagPending;
   uint16 mov_byte_cnt; //STATE2[15:0]
   uint8  output_requesting;
    uint32 output_ack;
  uint8 uc_flag_fifo_ptrs; // For register info only
  uint8 uc_data_fifo_ptrs; // For register info only
  uint8  break_on_flag; // For register info only

   //FLAG
   uint8  flag_flag_mode;
   uint8  flag_flag_mask; //STATE2[28:25]
  uint8  flag_data_set;
  uint8  flag_match_data;
  uint8  flag_rst_ena; // For register info only

   //JUMP
   uint8  jump_flag;

   //WAIT_EVENT
   uint8  event_type;
   uint16 event_num_clocks;
   uint16 event_clock_cnt;
   uint8 event_cri_IntId;

   //REPEAT
   uint8  repeat_cnt; //STATE0[23:16]  //Current repeat count within a repeat
   uint8  repeat_max_cnt;  //STATE0[31:24] //Max number of times to repeat
   uint16 repeat_pc; //STATE0[15:8] //PC value of the last repeat statement

} t_code_engine;

typedef struct {
   uint8 uc_byte[2]; //STATE1[15:0]
   uint8 uc_flag[2]; //STATE1[23:16]
   uint8 uc_numByte;
   uint8 uc_numFlag;
} t_fifo;

/**********************************************************************
 * Global Registers                                                   *
 **********************************************************************/

typedef struct {

// Per Instance Registers

   // Version
   uint8  Major;
   uint8  Minor;

  uint8  Mbox_Access_Disable;

   // WB Debug
   uint8  Rx_Num_Iter;
   uint8  Rx_Num_Err;
   uint16 Rx_RCheck[16];
   uint16 Rx_RSynd[16];
   uint16 Rx_AJ[16];

// Per Port Registers - Tx

   // Config Start Address
   uint16 Tx_Cfg_Start_Addr;

   // FIFO
   uint8  Tx_FIFO_LP;
   uint8  Tx_FIFO_Rdy;
   uint8  Tx_FIFO_Write;
   uint8  Tx_FIFO_Num;
   uint8  Tx_FIFO_Byte;
   uint16 Tx_FIFO_Valid_Bytes;
   uint8  Tx_FIFO_VB_Req;

   //NTR
   uint16 Tx_NTR_DS;
   uint16 Tx_NTR_Accum;
   uint16 Tx_NTR_Raw;
   uint8  Tx_NTR_IBits;
   uint8  Tx_NTR_Clk;
   uint32 Tx_LTR_NTR_Ratio;
   uint32 Tx_PLL_LTR_Num;
   uint16 Tx_PLL_LTR_Den;

   // QT DTB
   uint16 Tx_LP1_PMS_Size;
   uint16 Tx_LP0_PMS_Size;
   uint16 Tx_LP1_DT_Size;
   uint16 Tx_LP0_DT_Size;
   uint8  Tx_PMS1_Latch_Ena;
   uint8  Tx_PMS0_Latch_Ena;
   uint8  Tx_DT1_Latch_Ena;
   uint8  Tx_DT0_Latch_Ena;
   uint16 Tx_TXDTB_RD_Size_0;
   uint16 Tx_TXDTB_RD_Base_0;
   uint16 Tx_TXDTB_RD_Size_1;
   uint16 Tx_TXDTB_RD_Base_1;
   uint16 Tx_TXDTB_RD_Size_2;
   uint16 Tx_TXDTB_RD_Base_2;
   uint16 Tx_TXDTB_RD_Addr_1;
   uint16 Tx_TXDTB_RD_Addr_0;
   uint16 Tx_TXDTB_RD_Addr_2;
   uint16 Tx_DTB_Offset;

   // Err Stat
   uint8  Tx_Err_Stat;
   uint8  Tx_Sync_Reset;

// Per Port Registers - Rx

   // Config Start Address
   uint16 Rx_Cfg_Start_Addr;

   // FIFO
   uint8  Rx_FIFO_LP;
   uint8  Rx_FIFO_Rdy;
   uint8  Rx_FIFO_Write;
   uint8  Rx_FIFO_Num;
   uint8  Rx_FIFO_Byte;
   uint16 Rx_FIFO_Valid_Bytes;
   uint8  Rx_FIFO_VB_Req;

   // QT DTB
   uint16 Rx_LP1_PMS_Size;
   uint16 Rx_LP0_PMS_Size;
   uint16 Rx_LP1_DT_Size;
   uint16 Rx_LP0_DT_Size;
   uint8  Rx_PMS1_Latch_Ena;
   uint8  Rx_PMS0_Latch_Ena;
   uint8  Rx_DT1_Latch_Ena;
   uint8  Rx_DT0_Latch_Ena;
   uint16 Rx_RXDTB_WR_Size_0;
   uint16 Rx_RXDTB_WR_Base_0;
   uint16 Rx_RXDTB_WR_Size_1;
   uint16 Rx_RXDTB_WR_Base_1;
   uint16 Rx_RXDTB_WR_Size_2;
   uint16 Rx_RXDTB_WR_Base_2;
   uint16 Rx_RXDTB_WR_Addr_1;
   uint16 Rx_RXDTB_WR_Addr_0;
   uint16 Rx_RXDTB_WR_Addr_2;
   uint16 Rx_QTScore;
   uint16 Rx_DMetric_WP;
   uint16 Rx_DTB_Offset;

   // Err Stat
   uint8  Rx_Err_Stat;
   uint8  Rx_Sync_Reset;

} t_ZepGlobalRegisters;


/**********************************************************************
 * Transmit Registers                                                 *
 **********************************************************************/

typedef struct {

// General purpose registers
   uint32 Tx_REG0;
   uint32 Tx_REG1;
   uint32 Tx_REG2;
   uint32 Tx_REG3;

// Codeword
   uint8  Tx_SymbolsPerCW; //same
   uint8  Tx_CheckByteSize;
   uint8  Tx_KP_Val;
   uint8  Tx_CWSize; //same

// VBC_size
      uint16 Tx_BC1_Bytes;
   uint16 Tx_BC0_Bytes;

// Frame_Idx
   uint8  Tx_OHSwitch;
   uint8  Tx_Tp;  //same
   uint16 Tx_MaxFrameIndex;   //same

// OHRate
   uint8  Tx_OH1Rate;
   uint8  Tx_OH2Rate;
   uint16 Tx_Max_OH;

// Flag Control
   uint8  Tx_ILVB_Flg_Ptr;
   uint8  Tx_DTB_Flg_Inc;
   uint8  Tx_DTB_Flg_Clr;
   uint8  Tx_SCR_Flg_Clr;
   uint8  Tx_CRC1_Flg_Check;
   uint8  Tx_CRC1_Flg_Clr;
   uint8  Tx_CRC0_Flg_Check;
   uint8  Tx_CRC0_Flg_Clr;
   uint8  Tx_NTR_Flg_SF;
   uint8  Tx_TCSRC_Flg_BC;
   uint8  Tx_TCSRC_Flg_Misc;
  uint8  Tx_MBOX_RW_Flg;
   uint8  Tx_GARB_BLK_DEC_Flg ;
   uint8  Tx_GARB_BLK_INC_Flg ;
   uint8  Tx_GARB_BYTE_Flg;

// CRC
   uint32 Tx_CRC_Accum[2];
   uint32 Tx_CRC_Poly[2];
   uint16 Tx_CRC_Err_Cnt[2];
   uint8  Tx_CRC_Len[2];
   uint8  Tx_CRC_In_Brev[2];

// SCR
   uint32 Tx_SCR_Accum;
   uint32 Tx_SCR_Poly;
   uint8  Tx_SCR_Len;
   uint32 Tx_SCR_State;

// ALU
   uint8  Tx_ALU_Client_Valid;
   uint8  Tx_ALU_Curr_Client;
   uint8  Tx_ALU_MSB_Valid;
   uint8  Tx_ALU_MSB_Data;
   uint32 Tx_ALU_Result;
  uint32 Tx_ALU_Cli_Req;

// DTB
   uint8  Tx_DTB_LPBK;
   uint16 Tx_DTB_Size;
   uint16 Tx_DTB_Base;
   uint16 Tx_DTB_WAD;
   uint16 Tx_DTB_RAD;

// ILVB
   uint32 Tx_ILVB_WRAD;
   uint32 Tx_ILVB_RDAD;
   uint32 Tx_ILVB_WRPTR;
   uint32 Tx_ILVB_RDPTR;

// FIFO
   uint16 Tx_FIFO_Size[4];
   uint32 Tx_FIFO_Base[4];
   uint8  Tx_FIFO_Full[4];
   uint8  Tx_FIFO_Stack_Mode[4];
   uint16 Tx_FIFO_RDPTR[4];
   uint16 Tx_FIFO_WRPTR[4];
   uint8  Tx_FIFO_Step[4];
   uint8  Tx_FIFO_Wrap[4];
   uint8  Tx_FIFO_Cnst[4];
  uint8  Tx_FIFO_Stall[4];

// ILV Config
   uint8  Tx_Has_Dummy_Byte;
   uint8  Tx_EFF_Dis[2];
   uint16 Tx_LP0_Pre_FC;
   uint8  Tx_FIFO_EXT;
   uint8  Tx_isILVorDILV[2];
   uint8  Tx_ILV_TYPE[2];
   uint8  Tx_ILV_I[2];
   uint8  Tx_PmsStep[2];
   uint8  Tx_PmdStep[2];
   uint32 Tx_Max_Fullness[2];
   uint32 Tx_Min_Fullness[2];
   uint16 Tx_D_Shadow_LP ;
   uint16 Tx_D[2];
   uint32 Tx_ILV_Base[2];
   uint32 Tx_ILV_Size[2];        //new
   uint16 Tx_ILV_PmsCntrsMsb[2];//new
   uint32 Tx_ILV_PmsCntrs[2];//new
   uint16 Tx_ILV_PmdCntrsMsb[2];//new
   uint32 Tx_ILV_PmdCntrs[2];//new
   uint32 Tx_ILV_FullnessCntr[2];//new

   uint32 Tx_IBLK_Base; // rep28 not used?
   uint32 Tx_ILV_Limit;
   uint8  Tx_Shalf_Ctl;
   uint16 Tx_Row_Width;
   uint16 Tx_DMax;
   uint16 Tx_IBLK_Trans_Cnt;
   uint16 Tx_ILV_Bytes;

// DCID
   uint8  Tx_DCID_K;
   uint8  Tx_DCID_Z;
   uint8  Tx_DCID_Pending;
   uint8  Tx_Dummies_Last;
   uint8  Tx_Last_FIFO_Valid;
   uint16 Tx_D_Lower;
   uint16 Tx_DCID_PTR_Iover2;
   uint16 Tx_DCID_GL_Ptr;

// PMD FIFO
   uint16 Tx_PMD_D_Lower_FIFO_Delay;
   uint16 Tx_PMD_FIFO_Delay;
   uint16 Tx_PMD_DMAX_FIFO_Delay_Num;
   uint16 Tx_PMD_D_Lower_FIFO_Delay_Num;

// PMS Counters
   uint16 Tx_PMS_DMAX_FIFO_Delay;
   uint16 Tx_PMS_DMAX_FIFO_Delay_Num;
   uint32 Tx_PMS_Base_Ptr;
   uint8  Tx_PMS_FIFO;
   uint16 Tx_PMS_Ptr_Iover2;
   uint16 Tx_PMS_GL_Ptr;

// PMD Counters
   uint16 Tx_PMD_DMAX_FIFO_Delay;
   uint32 Tx_PMD_Base_Ptr;
   uint8  Tx_PMD_FIFO;
   uint16 Tx_PMD_Ptr_Iover2;
   uint16 Tx_PMD_GL_Ptr;

// ILV Data State
   uint32 Tx_ILV_DATAI_State;
   uint32 Tx_ILV_WR0_State;
   uint32 Tx_ILV_WR1_State;
   uint32 Tx_ILV_DATAO_State;
   uint32 Tx_ILV_RD0_State;
   uint32 Tx_ILV_RD1_State;

// Checkbyte
   uint8  Tx_CheckByte[16];

// TCSRC
   uint32 Tx_TCSRC_State;

// UPROC
   uint8  Tx_UPROC_Ena[10];
   uint16 Tx_UPROC_Base[10];
   uint8  Tx_UPROC_Int_Stat[10];

  t_code_engine TxCodeEngine[NUM_CODE_ENGINE];
  t_fifo        Tx_FIFO[NUM_ENGINE];
} t_ZepTxRegisters;


/**********************************************************************
 * Receive Registers                                                  *
 **********************************************************************/

typedef struct {
// General purpose registers
   uint32 Rx_REG0;
   uint32 Rx_REG1;
   uint32 Rx_REG2;
   uint32 Rx_REG3;

// Codeword
   uint8  Rx_SymbolsPerCW;
   uint8  Rx_CheckByteSize;
   uint8  Rx_KP_Val;
   uint8  Rx_CWSize;

// VBC_size
      uint16 Rx_BC1_Bytes;
   uint16 Rx_BC0_Bytes;

// Frame_Idx
   uint8  Rx_OHSwitch;
   uint8  Rx_Tp;
   uint16 Rx_MaxFrameIndex;

// OHRate
   uint8  Rx_OH1Rate;
   uint8  Rx_OH2Rate;
   uint16 Rx_Max_OH;

// Flag Control
   uint8  Rx_ILVB_Flg_Ptr;
   uint8  Rx_DTB_Flg_Inc;
   uint8  Rx_DTB_Flg_Clr;
   uint8  Rx_SCR_Flg_Clr;
   uint8  Rx_CRC1_Flg_Check;
   uint8  Rx_CRC1_Flg_Clr;
   uint8  Rx_CRC0_Flg_Check;
   uint8  Rx_CRC0_Flg_Clr;
   uint8  Rx_TCSNK_Flg_BC;
   uint8  Rx_TCSNK_Flg_Misc;
   uint8  Rx_RSDEC_Flg_Uncorr;
  uint8  Rx_MBOX_RW_Flg;
   uint8  Rx_GARB_BLK_DEC_Flg ;
   uint8  Rx_GARB_BLK_INC_Flg ;
   uint8  Rx_GARB_BYTE_Flg;


// CRC
   uint32 Rx_CRC_Accum[2];
   uint32 Rx_CRC_Poly[2];
   uint16 Rx_CRC_Err_Cnt[2];
   uint8  Rx_CRC_Len[2];
   uint8  Rx_CRC_In_Brev[2];

// SCR
   uint32 Rx_SCR_Accum;
   uint32 Rx_SCR_Poly;
   uint8  Rx_SCR_Len;
   uint32 Rx_SCR_State;

// ALU
   uint8  Rx_ALU_Client_Valid;
   uint8  Rx_ALU_Curr_Client;
   uint8  Rx_ALU_MSB_Valid;
   uint8  Rx_ALU_MSB_Data;
   uint32 Rx_ALU_Result;
  uint32 Rx_ALU_Cli_Req;

// DTB
   uint8  Rx_DTB_LPBK;
   uint16 Rx_DTB_Size;
   uint16 Rx_DTB_Base;
   uint16 Rx_DTB_WAD;
   uint16 Rx_DTB_RAD;

// ILVB
   uint32 Rx_ILVB_WRAD;
   uint32 Rx_ILVB_RDAD;
   uint32 Rx_ILVB_WRPTR;
   uint32 Rx_ILVB_RDPTR;

// FIFO
   uint16 Rx_FIFO_Size[4];
   uint32 Rx_FIFO_Base[4];
   uint8  Rx_FIFO_Full[4];
   uint8  Rx_FIFO_Stack_Mode[4];
   uint16 Rx_FIFO_RDPTR[4];
   uint16 Rx_FIFO_WRPTR[4];
   uint8  Rx_FIFO_Step[4];
   uint8  Rx_FIFO_Wrap[4];
   uint8  Rx_FIFO_Cnst[4];
   uint8  Rx_FIFO_Stall[4];

// ILV Config
// uint32 Tx_IBLK_Base; // rep28 not used?
   // ILV Config
   uint8  Rx_Has_Dummy_Byte;
   uint8  Rx_EFF_Dis[2];
   uint16 Rx_LP0_Pre_FC;
   uint8  Rx_FIFO_EXT;
   uint8  Rx_isILVorDILV[2];//new
   uint8  Rx_ILV_TYPE[2];
   uint8  Rx_ILV_I[2];
   uint8  Rx_PmsStep[2];
   uint8  Rx_PmdStep[2];//new
   uint32 Rx_Max_Fullness[2];
   uint32 Rx_Min_Fullness[2];
   uint16 Rx_D_Shadow_LP ;
   uint16 Rx_D[2];
   uint32 Rx_ILV_Base[2];
   uint32 Rx_ILV_Size[2];        //new
   uint16 Rx_ILV_PmsCntrsMsb[2];//new
   uint32 Rx_ILV_PmsCntrs[2];//new
   uint16 Rx_ILV_PmdCntrsMsb[2];//new
   uint32 Rx_ILV_PmdCntrs[2];//new
   uint32 Rx_ILV_FullnessCntr[2];//new
   uint32 Rx_IBLK_Base;
   uint32 Rx_ILV_Limit;
   uint8  Rx_Shalf_Ctl;
   uint16 Rx_Row_Width;
   uint16 Rx_DMax;
   uint16 Rx_IBLK_Trans_Cnt;
   uint16 Rx_ILV_Bytes;
// DCID
   uint8  Rx_DCID_K;
   uint8  Rx_DCID_Z;
   uint8  Rx_DCID_Pending;
   uint8  Rx_Dummies_Last;
   uint8  Rx_Last_FIFO_Valid;
   uint16 Rx_D_Lower;
   uint16 Rx_DCID_PTR_Iover2;
   uint16 Rx_DCID_GL_Ptr;

// PMD FIFO
   uint16 Rx_PMD_D_Lower_FIFO_Delay;
   uint16 Rx_PMD_FIFO_Delay;
   uint16 Rx_PMS_DMAX_FIFO_Delay_Num;
   uint16 Rx_PMD_DMAX_FIFO_Delay_Num;
   uint16 Rx_PMD_D_Lower_FIFO_Delay_Num;

// PMS Counters
   uint16 Rx_PMS_DMAX_FIFO_Delay;
   uint32 Rx_PMS_Base_Ptr;
   uint8  Rx_PMS_FIFO;
   uint16 Rx_PMS_Ptr_Iover2;
   uint16 Rx_PMS_GL_Ptr;

// PMD Counters
   uint16 Rx_PMD_DMAX_FIFO_Delay;
   uint32 Rx_PMD_Base_Ptr;
   uint8  Rx_PMD_FIFO;
   uint16 Rx_PMD_Ptr_Iover2;
   uint16 Rx_PMD_GL_Ptr;

// ILV Data State
   uint32 Rx_ILV_DATAI_State;
   uint32 Rx_ILV_WR0_State;
   uint32 Rx_ILV_WR1_State;
   uint32 Rx_ILV_DATAO_State;
   uint32 Rx_ILV_RD0_State;
   uint32 Rx_ILV_RD1_State;

// ILV D and L
   uint8  Rx_D_MOD_I;
   uint16 Rx_D_DIV_L;
   uint16 Rx_D_MOD_L;
   uint16 Rx_I_DIV_L;
   uint16 Rx_I_MOD_L;

// DMetric
   uint16 Rx_Lp_Bits;
   uint16 Rx_DMetric_RDBase0;
   uint16 Rx_DM_IBLK_Base_Offset0;
   uint8  Rx_Symbol_Cross_OP;
   uint8  Rx_Next_Iblk_Sc_Metric;

// CW Counter
   uint16 Rx_CW_Count;

// FEC
   uint16 Rx_FEC_Corr;
   uint16 Rx_FEC_UnCorr;
   uint32 Rx_Uncorr_CW0_31;
   uint32 Rx_Uncorr_CW32_63;

// WB Score
   uint8  Rx_Use_Max_Soln;
   uint8  Rx_Err_Met_Cnst;
   uint8  Rx_Eras_Met_Cnst;
   uint8  Rx_No_WB_Score;
   uint8  Rx_Bypass_Metric;
   uint16 Rx_Score1;
   uint16 Rx_Score2;

// RS Decoder
   uint32 Rx_RSDEC_State;

// UPROC
   uint8  Rx_UPROC_Ena[10];
   uint16 Rx_UPROC_Base[10];
   uint8  Rx_UPROC_Int_Stat[10];
   uint32 Rx_UPROC_State[10][6];

  t_code_engine RxCodeEngine[NUM_CODE_ENGINE];
  t_fifo        Rx_FIFO[NUM_ENGINE];
} t_ZepRxRegisters;

// Transmit path attributes.
typedef struct {
  uint16 TxFramerByteCnt[NUM_LP];
  uint16 TxSMState[NUM_LP];
  uint8 DmtTxPathState[NUM_LP];
  uint8 VdslTxState[NUM_LP];
  uint16 Tx_Bis_TotalOHCnt[NUM_LP];
  uint16 Tx_Bis_OHCnt[NUM_LP];
  uint16 TxVBCSize[NUM_BC];
  uint16 TxCurrentCodewordSize[NUM_LP];
  FlagT TxFirstIdxInc[NUM_LP];
  uint8 TxAexLexIndex[NUM_LP];
  uint16 TxFrameNumber[NUM_LP];
} ZEP_FC_TxPath_t;


// Receive path attributes.
typedef struct {
  uint16 RxFramerByteCnt[NUM_LP];
  uint16 RxSMState[NUM_LP];
  uint8 DmtRxPathState[NUM_LP];

  uint8 VdslRxState[NUM_LP];
  uint16 Rx_Bis_TotalOHCnt[NUM_LP];
  uint16 Rx_Bis_OHCnt[NUM_LP];
  uint16 RxVBCSize[NUM_BC];
  uint16 RxCurrentCodewordSize[NUM_LP];
  FlagT RxFirstIdxInc[NUM_LP];
  int16 RxSkipCrcAccumulation[NUM_LP];
  uint16 RxCurrentKIndex[NUM_LP];
  uint16 RxFrameNumber[NUM_LP];

} ZEP_FC_RxPath_t;


typedef struct {
   uint8 uc_byte;
   uint8 uc_flag;
   uint8 uc_req;
   uint8 uc_ack;
   uint8 uc_master;
  uint32 ul_req_onehot;
  uint32 ul_ack_onehot;
  uint8 puc_byte[10];
  uint8 puc_flag[10];
} t_interface;

// structure used for ZEP_ILV BM internal registers
typedef struct {

   uint8 uc_pre_FC_RX_PROC_DONE; // internal signal to track rising edge of FC_RX_PROC_DONE
   uint8 uc_int_FC_RX_PROC_DONE[ZEP_ILV_NUM_LP]; // internal signal to latch FC_RX_PROC_DONE

   int16 s_Tx_DT_State; // TX data transfer state
   int16 s_Tx_DT_EnabledLP; // TX latency path enabled for data transfer
   uint8 uc_Tx_DT_Start[ZEP_ILV_NUM_LP]; // TX data transfer initiator
   uint8 uc_Tx_DT_Wait_Cnt[ZEP_ILV_NUM_LP]; // TX data transfer wait count
   uint8 uc_Tx_DT_Busy[ZEP_ILV_NUM_LP]; // TX data transfer busy signal

   uint16 us_Tx_NumFifo[ZEP_ILV_NUM_LP]; // # of FIFO's used in interleaving
   uint8 uc_Tx_DummyByte[ZEP_ILV_NUM_LP]; // dummy byte insertion/extraction indicator, 0 is VDSL mode
   uint16 us_Tx_NumDummyByteWr[ZEP_ILV_NUM_LP]; // # of dummy byte inserted
   uint16 us_Tx_NumDummyByteRd[ZEP_ILV_NUM_LP]; // # of dummy byte extracted

   uint8 uc_Tx_Shalf_Rd; // indicate 1st or 2nd CW read (from ILVB) for S=1/2 mode
   uint8 uc_Tx_Shalf_Wr; // indicate 1st or 2nd CW write (to ILVB) for S=1/2 mode

   int16 s_Rx_DT_State; // RX data transfer state
   int16 s_Rx_DT_EnabledLP; // RX latency path enabled for data transfer
   uint8 uc_Rx_DT_Busy[ZEP_ILV_NUM_LP]; // RX data transfer busy signal

   uint16 us_Rx_NumFifo[ZEP_ILV_NUM_LP]; // # of FIFO's used in deinterleaving
   uint8 uc_Rx_DummyByte[ZEP_ILV_NUM_LP]; // dummy byte insertion/extraction indicator, 0 is VDSL mode
   uint16 us_Rx_NumDummyByteWr[ZEP_ILV_NUM_LP]; // # of dummy byte inserted
   uint16 us_Rx_NumDummyByteRd[ZEP_ILV_NUM_LP]; // # of dummy byte extracted

   uint32 ul_Rx_Raw_Dilvb_Level[ZEP_ILV_NUM_LP]; // 17-bit LEVEL counter, increment on write and decrement on read, can be greater than DILVB size

// New registers added to keep Tx/Rx single-port state machine working
// for multi-port BM
   uint16 us_Tx_Dt_Bytes[ZEP_ILV_NUM_LP]; // # of bytes from ILVB to TxDTB
   uint16 us_Rx_Dt_Bytes[ZEP_ILV_NUM_LP]; // # of bytes from RxDTB to DILVB

} t_ZEP_ILV_BM_Registers;

typedef struct {
   uint8 state;
   uint8 rdwr;
   uint8 addrLow;
   uint8 addrHigh;
   uint8 rdData;
   uint8 wrData;
   uint8 error;
} t_mailbox;

#endif //_ZEP_TYPEDEF_H    Do not add anything below this line.


