//BuildVdslOnlyImage.sc
//
// History
//
//
//11/07/2013 Kannan : Implemented New Memory Layout Type - 2
//         It is common for both VR9 & VRX318.
//         Grep for "XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2"
//
//XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2 (START)
//BOOT LOADER
// boot loader already loaded in the simulator memory at the start of cache
eval gl_StartOfCache = (long)&_StartOfFlash
eval gl_CurImageStart = gl_StartOfCache 
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize


//VDSL CACHE
// attaching vdsl cache
eval gl_CurImageStart = gl_CurImageEnd
file2mem (long*)(*((long*)&gl_CurImageStart)) obj\vcpe\vcpe_cache.bin
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize


// attaching adsl cache
//eval gl_CurImageStart = gl_CurImageEnd
//file2mem (long*)(*((long*)&gl_CurImageStart)) obj\adsl_cpe\adsl_cpe_cache.bin
//eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
//eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize

//UPDATE VDSL CACHE header word offset 33, 34 & 35
// updating loader header entry for VDSL CACHE SIZE
// offset set to beginning of VDSL cache
// size equals vdsl_cache in long words
eval *((long*)(gl_StartOfCache + 33*4)) = (gl_CurImageStart - gl_StartOfCache) //Offset in bytes to beginning of VDSL cache (ARC)
eval *((long*)(gl_StartOfCache + 34*4)) = (gl_CurImageStart - gl_StartOfCache)  //Offset in bytes to beginning of VDSL cache (FW-image)
eval *((long*)(gl_StartOfCache + 35*4)) = (gl_CurImageSize)  //Size in bytes

//UPDATE BAR16 debug memory offset 20
//Memory allocation required in External memory using BAR16, 512K 
// reserved for DSL FW usage.
eval *((long*)(gl_StartOfCache + 20*4)) = (512*1024) //Size in bytes

//VDSL FULL IMAGE
// attaching vdsl image
eval gl_CurImageStart = gl_CurImageEnd
file2mem (long*)(*((long*)&gl_CurImageStart)) obj\vcpe\vcpe_non_cache.bin
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize

//UPDATE VDSL FULL IMAGE header word offset 27, 28 & 29
// updating VDSL header entry of the bootloader swap header table
//Page 4: Offset in bytes to beginning of VDSL image (ARC), i.e offset from 0x80000
eval *((long*)(gl_StartOfCache + 27*4)) = ((((gl_CurImageStart - gl_StartOfCache)/(64*1024))+1) * 64*1024) //(gl_CurImageStart - gl_StartOfCache)
//Page 4: Offset in bytes to beginning of VDSL image (FW-image)
eval *((long*)(gl_StartOfCache + 28*4)) = (gl_CurImageStart - gl_StartOfCache)
eval *((long*)(gl_StartOfCache + 29*4)) = (gl_CurImageSize) //Size in bytes
                                                                 
//XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2 (END)


// updating the size field of the combined image
eval *((long*)gl_StartOfCache) = gl_CurImageEnd - gl_StartOfCache - 8
eval gl_CurImageSize = gl_CurImageEnd - gl_StartOfCache
mem2file &_StartOfFlash gl_CurImageSize   itux_image.bin

exit
