
// boot loader already loaded in the simulator memory at the start of cache
eval gl_StartOfCache = (long)&_StartOfFlash
eval gl_CurImageStart = gl_StartOfCache 
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize



// attaching vdsl cache
eval gl_CurImageStart = gl_CurImageEnd
file2mem (long*)(*((long*)&gl_CurImageStart)) obj\vcpe\vcpe_cache.bin
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize




// attaching adsl cache
eval gl_CurImageStart = gl_CurImageEnd
file2mem (long*)(*((long*)&gl_CurImageStart)) obj\adsl_cpe\adsl_cpe_cache.bin
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize

// updating loader header entry for RESIDENT-CACHE SIZE
// offset set equals to 0 - beginning of cache
// size equals to bootloader + vdsl_cache + adsl_cache
eval *((long*)(gl_StartOfCache + 21*4)) = 0
eval *((long*)(gl_StartOfCache + 23*4)) = ((gl_CurImageEnd - gl_StartOfCache)/4)



// attaching vdsl image
eval gl_CurImageStart = gl_CurImageEnd
file2mem (long*)(*((long*)&gl_CurImageStart)) obj\vcpe\vcpe_non_cache.bin
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize

// updating VDSL header entry of the bootloader swap header table
eval *((long*)(gl_StartOfCache + 9*4)) = (gl_CurImageStart - gl_StartOfCache)
eval *((long*)(gl_StartOfCache + 11*4)) = (gl_CurImageSize/4)
                                                                  



// attaching adsl image
eval gl_CurImageStart = gl_CurImageEnd
file2mem (long*)(*((long*)&gl_CurImageStart)) obj\adsl_cpe\adsl_cpe_non_cache.bin
eval gl_CurImageSize = *((long*)gl_CurImageStart) + 8
eval gl_CurImageEnd = gl_CurImageStart + gl_CurImageSize

// updating ADSL header entry of the bootloader swap header table
eval *((long*)(gl_StartOfCache + 15*4)) = (gl_CurImageStart - gl_StartOfCache)
eval *((long*)(gl_StartOfCache + 17*4)) = (gl_CurImageSize/4)
                                                                  



// updating the size field of the combined image
eval *((long*)gl_StartOfCache) = gl_CurImageEnd - gl_StartOfCache - 8
eval gl_CurImageSize = gl_CurImageEnd - gl_StartOfCache
mem2file &_StartOfFlash gl_CurImageSize   obj\vcpe\adsl_vdsl_cpe.bin

exit
