@echo off
rem **COPYRIGHT*****************************************************************
rem    INTEL CONFIDENTIAL
rem    Copyright (C) 2017 Intel Corporation
rem *****************************************************************COPYRIGHT**
rem **DISCLAIMER****************************************************************
rem  The source code contained or described herein and all documents related
rem  to the source code ("Material") are owned by Intel Corporation or its
rem  suppliers or licensors. Title to the Material remains with Intel
rem  Corporation or its suppliers and licensors. The Material may contain
rem  trade secrets and proprietary and confidential information of Intel
rem  Corporation and its suppliers and licensors, and is protected by
rem  worldwide copyright and trade secret laws and treaty provisions. No part
rem  of the Material may be used, copied, reproduced, modified, published,
rem  uploaded, posted, transmitted, distributed, or disclosed in any way
rem  without Intel's prior express written permission.
rem
rem  No license under any patent, copyright, trade secret or other
rem  intellectual property right is granted to or conferred upon you by
rem  disclosure or delivery of the Materials, either expressly, by
rem  implication, inducement, estoppel or otherwise. Any license under
rem  such intellectual property rights must be express and approved by
rem  Intel in writing.
rem ****************************************************************DISCLAIMER**
@echo on
@echo off

rem         build a Modem executable with codeswapping for the ARC/ASIM, CO/CPE
rem         depeding on the command line arguments

rem         This bat file must run with two arguments
rem             First argument could be either (arc/ARC, asim/ASIM)
rem             Second argument coudl be either (co/CO, cpe/CPE)
rem         An example is:    
rem             build_vdsl.bat arc cpe

rem         if the build is successful, the following files are created/updated:
rem         obj\itux_asim/arc.out        - the executable image
rem         obj\itux\"swap_page".out     - the executable swap pages
rem         make_rls\itux\*.rls               - all rule files
rem         make_uflags\itux\*.uf             - make input files
rem         make_inputs\*.src,*.inc      - make input files
rem         obj\itux\*.o, *.a                 - object files and archives
rem         asm\itux\*.s                      - asm listing of corresponding C files
rem         map\vco/vcpe_asim/arc.map    - memory map of the *.out image
rem         link_report.log              - PM cross reference report
rem         far_calls_report.log         - report of far calls to functions in MAIN

@setlocal




:CheckCrossBuild
@echo set TARGET_OPT=%TARGET_OPT%> .temp_build_info.txt
@echo set ITUX_OPT=%ITUX_OPT%>> .temp_build_info.txt
@echo set EXTRA_COMPILER_OPTIONS=%EXTRA_COMPILER_OPTIONS%>> .temp_build_info.txt
@echo set CUSTOMER_BLD=%CUSTOMER_BLD%>> .temp_build_info.txt
@echo set ARC_OPT=%ARC_OPT%>> .temp_build_info.txt

if not exist .%ITUX_FILE%_build_info.txt goto BuildStart

fc .temp_build_info.txt .%ITUX_FILE%_build_info.txt
if %ERRORLEVEL% NEQ 0 (
    ..\arc_bld_62\gmake_3.80.exe -f ..\arc_bld_62\vdsl_modem.mak CLEAN_ALL_EXCEPT_IMAGES
)


:BuildStart
move .temp_build_info.txt .%ITUX_FILE%_build_info.txt

rem
rem /**** use gendate utility to create timestmp.c *****/
rem
@if "%SKIP_BUILD_TIMESTAMP%" == "" (
    @if exist timestmp1.c attrib timestmp1.c -r
    @if exist timestmp1.c del timestmp1.c
    @if exist ..\arc_src\platform\timestmp.c attrib ..\arc_src\Platform\timestmp.c -r
    @if exist ..\arc_src\platform\timestmp.c del ..\arc_src\Platform\timestmp.c 
    ..\arc_bld_62\gendate
    copy ..\arc_src\platform\timestmpheader.c ..\arc_src\platform\timestmp.c
    @type timestmp1.c >> ..\arc_src\platform\timestmp.c
    @del timestmp.c
)

@echo on


@if exist %ITUX_FILE%_%TARGET_FILE%.log del %ITUX_FILE%_%TARGET_FILE%.log
@if exist obj\%ITUX_FILE%_%TARGET_FILE%.out del obj\%ITUX_FILE%_%TARGET_FILE%.out 
@if exist obj\%ITUX_FILE%_%TARGET_FILE%.a del obj\%ITUX_FILE%_%TARGET_FILE%.a 

:UpdateSrcInc
..\arc_bld_62\gmake_3.80.exe  -f ..\arc_bld_62\vdsl_modem.mak UPDATE_SRC_INC
@if errorlevel 1 goto UPDATE_SRC_INC_FAIL

call perl ..\arc_bld_62\perl\sleep.pl 3

:SetUpCodeSwap
..\arc_bld_62\gmake_3.80.exe  -f ..\arc_bld_62\vdsl_modem.mak SET_UP_CODESWAP
@if errorlevel 1 goto SET_UP_CODESWAP_FAIL

call perl ..\arc_bld_62\perl\sleep.pl 3

:CheckSourceTimeStampsForceRebuild
..\arc_bld_62\gmake_3.80.exe  -f ..\arc_bld_62\vdsl_modem.mak CHECK_SOURCE_TIMESTAMPS FORCE_REBUILD=1
@if %ERRORLEVEL% NEQ 0 goto UPDATE_SOURCE_TIMESTAMPS_FAIL

perl ..\arc_bld_62\perl\sleep.pl 3

..\arc_bld_62\gmake_3.80.exe  -f ..\arc_bld_62\vdsl_modem.mak UPDATE_ALL_RLS
@if errorlevel 1 goto RLS_FAIL_UPDATE

call perl ..\arc_bld_62\perl\sleep.pl 3

:UpdateSourceTimeStamps
..\arc_bld_62\gmake_3.80.exe  -f ..\arc_bld_62\vdsl_modem.mak CHECK_SOURCE_TIMESTAMPS FORCE_REBUILD=0
@if %ERRORLEVEL% NEQ 0 goto UPDATE_SOURCE_TIMESTAMPS_FAIL

perl ..\arc_bld_62\perl\sleep.pl 3

..\arc_bld_62\gmake_3.80.exe  -f ..\arc_bld_62\vdsl_modem.mak CODESWAP_MODEM > %ITUX_FILE%_%TARGET_FILE%.log
@if errorlevel 1 goto BUILD_MODEM_FAIL
@if not exist obj\%ITUX_FILE%\%ITUX_FILE%_%TARGET_FILE%.out goto BUILD_MODEM_FAIL


:SUCCESSFUL_BUILD
@echo     ***
@echo     ************ SUCCESSFULLY BUILT %ITUX_FILE%_%TARGET_FILE%.out ************
@echo     ***
@dir obj\%ITUX_FILE%\%ITUX_FILE%_%TARGET_FILE%.out
@dir obj\%ITUX_FILE%\%ITUX_FILE%_%TARGET_FILE%.bin

REM build simext.dll
if /I "%TARGET_FILE%"=="asim" call .\build_simext.bat
@echo  ...  
@echo  ... 

@goto BUILD_MODEM_EXIT

:FAIL_TO_CLEAN:
    @echo             "******************************"
    @echo             "**** FAIL TO CLEAN         ***"
    @echo             "******************************"
    @goto BUILD_MODEM_EXIT_FAIL

:UPDATE_SRC_INC_FAIL
    @echo             "******************************"
    @echo             "**** UPDATE_SRC_INC FAILED ***"
    @echo             "******************************"
    @goto BUILD_MODEM_EXIT_FAIL

:SET_UP_CODESWAP_FAIL
    @echo             "*******************************"
    @echo             "**** SET_UP_CODESWAP FAILED ***"
    @echo             "*******************************"
    @goto BUILD_MODEM_EXIT_FAIL

:RLS_FAIL_UPDATE
    @echo             "******************************"
    @echo             "***** UPDATE_RLS FAILED    ***"
    @echo             "******************************"
    @goto BUILD_MODEM_EXIT_FAIL

:CHECKSUM_FAIL
    @echo             "******************************"
    @echo             "***** CHECKSUM FAILED      ***"
    @echo             "******************************"
    @goto BUILD_MODEM_EXIT_FAIL

:BUILD_MODEM_FAIL
    @echo             "********************************"
    @echo             "*** BUILD MODEM IMAGE FAILED ***"
    @echo             "********************************"
    @goto BUILD_MODEM_EXIT_FAIL

:UPDATE_SOURCE_TIMESTAMPS_FAIL
    @echo             "********************************"
    @echo             "*** CHECK TIMESTAMPS FAILED  ***"
    @echo             "********************************"
    @goto BUILD_MODEM_EXIT_FAIL

:BUILD_MODEM_EXIT_FAIL
@EXIT /B 1

:BUILD_MODEM_EXIT

