# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
MEMORY {
//***********************************************************
//***************** Customer Swap pages *********************
// Attention! These pages are not fragmented in 4k blocks !!!!

   // IFX Overlays
   //Resident Memory
   CUST_MAIN_IRAM:    ORIGIN = ADDR(CUST_IRAM), LENGTH = SIZEOF(CUST_IRAM)
    // once we optimized the resident IRAM, we'll try to make this common with 50 version

   //Codeswap Memory for config 2
   CUST_ISWAP_CUST_2:    ORIGIN = ADDR(CUST_MAIN_IRAM) + SIZEOF(CUST_MAIN_IRAM), LENGTH = 0
   

   //Codeswap Memory showtime / reset
   CUST_ISWAP_STEADY_RESET:    ORIGIN = ADDR(CUST_ISWAP_CUST_2) + SIZEOF(CUST_ISWAP_CUST_2), LENGTH = 0

//***********************************************************
//***********************************************************

            __CUST_IBRAM__ :   ORIGIN = ADDR(CUST_IBRAM), LENGTH = SIZEOF(CUST_IBRAM)

        __CUST_MAIN_ISWAP__:    ORIGIN = ADDR(CUST_MAIN_IRAM),     LENGTH = SIZEOF(CUST_MAIN_IRAM)
        __CUST_2_ISWAP__:        ORIGIN = ADDR(CUST_ISWAP_CUST_2), LENGTH = SIZEOF(CUST_ISWAP_CUST_2)
        __CUST_RESET_ISWAP__:    ORIGIN = ADDR(CUST_ISWAP_STEADY_RESET), LENGTH = SIZEOF(CUST_ISWAP_STEADY_RESET)
        __CUST_STEADY_ISWAP__:   ORIGIN = ADDR(CUST_ISWAP_STEADY_RESET), LENGTH = SIZEOF(CUST_ISWAP_STEADY_RESET)
        __CUST_TEST_ISWAP__:    ORIGIN = ADDR(CUST_ISWAP_CUST_2), LENGTH = SIZEOF(CUST_ISWAP_CUST_2)
}

SECTIONS {

   // Only present in reset state
   GROUP LOAD((ADDR(VCPE_CUST_RESET_FADX_PM_BT))): {

      .PMSWAP_VCPE_CUST_RESET ALIGN(4): {

      }
   } > __CUST_RESET_ISWAP__


   // Only present in showtime
   GROUP LOAD((ADDR(VCPE_CUST_STEADY_FADX_PM))): {
      .PMSWAP_VCPE_CUST_STEADY ALIGN(4): {

      }
   } > __CUST_STEADY_ISWAP__

   GROUP LOAD((ADDR(VCPE_CUST_TEST_FADX_PM))): {
      .PMSWAP_VCPE_CUST_TEST ALIGN(4): {
#ifndef VDSL_62
            // These files are moved to SLEEP page
            DmtScope_MsgHandler.o(.text*)
            DmtScope_PsdMeasure.o(.text*)
            PsdMeasHold_loop.o(.text*)
#endif
      }
   } > __CUST_TEST_ISWAP__  


   // Config 2: Utopia, POS-PHY, ATM
   GROUP LOAD((ADDR(VCPE_CUST_2_FADX_PM_BT))): {
      .PMSWAP_VCPE_CUST_2 ALIGN(4): {

      }
   } > __CUST_2_ISWAP__


   // Resident (always present)
   GROUP LOAD((ADDR(VCPE_CUST_MAIN_FADX_PM_BT))): {

      .PMSWAP_VCPE_CUST_MAIN ALIGN(4): {
        afe_io.o(.text*)
        #ifdef VRX518
    		AFED_ReadWriteModify.o(.text*)
    		AFED_LineDriverConfig.o(.text*)
        #else	
			// VR9_AFE
            AfeRdWrite.o(.text*)
            SetLDMode.o(.text*)
			ThreeGLP_status.o(.text*)
		#endif
            // Init_POFIPOCO.o(.text*)           // moved to CACHE page
            // the reset of VR9_AFE files are in CACHE page
            // end VR9 AFE

            CustomerTasks.o(.text*)
            xTC_VersionInfo.o(.text*)
            xTC_DebugMsgHandler.o(.text*)
      }
   } > __CUST_MAIN_ISWAP__


   // Data memory (should contain all files)
   GROUP LOAD((ADDR(VCPE_CUST_IBRAM_FADX_DM_BT))): {
      .DMSWAP_VCPE_CUST_IBRAM ALIGN(4) : {
            afe_io.o(.data*, .bss)      
        #ifdef VRX518
            AFED_AnalogRegInit.o(.data*, .bss)
            AFED_ReadWriteModify.o(.data*, .bss)            
            AFED_LineDriverConfig.o(.data*, .bss)   
            AFED_FilterTune.o(.data*, .bss)
            AFED_EfuseCopy.o(.data*, .bss)
            AFED_RcMeasure.o(.data*, .bss)
            AFED_PofiPocoConfg.o(.data*, .bss)	    	                
        #else
            AfeRdWrite.o(.data*, .bss)
            SetLDMode.o(.data*, .bss)
            AFE_ModeSelection.o(.data*, .bss)
            AdcTrimming.o(.data*, .bss)
            Init_POFIPOCO.o(.data*, .bss)

            InitAFEPowerUp.o(.data*, .bss)
            *GLP_Interface.o(.data*, .bss)
            AfeAnalogRegInit.o(.data*, .bss)
            AfeDigitalRegInit.o(.data*, .bss)
            FilterTune.o(.data*, .bss)
            VR9_EfuseCopy.o(.data*, .bss)
            RC_Measure.o(.data*, .bss)
            ThreeGLP_status.o(.data*, .bss)            
          #endif
          
            DmtScope_MsgHandler.o(.data*, .bss)
            DmtScope_PsdMeasure.o(.data*, .bss)

            CustomerTasks.o(.data*, .bss)
            xTC_VersionInfo.o(.data*, .bss)
            xTC_DebugMsgHandler.o(.data*, .bss)
            xTC_VersionInfo_Init.o(.data*, .bss)

            *(.CUST_IBRAM)
      }
   } > __CUST_IBRAM__
}
