# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
// ***********************************************************************************************************
// vcpe_inputs.cmd
//
// History
//
// 10/07/2012 Vinjam: Added code to add data buffers in TWO_PORT_SHOW_ONLY section.
//                     Grep for XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise
//
// 07/11/2012 Kannan:
// VRX318 specific changes:
// (1) Introduced 2 new code swap pages for VRX318 to keep the
// functions which was available in cache at VR9.
// (i)Page "VCPE_CACHE_INIT_1PORT_FADX_PM_BT" to keep AFE related initialization
// functions. (ii) Page "VCPE_CACHE_TRN_1PORT_FADX_PM_BT" to keep training and showtime related functions.
// (2) Moved the functions from cache to newly introduced  code swap pages
// (3) For VRX318 "CACHE" is equivalent to  PDBRAM.
// (4) Total memory size of PDBRAM is 140K
// (5) CACHE_1 page is allowed to use 96K of PDBRAM, this memory is fully available for VRX318
// (6) CACHE_2 page is allowed to use upto 44K (S_44K) of PDBRAM only during training and in showtime
//     S_44K memory will be used by PPE for data traffic. Hence we should not keep showtime related
//     functions in S_44K memory. Memory Section "ARC_PPE_SHARED_CACHE" is already defined in
//     VRX318_VDSL_CPE_62.mem
// (7) #ifdef VRX318 is used to have VRX318 specific changes and DSL accelerator cores of VRX318
//     is almost the same as in VR9.
// Grep for: "XDSLRTFW-542: Platform_VRX318"
//
//11/07/2013 Kannan : Implemented New Memory Layout Type - 2
//         It is common for both VR9 & VRX318. VRX318 cache memory Max size is limited to 140K, it is due to
//         PDBRAM size limitation.
//         Grep for "XDSLRTFW-1022: Feature_VR9_VRX318_FirmwareNewMemoryLayoutType_2"
//
//19/07/2013 Kannan: Changes to have 2 DM code swap pages for US ReTx micro code
//Grep for "XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx"
//
//17/09/2013 Kannan : VRX318 Platform is not having sufficient Program Memory in CACHE_1 page(PDBRAM)
//       hence moved handshake related fns from CACHE_1 page to CACHE_2 page.
// Note: CACHE_1 page contains both training & showtime related code.
//       CACHE_2 page contains the code which is required for training only.
//       Grep for "XDSLRTFW-1220: Feature_US_VDSL2_ALL_UsReTx_VRX318_BuildIssue"
//
//21/10/2013 Varun : Memory optimization as a part of Amend2. Added TRAIN_ILV_DILV_TRAINING_ONLY data ovelay section
//                   Grep for XDSLRTFW-1287 Feature_US_VDSL2_ALL_UsReTxAmend2_MemoryOpt
//
//29/10/2013 Kannan : VRX318 Platform is not having sufficient Program Memory in CACHE_1 page(PDBRAM)
//       hence moved G.vector related fns from CACHE_1 page to didicated ONE_PORT_SHOW memory page,
//       which is common for both VR9 & VRX318.
//       Grep for "XDSLRTFW-1288 Feature_US_VDSL2_ALL_UsReTxAmend2_MemoryOpt"
//
//01/11/2013 Ram: Moved tx_eoc_init.o and rx_eoc_init.o to VDSL_CACHE_2 for VRX318 build due to lack of memory in
//                VDSL_CACHE section.
//                Moved profile.o to ONE_PORT_MAIN_ISWAP due to lack of memory in MAIN_ISWAP section
//
//28/11/2013 Sooraj: Support for PERSISTENT MEMORY for ADSL mode, by introducing PERSISTENT_MEM_ADSL section of 512 bytes
//                   Created a seperate memory section PERSISTENT_MEM_VDSL to support PERSISTENT memory of VDSL mode.
//                   Created a seperate memory section PERSISTENT_MEM_COMMON to support PERSISTENT common memory for ADSL and VDSL mode.
//
//22/01/2014 Vinjam: Free up program memory in "VDSL_CACHE" segment by moving training modules to "VDSL_CACHE_2"
//                   Files moved to VDSL_CACHE2 are as follows:
//                   (i) FormRPmsMsg_VDSL2.o(.text)
//                   (ii) FormPmsMsgs_VDSL2.o(.text)
//                   (iii) InterpOPrmMsg_VDSL2.o(.text)
//                   (iv) FormMsg2.o(.text)
//                   grep for XDSLRTFW-1518
//
//24/01/2014 Vinjam: Free up program memory in "CACHE_TRN_1PORT" segment by moving training modules to "VDSL_CACHE_2".
//                   Files moved to VDSL_CACHE2 are as follows:
//                   (i) InterpOUpdateMsg_VDSL2.o(.text)
//                   (ii) InterpOTAUpdateMsg_VDSL2.o(.text)
//                   (iii) InterpOSignatureMsg_VDSL2.o(.text)
//                   (iv)   InterpOMsg1Msg_VDSL2.o(.text)
//                   grep for XDSLRTFW-1518
//
// 18/09/2014  Palaksha:
//      The FW changes for "XDSLRTFW-1707 Bringup of DS/US Retransmission on 30a profile"
//      In general The changes involve
//      - Memory optimization (Need more memory to support 200Mbps DSNDR /100Mbps USNDR)
//            VRx318 platform : 86K + 12K+ 17K = 115K IlvDilv Memory
//               Moved ThreeGLP_Interface.c(used all the time) from CACHE_INIT_1PORT to ONE_PORT_MAIN_ISWAP
//               Also moved below files(used all the time) from CACHE_TRN_1PORT to ONE_PORT_MAIN_ISWAP
//                  main_hw.o(.text) snr_b.o(.text)    CalcShowtimeSnrMargin.o(.text)   QuickAverage.o(.text)
//                  CACHE_TRN_1PORT contains files which are used only till training ==> this place can be used in showtime as a overlay
//               This got around 12K+17K for ReTx buffer usage
//            VR9    platform : 86K           = 86K IlvDilv Memory
//            So only VRx318 platform can support 200Mpbs DSNDR + Additional 18K buffer 3-needle noise handling
//                     Vector friendly FW binary      Full Vector  FW binary
//                        -----------------         ---------------------
//                           VRx318   VR9              VRx318    VR9
//      Memory Section Name
//      Size in Bytes
//      ST_VECTORING_BUFFER   12800   12800            0         0
//      ONE_PORT_ILV_DILV_HW  88064   88064            88064     88064
//      CACHE_INIT_1PORT      12544   0                12544     0
//      CACHE_TRN_1PORT       22064   0                22064     0
//      Total Memory in Bytes 135472  100864           122672    88064
//      Total Memory in KB    132.30  98.50            119.80    86.00
//      on VRX 318, disabled DEBUG buffer functionality to get around 4k of data memory in addition to above
//      - Indicate Max delay Octet = 121K*2 for Vrx318 and 86K*2 for VR9 ("Field 10 : Octet 11-12-13 of  G.INP R-MSG2  message)
//      - ARC Mips optimization/HW Accelerator time change
//         Since in 30a profile frame rate is 8KHz and it has only 2 Timeslots(32768 ARC cycles will be available),
//         less cylces for ARC/HW accelarators  available in a symbol period.
//         Changed Start time of  Tx FC,Tx QTP, Tx QT and Rx FC and these changes are under bit#6 of test 28 0 CMV and enabled by default
//      - rearranged some functions related to RTXus so that forward DTU function execte early in RXTC
//      - Restricted rate of transfer size to 3438 bytes instead of 4160 bytes on PPE-DSL intreface to reduce PPE buffer overflow.TEST_Control3_Test28_Bit7Mask
//      -  RMSG2_UsNetDataRateMax = 100 mbps
//      - RTXds Framing modifications for 30 Mhz profile
//         So far framing generation tested only for upto 17a profile. For 30a there are additional framing combinations available
//         Need to evaluation these framing for 30a RTXds mode for HW accelerator time constraint(only 32768 cycles in a symbol).
//         More codewords in a symbol will result in more time to complete.
//         Restricting framing combinations(HQV) to have maximum of 7 CWs (HQV index from 15 to 25 are only selected)
//         Also overflow handling in fixed point implementation code in RTX framing generation is done
//      - RTXds parameter handling in 30Mhz profile
//         Roundtrip delay in symbols is double due to higher frame and Roundtrip delay in DTUs is to be taken as is(No doubling)
//      - Change the value "RX_LP_ORDER (Order of processing of Rx latency paths) field in IR_MISC register"
//         from 4 (Lp2 Lp1 Lp0) to 2(Lp0 Lp1 Lp2). With RX_LP_ORDER=4(Lp2 Lp1 Lp0), if the 1st bin in ToT is >8 bits, then even
//         if Lp2 is allocated 0 bits, but HW considers it asactive LP and throws up HW Rx BAT error in CRI register.This is because
//         hardware supports encoding of two latency paths on the same tone. As of now RX_LP_ORDER=2(Lp0 Lp1 Lp2) is being used as an
//         interm solution DS RTX is enabled in 30a profile. If US RTX in 30a to be supported then RX_LP_ORDER=4(Lp2 Lp1 Lp0) setting is needed.
//         In that case we need to have the special handling of 1st tone in ToT. The same problem can also happen on tx path(TX_LP_ORDER) as well.
//         we decided not do change anything we shall use default (Lp2 Lp1 Lp0) ordering. So as a working around testing 30a RTX (us, ds or both)
//         we shall use  OH rate of minimum of 128 kbps (this ensures minimum 16 bits per symbol)
//
//   grep for XDSLRTFW-1707_30a_RTX_DsUs
//
//23/09/2014 Kannan: Created DM code swap page "VCPE_DEC_MEM_16BIT_FADX_DM" to use DEC coefficient memory
//                   for 16 & Bit variables, since DEC in strymon is not being used in VDSL mode.
//                   "VCPE_NOISE_MRGN_SEP_FADX_DM" DM page is created to keep noise margin separation
//                   snr. This memory will be used for NMS for profiles 17a and below,
//                   for 30a with ReTx, NMS memory will be used for ReTx Queue.
//                   Grep for "XDSLRTFW-1979"
//
//23/09/2014 Kannan: Removed unused micro interruption handler function from showtime PM code swap page
//                  (SHOW_1_V2 & SHOW_1). This is done as a part of PM & DM free up activity
//                   Grep for "XDSLRTFW-1979"
//
// 29/10/2014 Anantha Ramu: Added separate code swap pages for Intra DTU interleaving microcode.
//                          Grep for "XDSLRTFW-1617"
//
// 28/03/2014 Anantha Ramu:
//                   Before this modification The variables declared in file vdsl\Modem\source\Vdsl_Task\shared\Vr9_1port_debug_data.c
//                   were not getting initialised to zero after boot up. To initialise varibles to zero after boot up, these variables
//                   are now allocated the memory region VCPE_ONE_PORT_SHOW_ONLY_FADX_DM_BT instead of VCPE_ONE_PORT_SHOW_ONLY_FADX_DM.
//                   When I traced back the history of changes, the variables were earlier allocated to region VCPE_ONE_PORT_SHOW_ONLY_FADX_DM_BT
//                  , but at Mercurial node 1fffef37bfaf variables allocation was changed  to   VCPE_ONE_PORT_SHOW_ONLY_FADX_DM. I could not
//                  get the reason for changing. However,  with the present changes did a loop reah test(FlexIT rate adaptive test BA12A) and test was
//                  successful.
//
// ************************************************************************************************************


// Notes:
// 0. This cmd file only supports #ifdef (#else), #endif pair.
//    Anything else will be considered a syntax error.
//    Nested ifdef's are not supported.
//    These two macros are exclusive: TARGET_HW, TARGET_SIM.
//    However TARGET_ARC will include TARGET_HW
// 1. Sizes in this file are in bytes. 32K reads 32K bytes.
// 2. Naming conventions:
//    a. FADX stands for flash address.
//    b. BT stands for boot
//    c. IBT stands for indirect boot (boot pages that will be loaded from ME/flash/sram
//       into intermediate internal buffer and can't be dma'ed directly to the final
//       destination. Examples are VDSL core mem, X-Y ram, LOCAL_LD_ST mem.
//    d. PM stands for Program memory
//    e  DM stands for Data memory.
//    f. All caps names are memory regions (each of which is associated with a start
//       address and some length. For e.g., LT_PRIM_4K)
//    g. All caps beginning with '.' are memory sections. They are actual blocks of
//       PM or DM to be loaded into memory. (for e.g., .PMSWAP_BIS_T1)
//    h. PMSWAP and DMSWAP signify memory sections that require PM/DM swapping.
//       These usually have associated FADX sections.
//    i. ZBT stands for zero boot (boot pages that will be zeroed out and will not
//       take space in the .bin image file.
// 3. Program memory map looks like:
//
//                |----------------------------------------|   0x00000000
//                |                                        |
//                |                                        |
//                |     MAIN PM (MAIN_IRAM)
//                |                                        |
//                |                                        |
//                |----------------------------------------|
//                |                                        |
//                |                                        |
//                |     SWAP1 BUFFER (ISWAP_32_56)
//                |                                        |
//                |                                        |
//                |----------------------------------------|
//                |                                        |
//                |                                        |
//                |     SWAP2 BUFFER (ISWAP_56_80)
//                |                                        |
//                |                                        |
//                |----------------------------------------|
//
//  4. Notice the round-off is to make each swap page aligns on 4-byte boundary.
//
//  5. When hercules_memrymap.h and hercules_mp.h are changed, this file needs to be
//  reviewed and changed accordingly.
//
//  6. The order of FADX pages are important:
//         o Normal Swap Pages
//         o Boot Pages
//         o Intermediate Boot Pages

#ifdef VRX518
    #include "VRX518_VDSL_CPE_62.mem"
#endif
	
#ifdef VRX318
    #include "VRX318_VDSL_CPE_62.mem"
#endif

#ifdef VRX218
	#include "VDSL_CPE_62.mem"
#endif



MEMORY {
// at loadtime, the simulator will load these swap pages at these addresses. They
// are also the addresses of swap pages in SRAM.


        VDSL_IMAGE_LAYOUT_FADX:     ORIGIN = 0x00400000, LENGTH = SIZEOF(.VDSL_IMAGE_LAYOUT);
      VDSL_IMAGE_CONFIG_0_FADX:     ORIGIN = 0x00400100, LENGTH = 0x700
        VDSL_IMAGE_HEADER_FADX:     ORIGIN = 0x00400800, LENGTH = SIZEOF(.VDSL_IMAGE_HEADER);



//INIT
           VCPE_INIT_2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_INIT_2) + 3)/4)*4;
//GHS
            VCPE_GHS_1_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_GHS_1) + 3)/4)*4;

            VCPE_GHS_2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_GHS_2) + 3)/4)*4;
//TRAIN
       VCPE_TRAIN_MAIN_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_TRAIN_MAIN) + 3)/4)*4;

//VDSL1
          VCPE_TRAIN_1_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_TRAIN_1) + 3)/4)*4;

          VCPE_TRAIN_2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_TRAIN_2) + 3)/4)*4;

           VCPE_ANAL_1_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ANAL_1) + 3)/4)*4;

           VCPE_ANAL_2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ANAL_2) + 3)/4)*4;

           VCPE_ANAL_3_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ANAL_3) + 3)/4)*4;

           VCPE_ANAL_4_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ANAL_4) + 3)/4)*4;

           VCPE_SHOW_1_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_SHOW_1) + 3)/4)*4;

           VCPE_SHOW_2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_SHOW_2) + 3)/4)*4;


// VDSL2
       VCPE_ALGHD_1_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ALGHD_1_V2) + 3)/4)*4;

       VCPE_ALGHD_2_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ALGHD_2_V2) + 3)/4)*4;

       VCPE_ALGHD_3_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ALGHD_3_V2) + 3)/4)*4;

       VCPE_ALGHD_4_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ALGHD_4_V2) + 3)/4)*4;

       VCPE_CHDIS_1_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CHDIS_1_V2) + 3)/4)*4;

       VCPE_TRAIN_1_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_TRAIN_1_V2) + 3)/4)*4;

       VCPE_TRAIN_2_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_TRAIN_2_V2) + 3)/4)*4;

       //XDSLRTFW-2059 : New page added in image for USPSD compensation table
       VCPE_COMP_TABLE_V2_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_COMP_TABLE_V2) + 3)/4)*4;

       VCPE_ANAL_1_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ANAL_1_V2) + 3)/4)*4;

        VCPE_ANAL_4_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ANAL_4_V2) + 3)/4)*4;

        VCPE_ANAL_5_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_ANAL_5_V2) + 3)/4)*4;

        VCPE_SHOW_1_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_SHOW_1_V2) + 3)/4)*4;

        VCPE_SHOW_2_V2_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_SHOW_2_V2) + 3)/4)*4;
//MISC
          VCPE_PRESHOW_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_PRESHOW) + 3)/4)*4;

            VCPE_SLEEP_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_SLEEP) + 3)/4)*4;

            VCPE_DILVB_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_DILVB) + 3)/4)*4;

   //XDSLRTFW-1979  (START) //DM & PM Free up
   //XDSLRTFW-3558 Move Data from DEC memory to Bulk memory

   VCPE_NOISE_MRGN_SEP_FADX_DM:
                       LENGTH = ((SIZEOF(.DMSWAP_VCPE_NMRGN_SEP) + 3)/4)*4;

   VCPE_DEBUG_TRACES_BUFFER_FADX_DM:
                       LENGTH = ((SIZEOF(.DMSWAP_VCPE_DEBUG_TRACES_BUFFER) + 3)/4)*4;

   //XDSLRTFW-1979  (END)  //DM & PM Free up

   VCPE_HYB_COEFS_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_HYB_COEFS) + 3)/4)*4;
VCPE_XILVB_B4_SHOW_INIT_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_XILVB_B4_SHOW_INIT) + 3)/4)*4;

   VCPE_SRC_COEFS_4KHZ_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_SRC_COEFS_4KHZ) + 3)/4)*4;

   VCPE_SRC_COEFS_8KHZ_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_SRC_COEFS_8KHZ) + 3)/4)*4;
                           
#ifdef VRX518			   
   VCPE_SRC_COEFS_35B_RX_FADX_DM:  
			        LENGTH = ((SIZEOF(.DMSWAP_VCPE_SRC_COEFS_35B_RX) + 3)/4)*4;

   VCPE_SRC_COEFS_35B_TX_FADX_DM:
				LENGTH = ((SIZEOF(.DMSWAP_VCPE_SRC_COEFS_35B_TX) + 3)/4)*4;												   
#endif

        VCPE_IIR_COEFS_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_IIR_COEFS) + 3)/4)*4;

     VCPE_TX_LP0_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_TX_LP0_UCODE) + 3)/4)*4;

     VCPE_TX_LP1_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_TX_LP1_UCODE) + 3)/4)*4;
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx(START)
   VCPE_TX_LP0_RETX_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_TX_LP0_RETX_UCODE) + 3)/4)*4;

   VCPE_TX_LP1_RETX_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_TX_LP1_RETX_UCODE) + 3)/4)*4;
//XDSLRTFW-1617 (Start_End)
   VCPE_TX_LP1_RETX_IDILV_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_TX_LP1_RETX_IDILV_UCODE) + 3)/4)*4;
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx(END)
     VCPE_RX_LP0_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_RX_LP0_UCODE) + 3)/4)*4;

     VCPE_RX_LP1_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_RX_LP1_UCODE) + 3)/4)*4;

VCPE_RX_LP1_RETX_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_RX_LP1_RETX_UCODE) + 3)/4)*4;
//XDSLRTFW-1617 (Start_End)
VCPE_RX_LP1_RETX_IDILV_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_RX_LP1_RETX_IDILV_UCODE) + 3)/4)*4;


VCPE_TX_PORT1_LP0_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_TX_PORT1_LP0_UCODE) + 3)/4)*4;

VCPE_TX_PORT1_LP1_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_TX_PORT1_LP1_UCODE) + 3)/4)*4;

VCPE_RX_PORT1_LP0_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_RX_PORT1_LP0_UCODE) + 3)/4)*4;

VCPE_RX_PORT1_LP1_UCODE_FADX_DM:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_RX_PORT1_LP1_UCODE) + 3)/4)*4;

            //-------------------------
            // Customer Swap Pages
            //-------------------------

           VCPE_CUST_1_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CUST_1) + 3)/4)*4;
      VCPE_CUST_STEADY_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CUST_STEADY) + 3)/4)*4;
        VCPE_CUST_TEST_FADX_PM:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CUST_TEST) + 3)/4)*4;


// BOOT PAGES start
       VCPE_INTVECS_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_INTVECS) + 3)/4)*4;
          VCPE_MAIN_FADX_PM_BT:
#ifdef TARGET_HW
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_MAIN) + SIZEOF(.text) + 3)/4)*4;
#else
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_MAIN) + 3)/4)*4;
#endif

#ifdef VECTORING_MEM_LYT
       VCPE_IIBRAM_MAIN_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_IIBRAM_MAIN) + 3)/4)*4;

       VCPE_IIBRAM_SHOW_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_IIBRAM_SHOW) + 3)/4)*4;
#endif

            //-------------------------
            // Customer Boot Pages
            //-------------------------
        VCPE_CUST_2_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CUST_2) + 3)/4)*4;
     VCPE_CUST_MAIN_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CUST_MAIN) + 3)/4)*4;
    VCPE_CUST_RESET_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CUST_RESET) + 3)/4)*4;


          VCPE_MAIN_FADX_DM_BT:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_MAIN) + 3)/4)*4;

    VCPE_HMP_MBOXES_FADX_DM_BT:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_HMP_MBOXES) + 3)/4)*4;

    VCPE_CUST_IBRAM_FADX_DM_BT:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_CUST_IBRAM) + 3)/4)*4;

    VCPE_INIT_1_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_INIT_1) + 3)/4)*4;
#ifdef VRX518
    VCPE_CACHE_TRAIN_1_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CACHE_TRAIN_1) + 3)/4)*4;
#endif

#ifdef (VRX318 || VRX518)
    VCPE_CACHE_TRAIN_2_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CACHE_TRAIN_2) + 3)/4)*4;

    VCPE_CACHE_TRAIN_3_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CACHE_TRAIN_3) + 3)/4)*4;
#endif //#ifdef VRX318

#ifdef VDSL_62
//XDSLRTFW-1661 (Start)
VCPE_ONE_PORT_SHOW_ONLY_FADX_DM_BT:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_ONE_PORT_SHOW_ONLY) + 3)/4)*4;
//XDSLRTFW-1661 (End)
#endif

#ifdef (TARGET_SIM || TARGET_ARC)
       VCPE_SIMTEST_FADX_PM_BT:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_SIMTEST) + SIZEOF(.text) + 3)/4)*4;

       VCPE_SIMTEST_FADX_DM_BT:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_SIMTEST) + 3)/4)*4;
#endif

// ZERO BOOT PAGES start
   VCPE_ILVB_FADX_DM_ZBT:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_ILVB) + 3)/4)*4;

   VCPE_AWRE_IBRAM_FADX_DM_ZBT:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_AWRE_IBRAM) + 3)/4)*4;

   VCPE_X_RAM_FADX_DM_ZBT:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_X_RAM) + 3)/4)*4;

   VCPE_Y_RAM_FADX_DM_ZBT:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_Y_RAM) + 3)/4)*4;

   VCPE_LOCAL_LD_ST_FADX_DM_ZBT:
                           LENGTH = ((SIZEOF(.DMSWAP_VCPE_LOCAL_LD_ST) + 3)/4)*4;

    // off chip page(s)
  VCPE_WRITE_DATA_TO_SRAM_FADX_DM:
                                    LENGTH = 0

#ifdef ALLOW_READ_FROM_SRAM
  // for future implementation of reading SRAM into internal RAM
  VCPE_READ_DATA_FROM_SRAM_FADX_DM:
                                    LENGTH = 0
#endif


   VDSL_CACHE_HEADER_FADX:
                           LENGTH = ((SIZEOF(.VDSL_CACHE_HEADER) + 3)/4)*4;

   VCPE_CACHE_1_FADX:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CACHE_1) + 3)/4)*4;
#ifdef (VRX218 || VRX318)
   VCPE_CACHE_TRAIN_1_FADX:
                           LENGTH = 140K - SIZEOF(VDSL_CACHE_HEADER_FADX) - SIZEOF(VCPE_CACHE_1_FADX) - GET_SIZE_OF(obj\loader_62\loader_62.bin);
#endif                           

#ifdef VRX218
    VCPE_CACHE_TRAIN_2_FADX:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CACHE_TRAIN_2) + 3)/4)*4;

    VCPE_CACHE_TRAIN_3_FADX:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CACHE_TRAIN_3) + 3)/4)*4;

    VCPE_CACHE_VR9_ONLY_FADX:
                           LENGTH = ((SIZEOF(.PMSWAP_VCPE_CACHE_VR9_ONLY) + 3)/4)*4;
#endif

   LAST_FADX:
                           LENGTH = 0

}



// the following are real pages including MAIN, training and showtime pages
SECTIONS {

    GROUP LOAD((ADDR(VCPE_INIT_1_FADX_PM_BT))): {
        .PMSWAP_VCPE_INIT_1 ALIGN(4): {

            .VCPE_INIT_1_MULT_DEF: {
                // contains functions calling multiply defined functions
                InitModemTasks_PowerUp.o(.text*)
                // contains multiply defined functions
            }
        }
    } > INIT_1_ISWAP

    GROUP LOAD((ADDR(VCPE_INIT_2_FADX_PM))): {
        .PMSWAP_VCPE_INIT_2 ALIGN(4): {
            mtkernel_init.o(.text*)
            hs_init.o(.text*)
            initfifo.o(.text*)
            InitEngine_PreHandshake.o(.text*)
            V_STR_SRC_Ini_data.o(.text*)
            ZPH_Ini.o(.text*)

            .VCPE_INIT_2_MULT_DEF: {
                // contains functions calling multiply defined functions

                // contains multiply defined functions
                IRI_IOf_train.o(.text*)
                V_STR_SRC_Ini.o(.text*)
                V_STR_Ini.o(.text*)
                V_STR_IIR_IOf.o(.text*)
                V_STR_IOf_Trn.o(.text*)


                // this one is put inside MULTDEF so that we can separate cache and non-cache functions
                cri_ini.o(.text*)
            }
            SWAP_VCPE_INIT_2.o(.rodata)
        }
    } > INIT_2_ISWAP

#ifdef (VRX318 || VRX518)
    GROUP LOAD((ADDR(VCPE_CACHE_TRAIN_2_FADX_PM_BT))): {
#else
    GROUP LOAD((ADDR(VCPE_CACHE_TRAIN_2_FADX))): {
#endif //#ifdef VRX318

        .PMSWAP_VCPE_CACHE_TRAIN_2 ALIGN(4): {

            .VCPE_CACHE_TRAIN_2_MULT_DEF: {
                //Don't move AFE related init fns to PDBRAM, because moving
                //AFE related init fns to PDBRAM causing training failures, looks like timeout is happening
                //at the AFE related init fns may be at the ADC trimming which needs to be executed
                //as soon as possible. hence please keep them in the
                //IIBRAM instead of PDBRAM.
                #ifdef VRX518
                AFED_ModeConfig.o(.text*)
                AFED_AnalogRegInit.o(.text*)
                AFED_FilterTune.o(.text*)
                AFED_EfuseCopy.o(.text*)
                AFED_RcMeasure.o(.text*)
                #else
                AFE_ModeSelection.o(.text*)
                AdcTrimming.o(.text*)
                InitAFEPowerUp.o(.text*)
                //ThreeGLP_Interface.o(.text*)
                AfeAnalogRegInit.o(.text*)
                AfeDigitalRegInit.o(.text*)
                FilterTune.o(.text*)
                FuseCopy.o(.text*)
                RC_Measure.o(.text*)
                #endif
            }
            VCPE_CACHE_TRAIN_2.o(.rodata)
        }
    } > VDSL_CACHE_TRAIN_2

    //VDSL training message fns are moved from VDSL_CACHE to
   //separate page in VRX318
#ifdef (VRX318 || VRX518)
    GROUP LOAD((ADDR(VCPE_CACHE_TRAIN_3_FADX_PM_BT))): {
#else
    GROUP LOAD((ADDR(VCPE_CACHE_TRAIN_3_FADX))): {
#endif //#ifdef VRX318
        .PMSWAP_VCPE_CACHE_TRAIN_3 ALIGN(4): {

           //Training only files - start
           LinkStart.o(.text*)
           GetQlnHlogForCarrierGroup.o(.text*)
           psd_b.o(.text*)
           //Message parsing after medley - end

            .VCPE_CACHE_TRAIN_3_MULT_DEF: {

                //Interp message functions
                //Training only files - start
                quick_PSDsort.o(.text*)
                BgComputeQln.o(.text*)

                ApplyBandLimit.o(.text*)

                //Message parsing after medley - start
                InterpOTpsMsg_VDSL2.o(.text*)
                InterpOPmsMsg_VDSL2.o(.text*)
                InterpOPmdMsg_VDSL2.o(.text*)
                //Message parsing after medley - end


                GenFramingParams_VDSL2.o(.text*)
                //Training only files - end
             #ifdef VRX518
	        AFED_PgaHandlerUtilities.o(.text*)
	     #else
                VR9_Afe.o(.text*)
	     #endif
            }
            VCPE_CACHE_TRAIN_3.o(.rodata)
        }
    } > VDSL_CACHE_TRAIN_3

#ifdef VRX218
    GROUP LOAD((ADDR(VCPE_CACHE_VR9_ONLY_FADX))): {
        .PMSWAP_VCPE_CACHE_VR9_ONLY ALIGN(4): {
            .VCPE_CACHE_VR9_ONLY_MULT_DEF: {
               // Memory available only for VR9 builds, and so left it as free.
               // Decided to maintain similar memory map for VR9 and VRx318, this block remains UNUSED.
            }
        }
    } > VDSL_CACHE_VR9_ONLY
#endif //#ifdef VRX318


//---------------------------------------------------------------//
//-------------------- GHS PAGES --------------------------------//
//---------------------------------------------------------------//
    GROUP LOAD((ADDR(VCPE_GHS_1_FADX_PM))): {
        .PMSWAP_VCPE_GHS_1 ALIGN(4): {
            .VCPE_GHS_1_MULT_DEF: {
                //TX state functions
                RSilent0TxF.o(.text*)
                RTonesReqTxF.o(.text*)
                RSilent1TxF.o(.text*)
                RTone1TxF.o(.text*)
                RFlag1TxF.o(.text*)
                RHSMsgTxF.o(.text*)

                //RX state functions
                RCSilent1RxF.o(.text*)
                RCTonesRxF.o(.text*)
                RCGalf1RxF.o(.text*)
                RCFlag1RxF.o(.text*)
                RCHSMsgRxF.o(.text*)

                //GHS Utility Functions
                hs_data.o(.text*)
                ghs_cpe.o(.text*)
                RxSymbolReAlign.o(.text*)
                hs_init_train.o(.text*)
                hs_resp_cpe.o(.text*)
                hs_resp.o(.text*)
                LeaveGhsTrail.o(.text*)

                // Multiply Defined and/or Exported Files
                //GHS Utility Functions
                hs_rx.o(.text*)
                hs_tx.o(.text*)
                rx_ops.o(.text*)

                IRI_IOf_train.o(.text*)
                V_STR_IOf_Trn.o(.text*)

            }
            SWAP_VCPE_GHS_1.o(.rodata)
        }
    } > GHS_1_ISWAP

    GROUP LOAD((ADDR(VCPE_GHS_2_FADX_PM))): {
        .PMSWAP_VCPE_GHS_2 ALIGN(4): {

            V_STR_SRC_Ini_data.o(.text*)

            .VCPE_GHS_2_MULT_DEF: {
                //TX and RX state functions
                hs_exit.o(.text*)

                // Multiply Defined and/or Exported Files
                //GHS_1 only Utility Functions (Moved here to make space in GHS_1)
                hs_mesg.o(.text*)
                OctetTransparency.o(.text*)

                //GHS Utility Functions
                hs_rx.o(.text*)
                hs_tx.o(.text*)
                rx_ops.o(.text*)

                //Post GHS Functions
                cnfg_task_postGhs.o(.text*)
                Reconfig_CRI.o(.text*)

                SocMsgsInit.o(.text*)
                IRI_IOf_train.o(.text*)
                V_STR_SRC_Ini.o(.text*)
                V_STR_Ini_PostGhs.o(.text*)
                V_STR_IOf_Trn.o(.text*)
                V_STR_IIR_IOf.o(.text*)
            }
        }
    } > GHS_2_ISWAP

//---------------------------------------------------------------//
//-------------------- TRAIN MAIN PAGES -------------------------//
//---------------------------------------------------------------//
    GROUP LOAD((ADDR(VCPE_TRAIN_MAIN_FADX_PM))): {
        .PMSWAP_VCPE_TRAIN_MAIN ALIGN(4): {
            .VCPE_TRAIN_MAIN_MULT_DEF: {
                DetectSynch.o(.text*)
                DetectReverbSegue.o(.text*)
                SocMsgs_Common.o(.text*)

                FormORRepeatRqstMsg_VDSL2.o(.text*)
                HDLC.o(.text*)

                LeaveSocTrail.o(.text*)
                ModulateSocMessges.o(.text*)
                DemodSocMsgForDiagMode.o(.text*)
                SharedFuncs.o(.text*)

                TxRxMsgHandler.o(.text*)

                //Form message functions
                FormRMsg1Msg_VDSL2.o(.text*) //Moved from CHDIS_1_V2_ISWAP

            }
        }
    } > TRAIN_MAIN_ISWAP

//---------------------------------------------------------------//
//-------------------- VDSL1 PAGES ------------------------------//
//---------------------------------------------------------------//
//---------------------------------------------------------------//
//   PLEASE PLEASE TRY TO JUDICIOUSLY FOLLOW THE FORMATTING      //
//  EMPLOYED WRT TX/RX STATE FUNCTIONS, FORM/INTERP MSG ORDERING //
//                  IN CHRONLOGICAL ORDER                        //
//---------------------------------------------------------------//
    GROUP LOAD((ADDR(VCPE_TRAIN_1_FADX_PM))): {
        .PMSWAP_VCPE_TRAIN_1 ALIGN(4): {

            .VCPE_TRAIN_1_MULT_DEF: {
            //keep empty dummy page
            }
            SWAP_VCPE_TRAIN_1.o(.rodata)
        }
    } > TRAIN_1_ISWAP

    GROUP LOAD((ADDR(VCPE_TRAIN_2_FADX_PM))): {
        .PMSWAP_VCPE_TRAIN_2 ALIGN(4): {
            //super file
            .VCPE_TRAIN_2_MULT_DEF: {
             //keep empty dummy page
            }
        }
    } > TRAIN_2_ISWAP

    GROUP LOAD((ADDR(VCPE_ANAL_1_FADX_PM))): {
        .PMSWAP_VCPE_ANAL_1 ALIGN(4): {

            .VCPE_ANAL_1_MULT_DEF: {
            //keep empty dummy page
            }
        }
    } > ANAL_1_ISWAP

    GROUP LOAD((ADDR(VCPE_ANAL_2_FADX_PM))): {
        .PMSWAP_VCPE_ANAL_2 ALIGN(4): {

            .VCPE_ANAL_2_MULT_DEF: {
             //keep empty dummy page
            }
        }
    } > ANAL_2_ISWAP

    GROUP LOAD((ADDR(VCPE_ANAL_3_FADX_PM))): {
        .PMSWAP_VCPE_ANAL_3 ALIGN(4): {
            .VCPE_ANAL_3_MULT_DEF: {
             //keep empty dummy page
            }
        }
    } > ANAL_3_ISWAP

    GROUP LOAD((ADDR(VCPE_ANAL_4_FADX_PM))): {
        .PMSWAP_VCPE_ANAL_4 ALIGN(4): {

            .VCPE_ANAL_4_MULT_DEF: {
             //keep empty dummy page
            }

        }
    } > ANAL_4_ISWAP

    GROUP LOAD((ADDR(VCPE_SHOW_1_FADX_PM))): {
        .PMSWAP_VCPE_SHOW_1 ALIGN(4): {
            .VCPE_SHOW_1_MULT_DEF: {
             //keep empty dummy page
           }
        }
    } > SHOW_1_ISWAP

    GROUP LOAD((ADDR(VCPE_SHOW_2_FADX_PM))): {
        .PMSWAP_VCPE_SHOW_2 ALIGN(4): {
             .VCPE_SHOW_2_MULT_DEF: {
             //keep empty dummy page
            }
        }
    } > SHOW_2_ISWAP

//---------------------------------------------------------------//
//-------------------- VDSL2 PAGES ------------------------------//
//---------------------------------------------------------------//
//   PLEASE PLEASE TRY TO JUDICIOUSLY FOLLOW THE FORMATTING      //
//  EMPLOYED WRT TX/RX STATE FUNCTIONS, FORM/INTERP MSG ORDERING //
//                  IN CHRONLOGICAL ORDER                        //
//---------------------------------------------------------------//
    GROUP LOAD((ADDR(VCPE_ALGHD_1_V2_FADX_PM))): {
        .PMSWAP_VCPE_ALGHD_1_V2 ALIGN(4): {
            .VCPE_ALGHD_1_V2_MULT_DEF: {
                // Algorithm Handlers & shared functions
                AddPsdBrkpt.o(.text*)
                FdqHandler.o(.text*)

                FrameAlignmentHandler.o(.text*)
                InsertCE.o(.text*)
                IRI_IOf_train.o(.text*)
                IRI_sync.o(.text*)
                PeriodicStateHandler_VDSL2.o(.text*)
                PsdHandler.o(.text*)

                SnrHandler.o(.text*)
                TimingAdvanceHandler.o(.text*)

                // TX bridge state functions
                RMsg1TxF_VDSL2_Bridge.o(.text*)
                RPTrain1TxF_VDSL2_Bridge.o(.text*)
                RPMedleyTxF_VDSL2_Bridge.o(.text*)

                // RX bridge state functions
                ROSignatureRxF_VDSL2_Bridge.o(.text*)
                ROPTrain1RxF_VDSL2_Bridge.o(.text*)
                ROPMedleyRxF_VDSL2_Bridge.o(.text*)
//#ifdef MTK_VECTORING_SUPPORT
                ROPSynchroVector1RxF_VDSL2_Handler.o(.text*)
// #endif
            }
        }
    } > ALGHD_1_V2_ISWAP

    GROUP LOAD((ADDR(VCPE_ALGHD_2_V2_FADX_PM))): {
        .PMSWAP_VCPE_ALGHD_2_V2 ALIGN(4): {
            .VCPE_ALGHD_2_V2_MULT_DEF: {
//#ifdef MTK_VECTORING_SUPPORT
                ROPVector1Handler.o(.text*)
                DetectDSSync_Vector_Handler.o(.text*)
                ddsnrfdq_iof.o(.text*)
                IRI_IOf_train.o(.text*)
                IRI_sync.o(.text*)
//#endif
            }
        }
    } > ALGHD_2_V2_ISWAP

    GROUP LOAD((ADDR(VCPE_ALGHD_3_V2_FADX_PM))): {
        .PMSWAP_VCPE_ALGHD_3_V2 ALIGN(4): {
            .VCPE_ALGHD_3_V2_MULT_DEF: {
                // Algorithm Handlers & shared functions
                ComplexMult.o(.text*)
                FdqHandler.o(.text*)

                IRI_IOf_mfdq.o(.text*)
                IRI_IOf_train.o(.text*)
                IRI_sync.o(.text*)

                MfdqHandler.o(.text*)

                SnrFrameAlignHandler.o(.text*)
                SnrHandler.o(.text*)
                V_STR_IOf_Trn.o(.text*)
            }
        }
    } > ALGHD_3_V2_ISWAP

    GROUP LOAD((ADDR(VCPE_ALGHD_4_V2_FADX_PM))): {
        .PMSWAP_VCPE_ALGHD_4_V2 ALIGN(4): {
            .VCPE_ALGHD_4_V2_MULT_DEF: {
                // Algorithm Handlers & shared functions
                BitloadHandler.o(.text*)
                HlinHandler.o(.text*)
            }
        }
    } > ALGHD_4_V2_ISWAP

    GROUP LOAD((ADDR(VCPE_CHDIS_1_V2_FADX_PM))): {
        .PMSWAP_VCPE_CHDIS_1_V2 ALIGN(4): {
            .VCPE_CHDIS_1_V2_MULT_DEF: {
                // TX state functions
                InitTrainState.o(.text*)
                RMsg1TxF_VDSL2.o(.text*)

                // RX state functions
                ROTrainingRxF_VDSL2.o(.text*)
                ROSignatureRxF_VDSL2.o(.text*)

            #ifdef VRX518
		       AFED_HybTrainUtilities.o(.text*)
		    #else
                VR9_AfeHybr.o(.text*)
            #endif
                BitSynchHandler_VDSL2.o(.text*)
                ByteSynchHandler_VDSL2.o(.text*)


                PGAHandler.o(.text*)
                LoadTransmitGains.o(.text*)
                HybridTrainingHandler.o(.text*)

                IRI_IOf_train.o(.text*)
                LoadIridiaTransmitGains.o(.text*)

                SelectRxBandLimit.o(.text*)
                V_STR_IOf_Trn.o(.text*)
                V_STR_IIR_IOf.o(.text*)
            }
            SWAP_VCPE_CHDIS_1_V2.o(.rodata)
        }
    } > CHDIS_1_V2_ISWAP

    GROUP LOAD((ADDR(VCPE_TRAIN_1_V2_FADX_PM))): {
        .PMSWAP_VCPE_TRAIN_1_V2 ALIGN(4): {
            .VCPE_TRAIN_1_V2_MULT_DEF: {
                // TX state functions
                RPSynchro1TxF_VDSL2.o(.text*)
                RPLineprobeTxF_VDSL2.o(.text*)
                RPPeriodic1TxF_VDSL2.o(.text*)
                RPSynchro2TxF_VDSL2.o(.text*)
                RPDiscovery2TxF_VDSL2.o(.text*)
                RPSynchro3TxF_VDSL2.o(.text*)
                RPQuiet2TxF_VDSL2.o(.text*)
                RPTrain1TxF_VDSL2.o(.text*)

                // RX state functions
                ROPSynchro1RxF_VDSL2.o(.text*)
                ROPQuietPilot1RxF_VDSL2.o(.text*)
                ROPPeriodic1RxF_VDSL2.o(.text*)
                ROPSynchro2RxF_VDSL2.o(.text*)
                ROUpdateRxF_VDSL2.o(.text*)
                ROPrmRxF_VDSL2.o(.text*)
                ROAckRxF_VDSL2.o(.text*)
                ROPSynchro3RxF_VDSL2.o(.text*)
                ROPTrain1RxF_VDSL2.o(.text*)

                // form message functions
                FormRUpdateMsg_VDSL2.o(.text*)

                // misc
                AddPsdBrkpt.o(.text*)


                IRI_IOf_train.o(.text*)
                IRI_sync.o(.text*)
                LoadIridiaTransmitGains.o(.text*)
                LoadTransmitGains.o(.text*)
                PGAHandler.o(.text*)
                V_STR_IOf_Trn.o(.text*)
            }
            SWAP_VCPE_TRAIN_1_V2.o(.rodata)
        }
    } > TRAIN_1_V2_ISWAP

    GROUP LOAD((ADDR(VCPE_TRAIN_2_V2_FADX_PM))): {
        .PMSWAP_VCPE_TRAIN_2_V2 ALIGN(4): {
            .VCPE_TRAIN_2_V2_MULT_DEF: {
                // TX state functions
                RPSynchro4TxF_VDSL2.o(.text*)
                RPMultTrain2TxF_VDSL2.o(.text*)
                RPTrain2TxF_VDSL2.o(.text*)
                RPSynchro5TxF_VDSL2.o(.text*)
                RPVector2TxF_VDSL2.o(.text*)

                // RX state functions
                ROPSynchro4RxF_VDSL2.o(.text*)
                ROPMultTrain2RxF_VDSL2.o(.text*)
                ROTaUpdateRxF_VDSL2.o(.text*)
                ROPSynchro5RxF_VDSL2.o(.text*)
                ROMsg1RxF_VDSL2.o(.text*)

                // form message functions
                FormRTAUpdateMsg_VDSL2.o(.text*)
                FormRAckMsg_VDSL2.o(.text*)


                // misc
                IRI_IOf_train.o(.text*)
                V_STR_IOf_Trn.o(.text*)
            }
            SWAP_VCPE_TRAIN_2_V2.o(.rodata)
        }
    } > TRAIN_2_V2_ISWAP

    GROUP LOAD((ADDR(VCPE_ANAL_1_V2_FADX_PM))): {
        .PMSWAP_VCPE_ANAL_1_V2 ALIGN(4): {
            .VCPE_ANAL_1_V2_MULT_DEF: {
                // TX state functions
                RPMedleyTxF_VDSL2.o(.text*)
                RMedleyMsgTxF_VDSL2.o(.text*)

                // RX state functions
                ROPMedleyRxF_VDSL2.o(.text*)
                ROTpsRxF_VDSL2.o(.text*)
                ROPmsRxF_VDSL2.o(.text*)
                ROPmdRxF_VDSL2.o(.text*)
                ROPSynchro6RxF_VDSL2Diag.o(.text*)

                // form message functions
                FormRMsg2Msg_VDSL2.o(.text*)
                FormRTpsAckMsg_VDSL2.o(.text*)


                IRI_IOf_mfdq.o(.text*)
                IRI_sync.o(.text*)
                MedleyMsgCheckRxTimer.o(.text*)
                MedleyTrainingRxF.o(.text*)


                ResetPRBS.o(.text*)
                RMedleyMsgHandler.o(.text*)
                TimingAdvanceHandler.o(.text*)

                // Misc
                InsertCE.o(.text*)

            }
        }
    } > ANAL_1_V2_ISWAP

    GROUP LOAD((ADDR(VCPE_ANAL_4_V2_FADX_PM))): {
        .PMSWAP_VCPE_ANAL_4_V2 ALIGN(4): {

            //super file
            .VCPE_ANAL_4_V2_MULT_DEF: {
                InitShowTimeRx.o(.text*)
                // Datapump Setup
                RxDataPumpSetUp.o(.text*)
                RxDataPumpSetUp_VDSL2.o(.text*)

                TxDataPumpSetUp.o(.text*)
                FindPmdStep.o(.text*)

                //Diagnostic mode files
                RPSynchro6TxF_VDSL2Diag.o(.text*)
                RPTrain3TxF_VDSL2Diag.o(.text*)
                RPSynchro7TxF_VDSL2Diag.o(.text*)
                ROMsgLdRxF_VDSL2Diag.o(.text*)
                ROPSynchro7RxF_VDSL2Diag.o(.text*)
                DiagDoneStateFunc_VDSL2Diag.o(.text*)
            }
        }
    } > ANAL_4_V2_ISWAP

    GROUP LOAD((ADDR(VCPE_ANAL_5_V2_FADX_PM))): {
        .PMSWAP_VCPE_ANAL_5_V2 ALIGN(4): {
            //super file
            .VCPE_ANAL_5_V2_MULT_DEF: {
                //TX state functions
                RMedleyMsg2TxF_VDSL2.o(.text*)
                RPSynchro6TxF_VDSL2.o(.text*)

                //RX state functions
                ROPmdAckRxF_VDSL2.o(.text*)
                ROPSynchro6RxF_VDSL2.o(.text*)
                FormRPmdMsg_VDSL2.o(.text*)

                // Multiply Defined and/or Exported Files
                // State function
                RMedleyMsgHandler.o(.text*)

                FindPmdStep.o(.text*)
                InitShowTimeTx.o(.text*)

                TxDataPumpSetUp.o(.text*)
                TxDataPumpSetUp_VDSL2.o(.text*)

            }
        }
    } > ANAL_5_V2_ISWAP


    GROUP LOAD((ADDR(VCPE_SHOW_1_V2_FADX_PM))): {
        .PMSWAP_VCPE_SHOW_1_V2 ALIGN(4): {

            retx_asm.o(.text*)

            .VCPE_SHOW_1_V2_MULT_DEF: {
                // Tx State function
                ShowtimeTxTC_VDSL2.o(.text*)

                // Rx State function
                ShowtimeRxTC_VDSL2.o(.text*)

#ifndef VECTORING_MEM_LYT
                ShowtimeTxF_VDSL2.o(.text*)
                ShowtimeRxF_VDSL2.o(.text*)
                DetectReverbSegue.o(.text*)
                eoc_data.o(.text*)
#endif

                //HW Interface
                show_iof_VDSL2.o(.text*)


                //Overhead Processing Utilities
                OvhdMsg_IOf_VDSL2.o(.text*)
                ovhd.o(.text*)

                LeaveEocTrail.o(.text*)

                // Multiply Defined and/or Exported Files
                //XDSLRTFW-1979 (start_end)
                //MicroInterruptionHandler.o(.text) //This file is not required, since it is not being used in the showtime
                rx_ib.o(.text*)
                tx_ib.o(.text*)

                //G997 Showtime Processing
                g997.o(.text*)

                //HW Interface
                show_iof.o(.text*)
                ResetPRBS.o(.text*)
                ddsnrfdq_iof.o(.text*)


                // Loopback Test
                show_lpbk_iof.o(.text*)
            }
        }
    } > SHOW_1_V2_ISWAP

    GROUP LOAD((ADDR(VCPE_SHOW_2_V2_FADX_PM))): {
        .PMSWAP_VCPE_SHOW_2_V2 ALIGN(4): {
            //super file
            .VCPE_SHOW_2_V2_MULT_DEF: {
                // Multiply Defined and/or Exported Files

                ovhd_tx.o(.text*)
                BitswapHandler_VDSL2.o(.text*)

                // DD Processing
                DDSnrFdqHandler.o(.text*)

            }
        }
    } > SHOW_2_V2_ISWAP

//---------------------------------------------------------------//
//-------------------- MISC PAGES ---------------------------//
//---------------------------------------------------------------//
    GROUP LOAD((ADDR(VCPE_PRESHOW_FADX_PM))): {
        .PMSWAP_VCPE_PRESHOW ALIGN(4): {
            .VCPE_PRESHOW_MULT_DEF: {
                // contains functions calling multiply defined functions
                preshow.o(.text*)

                // Loopback Test
                show_lpbk_iof.o(.text*)

                FindPmdStep.o(.text*)
                InitShowTimeRx.o(.text*)
                InitShowTimeTx.o(.text*)

                RxDataPumpSetUp.o(.text*)
                TxDataPumpSetUp.o(.text*)
                RxDataPumpSetUp_VDSL2.o(.text*)
                TxDataPumpSetUp_VDSL2.o(.text*)

                IRI_IOf_train.o(.text*)
                IRI_sync.o(.text*)
                V_STR_IOf_Trn.o(.text*)

            }
        }
    } > PRESHOW_ISWAP

    GROUP LOAD((ADDR(VCPE_SLEEP_FADX_PM))): {
        .PMSWAP_VCPE_SLEEP ALIGN(4): {

            .VCPE_SLEEP_MULT_DEF: {
                sleep.o(.text*)
                TimingAdvanceHandler.o(.text*)
                InsertCE.o(.text*)
                PsdHandler.o(.text*)
                FdqHandler.o(.text*)
                FrameAlignmentHandler.o(.text*)

                SnrHandler.o(.text*)
                ModulateSocMessges.o(.text*)
                cosine.o(.text*)
                SharedFuncs.o(.text*)
                AddPsdBrkpt.o(.text*)

                LoadIridiaTransmitGains.o(.text*)
                LoadTransmitGains.o(.text*)

                PGAHandler.o(.text*)
                interrupt_control.o(.text*)
                IRI_IOf_train.o(.text*)
                IRI_sync.o(.text*)
                sleep_iof.o(.text*)

                DmtScope_MsgHandler.o(.text*)
                DmtScope_PsdMeasure.o(.text*)
                MfdqHandler.o(.text*)
                Reconfig_CRI.o(.text*)

                V_STR_IOf_Trn.o(.text*)
                vecpwr.o(.text*)

            }
                PsdMeasHold_loop.o(.text*)

            SWAP_VCPE_SLEEP.o(.rodata)
        }
    } > SLEEP_ISWAP

    GROUP LOAD((ADDR(VCPE_CACHE_1_FADX))): {
        .PMSWAP_VCPE_CACHE_1 ALIGN(4): {

            *(.BG_CACHE_1)
            main_hw.o(.text*)
            .VCPE_CACHE_1_MULT_DEF: {
                SharedFuncs.o(.text*)
                DDSnrFdqHandler.o(.text*)
                // show_1_v2 bg

                tx_eoc_form_msg.o(.text*)
                ovhd_rx_proc.o(.text*)

                // show_1 show_1_v2 common BG

                ShowtimeTestControl.o(.text*)
                show_test_iof.o(.text*)

                // show_2 BG
                ToneReorder.o(.text*)

                // show_2_v2 BG
                ovhd_rx.o(.text*)
                UPBO.o(.text*)
                Bitload_support.o(.text*)
                ChangeBat.o(.text*)
                ChooseFineGains.o(.text*)

                BitSwapDecision_VDSL2.o(.text*)
                ReorderTRT.o(.text*)
                GetSnrForCarrierGroup.o(.text*)

                PSDShaping.o(.text*)
                nomatp.o(.text*)
                ConvertToDB.o(.text*)
                GetTonePsd.o(.text*)

                g997.o(.text*)

                // these are here inside MULTDEF so that we can separate cache and non-cache functions
                cri_ini.o(.text*)
                noiseacc.o(.text*)
                hs_mesg.o(.text*)
                ovhd_tx.o(.text*)
                PSDHandler_HybTrn.o(.text*)
                psd_b_hybtrn.o(.text*)


                //Interp message functions
                SocMsgs_Common.o(.text*)

                InterpolatePSDUtil_tssi.o(.text*)
                InterpMsg_RT.o(.text*)

                SelectActualPmsParms_VDSL2.o(.text*)
                BgCalcProposedCeiling.o(.text*)
                CalcAtpCeil.o(.text*)
                ConvertLogToLinear.o(.text*)
                FrameAlign.o(.text*)
                TxPSDControl.o(.text*)
                Switch_TxFineGains_Tssi.o(.text*)
                AddPsdBrkpt.o(.text*)
                FormTRT.o(.text*)

                g997_showinit.o(.text*)
                InitShowTimeRx.o(.text*)
                InitShowTimeTx.o(.text*)
                InitShowTimeRx_VDSL2.o(.text*)
                InitShowTimeTx_VDSL2.o(.text*)

                RxDataPumpSetUp_VDSL2.o(.text*)
                TxDataPumpSetUp_VDSL2.o(.text*)

                //from VCPE_ANAL_4_V2
                FormMsgLD_VDSL2Diag.o(.text*)
                InterpMsgLD_VDSL2Diag.o(.text*)
                ComputeRates.o(.text*)

                Framing_VDSL2.o(.text*)
                FramingGenLP0.o(.text*)
                //FramingGenLP1.o(.text*)  //Moved to IIBRAM_SHOW_ISWAP

                CalcMaxIlvDilvSize.o(.text*)
                MfdqHandler_b.o(.text*)
                MfdqAdjust.o(.text*)
                MfdqSupport.o(.text*)
                matrix.o(.text*)
                IRI_IOf_mfdq.o(.text*)

                AllocateBiGi.o(.text*)
                CalcMaxBits.o(.text*)

                CheckMfdqToneSet.o(.text*)
                Bitload.o(.text*)
                Bitload_VDSL2.o(.text*)
                CalcMedleySnrMargin.o(.text*)

                fdq.o(.text*)
                cosine.o(.text*)

                // From VCPE_MAIN
                acc48_ops.o(.text*)
                ieee_flt.o(.text*)

                CheckForBandOverlap.o(.text*)


                IRI_IOf_train.o(.text*)
                V_STR_IOf_Trn.o(.text*)
                zep_trn_iof.o(.text*)

                // afe stuff
                LoadTransmitGains.o(.text*)

                // needed during AfePowerUp, preGhs and postGhs
                // the calling code is in BG, so it's ok for these
                // functions to be in cache
	     #ifdef VRX518
	        AFED_PofiPocoConfg.o(.text*)
	     #else	
                Init_POFIPOCO.o(.text*)
                ThreeGLP_Interface.o(.text*)
	     #endif
                CustomerBgTasks.o(.text*)

           }
            CalcShowtimeSnrMargin.o(.text*)
            QuickAverage.o(.text*)
            snr_b.o(.text*)    //MOVE from ONE_PORT_MAIN_ISWAP to CACHE
            RunModem.o(.text*)
            xTC_VersionInfo_Init.o(.text*)
       }

    } > VDSL_CACHE

#ifdef VRX518
    GROUP LOAD((ADDR(VCPE_CACHE_TRAIN_1_FADX_PM_BT))): {
#else    
    GROUP LOAD((ADDR(VCPE_CACHE_TRAIN_1_FADX))): {
#endif    
        .PMSWAP_VCPE_CACHE_TRAIN_1 ALIGN(4): {

            .VCPE_CACHE_TRAIN_1_MULT_DEF: {
                //The following init functions are part of DSL FW & PPE shared PDBRAM
                //memory S_44K
                // INIT_1
                CmvInit_PowerUp.o(.text*)
                InitGlobalVars_PowerUp.o(.text*)
                InitModem_PowerUp.o(.text*)
                InitStateMachine.o(.text*)
                ModemMonitor_Init.o(.text*)
                nmp_init.o(.text*)
                //InitEngine_PowerUp.o(.text*)

                // INIT_2
                InitModem_PreHandshake.o(.text*)
                stateini.o(.text*)
                cnfg_task_preGhs.o(.text*)
                InitGlobalVars.o(.text*)
                IRI_Ini.o(.text*)
                cmv_init.o(.text*)
                AllocateDataBuffers.o(.text*)

                g997_init.o(.text*)
                g997_init_failure_struct.o(.text*)
                //XDSLRTFW-542: Platform_VRX318 (END)

                //XDSLRTFW-1220: Feature_US_VDSL2_ALL_UsReTx_VRX318_BuildIssue (START_END)
                // from GHS_1 & GHS_2
                cnfg_task_postGhs.o(.text*)

                //from Train_1_v2
                FormRPrmMsg_VDSL2.o(.text*)

                //XDSLRTFW-1518 (Start)
                //Moved from VDSL_CACHE
                FormRPmsMsg_VDSL2.o(.text*)
                InterpOPrmMsg_VDSL2.o(.text*)
                //XDSLRTFW-1518 (End)

                //XDSLRTFW-1518 (Start)
                //Moved from VDSL_CACHE_TRAIN_3
                //Message parsing before medley - start
                InterpOUpdateMsg_VDSL2.o(.text*)
                InterpOTAUpdateMsg_VDSL2.o(.text*)
                InterpOSignatureMsg_VDSL2.o(.text*)
                InterpOMsg1Msg_VDSL2.o(.text*)
                //Message parsing before medley - end
                //XDSLRTFW-1518 (End)

                //Moved from VDSL_CACHE
                rx_eoc_init.o(.text*)
                tx_eoc_init.o(.text*)
                //Train only functions Moved from CACHE to CACHE2
                PackUnpackQlnHlog_VDSL2.o(.text*)
                BgSelectPilot.o(.text*)
                BgSelectMultiPilot.o(.text*)
                BgReconfigBandPlan.o(.text*)
                PsdAnalysis.o(.text*)
                CalcCarrierGroupSize.o(.text*)
                cnfg_Dfe.o(.text*)
                CheckForUS0Enable.o(.text*)
                ProcessCpBeta.o(.text*)
            }
#ifdef (VRX218 || VRX318)
            *(.BG_CACHE_2)
#endif
        }
    } > VDSL_CACHE_TRAIN_1

#ifdef TARGET_ARC
    GROUP LOAD((ADDR(VCPE_SIMTEST_FADX_PM_BT))): {
        .PMSWAP_VCPE_SIMTEST ALIGN(4): {
            mini_stdio.o(.text*)
            afeif_iof.o(.text*)
            dadd.o(.text*)
            dmul.o(.text*)
            ddiv.o(.text*)
            InitBM.o(.text*)
            cnfg_task_test.o(.text*)

            sprintf.o(.text*)
            strlen.o(.text*)
            strcpy.o(.text*)
            strtok.o(.text*)
            strcmp.o(.text*)
            _doprint.o(.text*)
            memchr.o(.text*)
            _strtokr.o(.text*)
            wctomb.o(.text*)
            wcstombs.o(.text*)
            _doecvtd.o(.text*)
            _itos.o(.text*)
            _stoi.o(.text*)
            _uchrchr.o(.text*)
            ctype.o(.text*)
            mwdctor.o(.text*)
            tlsctorg.o(.text*)

            .VCPE_SIMTEST_MULT_DEF: {
            }

            ctype.o(.rodata)
            mini_stdio.o(.rodata)
        }

        .text ALIGN(4) : {
            *(.text*)
        }
    } > EXT_IRAM
#endif

    GROUP LOAD((ADDR(VCPE_INTVECS_FADX_PM_BT))): {
        .PMSWAP_VCPE_INTVECS ALIGN(4): {
            interrupts_62.o(.INTVECS)
        }
    } > INTVECS_IRAM

    // no swap page for this
    GROUP : {
        .DMSWAP_VCPE_PORTMODECONTROL ALIGN(4): {
            gdata.o(.PORTMODECONTROL_DATA)
        }

    } > PORT_MODE_CONTROL_DATA

    GROUP LOAD((ADDR(VCPE_MAIN_FADX_PM_BT))): {
        .PMSWAP_VCPE_MAIN ALIGN(4): {

            interrupts_62.o(.text*)
            acc48_ops.o(.text*)

            accum32.o(.text*)
            arctan.o(.text*)
            dsp_op.o(.text*)
            cmplxvecmult.o(.text*)
            cmplxvecmultloop.o(.text*)

            mem_funcs.o(.text*)
//            DshService.o(.text*)  //Moved to IIBRAM_MAIN

            xception.o(.text*)
            cmv.o(.text*)
            fifo.o(.text*)
            states.o(.text*)
            statestc.o(.text*)
            mtkernel.o(.text*)
            DetectInterrupts.o(.text*)
            codeswap.o(.text*)

#ifndef VECTORING_MEM_LYT
            nmp.o(.text*)
            nmp_plfm.o(.text*)
            V_STR_IOf.o(.text*)
#endif

            ModemMonitor.o(.text*)
            LeaveStatesTrail.o(.text*)
            ModulateSocMessgesDiag.o(.text*)

            //cri_iof.o(.text*)        //Moved to IIBRAM_MAIN
            //IRI_IOf.o(.text*)  //Moved to ONE_PORT_MAIN
            //IRI_IOf_FFT.o(.text*)  // Moved to IIBRAM_MAIN 

            fcs.o(.text*)

            decimalgain.o(.text*)
            //Moving to ONE_PORT_MAIN_ISWAP
            //profile.o(.text*)
            //DebugBuffer.o(.text*)

            //pll.o(.text*)            //Moved to IIBRAM_MAIN
            TimingRecov.o(.text*)



#ifdef AWRE_BLD_H
            afe_io.o(.text*)
            CustomerTasks.o(.text*)
#endif

#ifdef TARGET_HW
            *(.text*)
#endif
            // this grabs FG functions from a file that was put in cache.
            *(fg001)

            *(.init)
            *(.lit)
            *(.rodata)

        }

#ifdef TARGET_HW
        .text ALIGN(4) : {
            *(.text*)
        }
#endif

    } > MAIN_ISWAP

#ifdef VECTORING_MEM_LYT
    GROUP LOAD((ADDR(VCPE_IIBRAM_MAIN_FADX_PM_BT))): {
        .PMSWAP_VCPE_IIBRAM_MAIN ALIGN(4): {
            nmp.o(.text*)
            nmp_plfm.o(.text*)
            V_STR_IOf.o(.text*)
            IRI_IOf.o(.text*)  //Moved from VCPE_MAIN
            //Moved from MAIN_ISWAP
            profile.o(.text*)
            DebugBuffer.o(.text*)
            LL_IOf_62.o(.text*)
            xdma_62.o(.text*)
            DshService.o(.text*)  //Moved from VCPE_MAIN
            IRI_IOf_FFT.o(.text*)  // Moved from VCPE_MAIN             

            cri_iof.o(.text*) //Moved from VCPE_MAIN
            pll.o(.text*)     //Moved from VCPE_MAIN

            //Moved from VCPE_MAIN
            .VCPE_MAIN_MULT_DEF: {
                // LinkStart has to be here to be able to call post GHs setup
                // on SimTest page

                // g997_common has to be here to be able to call G997_1sec_Task_VDSL?
                g997_common.o(.text*)
                ddsnrfdq_iof.o(.text*)
                noiseacc.o(.text*)
            }
        }
    } > IIBRAM_MAIN_ISWAP

    GROUP LOAD((ADDR(VCPE_IIBRAM_SHOW_FADX_PM_BT))): {
        .PMSWAP_VCPE_IIBRAM_SHOW ALIGN(4): {

            .VCPE_IIBRAM_SHOW_MULT_DEF: {
                // Tx State function
                ShowtimeTxF_VDSL2.o(.text*)

                // Rx State function
                ShowtimeRxF_VDSL2.o(.text*)
                DetectReverbSegue.o(.text*)
                ShowtimeErbHandler.o(.text*)
                DetectReverbSegueG9935ST.o(.text*)

                //US RETX functions
                UsRTX_Tasks.o(.text*)
                UsRTX_io.o(.text*)
      //XDSLRTFW-1288 Feature_US_VDSL2_ALL_UsReTxAmend2_MemoryOpt (START_END)
                FormRErrorFeedbackMsg_VDSL2.o

                // XDSLRTFW-650 / XDSLRTFW-1384 (Start_End)
                L3StatMachine.o(.text*)

                eoc_data.o(.text*)
                
                //ReTx Framing functions
                FramingGenLP1.o(.text*)  //Moved from VDSL_CACHE
                // Showtime pilot tone switching
                SelectPilot.o(.text*)    // XDSLRTFW-3280
            }
        }
    } > IIBRAM_SHOW_ISWAP
#endif



#ifdef TARGET_SIM
    GROUP LOAD((ADDR(VCPE_SIMTEST_FADX_PM_BT))): {
        .PMSWAP_VCPE_SIMTEST ALIGN(4): {
            mini_stdio.o(.text*)
            afeif_iof.o(.text*)
            dadd.o(.text*)
            dmul.o(.text*)
            ddiv.o(.text*)
            PrintTrail.o(.text*)
            RunCores.o(.text*)
            corexec.o(.text*)
            InitBM.o(.text*)
            cnfg_task_test.o(.text*)

            // these are used during test initialization

            .VCPE_SIMTEST_MULT_DEF: {
            }

            // rodata section
            mini_stdio.o(.rodata)
            ctype.o(.rodata)
            PrintTrail.o(.rodata)
            *(.rodata*)

            // the rest of PM
            *(.text*)

        }

        .text ALIGN(4) : {
            *(.text*)
        }
    } > EXT_IRAM
#endif

    GROUP : {
        .DMSWAP_VCPE_X_RAM ALIGN(4) : {
            *(.X_RAM)
        }
    } > X_RAM

    GROUP : {
        .DMSWAP_VCPE_Y_RAM ALIGN(4) : {
            *(.Y_RAM)
        }
    } > Y_RAM

    GROUP : {
        .DMSWAP_VCPE_ILVB ALIGN(4) : {
            *(.ILVB)
        }
   } > DILVB_ILVB_RAM

    GROUP LOAD((ADDR(VCPE_DILVB_FADX_DM))): {
        .DMSWAP_VCPE_DILVB ALIGN(4) : {
            *(.DILVB)
        }
   } > DILVB_ILVB_RAM

    GROUP : {
        .DMSWAP_VCPE_TRN_VECTORING_BUFFER ALIGN(4) : {
            *(.TRN_VECTORING_BUFFER)
        }
    } > TRN_VECTORING_BUFFER

   GROUP LOAD((ADDR(VCPE_HYB_COEFS_FADX_DM))): {
        .DMSWAP_VCPE_HYB_COEFS ALIGN(4) : {
            *(.HYB_COEFS)
        }
    } > HYB_COEFS

    GROUP LOAD((ADDR(VCPE_XILVB_B4_SHOW_INIT_FADX_DM))): {
        .DMSWAP_VCPE_XILVB_B4_SHOW_INIT ALIGN(4) : {
            *(.XILVB_B4_SHOW_INIT)
        }
   } > XILVB_B4_SHOW_INIT

    GROUP LOAD((ADDR(VCPE_SRC_COEFS_4KHZ_FADX_DM))): {
        .DMSWAP_VCPE_SRC_COEFS_4KHZ ALIGN(4) : {
            *(.SRC_COEFS_4KHZ)
        }
    } > STR_SRC_COEFS_4KHZ

    GROUP LOAD((ADDR(VCPE_SRC_COEFS_8KHZ_FADX_DM))): {
        .DMSWAP_VCPE_SRC_COEFS_8KHZ ALIGN(4) : {
            *(.SRC_COEFS_8KHZ)
        }
    } > STR_SRC_COEFS_8KHZ
    
#ifdef VRX518
    GROUP LOAD((ADDR(VCPE_SRC_COEFS_35B_RX_FADX_DM))): {
        .DMSWAP_VCPE_SRC_COEFS_35B_RX ALIGN(4) : {
            *(.SRC_COEFS_35B_RX)
        }
    } > VRX518_SRC_COEFS_35B_RX_DM
	
    GROUP LOAD((ADDR(VCPE_SRC_COEFS_35B_TX_FADX_DM))): {
        .DMSWAP_VCPE_SRC_COEFS_35B_TX ALIGN(4) : {
            *(.SRC_COEFS_35B_TX)
        }
    } > VRX518_SRC_COEFS_35B_TX_DM
#endif

    GROUP LOAD((ADDR(VCPE_IIR_COEFS_FADX_DM))): {
        .DMSWAP_VCPE_IIR_COEFS ALIGN(4) : {
            V_STR_IIR_Ini_Data.o(.data*)
        }
    } > IIR_COEFS_BUFFER

    GROUP LOAD((ADDR(VCPE_TX_LP0_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_TX_LP0_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.TX_LP0_UCODE)
        }
    } > TX_LP0_UCODE_BUFFER

    GROUP LOAD((ADDR(VCPE_TX_LP1_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_TX_LP1_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.TX_LP1_UCODE)
        }
    } > TX_LP1_UCODE_BUFFER
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx(START)
    GROUP LOAD((ADDR(VCPE_TX_LP0_RETX_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_TX_LP0_RETX_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.TX_LP0_RETX_UCODE)
        }
    } > TX_LP0_RETX_UCODE_BUFFER


    GROUP LOAD((ADDR(VCPE_TX_LP1_RETX_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_TX_LP1_RETX_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.TX_LP1_RETX_UCODE)
        }
    } > TX_LP1_RETX_UCODE_BUFFER
//XDSLRTFW-1048 Feature_US_VDSL2_ALL_UsReTx(END)

//XDSLRTFW-1617 (Start)
    GROUP LOAD((ADDR(VCPE_TX_LP1_RETX_IDILV_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_TX_LP1_RETX_IDILV_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.TX_LP1_RETX_IDILV_UCODE)
        }
    } > TX_LP1_RETX_IDILV_UCODE_BUFFER
//XDSLRTFW-1617 (End)

    GROUP LOAD((ADDR(VCPE_RX_LP0_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_RX_LP0_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.RX_LP0_UCODE)
        }
    } > RX_LP0_UCODE_BUFFER

    GROUP LOAD((ADDR(VCPE_RX_LP1_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_RX_LP1_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.RX_LP1_UCODE)
        }
    } > RX_LP1_UCODE_BUFFER

    GROUP LOAD((ADDR(VCPE_RX_LP1_RETX_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_RX_LP1_RETX_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.RX_LP1_RETX_UCODE)
        }
    } > RX_LP1_RETX_UCODE_BUFFER

//XDSLRTFW-1617 (Start)
    GROUP LOAD((ADDR(VCPE_RX_LP1_RETX_IDILV_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_RX_LP1_RETX_IDILV_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.RX_LP1_RETX_IDILV_UCODE)
        }
    } > RX_LP1_RETX_IDILV_UCODE_BUFFER
//XDSLRTFW-1617 (End)

    GROUP LOAD((ADDR(VCPE_TX_PORT1_LP0_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_TX_PORT1_LP0_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.TX_PORT1_LP0_UCODE)
        }
    } > TX_PORT1_LP0_UCODE_BUFFER

    GROUP LOAD((ADDR(VCPE_TX_PORT1_LP1_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_TX_PORT1_LP1_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.TX_PORT1_LP1_UCODE)
        }
    } > TX_PORT1_LP1_UCODE_BUFFER


    GROUP LOAD((ADDR(VCPE_RX_PORT1_LP0_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_RX_PORT1_LP0_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.RX_PORT1_LP0_UCODE)
        }
    } > RX_PORT1_LP0_UCODE_BUFFER

    GROUP LOAD((ADDR(VCPE_RX_PORT1_LP1_UCODE_FADX_DM))): {
        .DMSWAP_VCPE_RX_PORT1_LP1_UCODE ALIGN(4) : {
            Zep_microCodeData.o(.RX_PORT1_LP1_UCODE)
        }
    } > RX_PORT1_LP1_UCODE_BUFFER

    GROUP : {
        .DMSWAP_VCPE_AWRE_IBRAM ALIGN(4) : {
            *(.AWRE_IBRAM)
        }
    } > AWRE_IBRAM

#ifdef VDSL_62
   GROUP LOAD((ADDR(VCPE_ONE_PORT_SHOW_ONLY_FADX_DM_BT))): {
//     GROUP LOAD((ADDR(VCPE_ONE_PORT_SHOW_ONLY_FADX_DM))): {
        .DMSWAP_VCPE_ONE_PORT_SHOW_ONLY ALIGN(4) : {
            __gla_OnePortShowDataStart = .;
            Vr9_1port_debug_data.o(*.data*)
            Vr9_1port_debug_data.o(*.bss*)
        }
    } > ONE_PORT_SHOW_ONLY

//XDSLRTFW-1979  (START) //DM & PM Free up
	//XDSLRTFW-3558 Move Data from DEC memory to Bulk memory

    GROUP LOAD((ADDR(VCPE_NOISE_MRGN_SEP_FADX_DM))): {
        .DMSWAP_VCPE_NMRGN_SEP ALIGN(4): {
           __gla_NoiseMarginSepBufferStart = .;
            *(.NOISE_MARGIN_SEP_BUFFER)
        }
    } > NOISE_MARGIN_SEP_BUFFER
//XDSLRTFW-1979  (END) //DM & PM Free up

    // XDSLRTFW-2368 (Start)
    GROUP LOAD((ADDR(VCPE_DEBUG_TRACES_BUFFER_FADX_DM))): {
        .DMSWAP_VCPE_DEBUG_TRACES_BUFFER ALIGN(4): {
           __gla_DebugTracesBufferStart = .;
            *(.DEBUG_TRACES_BUFFER)
        }
    } > DEBUG_TRACES_BUFFER
    // XDSLRTFW-2368 (End)

#ifdef VRX518
    GROUP LOAD((ADDR(VCPE_BULK_DATA2_FADX_DM))): {
        .DMSWAP_VCPE_BULK_DATA2 ALIGN(4): {
           __gla_BULK_DATA2_Start = .;
            *(.BULK_DATA2_SECTION)
        }
    } > BULK_DATA2_SECTION
#endif

    //
    // no need to swap in these buffers
    //

    GROUP : {
        .DMSWAP_VCPE_ONE_PORT_SNR_BUF ALIGN(4) : {
            *(.ONE_PORT_SNR_BUF)
        }
    } > ONE_PORT_SNR_BUF

    GROUP : {
        .DMSWAP_VCPE_DUMMY_SRC_COEFS ALIGN(4) : {
            *(.TRAIN_DUMMY_SRC_COEFS)
        }
    } > DUMMY_SRC_COEFS_BUFFER

    GROUP : {
        .DMSWAP_VCPE_PERSISTENT_MEM_ADSL ALIGN(4) : {
            *(.PERSISTENT_RAM_ADSL)
        }
    } > PERSISTENT_MEM_ADSL


    GROUP : {
        .DMSWAP_VCPE_PERSISTENT_MEM_VDSL ALIGN(4) : {
            *(.PERSISTENT_RAM_VDSL)
        }
    } > PERSISTENT_MEM_VDSL

    GROUP : {
        .DMSWAP_VCPE_PERSISTENT_MEM_COMMON ALIGN(4) : {
            *(.PERSISTENT_RAM_COMMON)
        }
    } > PERSISTENT_MEM_COMMON

    // the following dummy pages are to get the start address of HW buffers in IIBRAM

    GROUP : {
        .DMSWAP_VCPE_ZEP_PRAM ALIGN(4) : {
            __gla_ZepPramStart = .;
        }
    } > ZEP_PRAM

    GROUP : {
        .DMSWAP_VCPE_ZEP_OVHD_FIFO ALIGN(4) : {
            __gla_ZepOvhdFifoStart = .;
        }
    } > ZEP_OVHD_FIFO

    GROUP : {
        .DMSWAP_VCPE_ZR_ILVB_RDPTR_TABLE ALIGN(4) : {
            __gla_ZrIlvbRdPtrTable = .;
        }
    } > ZR_ILVB_RDPTR_TABLE

    //XDSLRTFW-1571 (Start)
    GROUP : {
        .DMSWAP_VCPE_ZR_ILVB_WRPTR_TABLE ALIGN(4) : {
            __gula_ZrIlvbWrPtrTable = .;
        }
    } > ZR_ILVB_WRPTR_TABLE
    //XDSLRTFW-1571 (End)

    GROUP : {
        .DMSWAP_VCPE_ZEP_TXRX_UCODE ALIGN(4) : {
            __gla_ZepTxRxUcodeStart = .;
        }
    } > TX_RX_UCODE

    GROUP : {
        .DMSWAP_VCPE_TWO_PORT_SHOW_ONLY ALIGN(4) : {
            __gla_TwoPortShowDataStart = .;
         //XDSLRTFW-439: Feature_All_DS_All_All_SupportDsTxRefVirtualNoise (Start_End)
         *(.TWO_PORT_SHOW_ONLY)
      // new object.o(.data)
        }
    } > TWO_PORT_SHOW_ONLY

    GROUP : {
        .DMSWAP_VCPE_ST_VECTORING_BUFFER ALIGN(4) : {
            __gla_ShowTimeVectoringBuffer = .;
            *(.ST_VECTORING_BUFFER)
        }
    } > ST_VECTORING_BUFFER

    GROUP : {
        .DMSWAP_VCPE_ST_ILV_DILV_MEM ALIGN(4) : {
            __gla_HwIlvDilvStart = .;
        }
    } > ST_ILV_DILV_MEM

    //XDSLRTFW-1287 Feature_US_VDSL2_ALL_UsReTxAmend2_MemoryOpt (Start)
    GROUP : {
        .DMSWAP_VCPE_ILV_DILV_TRAINING_ONLY ALIGN(4) : {
            *(.TRAIN_ILV_DILV_TRAINING_ONLY)
        }
    } > ILV_DILV_TRAINING_ONLY_BUFFER
    //XDSLRTFW-1287 Feature_US_VDSL2_ALL_UsReTxAmend2_MemoryOpt (End)

    //XDSLRTFW-2059 : New page added in image for USPSD compensation table
    GROUP LOAD((ADDR(VCPE_COMP_TABLE_V2_FADX_DM))): {
        .DMSWAP_VCPE_COMP_TABLE_V2 ALIGN(4) : {
            *(.COMP_TABLE_V2)
        }
    } > COMP_TABLE_V2_ISWAP



    // off chip data storage

    // this is a dummy swap buffer to get the SRAM address
    // for WRITE_DATA_TO_SRAM page
    GROUP : {
        .DMSWAP_VCPE_WRITE_DATA_TO_SRAM ALIGN(4) : {
        }
    } > SRAM_BAR15

#ifdef ALLOW_READ_FROM_SRAM
    // this is a dummy swap buffer to get the SRAM address
    // for READ_DATA_FROM_SRAM page
    GROUP : {
        .DMSWAP_VCPE_READ_DATA_FROM_SRAM ALIGN(4) : {
        }
    } > SRAM_BAR15
#endif

    // these pages are real pages for SRAM buffers and MUST start after the above dummy pages
    GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA ALIGN(4) : {
            __StartOfSramBAR15 = .;
            *(.SRAM_BAR15)
        }
    } > SRAM_BAR15

    GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA_2 ALIGN(4) : {
            __StartOfSramBAR14 = .;
            *(.SRAM_BAR14)
        }
    } > SRAM_BAR14
#endif

    GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA_BAR16 ALIGN(4) : {
            __StartOfSramBAR16 = .;
            *(.SRAM_BAR16)
        }
    } > SRAM_BAR16

    GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA_BAR17 ALIGN(4) : {
            __StartOfSramBAR17 = .;
            *(.SRAM_BAR17)
        }
    } > SRAM_BAR17 
	//XDSLRTFW-3688(Start)
    GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA_BAR18 ALIGN(4) : {
            __StartOfSramBAR18 = .;
            *(.SRAM_BAR18)
        }
    } > SRAM_BAR18
    GROUP : {
        .DMSWAP_VCPE_SRAM_SAVED_DATA_BAR19 ALIGN(4) : {
            __StartOfSramBAR19 = .;
            *(.SRAM_BAR19)
        }
    } > SRAM_BAR19
	//XDSLRTFW-3688(End)


    GROUP : {
        .DMSWAP_VCPE_LOCAL_LD_ST ALIGN(4): {
            *(.LOCAL_LD_ST)
        }
    } > LOCAL_LD_ST_RAM

    GROUP : {
        .DMSWAP_VCPE_LD_ST_MKERNEL ALIGN(4): {
            *(.LOCAL_LD_ST_MKERNEL)
        }
    } > LOCAL_LD_ST_RAM

    GROUP: {
        .stack SIZE(DEFINED _STACKSIZE?_STACKSIZE:6144):{}
    } > STACK_RAM

#ifdef (TARGET_SIM || TARGET_ARC)
    GROUP LOAD((ADDR(VCPE_SIMTEST_FADX_DM_BT))): {
        .DMSWAP_VCPE_SIMTEST ALIGN(4):
        {
            *(.EXT_BULK)
            PrintTrail.o(.bss)
            PrintTrail.o(.data*)
            mini_stdio.o(.bss)
            _iob.o(.data*)
            _doprint.o(.data*)
            float.o(.data*)
            tlsctorg.o(.data*)
            ctype.o(.rodata)
            _pow10d.o(.data*)
            mwdctor.o(.data*)
            fpcon.o(.data*)
            logf.o(.data*)
            nmp.o(.bss*)
        }
    } > EXT_BULK_DATA_RAM
#endif

    GROUP LOAD((ADDR(VCPE_HMP_MBOXES_FADX_DM_BT))): {
        .DMSWAP_VCPE_HMP_MBOXES ALIGN(4): {
            // do NOT remove or change the following symbol !!!
            __gt_HmpHeader = .;
                SHORT((0x1 << 8) | 0x1);             // version, num_of_mbox_pairs
                SHORT((0x1 << 8) | 0x4);             // offset_to_first_desc, size_of_desc,

            __gta_HmpMboxDescriptor = .;
                LONG(ADDR(ARC_TO_MEI_MBOX));
                LONG(SIZEOF(ARC_TO_MEI_MBOX)/2);
                LONG(ADDR(MEI_TO_ARC_MBOX));
                LONG(SIZEOF(MEI_TO_ARC_MBOX)/2);

            __gs_Me2ArcMboxCode = .;
            __gt_Me2ArcMboxMsg = .;
                SHORT(0);           // mbox_code
                SHORT(0);            // word0
                SHORT(0);            // word1
                SHORT(0);            // word2
                SHORT(0);            // word3
                SHORT(0);            // word4
                FILL(128*2);        // payload; FILL directive fills num of BYTES!

            __gs_Arc2MeMboxCode = .;
            __gt_Arc2MeMboxMsg = .;
                SHORT(0);           // mbox_code
                SHORT(0);            // word0
                SHORT(0);            // word1
                SHORT(0);            // word2
                SHORT(0);            // word3
                SHORT(0);            // word4
                FILL(128*2);        // payload; FILL directive fills num of BYTES!
        }
    } > HMP_MBOXES

    GROUP LOAD((ADDR(VCPE_MAIN_FADX_DM_BT))): {
        .DMSWAP_VCPE_MAIN ALIGN(4): {
            // do NOT remove or change the following symbol !!!
            __gta_SwapTable = .;
            __gta_SwapTableEnd = .;


            interrupts_62.o(.data)
            *(.data*)
            *(.bss)
            *(.tls)
        }
    } > MAIN_BULK
}

// Flash/Sram Image section

SECTIONS {
    GROUP: {
        .VDSL_IMAGE_LAYOUT ALIGN(4): {
        // adx = 0x0000
            LONG(0);        // preamble
            LONG(0);        // memory ID
        // adx = 0x0008
            LONG(0);        // memory configuration
            LONG(0);
            LONG(0);
            LONG(0);
        // adx = 0x0018     // bootloader(0) record
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
        // adx = 0x0034     // bootloader(1) record
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
            LONG(0);
        // adx = 0x0050     // FW(0) record
            LONG(0x80000000 | (ADDR(VDSL_IMAGE_HEADER_FADX) - ADDR(VDSL_IMAGE_LAYOUT_FADX)))    // start of FW
            LONG(0);
            LONG(0);
        // adx = 0x005C     // configuration(0) record
            LONG(0x80000000 | (ADDR(VDSL_IMAGE_CONFIG_0_FADX) - ADDR(VDSL_IMAGE_LAYOUT_FADX)));
            LONG(SIZEOF(.VDSL_IMAGE_CONFIG_0))
            LONG(0);
        // adx = 0x0068     // FW(1) record
            LONG(0x0)       // start of FW
            LONG(0);
            LONG(0);
        // adx = 0x0074     // configuration(1) record
            LONG(0);
            LONG(0);
            LONG(0);
        }
    } > VDSL_IMAGE_LAYOUT_FADX

    GROUP: {
        // an example of configuration record based on input scripts for asim_vdsl_fdconn_train_test
        // lines starting with # are comments
        // lines starting with M are actual commands/messages
        // For the checked-in version, only the link activate command is used (on the last line)
        .VDSL_IMAGE_CONFIG_0 ALIGN(4): {
            ASCII(# This is an example configuration record file)
            ASCII(# CW test 0 0 0x3108      // LogSnrFdq: on, SFControl: on, connectivity: on, channel: on)
            ASCII(# 4040 0001 0004 0000 0001 3108)
            ASCII(#M 0044 0000 0001 3108)
            ASCII(# CW test 1 0 1           // freq domain connectivity: on)
            ASCII(# 4040 0001 0104 0000 0001 0001)
            ASCII(#M 0144 0000 0001 0001)
            ASCII(# CW TEST 2 0 1           // init state: train)
            ASCII(# 4040 0001 0204 0000 0001 0001)
            ASCII(#M 0244 0000 0001 0001)
            ASCII(# CW test 5 0 200         // SFCnt: 200)
            ASCII(# 4040 0001 0504 0000 0001 00C8)
            ASCII(#M 0544 0000 0001 00C8)
            ASCII(# CW info 5 0 32 d i      // stop at rx showtime)
            ASCII(# 4040 0001 0503 0000 0001 0020)
            ASCII(#M 0543 0000 0001 0020)
            ASCII(# CW test 7 0 170         // LogToneIdx: 170)
            ASCII(# 4040 0001 0704 0000 0001 00AA)
            ASCII(#M 0744 0000 0001 00AA)
            ASCII(# CW optn 2 1 0x001C      // PARR: off, MFDQ train: off, Multi synch: off)
            ASCII(# 4040 0001 0205 0001 0001 001C)
            ASCII(#M 0245 0001 0001 001C)
            ASCII(# CW optn 2 2 0x002F      // tcm: off, bit-swap: off, FDQ update: on, MFDQ update: off, SNR update: on)
            ASCII(# 4040 0001 0205 0002 0001 002F)
            ASCII(#M 0245 0002 0001 002F)
            ASCII(# CW cntl 0 0 0x02        // start modem)
            ASCII(# 4040 0001 0001 0000 0001 0002)
            ASCII(M 0041 0000 0001 0002)
        }
    } > VDSL_IMAGE_CONFIG_0_FADX

    GROUP: {
        .VDSL_IMAGE_HEADER ALIGN(4): {
        _StartOfFlash = .;
            LONG(ADDR(VDSL_CACHE_HEADER_FADX) - ADDR(VDSL_IMAGE_HEADER_FADX) - 8);   // IMAGE SIZE in bytes
            LONG(0x00000000)                      // image checksum

            // The rest of VDSL_IMAGE_HEADER_BLOCK will be generated by setup_codeswap.pl
        }
    } > VDSL_IMAGE_HEADER_FADX

    // we will manually maintain the cache pages; probably won't change much.
    GROUP: {
        .VDSL_CACHE_HEADER ALIGN(4): {
        _VdslCacheHeader = .;
            LONG(ADDR(LAST_FADX) - ADDR(VDSL_CACHE_HEADER_FADX) - 8);   // IMAGE SIZE in bytes
            LONG(0x00000000)                      // image checksum
#ifdef VRX518
            LONG(1)                               // number of cache pages - hardcoded
#endif	    
#ifdef VRX318
            LONG(2)                               // number of cache pages - hardcoded
#endif
#ifdef VRX218
            LONG(4)                               // number of cache pages - hardcoded
#endif
            LONG(ADDR(VCPE_CACHE_1_FADX) - ADDR(VDSL_CACHE_HEADER_FADX));
            LONG(ADDR(.PMSWAP_VCPE_CACHE_1));
            LONG(SIZEOF(VCPE_CACHE_1_FADX)/4);
            LONG(0);
            LONG(0);
            LONG(0);
#ifdef (VRX218 || VRX318)
            LONG(ADDR(VCPE_CACHE_TRAIN_1_FADX) - ADDR(VDSL_CACHE_HEADER_FADX));
            LONG(ADDR(.PMSWAP_VCPE_CACHE_TRAIN_1));
            LONG(SIZEOF(VCPE_CACHE_TRAIN_1_FADX)/4);
            LONG(0);
            LONG(0);
            LONG(0);
#endif
	    
#ifdef VRX218
            LONG(ADDR(VCPE_CACHE_TRAIN_2_FADX) - ADDR(VDSL_CACHE_HEADER_FADX));
            LONG(ADDR(.PMSWAP_VCPE_CACHE_TRAIN_2));
            LONG(SIZEOF(VCPE_CACHE_TRAIN_2_FADX)/4);
            LONG(0);
            LONG(0);
            LONG(0);

            LONG(ADDR(VCPE_CACHE_TRAIN_3_FADX) - ADDR(VDSL_CACHE_HEADER_FADX));
            LONG(ADDR(.PMSWAP_VCPE_CACHE_TRAIN_3));
            LONG(SIZEOF(VCPE_CACHE_TRAIN_3_FADX)/4);
            LONG(0);
            LONG(0);
            LONG(0);
#endif
        }
    } > VDSL_CACHE_HEADER_FADX
}

#include "vcpe_customer.cmd"
