# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**

$cmd_file = @ARGV[0];
$ElfDump_file = @ARGV[1];
($itux = @ARGV[2]) =~ tr/a-z/A-Z/;


open(CMD_FILE, "<$cmd_file") || die "Failed to open $cmd_file\n";
open(ELFDUMP_FILE, "<$ElfDump_file") || die "Failed to open $ElfDump_file\n";


#foreach $section (keys %section_start)
#{
#    print "$section start $section_start{$section} size $section_allocated_size{$section}\n";
#}

while (<ELFDUMP_FILE>)
{
    # catch PM_section info
    #^36  0x13f00     8308 LOC  SECT .DMSWAP_BULK_O1
    if (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+LOC\s+SECT\s+(\.\w+)/)
    {
        $section_allocated_size{$3} = $2;
#        print "$3: dec($2) $2\n";
    }
}
seek(ELFDUMP_FILE, 0, 0);

$state = 0;

_while_0:
{
    while (<CMD_FILE>)
    {
        if ($state == 0)
        {
            if (/^\s*MEMORY\s*\{/)
            {
                $state = 10;
            }
        }
        elsif ($state == 10)
        {
            #end of this memory section when reaches the FADX
            if (/^\s*(\w+FADX\w*)/)
            {
                if (0)
                {
                    foreach $name (keys %section_start)
                    {
                        printf("$name: $section_start{$name} 0x%x\n", $section_allocated_size{$name});
                    }
                }
                last _while_0;
            }

            if (/^\s*(\w+)_ISWAP\s*:\s*ORIGIN\s*=\s*ADDR\((\w+)\)/)
            {
                if (defined $section_start{$2})
                {
                    $section_name = $2;
                    $page_name = $1;
                    $PM_section_list{$section_name} .= " $page_name";
                    $PM_page_to_section{$page_name} = $section_name;
#print "PM: $section_name $page_name \n"; 

                }
            }
            elsif ((/^\s*(\w+_RAM)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)\/\//) ||
                   (/^\s*(\w+_RAM)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)$/) ||
                   (/^\s*(\w+_BULK)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)\/\//) ||
                   (/^\s*(\w+_BULK)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)$/) ||
                   (/^\s*(\w+_MBOXES)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)\/\//) ||
                   (/^\s*(\w+_MBOXES)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)$/))
            {
                    $section_name = $1;
                    $page_name = $1;
                    $DM_section_list{$section_name} .= "$page_name ";
                    $DM_page_to_section{$page_name} = $section_name;

                $section_list{$section_name} = $section_name;
                $start = $2;
                $length = $3;

                ($start = $start) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_allocated_size{$1}/g;
                ($start = $start) =~ s/ADDR\(\s*(\w+)\s*\)/$section_start{$1}/g;
                ($start = $start) =~ s/(\d+)[kK]/$1\*1024/g;
                $section_start{$section_name} = eval("$start");

                ($length = $length) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_allocated_size{$1}/g;
                ($length = $length) =~ s/(\d+)[kK]/$1\*1024/g;
                $section_allocated_size{$section_name} = eval("$length");
#printf("DM: $section_name :, start = 0x%x, length =  %s = 0x%x\n", $section_start{$section_name}, $length, eval($length));
            }

            elsif ((/^\s*(\w+)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)\/\//) ||
                   (/^\s*(\w+)\s*:\s*ORIGIN\s*=\s*(.+)\s*[,]*\s*LENGTH\s*=\s*(.*)$/))
            {
                $section_name = $1;
                $section_list{$section_name} = $section_name;
                $start = $2;
                $length = $3;

                ($start = $start) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_allocated_size{$1}/g;
                ($start = $start) =~ s/ADDR\(\s*(\w+)\s*\)/$section_start{$1}/g;
                ($start = $start) =~ s/(\d+)[kK]/$1\*1024/g;
                $section_start{$section_name} = eval("$start");

                ($length = $length) =~ s/SIZEOF\(\s*(\.*\w+)\s*\)/$section_allocated_size{$1}/g;
                ($length = $length) =~ s/(\d+)[kK]/$1\*1024/g;
                $section_allocated_size{$section_name} = eval("$length");
#printf("$section_name :, start = 0x%x, $length =  %s = 0x%x\n", $section_start{$section_name}, $length, eval($length));
                
            }

        }
    }
}


while (<ELFDUMP_FILE>)
{
    # catch PM_section info
    #^36  0x13f00     8308 LOC  SECT .DMSWAP_VCO_MAIN
    if (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+LOC\s+SECT\s+\.PMSWAP_${itux}_(\w+)/i)
    {
        $page_name = $3;
        $page_start = $1;
        $page_size = $2;

        if (defined $PM_page_to_section{$page_name})
        {
            ${"$PM_page_to_section{$page_name}_PM_summary"}{eval($page_size)} = $page_name;
        }

        if (!defined $pmswap_list{"PMSWAP_${itux}_$3"})
        {
            $pmswap_list{"PMSWAP_${itux}_$3"} = 1;
        }
    }
    elsif ((/^\s*\d+\s+(0x\w+)\s+(\d+)\s+LOC\s+SECT\s+\.DMSWAP_${itux}_(\w+)/i) ||
           (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+LOC\s+SECT\s+\.(\w+)/))
    {
        $page_name = $3;
        $page_start = $1;
        $page_size = $2;
        if (defined $DM_page_to_section{$page_name})
        {
            ${"$DM_page_to_section{$page_name}_DM_summary"}{eval($page_size)} = $page_name;
        }

        if (defined $DM_page_to_section{"${page_name}_BULK"})
        {
            $temp = "${page_name}_BULK";
            ${"$DM_page_to_section{$temp}_DM_summary"}{eval($page_size)} = $page_name;
            ${"$section_list{$page_name}_DM_summary"}{eval($page_size)} = $page_name;
        }

        # this is for PARR_VEC page
#        if (defined $PM_page_to_section{$page_name})
#        {
#            ${"$PM_page_to_section{$page_name}_PM_summary"}{eval($page_size)} = $page_name;
#
#            if (!defined $pmswap_list{"PMSWAP_${itux}_$3"})
#            {
#                $pmswap_list{"PMSWAP_${itux}_$3"} = 1;
#            }
#        }

        if (defined $DM_page_to_section{"${page_name}_RAM"})
        {
            $temp = "${page_name}_RAM";
            ${"$DM_page_to_section{$temp}_DM_summary"}{eval($page_size)} = $page_name;
            ${"$section_list{$page_name}_DM_summary"}{eval($page_size)} = $page_name;
        }
        elsif (defined $section_list{$page_name})
        {
            ${"$section_list{$page_name}_DM_summary"}{eval($page_size)} = $page_name;
        }

        if ($page_name eq "stack")
        {
            ${"STACK_RAM_DM_summary"}{eval($page_size)} = $page_name;
        }

        if (!defined $dmswap_list{"DMSWAP_${itux}_$3"})
        {
            $dmswap_list{"DMSWAP_${itux}_$3"} = 1;
        }
    }

    # catch PM swap page details info
    #^111  0x84d8       216 LOC  FUNC .PMSWAP_INIT Config_Potshpf
    elsif (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+LOC\s+FUNC\s+\.(PMSWAP_${itux}_\w+)\s+(\w+)/i)
    {
        if ($4 ne "\$t")
        {
            $address = sprintf("0x%08x", eval($1));
            $size = sprintf("%05d", eval($2));
            ${"$3"}{"$size\@$4(static)"} = "$address";
        }
    }
    elsif (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+GLOB\s+FUNC\s+\.(PMSWAP_${itux}_\w+)\s+(\w+)/i)
    {
        $address = sprintf("0x%08x", eval($1));
        $size = sprintf("%05d", eval($2));
        ${"$3"}{"$size\@$4"} = "$address";
    }
    elsif (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+GLOB\s+FUNC\s+\.(DMSWAP_${itux}_\w+)\s+(\w+)/i)
    {
        $address = sprintf("0x%08x", eval($1));
        $size = sprintf("%05d", eval($2));
        $func_name = $4;
        ($temp = $3) =~ s/DMSWAP/PMSWAP/; 
        ${"$temp"}{"$size\@$func_name"} = "$address";
    }
    # catch DM swap page details info
    #^111  0x84d8       216 GLOB  OBJ .PMSWAP_INIT Config_Potshpf
    elsif (/^\s*\d+\s+(0x\w+)\s+(\d+)\s+GLOB\s+OBJ\s+\.(DMSWAP_${itux}_\w+)\s+(\w+)/i)
    {
        $address = sprintf("0x%08x", eval($1));
        $size = sprintf("%05d", eval($2));
        ${"$3"}{"$size\@$4"} = "$address";
    }

    # catch DM info
}
close (ELFDUMP_FILE);


# output PM section summary
print "\tPM SECTIONS SUMMARY\n\n";

printf("%s\t%s\n", "Overlay Buffer", "Allocated");
printf("%s\t%s\t%s\t%s\n", "Swap Page", "Actual Size", "Free Bytes", "Percentage");
printf("%s\t%s\t%s\t%s\n\n", "================", "===========", "===========", "===========");

foreach $section (keys %section_list)
{
    if (defined %{"${section}_PM_summary"})
    {

        $alloc_size = $section_allocated_size{$section};
        printf("\n%s\n", "PM Overlay $section");
        printf("%s0x%08x\t%d (allocated)\tFree\tPercent\n", "origin = ", $section_start{$section}, $alloc_size);
        printf("------------------------\t--------------------------------\t-------------\t-------------\n");
        foreach $page_size (sort numeric keys %{"${section}_PM_summary"})
        {
            $temp = ${"${section}_PM_summary"}{$page_size};
            printf("%s\t%d\t%d\t%8.1f\n", "page ${temp}", $page_size, 
                   ($alloc_size - $page_size), ($page_size*100/$alloc_size));
        }
        print "\n";
    }
}


# output DM section summary

print "\n\n\tDM SECTIONS SUMMARY\n\n";

printf("%s\t%s\n", "Overlay Buffer", "Allocated");
printf("%s\t%s\t%s\t%s\n", "Swap Page", "Actual Size", "Free Bytes", "Percentage");
printf("%s\t%s\t%s\t%s\n\n", "================", "===========", "===========", "===========");

foreach $section (keys %section_list)
{
    if (defined %{"${section}_DM_summary"})
    {
        $alloc_size = $section_allocated_size{$section};
        printf("\n%s\n", "DM Overlay $section");
        printf("%s0x%08x\t%d (allocated)\tFree\tPercent\n", "origin = ", $section_start{$section}, $alloc_size);
        printf("------------------------\t--------------------------------\t-------------\t-------------\n");
        foreach $page_size (sort numeric keys %{"${section}_DM_summary"})
        {
            $temp = ${"${section}_DM_summary"}{$page_size};
            printf("%s\t%d\t%d\t%8.1f\n", "page ${temp}", $page_size, 
                   ($alloc_size - $page_size), ($page_size*100/$alloc_size));
        }
        print "\n";
    }
}

print "\n***************\n";
print "\nDM details\n";
print "\n***************\n\n";

foreach $dmswap (keys %dmswap_list)
{
    if (%{$dmswap})
    {
        printf("\n$dmswap:\n");
        printf("\t%s\n", "Top 20");
        printf("\t%s\t%s\t%s\n", "Variable Name", "Address", "Size(bytes)");
        printf("\t%s\t%s\t%s\n", "--------------------", "--------------", "------------------");

        $i = 0;
        _foreach_0_loop:
        {
            foreach $var (sort numeric keys %{$dmswap})
            {
                $i++;
                ($size = $var) =~ s/\@.*//;
                ($var_name = $var) =~ s/.*@//;
                printf("\t%s\t%s\t%d \n", $var_name, ${"$dmswap"}{$var}, $size);
                if ($i >= 20)
                {
                    last _foreach_0_loop;
                }
            }
        }
    }
}

print "\n***************\n";
print "\nPM details\n";
print "\n***************\n\n";

foreach $pmswap (keys %pmswap_list)
{
    if (%{$pmswap})
    {
        printf("\n$pmswap:\n");

        printf("\t%s\t%s\t%s\n", "Function Name", "Address", "Size(bytes)");
        printf("\t%s\t%s\t%s\n", "--------------------", "--------------", "------------------");

        foreach $func (sort numeric keys %{$pmswap})
        {
            #print "$func ${$pmswap}{$func}\n";
            ($size = $func) =~ s/\@.*//;
            if ($size > 0)
            {
                ($func_name = $func) =~ s/.*@//;
                printf("\t%s\t%s\t%5d\n", $func_name, ${"$pmswap"}{$func}, $size);
            }
        }
    }
}

sub numeric { $b <=> $a; }

sub eval1
{
    print " @_\n";
}
