# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
$rls_dir = $ARGV[0];
$obj_dir = $ARGV[1];
$cur_timestamps = "$rls_dir/$ARGV[3]";
$force_rebuild = $ARGV[4];


$old_time_stamps_exist = 0;
_skip_old_timestamps:
{
    open(TIME_STAMPS, "<$cur_timestamps") || last _skip_old_timestamps;
    while(<TIME_STAMPS>)
    {
        if ((m%\s*(\.\.\S+\.c)\s+(\d+)%) || (m%\s*(\.\.\S+\.s)\s+(\d+)%) || (m%\s*(\.\.\S+\.h)\s+(\d+)%))
        {
            $old_time_stamps{$1} = $2;
            $old_time_stamps_exist = 1;
        }
    }
}
close(TIME_STAMPS);


foreach $src_file (split(' ',$ARGV[2]))
{
    open(SRC_FILE, "<$src_file") || die "Failed to open $src_file\n";

    while(<SRC_FILE>)
    {
        s%\\\\%\/%g;
        s%\s*\\\s*%%g;
        s%\/\/%\/%g;
        s%^\s+%%;
        s%^.*\.\./\.\./source%\.\./source%;
        s%^.*\.\./\.\./soc_src%\.\./soc_src%;
        s%^.*\.\./\.\./arc_src%\.\./arc_src%;
        if (m%\s*(\w+)(\.[sc])\s*\\*\s*$%)
        {
            $object_list{$1} = 1;
            $full_path_object_list{$1} = $_;
            $object_file{$1} = $1.$2;
            $object_file_pattern{$1} = "$1\\$2";

        }
    }
    close(SRC_FILE);
}


foreach $object (keys %object_list)
{
    if (open(RLS_FILE, "<$rls_dir/$object.rls"))
    {
        _while_RLS_FILE:
        while(<RLS_FILE>)
        {
            if (/\S+\.rls\s*:/)
            {
                last _while_RLS_FILE;
            }
            s%^\s+%%;
            s%\\\\%\/%g;
            s%\s*\\\s*%%g;
            s%\/\/%\/%g;
            s%.*:\s*%%;
            s%\s*\$\S+\s*%%;
            s%^.*\.\./\.\./source%\.\./source%g;
            s%^.*\.\./\.\./soc_src%\.\./\.\./soc_src%g;
            s%^.*\.\./\.\./arc_src%\.\./\.\./arc_src%g;
            while (m%(\.\.\S+\.[shc])%g)
            {

                ${"$1_dependency"}{$object} = 1;
                ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size, $atime,$mtime,$ctime,$blksize,$blocks) = stat("$1");
                $new_time_stamps{$1} = $mtime;

                $the_file = $1;

                if (($the_file =~ m/$object_file_pattern{$object}/) && ($full_path_object_list{$object} ne $the_file))
                {
                    print "$the_file  >>> has been changed to >>> $full_path_object_list{$object}\n";

                    $old_time_stamps{$the_file} = 0;
                }

            }

        }
        close(RLS_FILE);

    }
    else
    {
#        print "Failed to open $object.rls\n";
    }
}

if ($force_rebuild)
{
    foreach $src_file (keys %new_time_stamps)
    {
        if (($old_time_stamps_exist) && ($new_time_stamps{$src_file} != $old_time_stamps{$src_file}))
        {
            foreach $object (keys %{"${src_file}_dependency"})
            {
                $obj_to_remove{$object} = 1;
            }
        }
    }

    foreach $object (keys %obj_to_remove)
    {
        print "            removing $rls_dir/$object.rls\n";
        system("rm -f $rls_dir/$object.rls");
        print "            removing $obj_dir/$object.o\n";
        system("rm -f $obj_dir/$object.o");
    }
}
else
{
    open(TIME_STAMPS, ">$cur_timestamps") || die "Failed to open $cur_timestamps";
    foreach $src_file (keys %new_time_stamps)
    {
        print TIME_STAMPS "$src_file $new_time_stamps{$src_file}\n";
    }

    close(TIME_STAMPS);
    print "\tgenerating $cur_timestamps\n\n";
}
