# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
    $USAGE = "Usage:  perl gen_c_rls.pl ".
             "\tCC_COMMAND\n".
             "\tCOMMAND_STRING\n".
             "\tinclude_path_list\n".
             "\tsource_file_name_with_path\n".
             "\tsource_file_notdir\n".
             "\trls_file_name\n".
             "\ttemp_file_name\n".
             "\tobj_dir_name\n".
             "\tuser_flag_dir\n".
             "\tmake_inputs_dir\n";
    
    $CC_COMMAND = @ARGV[0];
    $AS_COMMAND = @ARGV[1];
    $COMMAND_STRING = @ARGV[1];
    $include_path_list = @ARGV[2];
    $source_file_name = @ARGV[3];
    ($source_file_notdir = @ARGV[4]) =~ s/\.c//;
    $rls_file_name = @ARGV[5];
    $temp_file_name = @ARGV[6];
    $obj_dir = @ARGV[7];
    $uflag_dir = @ARGV[8];
    $make_inputs_dir = @ARGV[9];
    
    $debug = 0;
    
    if ($debug)
    {
        print "CC_COMMAND = @ARGV[0]\n";
        print "COMMAND_STRING = @ARGV[1]\n";
        print "include_path_list = @ARGV[2]\n";
        print "source_file_name = @ARGV[3]\n";
        print "source_file_notdir = @ARGV[4]\n";
        print "rls_file_name = @ARGV[5]\n";
        print "temp_file_name = @ARGV[6]\n";
        print "obj_dir = @ARGV[7]\n";
        print "uflag_dir = @ARGV[8]\n";
        print "make_inputs_dir = @ARGV[9]\n";
    }
    
    if ($#ARGV == 10)
    {
        $codeswap_source = $ARGV[10];
        if ($codeswap_source ne "CODESWAP_SOURCE")
        {
    	    die($USAGE);
        }
    }
    elsif ($#ARGV != 9)
    {
    	die($USAGE);
    }
    
    #generate rules from ${temp_file_name}.c
    
    #print ("$CC_COMMAND -P -Hmake -Hrel $include_path_list ${source_file_name} > ${temp_file_name}.dep");
    system ("$CC_COMMAND -P -Hmake -Hrel $include_path_list ${source_file_name} > ${temp_file_name}.dep");
    
    if ($? != 0)
    {
        $temp_string = "$CC_COMMAND -P -Hmake $include_path_list ${source_file_name} > ${temp_file_name}.dep";
        ($temp_string = $temp_string) =~ s/\//\\/g;
        
        system("rm -f $rls_file_name\n");
        print "\n\n\n";
        system("type ${temp_file_name}.dep");
        print "\n\n\n";
        die ("failed to generate $rls_file_name. Please look at the above error output\n\n\n");
    }
    
    open(DEP_INPUT, "<${temp_file_name}.dep") || die "cannot open ${temp_file_name}.dep\n";
    open(DEP_OUTPUT, ">$rls_file_name") || die "cannot open scratch file $rls_file_name\n";
    
    print (DEP_OUTPUT "${source_file_notdir}_rls = 1\n\n");

    while(<DEP_INPUT>)
    {
        ($temp = $_) =~ s/\.o/.rls/;

        s/.o\s*:/.o:   \$(${source_file_notdir}_uf) /;

        if (/^w /)
        {
            #print ("!!! WARNING !!!\n\ncompiler warning(s) removed from $rls_file_name file\n\t\t$_\n\n");
            print ("\t$_\n");
            #"$CC_COMMAND -P -Hmake -Hrel $include_path_list ${source_file_name} > ${temp_file_name}.dep");
        }
        elsif (/^MetaWare/)
        {
            print ("\t$_\n");
        }
        else
        {
            print (DEP_OUTPUT $_);
            $dep_line .= $temp;
        }
    
    }

    $rule_line = 
        "\t\$(CC_COMMAND) \$(ALL_INC_PATHS) \$(\@${source_file_notdir}_uf) \$(filter %/${source_file_notdir}.c, \$(NON_CODESWAP_SOURCES) \$(CODESWAP_SOURCES)) -o \$(OBJ_DIR)/${source_file_notdir}.o\n" .
        "\t\@if exist ${source_file_notdir}.s  mv ${source_file_notdir}.s \$(ASM_DIR)/${source_file_notdir}.s\n";
    print (DEP_OUTPUT "\n$rule_line\n");
    
    print (DEP_OUTPUT "\n$dep_line");

	$rule_line = 
    "\t\@echo\t\t\tgenerating ${source_file_notdir}.rls\n" .
    "\t\@perl \$(PERL_DIR)/gen_C_rls.pl \"\$(CC_COMMAND)\" \"CC_COMMAND\" \\\n" .
    "\t\"\$(ALL_INC_PATHS)\" \"\$(filter %/${source_file_notdir}.c, \$(NON_CODESWAP_SOURCES) \$(CODESWAP_SOURCES))\" \\\n" .
    "\t\"${source_file_notdir}.c\" \"\$(RLS_DIR)/${source_file_notdir}.rls\" tempzzz \$(OBJ_DIR) \$(UFLAGS_DIR) \$(MAKE_INPUTS)\n".
    "\t\@-rm -f tempzzz*";

    print (DEP_OUTPUT "\n$rule_line\n");

#    print (DEP_OUTPUT "\n\t\$(${COMMAND_STRING}) $include_path_list".
#                      " \@${uflag_dir}/\$(notdir \$*).uf $source_file_name -o ${obj_dir}/\$(notdir \$@) \n");
#    print (DEP_OUTPUT "\t\@if exist ${source_file_notdir}.s  mv ${source_file_notdir}.s \$(ASM_DIR)/${source_file_notdir}.s\n");
    
    close DEP_OUTPUT;
    
    system ("if exist ${source_file_notdir}.i rm ${source_file_notdir}.i");
