# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
    $USAGE = "Usage:  perl gen_rls_for_asm.pl ".
             "\tCC_COMMAND\n".
             "\tAS_COMMAND\n".
             "\tAS_COMMAND_STRING\n".
             "\tinclude_path_list\n".
             "\tasm_file_name_with_path\n".
             "\tasm_file_notdir\n".
             "\trls_file_name\n".
             "\ttemp_file_name\n".
             "\tobj_dir_name\n".
             "\tuser_flag_dir\n".
             "\tmake_inputs_dir\n";
    
    $CC_COMMAND = @ARGV[0];
    $AS_COMMAND = @ARGV[1];
    $AS_COMMAND_STRING = @ARGV[2];
    $include_path_list = @ARGV[3];
    $asm_file_name = @ARGV[4];
    ($asm_file_notdir = @ARGV[5]) =~ s/\.s//;
    $rls_file_name = @ARGV[6];
    $temp_file_name = @ARGV[7];
    $obj_dir = @ARGV[8];
    $uflag_dir = @ARGV[9];
    $make_inputs_dir = @ARGV[10];
    
    $debug = 0;
    
    if ($debug)
    {
        print "CC_COMMAND = @ARGV[0]\n";
        print "AS_COMMAND = @ARGV[1]\n";
        print "AS_COMMAND_STRING = @ARGV[2]\n";
        print "include_path_list = @ARGV[3]\n";
        print "asm_file_name = @ARGV[4]\n";
        print "asm_file_notdir = @ARGV[5]\n";
        print "rls_file_name = @ARGV[6]\n";
        print "temp_file_name = @ARGV[7]\n";
        print "obj_dir = @ARGV[8]\n";
        print "uflag_dir = @ARGV[9]\n";
        print "make_inputs_dir = @ARGV[10]\n";
    }
    
    if ($#ARGV != 10)
    {
    	die($USAGE);
    }
    
    #print("$AS_COMMAND -w -c -Hasopt=-l,-ffimngnsnxno $include_path_list $asm_file_name -o ${temp_file_name}.o");
    system ("$AS_COMMAND -w -c -Hasopt=-l,-ffimngnsnxno $include_path_list $asm_file_name -o ${temp_file_name}.o");
    
    if ($? != 0)
    {
        system("cp ${temp_file_name}.lst ${rls_file_name}.bad");

        die ("\n\nfailed to generate $rls_file_name. See error output in ${rls_file_name}.bad\n\n\n");
    }
    
    open(LST_INPUT, "<${temp_file_name}.lst") || die "cannot open scratch file ${temp_file_name}.lst\n";
    open (TMP_OUT, ">${temp_file_name}.c") || die "cannot open scratch file ${temp_file_name}.c";
    
    while (<LST_INPUT>)
    {
         if (/^(\d+\.*)*\s*\.include\s*["<]\s*(\w+\.h)\s*[">]/)
         {
             print (TMP_OUT "#include \"$2\"\n");
             #print ("#include \"$2\"\n");
         }
    }
    #print ("\nvoid junk(void){ }");
    
    print (TMP_OUT "\nvoid junk(void){ }");
    close TMP_OUT;
    close LST_INPUT;
    
    #generate rules from ${temp_file_name}.c
    #print ("$CC_COMMAND -P -Hmake -Hrel $include_path_list ${temp_file_name}.c > ${temp_file_name}.dep");
    system ("$CC_COMMAND -P -Hmake $include_path_list ${temp_file_name}.c > ${temp_file_name}.dep");
    
    
    if ($? != 0)
    {
        print "\n\n\n";
        system("type ${temp_file_name}.dep");
        print "\n\n\n";

        die ("failed to generate $rls_file_name. See above error output\n");
    }
    
    open(DEP_INPUT, "${temp_file_name}.dep") || die "cannot open scratch file ${temp_file_name}.dep\n";
    open (TMP_OUT, ">$rls_file_name") || die "cannot open scratch file $rls_file_name\n";
    
    print (TMP_OUT "${asm_file_notdir}_rls = 1\n\n");

    while (<DEP_INPUT>)
    {

        $_ =~ s/${temp_file_name}\.c/$asm_file_name/;
        $_ =~ s/${temp_file_name}/${asm_file_notdir}/g;
        ($temp = $_) =~ s/\.o/.rls/;
        s/.o\s*:/.o:   \$(${asm_file_notdir}_uf) /;
        if (/^w /)
        {
            $temp_string = "$CC_COMMAND -P -Hmake -Hrel $include_path_list ${asm_file_name} > ${temp_file_name}.dep";
            ($temp_string = $temp_string) =~ s/\//\\/g;
            
            print ("failed to run:\n".  $temp_string . "\nThere are compiler warning(s) in $rls_file_name file\n");
                #"$CC_COMMAND -P -Hmake -Hrel $include_path_list ${asm_file_name} > ${temp_file_name}.dep");

        }
        print (TMP_OUT $_);
        $dep_line .= $temp;
    
    
    }
    
    $rule_line =
        "\t\$(AS_COMMAND) \$(ALL_INC_PATHS) \$(\@${asm_file_notdir}_uf) \$(filter %/${asm_file_notdir}.s, \$(NON_CODESWAP_SOURCES) \$(CODESWAP_SOURCES)) -o \$(OBJ_DIR)/${asm_file_notdir}.o\n";
    print (TMP_OUT "\n$rule_line\n");

    print (TMP_OUT "\n$dep_line");

	$rule_line = 
    "\t\@echo\t\t\tgenerating ${asm_file_notdir}.rls\n" .
    "\t\@perl \$(PERL_DIR)/gen_ASM_rls.pl \"\$(CC_COMMAND)\" \"\$(AS_RLS_COMMAND)\" \"AS_COMMAND\" \\\n" .
    "\t\"\$(ALL_INC_PATHS)\" \"\$(filter %/${asm_file_notdir}.s, \$(NON_CODESWAP_SOURCES) \$(CODESWAP_SOURCES))\" \\\n" .
    "\t\"${asm_file_notdir}.s\" \"\$(RLS_DIR)/${asm_file_notdir}.rls\" tempzzz \$(OBJ_DIR) \$(UFLAGS_DIR) \$(MAKE_INPUTS)\n".
    "\t\@-rm -f tempzzz*";

    print (TMP_OUT "\n$rule_line\n");
    close TMP_OUT;
    close DEP_INPUT;
