# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
#
# extract VDSL version from obj\vcpe\vcpe_non_cache.bin
# Copy built output vcpe_hw.bin & vcpe_hw.out to the form of VR9_xxxxxx.* in the same obj directory.
#

open(VDSL, "<obj\\vcpe\\vcpe_non_cache.bin") || die "!!! Error: Can't open obj\\vcpe\\vcpe_non_cache.bin !!!\n";
binmode(VDSL);
print "\tget VDSL version from $ARGV[0]...\n";

$found = 0;
while(<VDSL>)
{
    if (/\@\(\#\)[V_]*([a-f0-9\.a-f0-9\_]+)/i)
    {
        $version = $1;
        $version =~ s/\.//g;
        $found = 1;
    }
}
close(VDSL);

if ($found == 1)
{
    print "\t\tfound VDSL version: $version\n\n";
}
else
{
    die "!!! Error: couldn't get the version string from bin file !!!\n";
}



$new_target = "$ARGV[0]";
$obj_path = "obj\\vcpe\\"; 



# Generate a version string from above
   
$target = "${obj_path}vcpe_hw";
$target_ver = "${obj_path}${new_target}_${version}";

# Copy the standard .bin & .out files to the ones with version string attached.
if (-e "$target.bin")
{
	print "\nCopying $target.bin to $target_ver.bin\n";
	system ("copy $target.bin $target_ver.bin");
}
else
{
	print "\nFile $target.bin does not exist\n";
}

if (-e "$target.out")
{
	print "\nCopying $target.out to $target_ver.out\n";
	system ("copy $target.out $target_ver.out");
}
else
{
	print "\nFile $target.out does not exist\n";
}
