# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
# this utility is used to check the PM cross references
# for codeswap build.

    $USAGE = "Usage:  perl image_check.pl ".
             "\tmap_file_name_with_path\n".
             "\tcheck_all (or skip_main)\n".
             "\tVCO (or VCPE)\n".
             "\nWhen skip_main is specify, cross reference for MAIN will\n".
             "\not be checked\n";
    
    $map_file_name = @ARGV[0];
    ($check_all = @ARGV[1]) =~ tr/A-Z/a-z/;
    ($itux = @ARGV[2]) =~ tr/a-z/A-Z/;
    $SKIP_MAIN = "skip_main";
    $CHECK_ALL = "check_all";

    if ($#ARGV != 2)
    {
        die $USAGE;
    }

    $output_file = "far_calls_report.log";
    
    if ($check_all eq $CHECK_ALL)
    {
        $main_page_1 = "";
        $main_page_2 = "";
    }
    else
    {
        $main_page_1 = "PMSWAP_${itux}_MAIN";
        $main_page_2 = "PMSWAP_${itux}_SIMTEST";
    }
    
    $format_string = "%25s%35s    %s\n";
    
    open(MAP_INPUT, "<$map_file_name") || die "cannot open $map_file_name\n";
    
    $state = 0;
    $sub_state = 0;
    
    _while_block:
    while(<MAP_INPUT>)
    {
        _switch_0:
        {
            if ($state == 0)
            {
                if (/^SECTION DETAILS/)
                {
                    $state = 10;
                }
            }
            elsif ($state == 10)
            {
                if (/^\.(PMSWAP_\w+)/)
                {
                    $page_name = $1;
                    $page_list{$1} = 1;
                    $state = 15;
                }
                elsif (/^\s*CROSS REFERENCE TABLE\s+/)
                {
                    $state = 30;
                }
                last _switch_0;
            }
            elsif ($state == 15)
            {
                if (/^\.(PMSWAP_\w+)/)
                {
                    $page_name = $1;
                    $page_list{$1} = 1;
                    $state = 15;
                }
                #   .text       00000000  000003e3  000003e4  obj\modem_arc_cs.a(interrupts.o)
                #elsif (/^\s+\.text\s+[0-9a-f]+\s+[0-9a-f]+\s+[0-9a-f]+\s+\S+\((\w+\.o)\)/)
                elsif (/^\s+[\.]\w+\s+[0-9a-f]+\s+[0-9a-f]+\s+[0-9a-f]+\s+\S+\((\w+\.o)\)/)
                {
                    $cur_obj = $1;
                    $obj_to_page{$1} = $page_name;
#print"1>>> $page_name - $cur_obj: ($.)\n";
                }
                elsif (/^\s+(\w+)$/)
                {
                    $_ = <MAP_INPUT>;

                    if (/^\s+[0-9a-f]+\s+[0-9a-f]+\s+[0-9a-f]+\s+\S+\((\w+\.o)\)/)
                    {
                        $cur_obj = $1;
                        $obj_to_page{$1} = $page_name;
#print"2>>> $page_name - $cur_obj: ($.)\n";
                    }
                    else
                    {
                        $state = 10;
                    }
                }
                #    00000544   MasterIntHandler
                elsif (/^\s+[0-9a-f]+\s+(\w*)\s*$/)
                {
                    $pm_symbols{$1} = 1;
                    $sym_to_obj{$1} = $cur_obj;
#print"\t$1\n";

                }
                elsif (/^\s*CROSS REFERENCE TABLE\s+/)
                {
                    $state = 30;
                }
                elsif (/^\S+/)
                {
                    $state = 10;
                }
                last _switch_0;
            }
            elsif ($state == 30)
            {
                if (/^(\w+)$/)
                {
#                    $prev_line = $1;
                    $_ = $1 . <MAP_INPUT>;
#                    $long_symblol = 1;
#                    last _switch_0;
                }

#                if ($long_symblol == 1)
#                {
#                    $_ = $prev_line . $_;
#                    $prev_line = "";
#                    $long_symblol = 0;
#                }

                if ((/^__epilog(\w+)\s+\.(PMSWAP_\w+)\s*$/) || (/^__prolog(\w+)\s+\.(PMSWAP_\w+)\s*$/))
                {
                    $skip_this_symbol = 1;
                }
                elsif (/^(\w+)\s+\.(PMSWAP_\w+)\s*$/)
                {
                    if (defined($pm_symbols{$1}))
                    {
                        $the_symbol = $1;
                        $the_page = $2;
                    }
                    $skip_this_symbol = 0;
                }
                elsif ((/^(\w+)\s+\./) || /^(\w+)\s+(\S+)/)
                {
                     $skip_this_symbol = 1;
                }
                #   *C:\TLE_G\hcarc_4.5a_tools/lib/le/libct.a(abort.o)
                elsif (($skip_this_symbol == 0) && (m#^\s+\**[\w:\.\\/]+\((\w*.o)\)\s*$#))
                {
                    if (($the_page ne $obj_to_page{$1}) &&
                        ($the_page ne $main_page_1) && 
                        ($the_page ne $main_page_2))
                    {
                        $temp_string = sprintf ($format_string, $1, $the_symbol, "$the_page($sym_to_obj{$the_symbol})");
                        if (!defined($warning_strings{$temp_string}))
                        {
                            $warning_strings{$temp_string} = 1;
                            ${"warnings_$the_page"}{$obj_to_page{$1}} .= $temp_string;
                        }
                    }
else
{
}

                    if (($check_all ne $CHECK_ALL) &&
                        (($the_page eq $main_page_1) || 
                        ($the_page eq $main_page_2)) && 
                        (($obj_to_page{$1} ne $main_page_1) && 
                        ($obj_to_page{$1} ne $main_page_2)))
                    {
                        $far_report{$the_symbol} = 1;
                    }
                }
                last _switch_0;
            }
            elsif ($state == 50)
            {
                last _switch_0;
            }
            elsif ($state == 60)
            {
                last _switch_0;
            }
            elsif ($state == 70)
            {
                last _switch_0;
            }
            elsif ($state == 80)
            {
                last _switch_0;
            }
            elsif ($state == 90)
            {
                last _switch_0;
            }
        }
    }
    
    # only makes sense to produce far calls report if MAIN is skipped
    if ($check_all ne $CHECK_ALL)
    {
        open(OUTFILE, ">$output_file") || die "cannot open $output_file\n";
        foreach $symbol (keys(%far_report))
        {
            print (OUTFILE "$symbol\n");
        }
        close OUTFILE;
    }

    open(INDEX_FILE, "<../source/Vdsl_Platform/include/${itux}_swap_index.h") || die "cannot open ${itux}_swap_index.h\n"; 
    _while_swap_index:
    while (<INDEX_FILE>)
    {
        if (/^\s*#define\s+MAX_SWAP_PAGES/)
        {
            last _while_swap_index;
        }
        if (/^\s*#define\s+VDSL_(\w+)_PM_....PAGE/)
        {
            $page_name = "PMSWAP_${itux}_$1";

            if (($page_name ne $main_page_1) && 
                ($page_name ne $main_page_2))
            {
                print "************************************\n";
                print "  $page_name\n";
                print "************************************\n";
                #printf ("%25s%40s%40s\n", "", "Referenced Symbol", "Defined in");
                printf ($format_string, "", "Referenced Symbol", "Defined in");

                foreach $target_page (sort keys(%page_list))
                {
                    if (defined(${"warnings_$target_page"}{$page_name}))
                    {
                        $temp = ${"warnings_$target_page"}{$page_name};
                        print $temp;
                    }
                }
            }

#            delete($page_list{$page_name})
            $PrintedPages{$page_name} = 1;
        }
    }

    foreach $page_name (sort keys(%page_list))
    {
        if ((!defined($PrintedPages{$page_name})) &&
            ($page_name ne $main_page_1) && 
            ($page_name ne $main_page_2))
        {
            print "************************************\n";
            print "  $page_name\n";
            print "************************************\n";
            #printf ("%25s%40s%40s\n", "", "Referenced Symbol", "Defined in");
            printf ($format_string, "", "Referenced Symbol", "Defined in");
            foreach $target_page (sort keys(%page_list))
            {
                if (defined(${"warnings_$target_page"}{$page_name}))
                {
                    $temp = ${"warnings_$target_page"}{$page_name};
                    print $temp;
                }
            }
        }
    }
