# **COPYRIGHT*******************************************************************
#    INTEL CONFIDENTIAL
#    Copyright (C) 2017 Intel Corporation
# *******************************************************************COPYRIGHT**
# **DISCLAIMER******************************************************************
#    The source code contained or described herein and all documents related
#    to the source code ("Material") are owned by Intel Corporation or its
#    suppliers or licensors. Title to the Material remains with Intel
#    Corporation or its suppliers and licensors. The Material may contain
#    trade secrets and proprietary and confidential information of Intel
#    Corporation and its suppliers and licensors, and is protected by
#    worldwide copyright and trade secret laws and treaty provisions. No part
#    of the Material may be used, copied, reproduced, modified, published,
#    uploaded, posted, transmitted, distributed, or disclosed in any way
#    without Intel's prior express written permission.
#
#    No license under any patent, copyright, trade secret or other
#    intellectual property right is granted to or conferred upon you by
#    disclosure or delivery of the Materials, either expressly, by
#    implication, inducement, estoppel or otherwise. Any license under
#    such intellectual property rights must be express and approved by
#    Intel in writing.
# ******************************************************************DISCLAIMER**
# this tool will read the harvard cmd file for codeswap build,
# generate the CodeSwap_Source.src and CodeSwap_Source.inc files,
# generate the super files which are used to hide the multiply
# defined objects.
#
# The CodeSwap_Source.src (similar to other *.src) will have
# info about the super files, the path to those files, and some
# info (used by gmake) about objects that are used to form
# these super files. Later on, in the make file, we use this info
# to trim down the object archive for codeswap build.

    $USAGE = "Usage:  perl codeswap_modem_build.pl\n" .
             "\t\tcmd_input_file            // with path\n".
             "\t\tcmd_output_file           // with no path\n".
             "\t\tmake_inputs_path          // with path\n".
             "\t\tcodeswap_source           // dir name\n".
             "\t\tcodeswap_source_path      // with path\n".
             "\t\tpath to Source/Platform/include \n".
             "\t\tpath to arc_src/include\n".
             "\t\tALL_SRC_FILES             // list of all *.src files\n".
             "\t\tBUILD_OPTIONS_LIST        // list of all builds options used in .cmd input file\n";
    
    ($ifdef_processing = $0) =~ s/\w+\.[pP][lL]/ifdef_processing.pl/;

    $cmd_infile = @ARGV[0];
    $cmd_outfile = @ARGV[1];
    $make_inputs_dir = @ARGV[2];
    $codeswap_source_name = @ARGV[3];
    $super_file_dir = @ARGV[4];
    $swap_index_file = "@ARGV[5]swap_index.h";
    $arc_src_inc = @ARGV[6];
    
    $alias_gen_enabled = 0;
    $use_alias_build = 1;

    if ($#ARGV != 8)
    {
        die($USAGE);
    }
    
    $all_bld_options = @ARGV[8];

    foreach $bld_opt (split / /,@ARGV[8])
    {
        $build_options{$bld_opt} = 1;
        if ($bld_opt eq "TARGET_ARC")
        {
            $build_options{"TARGET_HW"} = 1;
        }
    }


    # read in alias file
    if ($alias_gen_enabled)
    {
        open(ALIAS_INFILE, "<alias_input.txt") ||  die ("can't open alias_input.txt\n");
        while(<ALIAS_INFILE>)
        {
            if (m%^(\w+.c):\s*(\w+)%)
            {
                ($temp1 = $1) =~ tr/A-Z/a-z/;
                if (!defined($aliased_function{$2}))
                {
                    $aliased_function{$2} = 1;
                    $alias_input{$temp1} .= "#pragma Alias($2, \"$2_zzzz\")\n";
                }
            }
        }
        close(ALIAS_INFILE);
    }

    # read in the *.src files
    foreach $file (split / /,@ARGV[7])
    {
        open(SRC_FILE, "<$file") || die ("Failed to open src file ($file)\n");
        $src_list_start = 0;
        while (<SRC_FILE>)
        {
            if (/\w+_SRC\s*[+]*=\s*\\/)
            {
                $src_list_start = 1;
            }
            elsif (/^\s*$/)
            {
                $src_list_start = 0;
            }

            if (($src_list_start) && (/(\S+[\\\/])(\w+\.[cs])\s*[\\]*/))
            {
                ($temp2 = $2) =~ tr/A-Z/a-z/;
                $src_file_with_path{$temp2} = $1 . $2;
            }
        }
        close(SRC_FILE);
    }
    
    # open input and output .cmd files
    open(CMD_INFILE, "<$cmd_infile") || 
        die "cannot open $cmd_infile\n";
    open(CMD_OUTFILE, ">${make_inputs_dir}/$cmd_outfile") || 
        die "cannot open $cmd_outfile\n";
    
    
    $state = 0;
    $num_of_swap_pages = 0;              # each page contains TWO swap blocks: one for PM and one for DM
    $CodeSwapTable_content = "";
    
    $prev_FADX_block = "";

    @ifxdef_stack = (1);               # by default, things are enabled.

    _end_of_file_block:
    while(<CMD_INFILE>)
    {

        if (/^\s*[^\/]+(GET_SIZE_OF\(\s*(\S+)\s*\))/)
        {
            if (open(FILE_IN, "<$2"))
            {
                seek(FILE_IN, 0, 2);
                $file_size = tell(FILE_IN);
                close(FILE_IN);
            }
            else
            {
                print "\t!!! Warning: $2 doesn't exist !!!\n\n";
                $file_size = 0;
            }
            $_ =~ s#GET_SIZE_OF\(\s*\S+\s*\)#${file_size}#;
        }

        _switch_0:
        {
        # ifdef/ifndef SINGLE_CONDITION support
            if (/^\s*\#ifdef\s+(\w+)\s*$/) 
            {
#print "$_";
                if (!defined($build_options{$1}))
                {
                    push(@ifxdef_stack, 0);
                }
                else
                {
                    push(@ifxdef_stack, (1 && $ifxdef_stack[$#ifxdef_stack]) );
                }
#print "@ifxdef_stack\n";
                last _switch_0;
            }

            if (/^\s*\#ifndef\s+(\w+)\s*$/) 
            {
#print "$_";
                if (defined($build_options{$1}))
                {
                    push(@ifxdef_stack, 0);
                }    
                else
                {
                    push(@ifxdef_stack, (1 && $ifxdef_stack[$#ifxdef_stack]) );
                }
#print "@ifxdef_stack\n";
                last _switch_0;
            }

        # ifdef (CONDITION_1 || CONDITION_2) support
            if (/^\s*#ifdef\s+\(\s*(\w+) \|\| (\w+)\s*\)\s*$/) 
            {
#print "$_";
                if (!defined($build_options{$1}) && !defined($build_options{$2}))
                {
                    push(@ifxdef_stack, 0);
                }
                else
                {
                    push(@ifxdef_stack, (1 && $ifxdef_stack[$#ifxdef_stack]) );
                }
#print "@ifxdef_stack\n";
                last _switch_0;
            }

        # ifdef (CONDITION_1 && CONDITION_2) support
            if (/^\s*#ifdef\s+\(\s*(\w+) \&\& (\w+)\s*\)\s*$/) 
            {
#print "$_";
                if (!defined($build_options{$1}) || !defined($build_options{$2}))
                {
                    push(@ifxdef_stack, 0);
                }    
                else
                {
                    push(@ifxdef_stack, (1 && $ifxdef_stack[$#ifxdef_stack]) );
                }
#print "@ifxdef_stack\n";
                last _switch_0;
            }

            if (/^\s*#else/)
            {
#print "$_";
                if ($#ifxdef_stack <= 0)
                {
                    die("Error: unmatched #else detected\n");
                }
                push(@ifxdef_stack, ((1^pop(@ifxdef_stack)) && $ifxdef_stack[$#ifxdef_stack]) );
#print "@ifxdef_stack\n";

                last _switch_0;
            }
         
            # get out if hit endif
            if (/^\s*#endif/)
            {
#print "$_";
                if ($#ifxdef_stack <= 0)
                {
                    die("Error: unmatched #endif detected\n");
                }
                pop(@ifxdef_stack);
#print "@ifxdef_stack\n";
                last _switch_0;
            }

            if ($ifxdef_stack[$#ifxdef_stack] == 0)
            {
                last _switch_0;
            }

            if (/^(\s*)ASCII\((.+)\)/)
            {
                print (CMD_OUTFILE "$1BYTE(");
                foreach $character (split //, $2)
                {
                    printf(CMD_OUTFILE "0x%x,", ord($character));
                }
                printf(CMD_OUTFILE "0x%x)\n", ord("\n"));
                last _switch_0;
            }

            if (/^\s*\/\/ The rest of VDSL_IMAGE_HEADER_BLOCK/)
            {
                print (CMD_OUTFILE $_);
                print (CMD_OUTFILE "$CodeSwapTable_content");
                last _switch_0;
            }

            if (/^\s*__gta_SwapTable\s*=\s*\.;/)
            {
                print (CMD_OUTFILE $_);
                print (CMD_OUTFILE "$InternalCodeSwapTable_content");
                last _switch_0;
            }

            if (/^\s*#include\s*"(\S+)"/)
            {
                IncludeFile($1);
                last _switch_0;
            }

            if (/^\s*SECTIONS\s*\{\w*$/)
            {
                $state = 5;
            }

            if ($state == 0)
            {
                # for each line, look to see if they are the definition of *_FADX
                # if so, keep track of them.
                if (/^\s*(\w+)_FADX_PM\s*:/)
                {
                    $swap_page_list{$num_of_swap_pages++} = "$1_PM_SWAPPAGE"; 

                    # source address (byte offset within Flash/Sram image)
                    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_PM) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR($1_FADX_PM) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";

                    # arc destination address
                    $CodeSwapTable_content .=         "            LONG(ADDR(.PMSWAP_$1));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR(.PMSWAP_$1));\n";

                    # size of page
                    $CodeSwapTable_content .=         "            LONG(SIZEOF($1_FADX_PM)/4);\n";
                    $InternalCodeSwapTable_content .= "                LONG(SIZEOF($1_FADX_PM)/4);\n";
                    $InternalCodeSwapTable_content .= "                LONG(0);\n\n";

                    # followed by a dummy DM header
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n\n";

                }
                elsif (/^\s*(\w+)_FADX_DM\s*:/)
                {
                    $swap_page_list{$num_of_swap_pages++} = "$1_DM_SWAPPAGE"; 

                    # starts with a dummy PM header
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";

                    # source address (byte offset within Flash/Sram image)
                    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_DM) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR($1_FADX_DM) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";

                    # arc destination address
                    $CodeSwapTable_content .=         "            LONG(ADDR(.DMSWAP_$1));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR(.DMSWAP_$1));\n";

                    # size of page
                    $CodeSwapTable_content .=         "            LONG((SIZEOF($1_FADX_DM)/4));\n\n";
                    $InternalCodeSwapTable_content .= "                LONG((SIZEOF($1_FADX_DM)/4));\n";
                    $InternalCodeSwapTable_content .= "                LONG(0);\n\n";
    
                }
                elsif (/^\s*(\w+)_FADX_PM_BT\s*:/)
                {
                    $swap_page_list{$num_of_swap_pages++} = "$1_PM_BOOTPAGE"; 

                    # source address (byte offset within Flash/Sram image)
                    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_PM_BT) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR($1_FADX_PM_BT) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";

                    # arc destination address
                    $CodeSwapTable_content .=         "            LONG(ADDR(.PMSWAP_$1));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR(.PMSWAP_$1));\n";

                    # size of page
                    $CodeSwapTable_content .=         "            LONG(0x80000000 + (SIZEOF($1_FADX_PM_BT)/4));\n";
                    $InternalCodeSwapTable_content .= "                LONG(SIZEOF($1_FADX_PM_BT)/4);\n";  # not a boot page to modem
                    $InternalCodeSwapTable_content .= "                LONG(0);\n\n";

                    # followed by a dummy DM header
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n\n";

                }
                elsif (/^\s*(\w+)_FADX_DM_BT\s*:/)
                {
                    $swap_page_list{$num_of_swap_pages++} = "$1_DM_BOOTPAGE"; 

                    # starts with a dummy PM header
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";


                    # source address (byte offset within Flash/Sram image)
                    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_DM_$2BT) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR($1_FADX_DM_$2BT) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";

                    # arc destination address
                    $CodeSwapTable_content .=         "            LONG(ADDR(.DMSWAP_$1));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR(.DMSWAP_$1));\n";

                    # size of page
                    $CodeSwapTable_content .=         "            LONG(0x80000000 + (SIZEOF($1_FADX_DM_BT)/4));\n\n";
                    $InternalCodeSwapTable_content .= "                LONG(SIZEOF($1_FADX_DM_BT)/4);\n";        # not a boot page to modem
                    $InternalCodeSwapTable_content .= "                LONG(0);\n\n";

                }
                elsif (/^\s*(\w+)_FADX_DM_IBT\s*:/)
                {
                    $swap_page_list{$num_of_swap_pages++} = "$1_DM_IBOOTPAGE"; 

                    # starts with a dummy PM header
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    # this is the actual destination address
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";


                    # source address (byte offset within Flash/Sram image)
                    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_DM_IBT) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR($1_FADX_DM_IBT) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";

                    # arc intermediate destination address 
                    $CodeSwapTable_content .=         "            LONG(ADDR(AWRE_IBRAM));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR(AWRE_IBRAM));\n";

                    # size of page
                    $CodeSwapTable_content .=         "            LONG(0);\n";     # host don't care about this type of pages
                    $InternalCodeSwapTable_content .= "                LONG(0x80000000 + (SIZEOF($1_FADX_DM_IBT)/4));\n"; # is a boot page to modem
                    $InternalCodeSwapTable_content .= "                LONG(ADDR(.DMSWAP_$1));\n\n";  # actual dest address.

                }
                elsif (/^\s*(\w+)_FADX_DM_ZBT\s*:/)     # this type of page, takes no room in .bin file
                {
                    $swap_page_list{$num_of_swap_pages++} = "$1_DM_ZBOOTPAGE"; 

                    # starts with a dummy PM header
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    # this is the actual destination address
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $CodeSwapTable_content .=         "            LONG(0);\n";


                    # source address (byte offset within Flash/Sram image); for this ZBT, this is a don't-care
                    $CodeSwapTable_content .=         "            LONG(ADDR($1_FADX_DM_ZBT) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";
                    $InternalCodeSwapTable_content .= "                LONG(ADDR($1_FADX_DM_ZBT) - ADDR(VDSL_IMAGE_HEADER_FADX));\n";

                    # arc intermediate destination address 
                    $CodeSwapTable_content .=         "            LONG(0);\n";
                    $InternalCodeSwapTable_content .= "                LONG(0);\n";

                    # size of page
                    $CodeSwapTable_content .=         "            LONG(0);\n";     # host don't care about this type of pages
                    $InternalCodeSwapTable_content .= "                LONG((SIZEOF(.DMSWAP_$1)+3)/4);\n"; # is a boot page to modem
                    $InternalCodeSwapTable_content .= "                LONG(ADDR(.DMSWAP_$1));\n\n";  # actual dest address.

                    $remove_DM_ZBT_from_image = 1;
                }



                if ((/^\s*(\w+_FADX_[PD]M[_IZBT]*\w*)\s*:/) || (/^\s*(\w+_FADX)\s*:/))
                {
                    $temp = $1;

                    print (CMD_OUTFILE $_);
                    if ((!(/^\s*(\w+_FADX\w*)\s*:\s*ORIGIN/)) && ($prev_FADX_block ne ""))
                    {
                        print(CMD_OUTFILE "						    		ORIGIN = ADDR($prev_FADX_block) + SIZEOF($prev_FADX_block),\n");
                    }
                    $prev_FADX_block = $temp;
                }
                elsif (/^\s*LENGTH\s*=/)
                {

                    if ($prev_FADX_block eq "LAST_FADX")
                    {
                        $CodeSwapTable_top = "            LONG($num_of_swap_pages);    // num of swap pages\n\n";
                        $CodeSwapTable_content = $CodeSwapTable_top . $CodeSwapTable_content;
                        $swap_page_list{$num_of_swap_pages} = "MAX_SWAP_PAGES";

                        # go processing MULT_DEF blocks
                        $state = 5;
                    }

                    if ($remove_DM_ZBT_from_image)
                    {
                        $remove_DM_ZBT_from_image = 0;
                        print(CMD_OUTFILE "                                    LENGTH = 0\n");
                    }
                    else
                    {
                        print (CMD_OUTFILE $_);
                    }
                }
                else
                {
                    print (CMD_OUTFILE $_);
                }

                last _switch_0;

            }
            elsif ($state == 5)
            {
                #$valid_cmd_infile = 1;
                if (m/^\s*\.(\w+)_MULT_DEF/)
                {
                    $state = 10;
                    $page_name = "SWAP_$1";
                    $page_name_root = $1;
                    $old_super_file_list = "";
                    $super_file_list = "";
                    $super_file_not_empty = 0;
                }
                else
                {
                    print (CMD_OUTFILE $_);
                }
                last _switch_0;
            }
            elsif ($state == 10)
            {
                if (m/^\s*}/)
                {
                    if (($super_file_not_empty == 0) ||
                        ($skip_ARC_SIM_page eq $page_name_root)) 
                    {
                        print "\tremoving empty `${super_file_dir}\\${page_name}.c'\n\n";
                        system("rm -f ${super_file_dir}\\${page_name}.c");
                        print (CMD_OUTFILE "            //empty super file\n");
                    }
                    else
                    {
                        # generate super-file

                        # include *_include_macros.h if exists
                        stat("$arc_src_inc/${page_name_root}_include_macros.h");

                        if (-e _)
                        {
                            $super_file_list = "#include \"${page_name_root}_include_macros.h\"\n\n" . $super_file_list;
                        }

                        $super_file_list = "#define ${page_name_root}_ONLY\n\n" . $super_file_list;

                        # include *_alias.h if exists
                        stat("$arc_src_inc/${page_name_root}_alias.h");
                        if (-e _)
                        {
                            $super_file_list .= "\n#include \"${page_name_root}_alias.h\"\n";
                        }

                        read_old_super_file("${super_file_dir}\\${page_name}.c");

                        if ($old_super_file_list eq $super_file_list)
                        {
                            print "\t`${super_file_dir}\\${page_name}.c' is up to date.\n\n";
                        }
                        else
                        {
                            print "\tgenerating `${super_file_dir}\\${page_name}.c'\n\n";
                            open(SUPER_FILE, ">${super_file_dir}/${page_name}.c") || 
                                die "cannot open ${super_file_dir}/${page_name}.c\n";
                            print (SUPER_FILE $super_file_list);
                            close(SUPER_FILE);
                        }
                        
                        $codeswap_src_list{$page_name} = 1;
    
                        print (CMD_OUTFILE "            //super file\n");
                        print (CMD_OUTFILE "            ${page_name}.o(.text*)\n");
                    }
                    $state = 5;
                }
                elsif (m/^\s*(\w+)\.o/)
                {
                    $super_file_not_empty = 1;
                    $objects_to_remove_frm_archive{"$1.o"} = 1;

                    $super_file_not_empty = 1;
                    ($temp1 = "$1.c") =~ tr/A-Z/a-z/;
                    ($temp2 = "$1.s") =~ tr/A-Z/a-z/;
                    if (defined($src_file_with_path{$temp1}))
                    {
                        $super_file_list .= "#include \"$src_file_with_path{$temp1}\"\n";
                    }
                    # check that no asm-source objects included in super file
                    elsif (defined($src_file_with_path{$temp2}))
                    {
                        die "Error: $temp1.s can't be included inside ${page_name}.c\n";
                    }
                    else
                    {
                        print "Warning: inclusion of $1.c without path information in ${page_name}.c\n";
                        $super_file_list .= "#include \"$1.c\"\n";
                    }

                    if ($alias_gen_enabled)
                    {
                        $local_alias_content = $alias_input{$temp1};
                        if ($local_alias_content ne "")
                        {
                            $alias_file_content .= ("\n// for $1.c\n" . $local_alias_content); 
                        }
                    }

                }
            }
        }
    }
    
    #if ($valid_cmd_infile != 1)
    #{
    #    die ("\n\n\t\t!!! FAILURE: Invalid $cmd_infile !!!\n\n\n");
    #}
    
    close(CMD_OUTFILE);

    if ($#ifxdef_stack != 0)
    {
        die("Error: unmatched #if/#else/#endif detected\n");
    }

    # create virtual swap_index.h
    $swap_index_content = "    // swap pages index by swap index.\n";

    foreach $index (sort numeric keys(%swap_page_list))
    {
        $swap_index_content .= sprintf("    #define %40s        %d\n", "$swap_page_list{$index}", $index);
    }

    $swap_index_content = 
        "#ifndef _SWAP_INDEX_H\n" .
        "#define _SWAP_INDEX_H\n" .
        $swap_index_content .
        "#endif\n";

    $swap_index_content =~ s/VCO_/VDSL_/g;
    $swap_index_content =~ s/VCPE_/VDSL_/g;
    
    $old_swap_index_content = "";
    if (open(SWAP_INDEX, "<$swap_index_file"))
    {
        while(<SWAP_INDEX>)
        {
            $old_swap_index_content .= $_;
        }
        close(SWAP_INDEX);
    }

    if ($old_swap_index_content ne $swap_index_content)
    {
        system("attrib -r $swap_index_file");
        open(SWAP_INDEX, ">$swap_index_file") || 
            die "cannot open $swap_index_file\n";
        print(SWAP_INDEX $swap_index_content);
        close(SWAP_INDEX);
    }

    $src_line = "${codeswap_source_name}_SRC += \\\n";
    $c_rls_line = "${codeswap_source_name}_C_RLS = \\\n";
    $asm_rls_line = "${codeswap_source_name}_ASM_RLS = \\\n";
    foreach $superfile (keys(%codeswap_src_list))
    {
        $src_line .= "    ${super_file_dir}/${superfile}.c \\\n";
        $c_rls_line .= "    ${superfile}.rls \\\n";
    }
    
    $new_src_content =  "$src_line\n$c_rls_line\n$asm_rls_line\n";
    
    $vpath_for_c_line = "VPATH_FOR_C += \\\n    ${super_file_dir}\n";
    
    $new_src_content .= $vpath_for_c_line;

#    $new_src_content .= "MULT_DEF_OBJECTS += \\\n";

#    foreach $obj (keys(%objects_to_remove_frm_archive))
#    {
#        $new_src_content .= "    $obj \\\n";
#    }
#    print(CODESWAP_SRC_OUTFILE "\n");
    
    
    $new_inc_content =  "-I$super_file_dir\n";
    


    $old_src_content = "";
    if (open(CODESWAP_SRC_OLDFILE, "<${make_inputs_dir}/${codeswap_source_name}.src"))
    {
        while(<CODESWAP_SRC_OLDFILE>)
        {
            $old_src_content .= $_;
        }
        close(CODESWAP_SRC_OLDFILE);
    }

    if ($old_src_content ne $new_src_content)
    {
        open(CODESWAP_SRC_OUTFILE, ">${make_inputs_dir}/${codeswap_source_name}.src") ||
            die "${make_inputs_dir}/${codeswap_source_name}.src\n";
        print (CODESWAP_SRC_OUTFILE $new_src_content);
        close(CODESWAP_SRC_OUTFILE);
    }

    $old_inc_content = "";
    if (open(CODESWAP_INC_OLDFILE, "<${make_inputs_dir}/${codeswap_source_name}.inc"))
    {
        while(<CODESWAP_INC_OLDFILE>)
        {
            $old_inc_content .= $_;
        }
        close(CODESWAP_INC_OLDFILE);
    }

    if ($old_inc_content ne $new_inc_content)
    {
        open(CODESWAP_INC_OUTFILE, ">${make_inputs_dir}/${codeswap_source_name}.inc") ||
            die "${make_inputs_dir}/${codeswap_source_name}.inc\n";
        print (CODESWAP_INC_OUTFILE $new_inc_content);
        close(CODESWAP_INC_OUTFILE);
    }

    exit;








sub read_old_super_file
{
    local ($file_name) = @_;
    
    $old_super_file_list = "";

    if (open(OLD_SUPER_FILE, "<$file_name"))
    {
        while (<OLD_SUPER_FILE>)
        {
            $old_super_file_list .= $_;
        }
        close (OLD_SUPER_FILE);
    }
}

sub numeric { $a <=> $b; }

sub IncludeFile
{
    local ($file_name) = @_;

    system("perl ../perl/$ifdef_processing ${make_inputs_dir}/$file_name temp_included_file.txt ${make_inputs_dir} \"$all_bld_options\"");

    if ($? != 0)
    {
        die ("Failed to preprocess ${make_inputs_dir}/$file_name\n");
    }

    open(INCLUDE_FILE, "<${make_inputs_dir}/temp_included_file.txt") || die "Failed to read in included file ${make_inputs_dir}/temp_included_file.txt";

    while(<INCLUDE_FILE>)
    {

        if (/^\s*[^\/]+(GET_SIZE_OF\(\s*(\S+)\s*\))/)
        {
            if (open(FILE_IN, "<$2"))
            {
                seek(FILE_IN, 0, 2);
                $file_size = tell(FILE_IN);
                close(FILE_IN);
            }
            else
            {
                print "\t!!! Warning: $2 doesn't exist !!!\n\n";
                $file_size = 0;
            }
            $_ =~ s#GET_SIZE_OF\(\s*\S+\s*\)#${file_size}#;
        }
        print (CMD_OUTFILE $_);
    }

    close(INCLUDE_FILE);
    system("del ${make_inputs_dir}\\temp_included_file.txt");
}
